/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.htmlInspections.XmlEntitiesInspection;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XHtmlFileType;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementWalkingVisitor;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.html.HtmlDocumentImpl;
import com.intellij.psi.impl.source.html.dtd.HtmlAttributeDescriptorImpl;
import com.intellij.psi.impl.source.parsing.xml.HtmlBuilderDriver;
import com.intellij.psi.impl.source.parsing.xml.XmlBuilder;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.Html5SchemaProvider;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.XmlAttributeDescriptorImpl;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import com.intellij.xml.util.HTMLControls;
import com.intellij.xml.util.HtmlPsiUtil;
import com.intellij.xml.util.XmlUtil;
import com.intellij.xml.util.documentation.MimeTypeDictionary;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.xml.util.HtmlUtil");
    @NonNls
    private static final String JSFC = "jsfc";
    @NonNls
    private static final String CHARSET = "charset";
    @NonNls
    private static final String CHARSET_PREFIX = "charset=";
    @NonNls
    private static final String HTML5_DATA_ATTR_PREFIX = "data-";
    public static final String SCRIPT_TAG_NAME = "script";
    public static final String STYLE_TAG_NAME = "style";
    public static final String STYLE_ATTRIBUTE_NAME = "style";
    public static final String ID_ATTRIBUTE_NAME = "id";
    public static final String CLASS_ATTRIBUTE_NAME = "class";
    public static final String[] CONTENT_TYPES = ArrayUtil.toStringArray(MimeTypeDictionary.getContentTypes());
    @NonNls
    public static final String MATH_ML_NAMESPACE = "http://www.w3.org/1998/Math/MathML";
    @NonNls
    public static final String SVG_NAMESPACE = "http://www.w3.org/2000/svg";
    public static final String[] RFC2616_HEADERS = new String[]{"Accept", "Accept-Charset", "Accept-Encoding", "Accept-Language", "Accept-Ranges", "Age", "Allow", "Authorization", "Cache-Control", "Connection", "Content-Encoding", "Content-Language", "Content-Length", "Content-Location", "Content-MD5", "Content-Range", "Content-Type", "Date", "ETag", "Expect", "Expires", "From", "Host", "If-Match", "If-Modified-Since", "If-None-Match", "If-Range", "If-Unmodified-Since", "Last-Modified", "Location", "Max-Forwards", "Pragma", "Proxy-Authenticate", "Proxy-Authorization", "Range", "Referer", "Refresh", "Retry-After", "Server", "TE", "Trailer", "Transfer-Encoding", "Upgrade", "User-Agent", "Vary", "Via", "Warning", "WWW-Authenticate"};
    private static final Set<String> EMPTY_TAGS_MAP = new THashSet();
    @NonNls
    private static final String[] OPTIONAL_END_TAGS = new String[]{"head", "p", "li", "dd", "dt", "thead", "tfoot", "tbody", "colgroup", "tr", "th", "td", "option", "embed", "noembed"};
    private static final Set<String> OPTIONAL_END_TAGS_MAP = new THashSet();
    @NonNls
    private static final String[] BLOCK_TAGS = new String[]{"p", "h1", "h2", "h3", "h4", "h5", "h6", "ul", "ol", "dir", "menu", "pre", "dl", "div", "center", "noscript", "noframes", "blockquote", "form", "isindex", "hr", "table", "fieldset", "address", "map", "body", "object", "applet", "ins", "del", "dd", "li", "button", "th", "td", "iframe", "comment"};
    @NonNls
    private static final String[] POSSIBLY_INLINE_TAGS = new String[]{"a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"};
    private static final Set<String> BLOCK_TAGS_MAP = new THashSet();
    @NonNls
    private static final String[] INLINE_ELEMENTS_CONTAINER = new String[]{"p", "h1", "h2", "h3", "h4", "h5", "h6", "pre", "dt"};
    private static final Set<String> INLINE_ELEMENTS_CONTAINER_MAP = new THashSet();
    private static final Set<String> POSSIBLY_INLINE_TAGS_MAP = new THashSet();
    @NonNls
    private static final String[] HTML5_TAGS = new String[]{"article", "aside", "audio", "canvas", "command", "datalist", "details", "embed", "figcaption", "figure", "footer", "header", "keygen", "mark", "meter", "nav", "output", "progress", "rp", "rt", "ruby", "section", "source", "summary", "time", "video", "wbr", "main"};
    private static final Set<String> HTML5_TAGS_SET = new THashSet();
    private static final Map<String, Set<String>> AUTO_CLOSE_BY_MAP = new THashMap();

    private HtmlUtil() {
    }

    public static boolean isSingleHtmlTag(String tagName2) {
        return EMPTY_TAGS_MAP.contains(tagName2.toLowerCase(Locale.US));
    }

    public static boolean isSingleHtmlTagL(String tagName2) {
        return EMPTY_TAGS_MAP.contains(tagName2);
    }

    public static boolean isOptionalEndForHtmlTag(String tagName2) {
        return OPTIONAL_END_TAGS_MAP.contains(tagName2.toLowerCase(Locale.US));
    }

    public static boolean isOptionalEndForHtmlTagL(String tagName2) {
        return OPTIONAL_END_TAGS_MAP.contains(tagName2);
    }

    public static boolean canTerminate(String childTagName, String tagName2) {
        Set<String> closingTags = AUTO_CLOSE_BY_MAP.get(tagName2);
        return closingTags != null && closingTags.contains(childTagName);
    }

    public static boolean isHtmlBlockTag(String tagName2) {
        return BLOCK_TAGS_MAP.contains(tagName2.toLowerCase(Locale.US));
    }

    public static boolean isPossiblyInlineTag(String tagName2) {
        return POSSIBLY_INLINE_TAGS_MAP.contains(tagName2);
    }

    public static boolean isHtmlBlockTagL(String tagName2) {
        return BLOCK_TAGS_MAP.contains(tagName2);
    }

    public static boolean isInlineTagContainer(String tagName2) {
        return INLINE_ELEMENTS_CONTAINER_MAP.contains(tagName2.toLowerCase(Locale.US));
    }

    public static boolean isInlineTagContainerL(String tagName2) {
        return INLINE_ELEMENTS_CONTAINER_MAP.contains(tagName2);
    }

    public static void addHtmlSpecificCompletions(XmlElementDescriptor descriptor2, XmlTag element, List<XmlElementDescriptor> variants) {
        block4: {
            PsiElement parent;
            block5: {
                String name = descriptor2.getName((PsiElement)element);
                if (name == null || !HtmlUtil.isOptionalEndForHtmlTag(name)) break block4;
                parent = element.getParent();
                if (parent != null) {
                    parent = parent.getParent();
                }
                if (!(parent instanceof HtmlTag)) break block5;
                XmlElementDescriptor parentDescriptor = ((HtmlTag)parent).getDescriptor();
                if (parentDescriptor == descriptor2 || parentDescriptor == null) break block4;
                for (XmlElementDescriptor elementsDescriptor : parentDescriptor.getElementsDescriptors((XmlTag)parent)) {
                    if (!HtmlUtil.isHtmlBlockTag(elementsDescriptor.getName())) continue;
                    variants.add(elementsDescriptor);
                }
                break block4;
            }
            if (parent instanceof HtmlDocumentImpl) {
                XmlNSDescriptor nsDescriptor = descriptor2.getNSDescriptor();
                for (XmlElementDescriptor elementDescriptor : nsDescriptor.getRootElementsDescriptors((XmlDocument)parent)) {
                    if (!HtmlUtil.isHtmlBlockTag(elementDescriptor.getName()) || variants.contains(elementDescriptor)) continue;
                    variants.add(elementDescriptor);
                }
            }
        }
    }

    @Nullable
    public static XmlDocument getRealXmlDocument(@Nullable XmlDocument doc) {
        return HtmlPsiUtil.getRealXmlDocument(doc);
    }

    public static boolean isShortNotationOfBooleanAttributePreferred() {
        return Registry.is((String)"html.prefer.short.notation.of.boolean.attributes", (boolean)true);
    }

    public static void setShortNotationOfBooleanAttributeIsPreferred(boolean value2, Disposable parent) {
        final boolean oldValue = HtmlUtil.isShortNotationOfBooleanAttributePreferred();
        final RegistryValue registryValue = Registry.get((String)"html.prefer.short.notation.of.boolean.attributes");
        registryValue.setValue(value2);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                registryValue.setValue(oldValue);
            }
        });
    }

    public static boolean isBooleanAttribute(@NotNull XmlAttributeDescriptor descriptor2, @Nullable PsiElement context2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/xml/util/HtmlUtil", "isBooleanAttribute"));
        }
        if (descriptor2 instanceof HtmlAttributeDescriptorImpl && descriptor2.isEnumerated()) {
            String[] values = descriptor2.getEnumeratedValues();
            if (values == null) {
                return false;
            }
            if (values.length == 2) {
                return values[0].isEmpty() && values[1].equals(descriptor2.getName()) || values[1].isEmpty() && values[0].equals(descriptor2.getName());
            }
            if (values.length == 1) {
                return descriptor2.getName().equals(values[0]);
            }
        }
        return context2 != null && HtmlUtil.isCustomBooleanAttribute(descriptor2.getName(), context2);
    }

    public static boolean isCustomBooleanAttribute(@NotNull String attributeName, @NotNull PsiElement context2) {
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "com/intellij/xml/util/HtmlUtil", "isCustomBooleanAttribute"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/xml/util/HtmlUtil", "isCustomBooleanAttribute"));
        }
        String entitiesString = HtmlUtil.getEntitiesString(context2, "HtmlUnknownBooleanAttribute");
        if (entitiesString != null) {
            StringTokenizer tokenizer = new StringTokenizer(entitiesString, ",");
            while (tokenizer.hasMoreElements()) {
                if (!tokenizer.nextToken().equalsIgnoreCase(attributeName)) continue;
                return true;
            }
        }
        return false;
    }

    public static XmlAttributeDescriptor[] getCustomAttributeDescriptors(XmlElement context2) {
        String entitiesString = HtmlUtil.getEntitiesString((PsiElement)context2, "HtmlUnknownAttribute");
        if (entitiesString == null) {
            return XmlAttributeDescriptor.EMPTY;
        }
        StringTokenizer tokenizer = new StringTokenizer(entitiesString, ",");
        XmlAttributeDescriptor[] descriptors = new XmlAttributeDescriptor[tokenizer.countTokens()];
        int index = 0;
        while (tokenizer.hasMoreElements()) {
            final String customName = tokenizer.nextToken();
            if (customName.length() == 0) continue;
            descriptors[index++] = new XmlAttributeDescriptorImpl(){

                @Override
                public String getName(PsiElement context2) {
                    return customName;
                }

                @Override
                public String getName() {
                    return customName;
                }
            };
        }
        return descriptors;
    }

    public static XmlElementDescriptor[] getCustomTagDescriptors(@Nullable PsiElement context2) {
        String entitiesString = HtmlUtil.getEntitiesString(context2, "HtmlUnknownTag");
        if (entitiesString == null) {
            return XmlElementDescriptor.EMPTY_ARRAY;
        }
        StringTokenizer tokenizer = new StringTokenizer(entitiesString, ",");
        XmlElementDescriptor[] descriptors = new XmlElementDescriptor[tokenizer.countTokens()];
        int index = 0;
        while (tokenizer.hasMoreElements()) {
            String tagName2 = tokenizer.nextToken();
            if (tagName2.length() == 0) continue;
            descriptors[index++] = new CustomXmlTagDescriptor(tagName2);
        }
        return descriptors;
    }

    @Nullable
    public static String getEntitiesString(@Nullable PsiElement context2, @NotNull String inspectionName) {
        if (inspectionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionName", "com/intellij/xml/util/HtmlUtil", "getEntitiesString"));
        }
        if (context2 == null) {
            return null;
        }
        PsiFile containingFile = context2.getContainingFile().getOriginalFile();
        InspectionProfileImpl profile2 = InspectionProjectProfileManager.getInstance(context2.getProject()).getCurrentProfile();
        XmlEntitiesInspection inspection = (XmlEntitiesInspection)profile2.getUnwrappedTool(inspectionName, (PsiElement)containingFile);
        if (inspection != null) {
            return inspection.getAdditionalEntries();
        }
        return null;
    }

    public static XmlAttributeDescriptor[] appendHtmlSpecificAttributeCompletions(XmlTag declarationTag, XmlAttributeDescriptor[] descriptors, XmlAttribute context2) {
        if (declarationTag instanceof HtmlTag) {
            descriptors = (XmlAttributeDescriptor[])ArrayUtil.mergeArrays((Object[])descriptors, (Object[])HtmlUtil.getCustomAttributeDescriptors((XmlElement)context2));
            return descriptors;
        }
        boolean isJsfHtmlNamespace = false;
        for (String jsfHtmlUri : XmlUtil.JSF_HTML_URIS) {
            if (declarationTag.getPrefixByNamespace(jsfHtmlUri) == null) continue;
            isJsfHtmlNamespace = true;
            break;
        }
        if (isJsfHtmlNamespace && declarationTag.getNSDescriptor("http://www.w3.org/1999/xhtml", true) != null && !"http://java.sun.com/JSP/Page".equals(declarationTag.getNamespace())) {
            descriptors = (XmlAttributeDescriptor[])ArrayUtil.append((Object[])descriptors, (Object)new XmlAttributeDescriptorImpl(){

                @Override
                public String getName(PsiElement context2) {
                    return HtmlUtil.JSFC;
                }

                @Override
                public String getName() {
                    return HtmlUtil.JSFC;
                }
            }, XmlAttributeDescriptor.class);
        }
        return descriptors;
    }

    public static boolean isHtml5Document(XmlDocument doc) {
        VirtualFile vFile;
        XmlDoctype doctype;
        if (doc == null) {
            return false;
        }
        XmlProlog prolog = doc.getProlog();
        XmlDoctype xmlDoctype = doctype = prolog != null ? prolog.getDoctype() : null;
        if (!HtmlUtil.isHtmlTagContainingFile((PsiElement)doc)) {
            return false;
        }
        PsiFile htmlFile = doc.getContainingFile();
        String htmlFileFullName = htmlFile != null ? ((vFile = htmlFile.getVirtualFile()) != null ? vFile.getPath() : htmlFile.getName()) : "unknown";
        if (doctype == null) {
            LOG.debug("DOCTYPE for " + htmlFileFullName + " is null");
            return Html5SchemaProvider.getHtml5SchemaLocation().equals(ExternalResourceManagerEx.getInstanceEx().getDefaultHtmlDoctype(doc.getProject()));
        }
        boolean html5Doctype = HtmlUtil.isHtml5Doctype(doctype);
        String doctypeDescription = "text: " + doctype.getText() + ", dtdUri: " + doctype.getDtdUri() + ", publicId: " + doctype.getPublicId() + ", markupDecl: " + doctype.getMarkupDecl();
        LOG.debug("DOCTYPE for " + htmlFileFullName + "; " + doctypeDescription + "; HTML5: " + html5Doctype);
        return html5Doctype;
    }

    public static boolean isHtml5Doctype(XmlDoctype doctype) {
        return doctype.getDtdUri() == null && doctype.getPublicId() == null && doctype.getMarkupDecl() == null;
    }

    public static boolean isHtml5Context(XmlElement context2) {
        XmlDocument doc = (XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)context2, XmlDocument.class);
        if (doc == null && context2 != null) {
            return Html5SchemaProvider.getHtml5SchemaLocation().equals(ExternalResourceManagerEx.getInstanceEx().getDefaultHtmlDoctype(context2.getProject()));
        }
        return HtmlUtil.isHtml5Document(doc);
    }

    public static boolean isHtmlTag(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/xml/util/HtmlUtil", "isHtmlTag"));
        }
        if (tag.getLanguage() != HTMLLanguage.INSTANCE) {
            return false;
        }
        XmlDocument doc = (XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)tag, XmlDocument.class);
        String doctype = null;
        if (doc != null) {
            doctype = XmlUtil.getDtdUri(doc);
        }
        doctype = doctype == null ? ExternalResourceManagerEx.getInstanceEx().getDefaultHtmlDoctype(tag.getProject()) : doctype;
        return XmlUtil.XHTML4_SCHEMA_LOCATION.equals(doctype) || !StringUtil.containsIgnoreCase((String)doctype, (String)"xhtml");
    }

    public static boolean hasNonHtml5Doctype(XmlElement context2) {
        XmlDocument doc = (XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)context2, XmlDocument.class);
        if (doc == null) {
            return false;
        }
        XmlProlog prolog = doc.getProlog();
        XmlDoctype doctype = prolog != null ? prolog.getDoctype() : null;
        return doctype != null && !HtmlUtil.isHtml5Doctype(doctype);
    }

    public static boolean isHtml5Tag(String tagName2) {
        return HTML5_TAGS_SET.contains(tagName2);
    }

    public static boolean isCustomHtml5Attribute(String attributeName) {
        return attributeName.startsWith(HTML5_DATA_ATTR_PREFIX);
    }

    @Nullable
    public static String getHrefBase(XmlFile file2) {
        XmlTag root = file2.getRootTag();
        XmlTag head = root != null ? root.findFirstSubTag("head") : null;
        XmlTag base = head != null ? head.findFirstSubTag("base") : null;
        return base != null ? base.getAttributeValue("href") : null;
    }

    public static boolean isOwnHtmlAttribute(XmlAttributeDescriptor descriptor2) {
        PsiElement declaration = descriptor2.getDeclaration();
        PsiFile file2 = declaration != null ? declaration.getContainingFile() : null;
        String name = file2 != null ? file2.getName() : null;
        return "meta.rnc".equals(name);
    }

    public static boolean tagHasHtml5Schema(@NotNull XmlTag context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/xml/util/HtmlUtil", "tagHasHtml5Schema"));
        }
        XmlElementDescriptor descriptor2 = context2.getDescriptor();
        if (descriptor2 != null) {
            XmlNSDescriptor nsDescriptor = descriptor2.getNSDescriptor();
            XmlFile descriptorFile = nsDescriptor != null ? nsDescriptor.getDescriptorFile() : null;
            String descriptorPath = descriptorFile != null ? descriptorFile.getVirtualFile().getPath() : null;
            return Comparing.equal((String)Html5SchemaProvider.getHtml5SchemaLocation(), (String)descriptorPath) || Comparing.equal((String)Html5SchemaProvider.getXhtml5SchemaLocation(), (String)descriptorPath);
        }
        return false;
    }

    public static Charset detectCharsetFromMetaTag(@NotNull CharSequence content2) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/xml/util/HtmlUtil", "detectCharsetFromMetaTag"));
        }
        int charPrefix = StringUtil.indexOf((CharSequence)content2, (CharSequence)CHARSET);
        while (true) {
            int charsetPrefixEnd;
            if (charPrefix == -1) {
                return null;
            }
            for (charsetPrefixEnd = charPrefix + CHARSET.length(); charsetPrefixEnd < content2.length() && Character.isWhitespace(content2.charAt(charsetPrefixEnd)); ++charsetPrefixEnd) {
            }
            if (charsetPrefixEnd < content2.length() && content2.charAt(charsetPrefixEnd) == '=') break;
            charPrefix = StringUtil.indexOf((CharSequence)content2, (CharSequence)CHARSET, (int)charsetPrefixEnd);
        }
        final Ref charsetNameRef = new Ref();
        try {
            new HtmlBuilderDriver(content2).build(new XmlBuilder(){
                @NonNls
                final Set<String> inTag = new THashSet();
                boolean metHttpEquiv = false;
                boolean metHttml5Charset = false;
                private String contentAttributeValue;

                @Override
                public void doctype(@Nullable CharSequence publicId, @Nullable CharSequence systemId, int startOffset, int endOffset) {
                }

                @Override
                public XmlBuilder.ProcessingOrder startTag(CharSequence localName, String namespace, int startoffset, int endoffset, int headerEndOffset) {
                    String name = localName.toString().toLowerCase();
                    this.inTag.add(name);
                    if (!this.inTag.contains("head") && !"html".equals(name)) {
                        this.terminate();
                    }
                    return XmlBuilder.ProcessingOrder.TAGS_AND_ATTRIBUTES;
                }

                private void terminate() {
                    throw TerminateException.INSTANCE;
                }

                @Override
                public void endTag(CharSequence localName, String namespace, int startoffset, int endoffset) {
                    String name = localName.toString().toLowerCase();
                    if ("meta".equals(name) && (this.metHttpEquiv || this.metHttml5Charset) && this.contentAttributeValue != null) {
                        String charsetName;
                        if (this.metHttpEquiv) {
                            int start2 = this.contentAttributeValue.indexOf(HtmlUtil.CHARSET_PREFIX);
                            if (start2 == -1) {
                                return;
                            }
                            int end = this.contentAttributeValue.indexOf(59, start2 += HtmlUtil.CHARSET_PREFIX.length());
                            if (end == -1) {
                                end = this.contentAttributeValue.length();
                            }
                            charsetName = this.contentAttributeValue.substring(start2, end);
                        } else {
                            charsetName = StringUtil.stripQuotesAroundValue((String)this.contentAttributeValue);
                        }
                        charsetNameRef.set((Object)charsetName);
                        this.terminate();
                    }
                    if ("head".equals(name)) {
                        this.terminate();
                    }
                    this.inTag.remove(name);
                    this.metHttpEquiv = false;
                    this.metHttml5Charset = false;
                    this.contentAttributeValue = null;
                }

                @Override
                public void attribute(CharSequence localName, CharSequence v2, int startoffset, int endoffset) {
                    String name = localName.toString().toLowerCase();
                    if (this.inTag.contains("meta")) {
                        String value2 = v2.toString().toLowerCase();
                        if (name.equals("http-equiv")) {
                            this.metHttpEquiv |= value2.equals("content-type");
                        } else if (name.equals(HtmlUtil.CHARSET)) {
                            this.metHttml5Charset = true;
                            this.contentAttributeValue = value2;
                        }
                        if (name.equals("content")) {
                            this.contentAttributeValue = value2;
                        }
                    }
                }

                @Override
                public void textElement(CharSequence display, CharSequence physical, int startoffset, int endoffset) {
                }

                @Override
                public void entityRef(CharSequence ref, int startOffset, int endOffset) {
                }

                @Override
                public void error(String message2, int startOffset, int endOffset) {
                }
            });
        }
        catch (TerminateException terminateException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        String name = (String)charsetNameRef.get();
        return CharsetToolkit.forName((String)name);
    }

    public static boolean isTagWithoutAttributes(@NonNls String tagName2) {
        return tagName2 != null && "br".equalsIgnoreCase(tagName2);
    }

    public static boolean hasHtml(PsiFile file2) {
        return HtmlUtil.isHtmlFile((PsiElement)file2) || file2.getViewProvider() instanceof TemplateLanguageFileViewProvider;
    }

    public static boolean supportsXmlTypedHandlers(PsiFile file2) {
        for (Language language = file2.getLanguage(); language != null; language = language.getBaseLanguage()) {
            if ("JavaScript".equals(language.getID())) {
                return true;
            }
            if (!"Dart".equals(language.getID())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasHtmlPrefix(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/xml/util/HtmlUtil", "hasHtmlPrefix"));
        }
        return url.startsWith("http://") || url.startsWith("https://") || url.startsWith("//") || url.startsWith("ftp://");
    }

    public static boolean isHtmlFile(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/xml/util/HtmlUtil", "isHtmlFile"));
        }
        Language language = element.getLanguage();
        return language.isKindOf((Language)HTMLLanguage.INSTANCE) || language == XHTMLLanguage.INSTANCE;
    }

    public static boolean isHtmlFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/util/HtmlUtil", "isHtmlFile"));
        }
        FileType fileType = file2.getFileType();
        return fileType == HtmlFileType.INSTANCE || fileType == XHtmlFileType.INSTANCE;
    }

    public static boolean isHtmlTagContainingFile(PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile != null) {
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class, (boolean)false);
            if (tag instanceof HtmlTag) {
                return true;
            }
            XmlDocument document = (XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)element, XmlDocument.class, (boolean)false);
            if (document instanceof HtmlDocumentImpl) {
                return true;
            }
            FileViewProvider provider = containingFile.getViewProvider();
            Language language = provider instanceof TemplateLanguageFileViewProvider ? ((TemplateLanguageFileViewProvider)provider).getTemplateDataLanguage() : provider.getBaseLanguage();
            return language == XHTMLLanguage.INSTANCE;
        }
        return false;
    }

    public static boolean isScriptTag(@Nullable XmlTag tag) {
        return tag != null && tag.getLocalName().equalsIgnoreCase(SCRIPT_TAG_NAME);
    }

    @Nullable
    public static Iterable<String> splitClassNames(@Nullable String classAttributeValue) {
        return classAttributeValue != null ? StringUtil.tokenize((String)classAttributeValue, (String)" \t,") : Collections.emptyList();
    }

    @Contract(value="!null -> !null")
    public static String getTagPresentation(@Nullable XmlTag tag) {
        String classValue;
        if (tag == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(tag.getLocalName());
        String idValue = HtmlUtil.getAttributeValue(tag, ID_ATTRIBUTE_NAME);
        if (idValue != null) {
            builder.append('#').append(idValue);
        }
        if ((classValue = HtmlUtil.getAttributeValue(tag, CLASS_ATTRIBUTE_NAME)) != null) {
            for (String className : HtmlUtil.splitClassNames(classValue)) {
                builder.append('.').append(className);
            }
        }
        return builder.toString();
    }

    @Nullable
    private static String getAttributeValue(@NotNull XmlTag tag, @NotNull String attrName) {
        String value2;
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/xml/util/HtmlUtil", "getAttributeValue"));
        }
        if (attrName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrName", "com/intellij/xml/util/HtmlUtil", "getAttributeValue"));
        }
        XmlAttribute classAttribute = HtmlUtil.getAttributeByName(tag, attrName);
        if (classAttribute != null && !HtmlUtil.containsOuterLanguageElements((PsiElement)classAttribute) && !StringUtil.isEmptyOrSpaces((String)(value2 = classAttribute.getValue()))) {
            return value2;
        }
        return null;
    }

    @Nullable
    private static XmlAttribute getAttributeByName(@NotNull XmlTag tag, @NotNull String name) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/xml/util/HtmlUtil", "getAttributeByName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/xml/util/HtmlUtil", "getAttributeByName"));
        }
        for (PsiElement child = tag.getFirstChild(); child != null; child = child.getNextSibling()) {
            PsiElement nameElement;
            if (!(child instanceof XmlAttribute) || (nameElement = child.getFirstChild()) == null || nameElement.getNode().getElementType() != XmlTokenType.XML_NAME || !name.equalsIgnoreCase(nameElement.getText())) continue;
            return (XmlAttribute)child;
        }
        return null;
    }

    private static boolean containsOuterLanguageElements(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/xml/util/HtmlUtil", "containsOuterLanguageElements"));
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof CompositeElement) {
                return HtmlUtil.containsOuterLanguageElements(child);
            }
            if (!(child instanceof OuterLanguageElement)) continue;
            return true;
        }
        return false;
    }

    public static List<XmlAttributeValue> getIncludedPathsElements(@NotNull XmlFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/util/HtmlUtil", "getIncludedPathsElements"));
        }
        final ArrayList result2 = new ArrayList();
        file2.acceptChildren((PsiElementVisitor)new XmlRecursiveElementWalkingVisitor(){

            public void visitXmlTag(XmlTag tag) {
                XmlAttribute attribute = null;
                if ("link".equalsIgnoreCase(tag.getName())) {
                    attribute = tag.getAttribute("href");
                } else if (HtmlUtil.SCRIPT_TAG_NAME.equalsIgnoreCase(tag.getName()) || "img".equalsIgnoreCase(tag.getName())) {
                    attribute = tag.getAttribute("src");
                }
                if (attribute != null) {
                    result2.add(attribute.getValueElement());
                }
                super.visitXmlTag(tag);
            }

            public void visitElement(PsiElement element) {
                if (element.getLanguage() instanceof XMLLanguage) {
                    super.visitElement(element);
                }
            }
        });
        return result2.isEmpty() ? Collections.emptyList() : result2;
    }

    static {
        for (HTMLControls.Control control : HTMLControls.getControls()) {
            String tagName2 = control.name.toLowerCase(Locale.US);
            if (control.endTag == HTMLControls.TagState.FORBIDDEN) {
                EMPTY_TAGS_MAP.add(tagName2);
            }
            AUTO_CLOSE_BY_MAP.put(tagName2, (Set<String>)new THashSet(control.autoClosedBy));
        }
        ContainerUtil.addAll(OPTIONAL_END_TAGS_MAP, (Object[])OPTIONAL_END_TAGS);
        ContainerUtil.addAll(BLOCK_TAGS_MAP, (Object[])BLOCK_TAGS);
        ContainerUtil.addAll(INLINE_ELEMENTS_CONTAINER_MAP, (Object[])INLINE_ELEMENTS_CONTAINER);
        ContainerUtil.addAll(POSSIBLY_INLINE_TAGS_MAP, (Object[])POSSIBLY_INLINE_TAGS);
        ContainerUtil.addAll(HTML5_TAGS_SET, (Object[])HTML5_TAGS);
    }

    public static class CustomXmlTagDescriptor
    extends XmlElementDescriptorImpl {
        private final String myTagName;

        public CustomXmlTagDescriptor(String tagName2) {
            super(null);
            this.myTagName = tagName2;
        }

        @Override
        public String getName(PsiElement context2) {
            return this.myTagName;
        }

        @Override
        public String getDefaultName() {
            return this.myTagName;
        }

        @Override
        public boolean allowElementsFromNamespace(String namespace, XmlTag context2) {
            return true;
        }
    }

    private static class TerminateException
    extends RuntimeException {
        private static final TerminateException INSTANCE = new TerminateException();

        private TerminateException() {
        }
    }
}

