/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlTagRuleProvider;
import com.intellij.xml.util.XmlTagRuleProviderBase;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TagSetRuleProvider
extends XmlTagRuleProviderBase {
    private final Map<String, TagsRuleMap> map = Collections.synchronizedMap(new HashMap());

    @Nullable
    protected abstract String getNamespace(@NotNull XmlTag var1);

    protected abstract void initMap(TagsRuleMap var1, @NotNull String var2);

    public XmlTagRuleProvider.Rule[] getTagRule(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/xml/util/TagSetRuleProvider", "getTagRule"));
        }
        String namespace = this.getNamespace(tag);
        if (namespace == null) {
            return XmlTagRuleProvider.Rule.EMPTY_ARRAY;
        }
        return this.getTagRule(tag, namespace);
    }

    public XmlTagRuleProvider.Rule[] getTagRule(@NotNull XmlTag tag, String namespace) {
        String tagName2;
        XmlTagRuleProvider.Rule[] rules;
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/xml/util/TagSetRuleProvider", "getTagRule"));
        }
        TagsRuleMap ruleMap = this.map.get(namespace);
        if (ruleMap == null) {
            ruleMap = new TagsRuleMap();
            this.initMap(ruleMap, namespace);
            this.map.put(namespace, ruleMap);
        }
        if ((rules = (XmlTagRuleProvider.Rule[])ruleMap.get(tagName2 = tag.getLocalName())) == null) {
            return XmlTagRuleProvider.Rule.EMPTY_ARRAY;
        }
        return rules;
    }

    protected static class TagsRuleMap
    extends HashMap<String, XmlTagRuleProvider.Rule[]> {
        protected TagsRuleMap() {
        }

        public void add(String tagName2, XmlTagRuleProvider.Rule ... rules) {
            assert (rules.length > 0);
            XmlTagRuleProvider.Rule[] oldValue = this.put(tagName2, rules);
            assert (oldValue == null);
        }
    }
}

