/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.IdReferenceProvider;
import com.intellij.psi.impl.source.xml.PossiblePrefixReference;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlDeclareIdInCommentAction;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlRefCountHolder {
    private static final Key<CachedValue<XmlRefCountHolder>> xmlRefCountHolderKey = Key.create((String)"xml ref count holder");
    private static final UserDataCache<CachedValue<XmlRefCountHolder>, XmlFile, Object> CACHE = new UserDataCache<CachedValue<XmlRefCountHolder>, XmlFile, Object>(){

        protected CachedValue<XmlRefCountHolder> compute(XmlFile file2, Object p2) {
            return CachedValuesManager.getManager((Project)file2.getProject()).createCachedValue(() -> {
                XmlRefCountHolder holder = new XmlRefCountHolder();
                Language language = file2.getViewProvider().getBaseLanguage();
                PsiFile psiFile = file2.getViewProvider().getPsi(language);
                assert (psiFile != null);
                psiFile.accept((PsiElementVisitor)new IdGatheringRecursiveVisitor(holder));
                return new CachedValueProvider.Result((Object)holder, new Object[]{file2});
            }, false);
        }
    };
    private final Map<String, List<Pair<XmlAttributeValue, Boolean>>> myId2AttributeListMap = new HashMap<String, List<Pair<XmlAttributeValue, Boolean>>>();
    private final Set<XmlAttributeValue> myPossiblyDuplicateIds = new HashSet<XmlAttributeValue>();
    private final List<XmlAttributeValue> myIdReferences = new ArrayList<XmlAttributeValue>();
    private final Set<String> myAdditionallyDeclaredIds = new HashSet<String>();
    private final Set<PsiElement> myDoNotValidateParentsList = new HashSet<PsiElement>();
    private final Set<String> myUsedPrefixes = new HashSet<String>();
    private final Set<String> myUsedNamespaces = new HashSet<String>();
    private static final Pattern PREFIX_PATTERN = Pattern.compile("[\\w_][\\w_.]*:");

    @Nullable
    public static XmlRefCountHolder getRefCountHolder(@NotNull XmlFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/util/XmlRefCountHolder", "getRefCountHolder"));
        }
        return (XmlRefCountHolder)((CachedValue)CACHE.get(xmlRefCountHolderKey, (UserDataHolder)file2, null)).getValue();
    }

    private XmlRefCountHolder() {
    }

    public boolean isDuplicateIdAttributeValue(@NotNull XmlAttributeValue value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xml/util/XmlRefCountHolder", "isDuplicateIdAttributeValue"));
        }
        return this.myPossiblyDuplicateIds.contains(value2);
    }

    public boolean isValidatable(@Nullable PsiElement element) {
        return !this.myDoNotValidateParentsList.contains(element);
    }

    public boolean hasIdDeclaration(@NotNull String idRef) {
        if (idRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idRef", "com/intellij/xml/util/XmlRefCountHolder", "hasIdDeclaration"));
        }
        return this.myId2AttributeListMap.get(idRef) != null || this.myAdditionallyDeclaredIds.contains(idRef);
    }

    public boolean isIdReferenceValue(@NotNull XmlAttributeValue value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xml/util/XmlRefCountHolder", "isIdReferenceValue"));
        }
        return this.myIdReferences.contains(value2);
    }

    private void registerId(@NotNull String id, @NotNull XmlAttributeValue attributeValue, boolean soft) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/xml/util/XmlRefCountHolder", "registerId"));
        }
        if (attributeValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeValue", "com/intellij/xml/util/XmlRefCountHolder", "registerId"));
        }
        List<Pair<XmlAttributeValue, Boolean>> list2 = this.myId2AttributeListMap.get(id);
        if (list2 == null) {
            list2 = new ArrayList<Pair<XmlAttributeValue, Boolean>>();
            this.myId2AttributeListMap.put(id, list2);
        } else if (!soft) {
            boolean html = HtmlUtil.isHtmlFile((PsiElement)attributeValue);
            boolean html5 = HtmlUtil.isHtml5Context((XmlElement)attributeValue);
            List notSoft = ContainerUtil.mapNotNull(list2, (Function)((NullableFunction)pair -> {
                if (attributeValue == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeValue", "com/intellij/xml/util/XmlRefCountHolder", "lambda$registerId$0"));
                }
                if (html5 && !"id".equalsIgnoreCase(((XmlAttribute)((XmlAttributeValue)pair.first).getParent()).getName())) {
                    return null;
                }
                if (html && ((XmlAttributeValue)pair.first).getParent().getParent() == attributeValue.getParent().getParent()) {
                    return null;
                }
                return (Boolean)pair.second != false ? null : (XmlAttributeValue)pair.first;
            }));
            if (!notSoft.isEmpty()) {
                this.myPossiblyDuplicateIds.addAll(notSoft);
                this.myPossiblyDuplicateIds.add(attributeValue);
            }
        }
        list2.add((Pair<XmlAttributeValue, Boolean>)new Pair((Object)attributeValue, (Object)soft));
    }

    private void registerAdditionalId(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/xml/util/XmlRefCountHolder", "registerAdditionalId"));
        }
        this.myAdditionallyDeclaredIds.add(id);
    }

    private void registerIdReference(@NotNull XmlAttributeValue value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xml/util/XmlRefCountHolder", "registerIdReference"));
        }
        this.myIdReferences.add(value2);
    }

    private void registerOuterLanguageElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/xml/util/XmlRefCountHolder", "registerOuterLanguageElement"));
        }
        PsiElement parent = element.getParent();
        if (parent instanceof XmlText) {
            parent = parent.getParent();
        }
        this.myDoNotValidateParentsList.add(parent);
    }

    public boolean isInUse(String prefix) {
        return this.myUsedPrefixes.contains(prefix);
    }

    public boolean isUsedNamespace(String ns) {
        return this.myUsedNamespaces.contains(ns);
    }

    private void addUsedPrefix(String prefix) {
        this.myUsedPrefixes.add(prefix);
    }

    private void addUsedNamespace(String ns) {
        this.myUsedNamespaces.add(ns);
    }

    private static class IdGatheringRecursiveVisitor
    extends XmlRecursiveElementWalkingVisitor {
        private final XmlRefCountHolder myHolder;

        private IdGatheringRecursiveVisitor(@NotNull XmlRefCountHolder holder) {
            if (holder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/xml/util/XmlRefCountHolder$IdGatheringRecursiveVisitor", "<init>"));
            }
            super(true);
            this.myHolder = holder;
        }

        public void visitElement(PsiElement element) {
            if (element instanceof OuterLanguageElement) {
                this.visitOuterLanguageElement(element);
            }
            super.visitElement(element);
        }

        private void visitOuterLanguageElement(@NotNull PsiElement element) {
            PsiReference[] references;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/xml/util/XmlRefCountHolder$IdGatheringRecursiveVisitor", "visitOuterLanguageElement"));
            }
            this.myHolder.registerOuterLanguageElement(element);
            for (PsiReference reference : references = element.getReferences()) {
                PsiElement resolve2;
                if (!(reference instanceof PossiblePrefixReference) || !((PossiblePrefixReference)reference).isPrefixReference() || !((resolve2 = reference.resolve()) instanceof SchemaPrefix)) continue;
                this.myHolder.addUsedPrefix(((SchemaPrefix)resolve2).getName());
            }
        }

        public void visitComment(PsiComment comment) {
            this.doVisitAnyComment(comment);
            super.visitComment(comment);
        }

        public void visitXmlComment(XmlComment comment) {
            this.doVisitAnyComment((PsiComment)comment);
            super.visitXmlComment(comment);
        }

        private void doVisitAnyComment(PsiComment comment) {
            String id = XmlDeclareIdInCommentAction.getImplicitlyDeclaredId(comment);
            if (id != null) {
                this.myHolder.registerAdditionalId(id);
            }
        }

        public void visitXmlTag(XmlTag tag) {
            this.myHolder.addUsedPrefix(tag.getNamespacePrefix());
            this.myHolder.addUsedNamespace(tag.getNamespace());
            String text2 = tag.getValue().getTrimmedText();
            this.detectPrefix(text2);
            super.visitXmlTag(tag);
        }

        public void visitXmlAttribute(XmlAttribute attribute) {
            if (!attribute.isNamespaceDeclaration()) {
                this.myHolder.addUsedPrefix(attribute.getNamespacePrefix());
            }
            this.myHolder.addUsedNamespace(attribute.getNamespace());
            super.visitXmlAttribute(attribute);
        }

        public void visitXmlAttributeValue(XmlAttributeValue value2) {
            PsiElement element = value2.getParent();
            if (!(element instanceof XmlAttribute)) {
                return;
            }
            XmlAttribute attribute = (XmlAttribute)element;
            XmlTag tag = attribute.getParent();
            if (tag == null) {
                return;
            }
            XmlElementDescriptor descriptor2 = tag.getDescriptor();
            if (descriptor2 == null) {
                return;
            }
            XmlAttributeDescriptor attributeDescriptor = descriptor2.getAttributeDescriptor(attribute);
            if (attributeDescriptor != null) {
                if (attributeDescriptor.hasIdType()) {
                    this.updateMap(attribute, value2, false);
                } else {
                    PsiReference[] references;
                    for (PsiReference r2 : references = value2.getReferences()) {
                        SchemaPrefix prefix;
                        if (r2 instanceof IdReferenceProvider.GlobalAttributeValueSelfReference) {
                            this.updateMap(attribute, value2, r2.isSoft());
                            continue;
                        }
                        if (!(r2 instanceof SchemaPrefixReference) || (prefix = ((SchemaPrefixReference)r2).resolve()) == null) continue;
                        this.myHolder.addUsedPrefix(prefix.getName());
                    }
                    Matcher matcher = PREFIX_PATTERN.matcher(value2.getText());
                    while (matcher.find()) {
                        this.myHolder.addUsedPrefix(matcher.group());
                    }
                }
                if (attributeDescriptor.hasIdRefType() && PsiTreeUtil.getChildOfType((PsiElement)value2, OuterLanguageElement.class) == null) {
                    this.myHolder.registerIdReference(value2);
                }
            }
            String s2 = value2.getValue();
            this.detectPrefix(s2);
            super.visitXmlAttributeValue(value2);
        }

        private void detectPrefix(String s2) {
            int pos;
            if (s2 != null && (pos = s2.indexOf(58)) > 0) {
                this.myHolder.addUsedPrefix(s2.substring(0, pos));
            }
        }

        private void updateMap(@NotNull XmlAttribute attribute, @NotNull XmlAttributeValue value2, boolean soft) {
            if (attribute == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/xml/util/XmlRefCountHolder$IdGatheringRecursiveVisitor", "updateMap"));
            }
            if (value2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xml/util/XmlRefCountHolder$IdGatheringRecursiveVisitor", "updateMap"));
            }
            String id = XmlHighlightVisitor.getUnquotedValue(value2, attribute.getParent());
            if (XmlUtil.isSimpleValue(id, (PsiElement)value2) && PsiTreeUtil.getChildOfType((PsiElement)value2, OuterLanguageElement.class) == null) {
                this.myHolder.registerId(id, value2, soft);
            }
        }
    }
}

