/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.extension.schema;

import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.ProcessingContext;
import com.jetbrains.jsonSchema.extension.schema.JsonSchemaBaseReference;
import com.jetbrains.jsonSchema.extension.schema.JsonSchemaInsideSchemaResolver;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaExportedDefinitions;
import com.jetbrains.jsonSchema.impl.JsonSchemaReader;
import com.jetbrains.jsonSchema.impl.JsonSchemaWalker;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaRefReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaRefReferenceProvider", "getReferencesByElement"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaRefReferenceProvider", "getReferencesByElement"));
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new JsonSchemaRefReference((JsonValue)element)};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaRefReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    private static class JsonSchemaRefReference
    extends JsonSchemaBaseReference<JsonValue> {
        public JsonSchemaRefReference(JsonValue element) {
            super(element, ElementManipulators.getValueTextRange((PsiElement)element));
        }

        @NotNull
        public String getCanonicalText() {
            String string2 = StringUtil.unquoteString((String)super.getCanonicalText());
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaRefReferenceProvider$JsonSchemaRefReference", "getCanonicalText"));
            }
            return string2;
        }

        @Override
        @Nullable
        public PsiElement resolveInner() {
            String normalized;
            String text2 = this.getCanonicalText();
            JsonSchemaReader.SchemaUrlSplitter splitter = new JsonSchemaReader.SchemaUrlSplitter(text2);
            VirtualFile schemaFile = ((JsonValue)this.getElement()).getContainingFile().getVirtualFile();
            if (splitter.isAbsolute()) {
                assert (splitter.getSchemaId() != null);
                schemaFile = JsonSchemaService.Impl.getEx(((JsonValue)this.getElement()).getProject()).getSchemaFileById(splitter.getSchemaId(), schemaFile);
                if (schemaFile == null) {
                    return null;
                }
            }
            if (StringUtil.isEmptyOrSpaces((String)(normalized = JsonSchemaExportedDefinitions.normalizeId(splitter.getRelativePath()))) || StringUtil.split((String)normalized.replace("\\", "/"), (String)"/").size() == 0) {
                return ((JsonValue)this.myElement).getManager().findFile(schemaFile);
            }
            List chain = StringUtil.split((String)normalized.replace("\\", "/"), (String)"/");
            Iterator iterator2 = chain.iterator();
            boolean canSkip = true;
            while (iterator2.hasNext()) {
                String step = (String)iterator2.next();
                if (canSkip && "properties".equals(step)) {
                    iterator2.remove();
                    canSkip = false;
                    continue;
                }
                canSkip = true;
            }
            List steps = (List)JsonSchemaWalker.buildSteps(StringUtil.join((Collection)chain, (String)"/")).getFirst();
            return new JsonSchemaInsideSchemaResolver(((JsonValue)this.myElement).getProject(), schemaFile, normalized, steps).resolveInSchemaRecursively();
        }
    }
}

