/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.jsonSchema.JsonSchemaFileType;
import com.jetbrains.jsonSchema.impl.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaWalker;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonBySchemaDocumentationProvider
implements DocumentationProvider {
    @NotNull
    private final VirtualFile mySchemaFile;
    @NotNull
    private final JsonSchemaObject myRootSchema;

    public JsonBySchemaDocumentationProvider(@NotNull VirtualFile schemaFile, @NotNull JsonSchemaObject schema) {
        if (schemaFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonBySchemaDocumentationProvider", "<init>"));
        }
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/impl/JsonBySchemaDocumentationProvider", "<init>"));
        }
        this.mySchemaFile = schemaFile;
        this.myRootSchema = schema;
    }

    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        return null;
    }

    @Nullable
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        return null;
    }

    @Nullable
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        JsonLikePsiWalker walker = JsonSchemaWalker.getWalker(element, this.myRootSchema);
        if (walker == null) {
            return null;
        }
        if (JsonSchemaFileType.INSTANCE.equals(element.getContainingFile().getFileType())) {
            JsonProperty jsonProperty;
            JsonProperty jsonProperty2 = jsonProperty = element instanceof JsonProperty ? (JsonProperty)element : (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)element, JsonProperty.class);
            if (jsonProperty != null) {
                JsonProperty description;
                JsonValue value2 = jsonProperty.getValue();
                if (value2 instanceof JsonObject && (description = ((JsonObject)value2).findProperty("description")) != null && description.getValue() instanceof JsonStringLiteral) {
                    return StringUtil.escapeXml((String)StringUtil.unquoteString((String)description.getValue().getText()));
                }
                return null;
            }
        }
        final Ref result2 = Ref.create();
        JsonSchemaWalker.findSchemasForDocumentation(element, walker, new JsonSchemaWalker.CompletionSchemesConsumer(){

            @Override
            public void consume(boolean isName, @NotNull JsonSchemaObject schema, @NotNull VirtualFile schemaFile, @NotNull List<JsonSchemaWalker.Step> steps) {
                if (schema == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/impl/JsonBySchemaDocumentationProvider$1", "consume"));
                }
                if (schemaFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonBySchemaDocumentationProvider$1", "consume"));
                }
                if (steps == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "steps", "com/jetbrains/jsonSchema/impl/JsonBySchemaDocumentationProvider$1", "consume"));
                }
                result2.set((Object)schema.getDescription());
            }

            @Override
            public void oneOf(boolean isName, @NotNull List<JsonSchemaObject> list2, @NotNull VirtualFile schemaFile, @NotNull List<JsonSchemaWalker.Step> steps) {
                if (list2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/jsonSchema/impl/JsonBySchemaDocumentationProvider$1", "oneOf"));
                }
                if (schemaFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonBySchemaDocumentationProvider$1", "oneOf"));
                }
                if (steps == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "steps", "com/jetbrains/jsonSchema/impl/JsonBySchemaDocumentationProvider$1", "oneOf"));
                }
            }

            @Override
            public void anyOf(boolean isName, @NotNull List<JsonSchemaObject> list2, @NotNull VirtualFile schemaFile, @NotNull List<JsonSchemaWalker.Step> steps) {
                if (list2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/jsonSchema/impl/JsonBySchemaDocumentationProvider$1", "anyOf"));
                }
                if (schemaFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonBySchemaDocumentationProvider$1", "anyOf"));
                }
                if (steps == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "steps", "com/jetbrains/jsonSchema/impl/JsonBySchemaDocumentationProvider$1", "anyOf"));
                }
            }
        }, this.myRootSchema, this.mySchemaFile);
        return (String)result2.get();
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context2) {
        return null;
    }
}

