/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.ide.DataManager;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.jetbrains.jsonSchema.impl.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.impl.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaPropertyProcessor;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaWalker;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JsonBySchemaObjectCompletionContributor
extends CompletionContributor {
    private static final String BUILTIN_USAGE_KEY = "json.schema.builtin.completion";
    private static final String SCHEMA_USAGE_KEY = "json.schema.schema.completion";
    private static final String USER_USAGE_KEY = "json.schema.user.completion";
    @NotNull
    private final SchemaType myType;
    @NotNull
    private final VirtualFile mySchemaFile;
    @NotNull
    private final JsonSchemaObject myRootSchema;

    public JsonBySchemaObjectCompletionContributor(@NotNull SchemaType type, @NotNull VirtualFile schemaFile, @NotNull JsonSchemaObject rootSchema) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor", "<init>"));
        }
        if (schemaFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor", "<init>"));
        }
        if (rootSchema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootSchema", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor", "<init>"));
        }
        this.myType = type;
        this.mySchemaFile = schemaFile;
        this.myRootSchema = rootSchema;
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor", "fillCompletionVariants"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor", "fillCompletionVariants"));
        }
        PsiElement position = parameters.getPosition();
        PsiFile containingFile = position.getContainingFile();
        if (containingFile == null) {
            return;
        }
        this.updateStat();
        PsiElement completionPosition = parameters.getOriginalPosition() != null ? parameters.getOriginalPosition() : parameters.getPosition();
        new Worker(this.myRootSchema, this.mySchemaFile, position, completionPosition, (Consumer<LookupElement>)result2).work();
        result2.stopHere();
    }

    public static List<LookupElement> getCompletionVariants(@NotNull JsonSchemaObject schema, @NotNull PsiElement position, @NotNull PsiElement originalPosition, @NotNull VirtualFile schemaFile) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor", "getCompletionVariants"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor", "getCompletionVariants"));
        }
        if (originalPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalPosition", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor", "getCompletionVariants"));
        }
        if (schemaFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor", "getCompletionVariants"));
        }
        ArrayList<LookupElement> result2 = new ArrayList<LookupElement>();
        new Worker(schema, schemaFile, position, originalPosition, (Consumer<LookupElement>)((Consumer)element -> result2.add((LookupElement)element))).work();
        return result2;
    }

    private void updateStat() {
        if (SchemaType.schema.equals((Object)this.myType)) {
            UsageTrigger.trigger(SCHEMA_USAGE_KEY);
        } else if (SchemaType.embeddedSchema.equals((Object)this.myType)) {
            UsageTrigger.trigger(BUILTIN_USAGE_KEY);
        } else if (SchemaType.userSchema.equals((Object)this.myType)) {
            UsageTrigger.trigger(USER_USAGE_KEY);
        }
    }

    public static void insertPropertyWithEnum(InsertionContext context2, Editor editor, String defaultValue, List<Object> values, JsonSchemaType type, String comma) {
        boolean isNumber = type != null && (JsonSchemaType._integer.equals((Object)type) || JsonSchemaType._number.equals((Object)type)) || type == null && (defaultValue != null && !StringUtil.isQuotedString((String)defaultValue) || values != null && ContainerUtil.and(values, v2 -> !(v2 instanceof String)));
        boolean hasValues = !ContainerUtil.isEmpty(values);
        boolean hasDefaultValue = !StringUtil.isEmpty((String)defaultValue);
        String stringToInsert = ":" + (hasDefaultValue ? defaultValue : (isNumber ? "" : "\"\"")) + comma;
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)stringToInsert, (boolean)false, (boolean)true, (int)1);
        if (!isNumber || hasDefaultValue) {
            SelectionModel model2 = editor.getSelectionModel();
            int caretStart = model2.getSelectionStart();
            int newOffset = caretStart + (hasDefaultValue ? defaultValue.length() : 1);
            if (hasDefaultValue && !isNumber) {
                --newOffset;
            }
            model2.setSelection(isNumber ? caretStart : caretStart + 1, newOffset);
            editor.getCaretModel().moveToOffset(newOffset);
        }
        JsonBySchemaObjectCompletionContributor.formatInsertedString(context2, stringToInsert.length());
        if (hasValues) {
            AutoPopupController.getInstance(context2.getProject()).autoPopupMemberLookup(context2.getEditor(), null);
        }
    }

    public static void formatInsertedString(@NotNull InsertionContext context2, int offset) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor", "formatInsertedString"));
        }
        Project project2 = context2.getProject();
        PsiDocumentManager.getInstance((Project)project2).commitDocument(context2.getDocument());
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
        codeStyleManager.reformatText(context2.getFile(), context2.getStartOffset(), context2.getTailOffset() + offset);
    }

    private static class Worker {
        @NotNull
        private final JsonSchemaObject myRootSchema;
        @NotNull
        private final VirtualFile mySchemaFile;
        @NotNull
        private final PsiElement myPosition;
        @NotNull
        private final PsiElement myOriginalPosition;
        @NotNull
        private final Consumer<LookupElement> myResultConsumer;
        private final boolean myWrapInQuotes;
        private final boolean myInsideStringLiteral;
        private final List<LookupElement> myVariants;
        private JsonLikePsiWalker myWalker;

        public Worker(@NotNull JsonSchemaObject rootSchema, @NotNull VirtualFile schemaFile, @NotNull PsiElement position, @NotNull PsiElement originalPosition, @NotNull Consumer<LookupElement> resultConsumer) {
            if (rootSchema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootSchema", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor$Worker", "<init>"));
            }
            if (schemaFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor$Worker", "<init>"));
            }
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor$Worker", "<init>"));
            }
            if (originalPosition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalPosition", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor$Worker", "<init>"));
            }
            if (resultConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultConsumer", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor$Worker", "<init>"));
            }
            this.myRootSchema = rootSchema;
            this.mySchemaFile = schemaFile;
            this.myPosition = position;
            this.myOriginalPosition = originalPosition;
            this.myResultConsumer = resultConsumer;
            this.myVariants = new ArrayList<LookupElement>();
            this.myWalker = JsonSchemaWalker.getWalker(this.myPosition, this.myRootSchema);
            this.myWrapInQuotes = this.myWalker.isNameQuoted() && !(position.getParent() instanceof JsonStringLiteral);
            this.myInsideStringLiteral = position.getParent() instanceof JsonStringLiteral;
        }

        public void work() {
            if (this.myWalker == null) {
                return;
            }
            JsonSchemaWalker.findSchemasForCompletion(this.myPosition, this.myWalker, new JsonSchemaWalker.CompletionSchemesConsumer(){

                @Override
                public void consume(boolean isName, @NotNull JsonSchemaObject schema, @NotNull VirtualFile schemaFile, @NotNull List<JsonSchemaWalker.Step> steps) {
                    if (schema == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor$Worker$1", "consume"));
                    }
                    if (schemaFile == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor$Worker$1", "consume"));
                    }
                    if (steps == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "steps", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor$Worker$1", "consume"));
                    }
                    if (isName) {
                        final boolean insertComma = myWalker.hasPropertiesBehindAndNoComma(myPosition);
                        final boolean hasValue = myWalker.isPropertyWithValue(myPosition.getParent().getParent());
                        final Set<String> properties = myWalker.getPropertyNamesOfParentObject(myOriginalPosition);
                        final JsonPropertyAdapter adapter2 = myWalker.getParentPropertyAdapter(myOriginalPosition);
                        JsonSchemaPropertyProcessor.process(new JsonSchemaPropertyProcessor.PropertyProcessor(){

                            @Override
                            public boolean process(String name, JsonSchemaObject schema) {
                                if (properties.contains(name) && (adapter2 == null || !name.equals(adapter2.getName()))) {
                                    return true;
                                }
                                this.addPropertyVariant(name, schema, hasValue, insertComma);
                                return true;
                            }
                        }, schema);
                    } else {
                        this.suggestValues(schema);
                    }
                }

                @Override
                public void oneOf(boolean isName, @NotNull List<JsonSchemaObject> list2, @NotNull VirtualFile schemaFile, @NotNull List<JsonSchemaWalker.Step> steps) {
                    if (list2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor$Worker$1", "oneOf"));
                    }
                    if (schemaFile == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor$Worker$1", "oneOf"));
                    }
                    if (steps == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "steps", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor$Worker$1", "oneOf"));
                    }
                    list2.forEach(s2 -> {
                        if (schemaFile == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor$Worker$1", "lambda$oneOf$0"));
                        }
                        if (steps == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "steps", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor$Worker$1", "lambda$oneOf$0"));
                        }
                        this.consume(isName, (JsonSchemaObject)s2, schemaFile, steps);
                    });
                }

                @Override
                public void anyOf(boolean isName, @NotNull List<JsonSchemaObject> list2, @NotNull VirtualFile schemaFile, @NotNull List<JsonSchemaWalker.Step> steps) {
                    if (list2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor$Worker$1", "anyOf"));
                    }
                    if (schemaFile == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor$Worker$1", "anyOf"));
                    }
                    if (steps == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "steps", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor$Worker$1", "anyOf"));
                    }
                    list2.forEach(s2 -> {
                        if (schemaFile == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor$Worker$1", "lambda$anyOf$1"));
                        }
                        if (steps == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "steps", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor$Worker$1", "lambda$anyOf$1"));
                        }
                        this.consume(isName, (JsonSchemaObject)s2, schemaFile, steps);
                    });
                }
            }, this.myRootSchema, this.mySchemaFile);
            for (LookupElement variant : this.myVariants) {
                this.myResultConsumer.consume((Object)variant);
            }
        }

        private void suggestValues(JsonSchemaObject schema) {
            block3: {
                block4: {
                    block2: {
                        this.suggestValuesForSchemaVariants(schema.getAnyOf());
                        this.suggestValuesForSchemaVariants(schema.getOneOf());
                        this.suggestValuesForSchemaVariants(schema.getAllOf());
                        if (schema.getEnum() == null) break block2;
                        for (Object o2 : schema.getEnum()) {
                            this.addValueVariant(o2.toString(), null);
                        }
                        break block3;
                    }
                    JsonSchemaType type = schema.getType();
                    if (type == null) break block4;
                    this.suggestByType(schema, type);
                    break block3;
                }
                if (schema.getTypeVariants() == null) break block3;
                for (JsonSchemaType schemaType : schema.getTypeVariants()) {
                    this.suggestByType(schema, schemaType);
                }
            }
        }

        private void suggestByType(JsonSchemaObject schema, JsonSchemaType type) {
            if (JsonSchemaType._boolean.equals((Object)type)) {
                this.addPossibleBooleanValue(type);
            } else if (JsonSchemaType._string.equals((Object)type)) {
                this.addPossibleStringValue(schema);
            } else if (JsonSchemaType._null.equals((Object)type)) {
                this.addValueVariant("null", null);
            }
        }

        private void addPossibleStringValue(JsonSchemaObject schema) {
            String defaultValueString;
            Object defaultValue = schema.getDefault();
            String string2 = defaultValueString = defaultValue == null ? null : defaultValue.toString();
            if (!StringUtil.isEmpty((String)defaultValueString)) {
                String quotedValue = defaultValueString;
                if (!StringUtil.isQuotedString((String)quotedValue)) {
                    quotedValue = StringUtil.wrapWithDoubleQuote((String)quotedValue);
                }
                this.addValueVariant(quotedValue, null);
            }
        }

        private void suggestValuesForSchemaVariants(List<JsonSchemaObject> list2) {
            if (list2 != null && list2.size() > 0) {
                for (JsonSchemaObject schemaObject : list2) {
                    this.suggestValues(schemaObject);
                }
            }
        }

        private void addPossibleBooleanValue(JsonSchemaType type) {
            if (JsonSchemaType._boolean.equals((Object)type)) {
                this.addValueVariant("true", null);
                this.addValueVariant("false", null);
            }
        }

        private void addValueVariant(@NotNull String key, @Nullable String description) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor$Worker", "addValueVariant"));
            }
            LookupElementBuilder builder = LookupElementBuilder.create((String)(!this.myWrapInQuotes ? StringUtil.unquoteString((String)key) : key));
            if (description != null) {
                builder = builder.withTypeText(description);
            }
            this.myVariants.add((LookupElement)builder);
        }

        private void addPropertyVariant(@NotNull String key, @NotNull JsonSchemaObject jsonSchemaObject, boolean hasValue, boolean insertComma) {
            String typeText;
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor$Worker", "addPropertyVariant"));
            }
            if (jsonSchemaObject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsonSchemaObject", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor$Worker", "addPropertyVariant"));
            }
            String description = jsonSchemaObject.getDescription();
            String title = jsonSchemaObject.getTitle();
            key = !this.myWrapInQuotes ? key : StringUtil.wrapWithDoubleQuote((String)key);
            LookupElementBuilder builder = LookupElementBuilder.create((String)key);
            String string2 = typeText = StringUtil.isEmpty((String)title) ? description : title;
            if (!StringUtil.isEmpty((String)typeText)) {
                builder = builder.withTypeText(typeText, true);
            }
            JsonSchemaType type = jsonSchemaObject.getType();
            List<Object> values = jsonSchemaObject.getEnum();
            if (type != null || !ContainerUtil.isEmpty(values) || jsonSchemaObject.getDefault() != null) {
                builder = builder.withInsertHandler(this.createPropertyInsertHandler(jsonSchemaObject, hasValue, insertComma));
            } else if (!hasValue) {
                builder = builder.withInsertHandler(this.createDefaultPropertyInsertHandler(false, insertComma));
            }
            this.myVariants.add((LookupElement)builder);
        }

        private InsertHandler<LookupElement> createDefaultPropertyInsertHandler(final boolean hasValue, final boolean insertComma) {
            return new InsertHandler<LookupElement>(){

                public void handleInsert(InsertionContext context2, LookupElement item) {
                    ApplicationManager.getApplication().assertWriteAccessAllowed();
                    Editor editor = context2.getEditor();
                    Project project2 = context2.getProject();
                    if (this.handleInsideQuotesInsertion(context2, editor, hasValue)) {
                        return;
                    }
                    String stringToInsert = ": 1" + (insertComma ? "," : "");
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)stringToInsert, (boolean)false, (boolean)true, (int)2);
                    JsonBySchemaObjectCompletionContributor.formatInsertedString(context2, stringToInsert.length());
                    int offset = editor.getCaretModel().getOffset();
                    context2.getDocument().deleteString(offset, offset + 1);
                    PsiDocumentManager.getInstance((Project)project2).commitDocument(editor.getDocument());
                    AutoPopupController.getInstance(context2.getProject()).autoPopupMemberLookup(context2.getEditor(), null);
                }
            };
        }

        @NotNull
        private InsertHandler<LookupElement> createPropertyInsertHandler(@NotNull JsonSchemaObject jsonSchemaObject, final boolean hasValue, final boolean insertComma) {
            Object defaultValue;
            if (jsonSchemaObject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsonSchemaObject", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor$Worker", "createPropertyInsertHandler"));
            }
            JsonSchemaType type = jsonSchemaObject.getType();
            final List<Object> values = jsonSchemaObject.getEnum();
            if (type == null && values != null && !values.isEmpty()) {
                type = Worker.detectType(values);
            }
            final String defaultValueAsString = (defaultValue = jsonSchemaObject.getDefault()) == null || defaultValue instanceof JsonSchemaObject ? null : (defaultValue instanceof String ? "\"" + defaultValue + "\"" : String.valueOf(defaultValue));
            final JsonSchemaType finalType = type;
            InsertHandler<LookupElement> insertHandler = new InsertHandler<LookupElement>(){

                public void handleInsert(InsertionContext context2, LookupElement item) {
                    String comma;
                    ApplicationManager.getApplication().assertWriteAccessAllowed();
                    Editor editor = context2.getEditor();
                    Project project2 = context2.getProject();
                    String string2 = comma = insertComma ? "," : "";
                    if (this.handleInsideQuotesInsertion(context2, editor, hasValue)) {
                        return;
                    }
                    if (finalType != null) {
                        switch (finalType) {
                            case _object: {
                                String stringToInsert = ":{}" + comma;
                                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)stringToInsert, (boolean)false, (boolean)true, (int)2);
                                PsiDocumentManager.getInstance((Project)project2).commitDocument(editor.getDocument());
                                JsonBySchemaObjectCompletionContributor.formatInsertedString(context2, stringToInsert.length());
                                EditorActionHandler handler2 = EditorActionManager.getInstance().getActionHandler("EditorEnter");
                                handler2.execute(editor, editor.getCaretModel().getCurrentCaret(), DataManager.getInstance().getDataContext((Component)editor.getContentComponent()));
                                break;
                            }
                            case _boolean: {
                                String value2 = String.valueOf(Boolean.TRUE.toString().equals(defaultValueAsString));
                                String stringToInsert = ":" + value2 + comma;
                                SelectionModel model2 = editor.getSelectionModel();
                                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)stringToInsert, (boolean)false, (boolean)true, (int)(stringToInsert.length() - comma.length()));
                                JsonBySchemaObjectCompletionContributor.formatInsertedString(context2, stringToInsert.length());
                                int start2 = editor.getSelectionModel().getSelectionStart();
                                model2.setSelection(start2 - value2.length(), start2);
                                AutoPopupController.getInstance(context2.getProject()).autoPopupMemberLookup(context2.getEditor(), null);
                                break;
                            }
                            case _array: {
                                String stringToInsert = ":[]" + comma;
                                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)stringToInsert, (boolean)false, (boolean)true, (int)2);
                                JsonBySchemaObjectCompletionContributor.formatInsertedString(context2, stringToInsert.length());
                                break;
                            }
                            case _string: 
                            case _integer: {
                                JsonBySchemaObjectCompletionContributor.insertPropertyWithEnum(context2, editor, defaultValueAsString, values, finalType, comma);
                                break;
                            }
                        }
                    } else {
                        JsonBySchemaObjectCompletionContributor.insertPropertyWithEnum(context2, editor, defaultValueAsString, values, null, comma);
                    }
                }
            };
            if (insertHandler == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor$Worker", "createPropertyInsertHandler"));
            }
            return insertHandler;
        }

        private boolean handleInsideQuotesInsertion(InsertionContext context2, Editor editor, boolean hasValue) {
            if (this.myInsideStringLiteral) {
                int endOffset;
                int offset = editor.getCaretModel().getOffset();
                PsiElement element = context2.getFile().findElementAt(offset);
                int tailOffset = context2.getTailOffset();
                int guessEndOffset = tailOffset + 1;
                if (element != null && (endOffset = element.getTextRange().getEndOffset()) > tailOffset) {
                    context2.getDocument().deleteString(tailOffset, endOffset - 1);
                }
                if (hasValue) {
                    return true;
                }
                editor.getCaretModel().moveToOffset(guessEndOffset);
            } else {
                editor.getCaretModel().moveToOffset(context2.getTailOffset());
            }
            return false;
        }

        @Nullable
        private static JsonSchemaType detectType(List<Object> values) {
            JsonSchemaType type = null;
            for (Object value2 : values) {
                JsonSchemaType newType = null;
                if (value2 instanceof Integer) {
                    newType = JsonSchemaType._integer;
                }
                if (type != null && !type.equals((Object)newType)) {
                    return null;
                }
                type = newType;
            }
            return type;
        }
    }
}

