/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.JsonElementTypes;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.jsonSchema.impl.JsonJsonPropertyAdapter;
import com.jetbrains.jsonSchema.impl.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.impl.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.impl.JsonSchemaWalker;
import com.jetbrains.jsonSchema.impl.JsonValueAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonOriginalPsiWalker
implements JsonLikePsiWalker {
    public static final JsonOriginalPsiWalker INSTANCE = new JsonOriginalPsiWalker();

    @Override
    public boolean handles(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/impl/JsonOriginalPsiWalker", "handles"));
        }
        return element instanceof JsonElement || element instanceof LeafPsiElement && element.getParent() instanceof JsonElement;
    }

    @Override
    public boolean isName(PsiElement checkable) {
        PsiElement parent = checkable.getParent();
        if (parent instanceof JsonObject) {
            return true;
        }
        if (parent instanceof JsonProperty) {
            return PsiTreeUtil.isAncestor((PsiElement)((JsonProperty)parent).getNameElement(), (PsiElement)checkable, (boolean)false);
        }
        return false;
    }

    @Override
    public boolean isPropertyWithValue(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/impl/JsonOriginalPsiWalker", "isPropertyWithValue"));
        }
        return element instanceof JsonProperty && ((JsonProperty)element).getValue() != null;
    }

    @Override
    public PsiElement goUpToCheckable(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/impl/JsonOriginalPsiWalker", "goUpToCheckable"));
        }
        for (PsiElement current = element; current != null && !(current instanceof PsiFile); current = current.getParent()) {
            if (!(current instanceof JsonValue) && !(current instanceof JsonProperty)) continue;
            return current;
        }
        return null;
    }

    @Override
    public List<JsonSchemaWalker.Step> findPosition(@NotNull PsiElement element, boolean isName, boolean forceLastTransition) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/impl/JsonOriginalPsiWalker", "findPosition"));
        }
        ArrayList<JsonSchemaWalker.Step> steps = new ArrayList<JsonSchemaWalker.Step>();
        if (!isName) {
            steps.add(new JsonSchemaWalker.Step(JsonSchemaWalker.StateType._value, null));
        }
        PsiElement current = element;
        while (!(current instanceof PsiFile)) {
            String propertyName;
            PsiElement position = current;
            if ((current = current.getParent()) instanceof JsonArray) {
                JsonArray array2 = (JsonArray)current;
                List<JsonValue> list2 = array2.getValueList();
                int idx = -1;
                for (int i2 = 0; i2 < list2.size(); ++i2) {
                    JsonValue value2 = list2.get(i2);
                    if (!value2.equals(position)) continue;
                    idx = i2;
                    break;
                }
                steps.add(new JsonSchemaWalker.Step(JsonSchemaWalker.StateType._array, new JsonSchemaWalker.ArrayTransition(idx)));
                continue;
            }
            if (current instanceof JsonProperty) {
                propertyName = ((JsonProperty)current).getName();
                if (!((current = current.getParent()) instanceof JsonObject)) {
                    return null;
                }
                if (position == element && !forceLastTransition) continue;
                steps.add(new JsonSchemaWalker.Step(JsonSchemaWalker.StateType._object, new JsonSchemaWalker.PropertyTransition(propertyName)));
                continue;
            }
            if (current instanceof JsonObject && position instanceof JsonProperty) {
                if (position == element && !forceLastTransition) continue;
                propertyName = ((JsonProperty)position).getName();
                steps.add(new JsonSchemaWalker.Step(JsonSchemaWalker.StateType._object, new JsonSchemaWalker.PropertyTransition(propertyName)));
                continue;
            }
            if (current instanceof PsiFile) break;
            return null;
        }
        Collections.reverse(steps);
        return steps;
    }

    @Override
    public boolean isNameQuoted() {
        return true;
    }

    @Override
    public boolean onlyDoubleQuotesForStringLiterals() {
        return true;
    }

    @Override
    public boolean hasPropertiesBehindAndNoComma(@NotNull PsiElement element) {
        PsiElement current;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/impl/JsonOriginalPsiWalker", "hasPropertiesBehindAndNoComma"));
        }
        PsiElement psiElement = current = element instanceof JsonProperty ? element : PsiTreeUtil.getParentOfType((PsiElement)element, JsonProperty.class);
        while (current != null && current.getNode().getElementType() != JsonElementTypes.COMMA) {
            current = current.getNextSibling();
        }
        int commaOffset = current == null ? Integer.MAX_VALUE : current.getTextRange().getStartOffset();
        int offset = element.getTextRange().getStartOffset();
        JsonObject object = (JsonObject)PsiTreeUtil.getParentOfType((PsiElement)element, JsonObject.class);
        if (object != null) {
            for (JsonProperty property : object.getPropertyList()) {
                int pOffset = property.getTextRange().getStartOffset();
                if (pOffset < offset || PsiTreeUtil.isAncestor((PsiElement)property, (PsiElement)element, (boolean)false)) continue;
                return pOffset < commaOffset;
            }
        }
        return false;
    }

    @Override
    public Set<String> getPropertyNamesOfParentObject(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/impl/JsonOriginalPsiWalker", "getPropertyNamesOfParentObject"));
        }
        JsonObject object = (JsonObject)PsiTreeUtil.getParentOfType((PsiElement)element, JsonObject.class);
        if (object != null) {
            return object.getPropertyList().stream().filter(p2 -> p2.getNameElement() instanceof JsonStringLiteral).map(p2 -> StringUtil.unquoteString((String)p2.getName())).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    @Override
    public JsonPropertyAdapter getParentPropertyAdapter(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/impl/JsonOriginalPsiWalker", "getParentPropertyAdapter"));
        }
        JsonProperty property = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)element, JsonProperty.class, (boolean)false);
        if (property == null) {
            return null;
        }
        return new JsonJsonPropertyAdapter(property);
    }

    @Override
    public boolean isTopJsonElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/impl/JsonOriginalPsiWalker", "isTopJsonElement"));
        }
        return element instanceof PsiFile;
    }

    @Override
    @Nullable
    public JsonValueAdapter createValueAdapter(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/impl/JsonOriginalPsiWalker", "createValueAdapter"));
        }
        return element instanceof JsonValue ? JsonJsonPropertyAdapter.createAdapterByType((JsonValue)element) : null;
    }
}

