/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.psi.JsonObject;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.Consumer;
import com.intellij.util.containers.SLRUMap;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaObject {
    private SmartPsiElementPointer<JsonObject> myPeerPointer;
    private String myDefinitionAddress;
    private Map<String, JsonSchemaObject> myDefinitions;
    private SmartPsiElementPointer<JsonObject> myDefinitionsPointer;
    private Map<String, JsonSchemaObject> myProperties;
    private Map<String, JsonSchemaObject> myPatternProperties;
    private final PatternCalculator myPatternCalculator;
    private final PatternCalculator myValuesPatternCalculator;
    private String myId;
    private String mySchema;
    private String myDescription;
    private String myTitle;
    private JsonSchemaType myType;
    private Object myDefault;
    private String myRef;
    private String myFormat;
    private List<JsonSchemaType> myTypeVariants;
    private Number myMultipleOf;
    private Number myMaximum;
    private boolean myExclusiveMaximum;
    private Number myMinimum;
    private boolean myExclusiveMinimum;
    private Integer myMaxLength;
    private Integer myMinLength;
    private String myPattern;
    private Boolean myAdditionalPropertiesAllowed;
    private JsonSchemaObject myAdditionalPropertiesSchema;
    private Boolean myAdditionalItemsAllowed;
    private JsonSchemaObject myAdditionalItemsSchema;
    private JsonSchemaObject myItemsSchema;
    private List<JsonSchemaObject> myItemsSchemaList;
    private Integer myMaxItems;
    private Integer myMinItems;
    private Boolean myUniqueItems;
    private Integer myMaxProperties;
    private Integer myMinProperties;
    private List<String> myRequired;
    private Map<String, List<String>> myPropertyDependencies;
    private Map<String, JsonSchemaObject> mySchemaDependencies;
    private List<Object> myEnum;
    private List<JsonSchemaObject> myAllOf;
    private List<JsonSchemaObject> myAnyOf;
    private List<JsonSchemaObject> myOneOf;
    private JsonSchemaObject myNot;
    private boolean myShouldValidateAgainstJSType;

    public JsonSchemaObject(@NotNull JsonObject object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/jetbrains/jsonSchema/impl/JsonSchemaObject", "<init>"));
        }
        this.myPatternCalculator = new PatternCalculator();
        this.myValuesPatternCalculator = new PatternCalculator();
        this.myProperties = new HashMap<String, JsonSchemaObject>();
        this.myPeerPointer = SmartPointerManager.getInstance((Project)object.getProject()).createSmartPsiElementPointer((PsiElement)object);
    }

    public JsonSchemaObject(@Nullable SmartPsiElementPointer<JsonObject> peerPointer) {
        this.myPatternCalculator = new PatternCalculator();
        this.myValuesPatternCalculator = new PatternCalculator();
        this.myProperties = new HashMap<String, JsonSchemaObject>();
        this.myPeerPointer = peerPointer;
    }

    public void copyValues(JsonSchemaObject other) {
        this.myId = other.myId;
        this.mySchema = other.mySchema;
        this.myDescription = other.myDescription;
        this.myTitle = other.myTitle;
        this.myProperties = other.myProperties;
        this.myDefinitions = other.myDefinitions;
        this.myPatternProperties = other.myPatternProperties;
        this.myPatternCalculator.clear();
        this.myValuesPatternCalculator.clear();
        this.myType = other.myType;
        this.myDefault = other.myDefault;
        this.myRef = other.myRef;
        this.myFormat = other.myFormat;
        this.myTypeVariants = other.myTypeVariants;
        this.myMultipleOf = other.myMultipleOf;
        this.myMaximum = other.myMaximum;
        this.myExclusiveMaximum = other.myExclusiveMaximum;
        this.myMinimum = other.myMinimum;
        this.myExclusiveMinimum = other.myExclusiveMinimum;
        this.myMaxLength = other.myMaxLength;
        this.myMinLength = other.myMinLength;
        this.myPattern = other.myPattern;
        this.myAdditionalPropertiesAllowed = other.myAdditionalPropertiesAllowed;
        this.myAdditionalPropertiesSchema = other.myAdditionalPropertiesSchema;
        this.myAdditionalItemsAllowed = other.myAdditionalItemsAllowed;
        this.myAdditionalItemsSchema = other.myAdditionalItemsSchema;
        this.myItemsSchema = other.myItemsSchema;
        this.myItemsSchemaList = other.myItemsSchemaList;
        this.myMaxItems = other.myMaxItems;
        this.myMinItems = other.myMinItems;
        this.myUniqueItems = other.myUniqueItems;
        this.myMaxProperties = other.myMaxProperties;
        this.myMinProperties = other.myMinProperties;
        this.myRequired = other.myRequired;
        this.myPropertyDependencies = other.myPropertyDependencies;
        this.mySchemaDependencies = other.mySchemaDependencies;
        this.myEnum = other.myEnum;
        this.myAllOf = other.myAllOf;
        this.myAnyOf = other.myAnyOf;
        this.myOneOf = other.myOneOf;
        this.myNot = other.myNot;
        this.myDefinitionAddress = other.myDefinitionAddress;
        this.myPeerPointer = other.myPeerPointer;
        this.myShouldValidateAgainstJSType = other.myShouldValidateAgainstJSType;
    }

    public void mergeValues(JsonSchemaObject other) {
        this.myProperties.putAll(other.myProperties);
        this.myDefinitions = JsonSchemaObject.copyMap(this.myDefinitions, other.myDefinitions);
        this.myPatternProperties = JsonSchemaObject.copyMap(this.myPatternProperties, other.myPatternProperties);
        this.myPatternCalculator.clear();
        this.myValuesPatternCalculator.clear();
        if (!StringUtil.isEmptyOrSpaces((String)other.myDescription)) {
            this.myDescription = other.myDescription;
        }
        if (other.myType != null) {
            this.myType = other.myType;
        }
        if (other.myDefault != null) {
            this.myDefault = other.myDefault;
        }
        if (other.myRef != null) {
            this.myRef = other.myRef;
        }
        if (other.myFormat != null) {
            this.myFormat = other.myFormat;
        }
        this.myTypeVariants = JsonSchemaObject.copyList(this.myTypeVariants, other.myTypeVariants);
        if (other.myMultipleOf != null) {
            this.myMultipleOf = other.myMultipleOf;
        }
        if (other.myMaximum != null) {
            this.myMaximum = other.myMaximum;
        }
        if (other.myExclusiveMaximum) {
            this.myExclusiveMaximum = other.myExclusiveMaximum;
        }
        if (other.myMinimum != null) {
            this.myMinimum = other.myMinimum;
        }
        if (other.myExclusiveMinimum) {
            this.myExclusiveMinimum = other.myExclusiveMinimum;
        }
        if (other.myMaxLength != null) {
            this.myMaxLength = other.myMaxLength;
        }
        if (other.myMinLength != null) {
            this.myMinLength = other.myMinLength;
        }
        if (other.myPattern != null) {
            this.myPattern = other.myPattern;
        }
        if (other.myAdditionalPropertiesAllowed != null) {
            this.myAdditionalPropertiesAllowed = other.myAdditionalPropertiesAllowed;
        }
        if (other.myAdditionalPropertiesSchema != null) {
            this.myAdditionalPropertiesSchema = other.myAdditionalPropertiesSchema;
        }
        if (other.myAdditionalItemsAllowed != null) {
            this.myAdditionalItemsAllowed = other.myAdditionalItemsAllowed;
        }
        if (other.myAdditionalItemsSchema != null) {
            this.myAdditionalItemsSchema = other.myAdditionalItemsSchema;
        }
        if (other.myItemsSchema != null) {
            this.myItemsSchema = other.myItemsSchema;
        }
        this.myItemsSchemaList = JsonSchemaObject.copyList(this.myItemsSchemaList, other.myItemsSchemaList);
        if (other.myMaxItems != null) {
            this.myMaxItems = other.myMaxItems;
        }
        if (other.myMinItems != null) {
            this.myMinItems = other.myMinItems;
        }
        if (other.myUniqueItems != null) {
            this.myUniqueItems = other.myUniqueItems;
        }
        if (other.myMaxProperties != null) {
            this.myMaxProperties = other.myMaxProperties;
        }
        if (other.myMinProperties != null) {
            this.myMinProperties = other.myMinProperties;
        }
        this.myRequired = JsonSchemaObject.copyList(this.myRequired, other.myRequired);
        this.myPropertyDependencies = JsonSchemaObject.copyMap(this.myPropertyDependencies, other.myPropertyDependencies);
        this.mySchemaDependencies = JsonSchemaObject.copyMap(this.mySchemaDependencies, other.mySchemaDependencies);
        if (other.myEnum != null) {
            this.myEnum = other.myEnum;
        }
        this.myAllOf = JsonSchemaObject.copyList(this.myAllOf, other.myAllOf);
        this.myAnyOf = JsonSchemaObject.copyList(this.myAnyOf, other.myAnyOf);
        this.myOneOf = JsonSchemaObject.copyList(this.myOneOf, other.myOneOf);
        if (other.myNot != null) {
            this.myNot = other.myNot;
        }
        this.myShouldValidateAgainstJSType |= other.myShouldValidateAgainstJSType;
    }

    public void shouldValidateAgainstJSType() {
        this.myShouldValidateAgainstJSType = true;
    }

    public boolean isShouldValidateAgainstJSType() {
        return this.myShouldValidateAgainstJSType;
    }

    private static <T> List<T> copyList(List<T> target, List<T> source) {
        if (source == null || source.isEmpty()) {
            return target;
        }
        if (target == null) {
            target = new ArrayList<T>();
        }
        target.addAll(source);
        return target;
    }

    private static <K, V> Map<K, V> copyMap(Map<K, V> target, Map<K, V> source) {
        if (source == null || source.isEmpty()) {
            return target;
        }
        if (target == null) {
            target = new HashMap();
        }
        target.putAll(source);
        return target;
    }

    public SmartPsiElementPointer<JsonObject> getPeerPointer() {
        return this.myPeerPointer;
    }

    public void setPeerPointer(SmartPsiElementPointer<JsonObject> peerPointer) {
        this.myPeerPointer = peerPointer;
    }

    public SmartPsiElementPointer<JsonObject> getDefinitionsPointer() {
        return this.myDefinitionsPointer;
    }

    public void setDefinitionsPointer(SmartPsiElementPointer<JsonObject> definitionsPointer) {
        this.myDefinitionsPointer = definitionsPointer;
    }

    public Map<String, JsonSchemaObject> getDefinitions() {
        return this.myDefinitions;
    }

    public void setDefinitions(Map<String, JsonSchemaObject> definitions) {
        this.myDefinitions = definitions;
    }

    public Map<String, JsonSchemaObject> getProperties() {
        return this.myProperties;
    }

    public void setProperties(Map<String, JsonSchemaObject> properties) {
        this.myProperties = properties;
    }

    public Map<String, JsonSchemaObject> getPatternProperties() {
        return this.myPatternProperties;
    }

    public void setPatternProperties(Map<String, JsonSchemaObject> patternProperties) {
        this.myPatternProperties = patternProperties;
        this.myPatternCalculator.clear();
    }

    public JsonSchemaType getType() {
        return this.myType;
    }

    public void setType(JsonSchemaType type) {
        this.myType = type;
    }

    public Number getMultipleOf() {
        return this.myMultipleOf;
    }

    public void setMultipleOf(Number multipleOf) {
        this.myMultipleOf = multipleOf;
    }

    public Number getMaximum() {
        return this.myMaximum;
    }

    public void setMaximum(Number maximum) {
        this.myMaximum = maximum;
    }

    public boolean isExclusiveMaximum() {
        return this.myExclusiveMaximum;
    }

    public void setExclusiveMaximum(boolean exclusiveMaximum) {
        this.myExclusiveMaximum = exclusiveMaximum;
    }

    public Number getMinimum() {
        return this.myMinimum;
    }

    public void setMinimum(Number minimum) {
        this.myMinimum = minimum;
    }

    public boolean isExclusiveMinimum() {
        return this.myExclusiveMinimum;
    }

    public void setExclusiveMinimum(boolean exclusiveMinimum) {
        this.myExclusiveMinimum = exclusiveMinimum;
    }

    public Integer getMaxLength() {
        return this.myMaxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.myMaxLength = maxLength;
    }

    public Integer getMinLength() {
        return this.myMinLength;
    }

    public void setMinLength(Integer minLength) {
        this.myMinLength = minLength;
    }

    public String getPattern() {
        return this.myPattern;
    }

    public void setPattern(String pattern) {
        this.myPattern = pattern;
        this.myValuesPatternCalculator.clear();
    }

    public Boolean getAdditionalPropertiesAllowed() {
        return this.myAdditionalPropertiesAllowed == null || this.myAdditionalPropertiesAllowed != false;
    }

    public void setAdditionalPropertiesAllowed(Boolean additionalPropertiesAllowed) {
        this.myAdditionalPropertiesAllowed = additionalPropertiesAllowed;
    }

    public JsonSchemaObject getAdditionalPropertiesSchema() {
        return this.myAdditionalPropertiesSchema;
    }

    public void setAdditionalPropertiesSchema(JsonSchemaObject additionalPropertiesSchema) {
        this.myAdditionalPropertiesSchema = additionalPropertiesSchema;
    }

    public Boolean getAdditionalItemsAllowed() {
        return this.myAdditionalItemsAllowed == null || this.myAdditionalItemsAllowed != false;
    }

    public void setAdditionalItemsAllowed(Boolean additionalItemsAllowed) {
        this.myAdditionalItemsAllowed = additionalItemsAllowed;
    }

    public JsonSchemaObject getAdditionalItemsSchema() {
        return this.myAdditionalItemsSchema;
    }

    public void setAdditionalItemsSchema(JsonSchemaObject additionalItemsSchema) {
        this.myAdditionalItemsSchema = additionalItemsSchema;
    }

    public JsonSchemaObject getItemsSchema() {
        return this.myItemsSchema;
    }

    public void setItemsSchema(JsonSchemaObject itemsSchema) {
        this.myItemsSchema = itemsSchema;
    }

    public List<JsonSchemaObject> getItemsSchemaList() {
        return this.myItemsSchemaList;
    }

    public void setItemsSchemaList(List<JsonSchemaObject> itemsSchemaList) {
        this.myItemsSchemaList = itemsSchemaList;
    }

    public Integer getMaxItems() {
        return this.myMaxItems;
    }

    public void setMaxItems(Integer maxItems) {
        this.myMaxItems = maxItems;
    }

    public Integer getMinItems() {
        return this.myMinItems;
    }

    public void setMinItems(Integer minItems) {
        this.myMinItems = minItems;
    }

    public boolean isUniqueItems() {
        return Boolean.TRUE.equals(this.myUniqueItems);
    }

    public void setUniqueItems(boolean uniqueItems) {
        this.myUniqueItems = uniqueItems;
    }

    public Integer getMaxProperties() {
        return this.myMaxProperties;
    }

    public void setMaxProperties(Integer maxProperties) {
        this.myMaxProperties = maxProperties;
    }

    public Integer getMinProperties() {
        return this.myMinProperties;
    }

    public void setMinProperties(Integer minProperties) {
        this.myMinProperties = minProperties;
    }

    public List<String> getRequired() {
        return this.myRequired;
    }

    public void setRequired(List<String> required) {
        this.myRequired = required;
    }

    public Map<String, List<String>> getPropertyDependencies() {
        return this.myPropertyDependencies;
    }

    public void setPropertyDependencies(Map<String, List<String>> propertyDependencies) {
        this.myPropertyDependencies = propertyDependencies;
    }

    public Map<String, JsonSchemaObject> getSchemaDependencies() {
        return this.mySchemaDependencies;
    }

    public void setSchemaDependencies(Map<String, JsonSchemaObject> schemaDependencies) {
        this.mySchemaDependencies = schemaDependencies;
    }

    public List<Object> getEnum() {
        return this.myEnum;
    }

    public void setEnum(List<Object> anEnum) {
        this.myEnum = anEnum;
    }

    public List<JsonSchemaObject> getAllOf() {
        return this.myAllOf;
    }

    public void setAllOf(List<JsonSchemaObject> allOf) {
        this.myAllOf = allOf;
    }

    public List<JsonSchemaObject> getAnyOf() {
        return this.myAnyOf;
    }

    public void setAnyOf(List<JsonSchemaObject> anyOf) {
        this.myAnyOf = anyOf;
    }

    public List<JsonSchemaObject> getOneOf() {
        return this.myOneOf;
    }

    public void setOneOf(List<JsonSchemaObject> oneOf) {
        this.myOneOf = oneOf;
    }

    public JsonSchemaObject getNot() {
        return this.myNot;
    }

    public void setNot(JsonSchemaObject not2) {
        this.myNot = not2;
    }

    public List<JsonSchemaType> getTypeVariants() {
        return this.myTypeVariants;
    }

    public void setTypeVariants(List<JsonSchemaType> typeVariants) {
        this.myTypeVariants = typeVariants;
    }

    public String getRef() {
        return this.myRef;
    }

    public void setRef(String ref) {
        this.myRef = ref;
    }

    public Object getDefault() {
        if (JsonSchemaType._integer.equals((Object)this.myType)) {
            return this.myDefault instanceof Number ? Integer.valueOf(((Number)this.myDefault).intValue()) : this.myDefault;
        }
        return this.myDefault;
    }

    public void setDefault(Object aDefault) {
        this.myDefault = aDefault;
    }

    public String getFormat() {
        return this.myFormat;
    }

    public void setFormat(String format) {
        this.myFormat = format;
    }

    public String getId() {
        return this.myId;
    }

    public void setId(String id) {
        this.myId = id;
    }

    public String getSchema() {
        return this.mySchema;
    }

    public void setSchema(String schema) {
        this.mySchema = schema;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(String description) {
        this.myDescription = description;
    }

    public String getTitle() {
        return this.myTitle;
    }

    public void setTitle(String title) {
        this.myTitle = title;
    }

    public boolean hasSpecifiedType() {
        return this.myType != null || this.myTypeVariants != null && !this.myTypeVariants.isEmpty();
    }

    public String getDefinitionAddress() {
        return this.myDefinitionAddress;
    }

    public void setDefinitionAddress(String definitionAddress) {
        this.myDefinitionAddress = definitionAddress;
    }

    @Nullable
    public JsonSchemaObject getMatchingPatternPropertySchema(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/jsonSchema/impl/JsonSchemaObject", "getMatchingPatternPropertySchema"));
        }
        if (this.myPatternProperties == null) {
            return null;
        }
        String pattern = this.myPatternCalculator.selectMatchingPattern(this.myPatternProperties.keySet(), name);
        return pattern == null ? null : this.myPatternProperties.get(pattern);
    }

    public boolean checkByPattern(@NotNull String value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/jsonSchema/impl/JsonSchemaObject", "checkByPattern"));
        }
        if (this.getPattern() == null) {
            return true;
        }
        return this.getPattern().equals(this.myValuesPatternCalculator.selectMatchingPattern(Collections.singletonList(this.getPattern()), value2));
    }

    public String getPatternError() {
        if (this.getPattern() != null) {
            this.myValuesPatternCalculator.ensureInit(Collections.singletonList(this.getPattern()));
            Map<String, String> patterns = this.myValuesPatternCalculator.getInvalidPatterns();
            if (patterns != null) {
                String error = patterns.get(this.getPattern());
                assert (error != null);
                return error;
            }
        }
        return null;
    }

    public Map<SmartPsiElementPointer<JsonObject>, String> getInvalidPatternProperties() {
        if (this.myPatternProperties != null) {
            this.myPatternCalculator.ensureInit(this.myPatternProperties.keySet());
            Map<String, String> patterns = this.myPatternCalculator.getInvalidPatterns();
            if (patterns == null) {
                return null;
            }
            return patterns.entrySet().stream().map(entry -> {
                JsonSchemaObject object = this.myPatternProperties.get(entry.getKey());
                assert (object != null);
                SmartPsiElementPointer<JsonObject> pointer = object.getPeerPointer();
                if (pointer != null) {
                    return Pair.create(pointer, entry.getValue());
                }
                return null;
            }).filter(o2 -> o2 != null).collect(Collectors.toMap(o2 -> (SmartPsiElementPointer)o2.getFirst(), o2 -> (String)o2.getSecond()));
        }
        return null;
    }

    public static void iterateAllInnerSchemas(@NotNull JsonSchemaObject object, @NotNull SchemaConsumer schemaConsumer) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/jetbrains/jsonSchema/impl/JsonSchemaObject", "iterateAllInnerSchemas"));
        }
        if (schemaConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaConsumer", "com/jetbrains/jsonSchema/impl/JsonSchemaObject", "iterateAllInnerSchemas"));
        }
        int control = 100000;
        ArrayDeque<Pair> queue2 = new ArrayDeque<Pair>();
        queue2.add(Pair.create((Object)object, new HashMap()));
        while (!queue2.isEmpty()) {
            if (--control == 0) {
                throw new RuntimeException("cyclic json schema search");
            }
            Pair pair = (Pair)queue2.removeFirst();
            JsonSchemaObject current = (JsonSchemaObject)pair.getFirst();
            Map context2 = (Map)pair.getSecond();
            Ref previous = new Ref();
            Ref childContextRef = new Ref((Object)context2);
            schemaConsumer.process(current, (Consumer<JsonSchemaObject>)((Consumer)item -> previous.set(item)), context2, (Consumer<Map<String, String>>)((Consumer)childContext -> childContextRef.set(childContext)));
            if (!previous.isNull()) {
                queue2.addFirst(Pair.create((Object)current, (Object)context2));
                queue2.addFirst(Pair.create((Object)previous.get(), (Object)context2));
                continue;
            }
            ArrayList<JsonSchemaObject> list2 = new ArrayList<JsonSchemaObject>();
            if (current.getDefinitions() != null) {
                list2.addAll(current.getDefinitions().values());
            }
            if (current.getProperties() != null) {
                list2.addAll(current.getProperties().values());
            }
            if (current.getPatternProperties() != null) {
                list2.addAll(current.getPatternProperties().values());
            }
            if (current.getAdditionalPropertiesSchema() != null) {
                list2.add(current.getAdditionalPropertiesSchema());
            }
            if (current.getAdditionalItemsSchema() != null) {
                list2.add(current.getAdditionalItemsSchema());
            }
            if (current.getItemsSchema() != null) {
                list2.add(current.getItemsSchema());
            }
            if (current.getItemsSchemaList() != null) {
                list2.addAll(current.getItemsSchemaList());
            }
            if (current.getSchemaDependencies() != null) {
                list2.addAll(current.getSchemaDependencies().values());
            }
            if (current.getAllOf() != null) {
                list2.addAll(current.getAllOf());
            }
            if (current.getAnyOf() != null) {
                list2.addAll(current.getAnyOf());
            }
            if (current.getOneOf() != null) {
                list2.addAll(current.getOneOf());
            }
            if (current.getNot() != null) {
                list2.add(current.getNot());
            }
            for (JsonSchemaObject schemaObject : list2) {
                queue2.addLast(Pair.create((Object)schemaObject, (Object)childContextRef.get()));
            }
        }
    }

    private static class PatternCalculator {
        private final Object myLock = new Object();
        private Map<String, Pattern> myCachedPatterns;
        private SLRUMap<String, String> myCachedPatternProperties;
        private Map<String, String> myInvalidPatterns;

        private PatternCalculator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public String selectMatchingPattern(@Nullable Collection<String> patterns, @NotNull String name) {
            HashMap<String, String> invalidPatterns;
            HashMap<String, Pattern> cachedPatterns;
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/jsonSchema/impl/JsonSchemaObject$PatternCalculator", "selectMatchingPattern"));
            }
            if (patterns == null || patterns.isEmpty()) {
                return null;
            }
            Object object = this.myLock;
            synchronized (object) {
                this.initPatternCache(patterns);
                String s2 = (String)this.myCachedPatternProperties.get((Object)name);
                if (s2 != null) {
                    return s2;
                }
                cachedPatterns = new HashMap<String, Pattern>(this.myCachedPatterns);
                invalidPatterns = this.myInvalidPatterns == null ? Collections.emptyMap() : new HashMap<String, String>(this.myInvalidPatterns);
            }
            return this.matchPatternsToString(name, patterns, cachedPatterns, invalidPatterns);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void ensureInit(@Nullable Collection<String> patterns) {
            if (patterns == null || patterns.isEmpty()) {
                return;
            }
            Object object = this.myLock;
            synchronized (object) {
                this.initPatternCache(patterns);
            }
        }

        @Nullable
        public Map<String, String> getInvalidPatterns() {
            return this.myInvalidPatterns;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.myLock;
            synchronized (object) {
                this.myCachedPatterns = null;
                this.myCachedPatternProperties = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String matchPatternsToString(@NotNull String name, @NotNull Collection<String> patterns, @NotNull Map<String, Pattern> cachedPatterns, @Nullable Map<String, String> invalidPatterns) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/jsonSchema/impl/JsonSchemaObject$PatternCalculator", "matchPatternsToString"));
            }
            if (patterns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patterns", "com/jetbrains/jsonSchema/impl/JsonSchemaObject$PatternCalculator", "matchPatternsToString"));
            }
            if (cachedPatterns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cachedPatterns", "com/jetbrains/jsonSchema/impl/JsonSchemaObject$PatternCalculator", "matchPatternsToString"));
            }
            ArrayList<String> strings = new ArrayList<String>(patterns);
            Collections.sort(strings);
            for (String pattern : strings) {
                if (invalidPatterns != null && invalidPatterns.containsKey(pattern)) continue;
                Pattern compiledPattern = cachedPatterns.get(pattern);
                assert (compiledPattern != null);
                try {
                    boolean matches = compiledPattern.matcher(StringUtil.newBombedCharSequence((CharSequence)name, (long)300L)).matches();
                    if (!matches) continue;
                    Object object = this.myLock;
                    synchronized (object) {
                        if (this.myCachedPatterns.containsKey(pattern)) {
                            this.myCachedPatternProperties.put((Object)name, (Object)pattern);
                        }
                    }
                    return pattern;
                }
                catch (ProcessCanceledException processCanceledException) {
                }
            }
            Object object = this.myLock;
            synchronized (object) {
                if (this.myCachedPatterns.equals(cachedPatterns)) {
                    this.myCachedPatternProperties.put((Object)name, (Object)"");
                }
            }
            return null;
        }

        private void initPatternCache(@NotNull Collection<String> patterns) {
            if (patterns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patterns", "com/jetbrains/jsonSchema/impl/JsonSchemaObject$PatternCalculator", "initPatternCache"));
            }
            if (this.myCachedPatterns == null) {
                this.myCachedPatterns = new HashMap<String, Pattern>(patterns.size());
                this.myCachedPatternProperties = new SLRUMap(100, 100);
            }
            for (String pattern : patterns) {
                if (this.myCachedPatterns.containsKey(pattern)) continue;
                try {
                    Pattern compiled = Pattern.compile(PatternCalculator.adaptSchemaPattern(pattern));
                    this.myCachedPatterns.put(pattern, compiled);
                }
                catch (PatternSyntaxException e2) {
                    if (this.myInvalidPatterns == null) {
                        this.myInvalidPatterns = new HashMap<String, String>();
                    }
                    this.myInvalidPatterns.put(pattern, e2.getMessage());
                }
            }
        }

        @NotNull
        private static String adaptSchemaPattern(String pattern) {
            pattern = pattern.startsWith("^") || pattern.startsWith("*") || pattern.startsWith(".") ? pattern : ".*" + pattern;
            pattern = pattern.endsWith("+") || pattern.endsWith("*") || pattern.endsWith("$") ? pattern : pattern + ".*";
            String string2 = pattern = pattern.replace("\\\\", "\\");
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaObject$PatternCalculator", "adaptSchemaPattern"));
            }
            return string2;
        }
    }

    public static interface SchemaConsumer {
        public void process(@NotNull JsonSchemaObject var1, Consumer<JsonSchemaObject> var2, @NotNull Map<String, String> var3, @NotNull Consumer<Map<String, String>> var4);
    }
}

