/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.indexing.IndexableSetContributor;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JsonSchemaResourcesRootsProvider
extends IndexableSetContributor {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.jsonSchema.impl.JsonSchemaResourcesRootsProvider");
    public static final NotNullLazyValue<Set<VirtualFile>> ourFiles = new AtomicNotNullLazyValue<Set<VirtualFile>>(){

        @NotNull
        protected Set<VirtualFile> compute() {
            JsonSchemaProviderFactory[] extensions;
            HashSet<VirtualFile> set2 = new HashSet<VirtualFile>();
            for (JsonSchemaProviderFactory extension : extensions = (JsonSchemaProviderFactory[])Extensions.getExtensions(JsonSchemaProviderFactory.EP_NAME)) {
                List<JsonSchemaFileProvider> providers = extension.getProviders(null);
                for (JsonSchemaFileProvider provider : providers) {
                    if (SchemaType.userSchema.equals((Object)provider.getSchemaType())) continue;
                    VirtualFile schemaFile = provider.getSchemaFile();
                    if (schemaFile == null) {
                        LOG.info("Can not find resource file for json schema provider: " + provider.getName());
                        continue;
                    }
                    set2.add(schemaFile);
                }
            }
            HashSet<VirtualFile> hashSet = set2;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaResourcesRootsProvider$1", "compute"));
            }
            return hashSet;
        }
    };

    @NotNull
    public Set<VirtualFile> getAdditionalRootsToIndex() {
        Set set2 = (Set)ourFiles.getValue();
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaResourcesRootsProvider", "getAdditionalRootsToIndex"));
        }
        return set2;
    }

    @NotNull
    public static GlobalSearchScope enlarge(@NotNull Project project2, final @NotNull GlobalSearchScope scope) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/jsonSchema/impl/JsonSchemaResourcesRootsProvider", "enlarge"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/jetbrains/jsonSchema/impl/JsonSchemaResourcesRootsProvider", "enlarge"));
        }
        GlobalSearchScope globalSearchScope = scope.union((SearchScope)new GlobalSearchScope(){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/jsonSchema/impl/JsonSchemaResourcesRootsProvider$2", "contains"));
                }
                return ((Set)ourFiles.getValue()).contains(file2);
            }

            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                if (file1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/jetbrains/jsonSchema/impl/JsonSchemaResourcesRootsProvider$2", "compare"));
                }
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/jetbrains/jsonSchema/impl/JsonSchemaResourcesRootsProvider$2", "compare"));
                }
                return scope.compare(file1, file2);
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/jetbrains/jsonSchema/impl/JsonSchemaResourcesRootsProvider$2", "isSearchInModuleContent"));
                }
                return scope.isSearchInModuleContent(aModule);
            }

            public boolean isSearchInLibraries() {
                return scope.isSearchInLibraries();
            }

            public boolean isSearchOutsideRootModel() {
                return true;
            }
        });
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaResourcesRootsProvider", "enlarge"));
        }
        return globalSearchScope;
    }
}

