/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.idea.RareLogger;
import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PairConsumer;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.CodeInsightProviders;
import com.jetbrains.jsonSchema.JsonSchemaFileTypeManager;
import com.jetbrains.jsonSchema.JsonSchemaVfsListener;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaImportedProviderMarker;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaExportedDefinitions;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaObjectCodeInsightWrapper;
import com.jetbrains.jsonSchema.impl.JsonSchemaReader;
import com.jetbrains.jsonSchema.impl.JsonSchemaServiceEx;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaServiceImpl
implements JsonSchemaServiceEx {
    private static final Logger LOGGER = Logger.getInstance(JsonSchemaServiceImpl.class);
    private static final Logger RARE_LOGGER = RareLogger.wrap(LOGGER, false);
    public static final Comparator<JsonSchemaFileProvider> FILE_PROVIDER_COMPARATOR = Comparator.comparingInt(JsonSchemaFileProvider::getOrder);
    @NotNull
    private final Project myProject;
    private final Object myLock;
    private final Map<VirtualFile, CodeInsightProviders> myWrappers;
    private final Set<VirtualFile> mySchemaFiles;
    private volatile boolean initialized;
    private final JsonSchemaExportedDefinitions myDefinitions;

    public JsonSchemaServiceImpl(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "<init>"));
        }
        this.myWrappers = new HashMap<VirtualFile, CodeInsightProviders>();
        this.mySchemaFiles = ContainerUtil.newConcurrentSet();
        this.myLock = new Object();
        this.myProject = project2;
        this.myDefinitions = new JsonSchemaExportedDefinitions();
        JsonSchemaVfsListener.startListening(project2, this);
        this.ensureSchemaFiles();
    }

    @NotNull
    protected JsonSchemaProviderFactory[] getProviderFactories() {
        JsonSchemaProviderFactory[] jsonSchemaProviderFactoryArray = (JsonSchemaProviderFactory[])JsonSchemaProviderFactory.EP_NAME.getExtensions();
        if (jsonSchemaProviderFactoryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "getProviderFactories"));
        }
        return jsonSchemaProviderFactoryArray;
    }

    private List<JsonSchemaFileProvider> getProviders() {
        ArrayList<JsonSchemaFileProvider> providers = new ArrayList<JsonSchemaFileProvider>();
        for (JsonSchemaProviderFactory factory2 : this.getProviderFactories()) {
            providers.addAll(factory2.getProviders(this.myProject));
        }
        Collections.sort(providers, FILE_PROVIDER_COMPARATOR);
        return providers;
    }

    @Override
    @Nullable
    public Annotator getAnnotator(@Nullable VirtualFile file2) {
        CodeInsightProviders wrapper = this.getWrapper(file2);
        return wrapper != null ? wrapper.getAnnotator() : null;
    }

    @Override
    @Nullable
    public CompletionContributor getCompletionContributor(@Nullable VirtualFile file2) {
        CodeInsightProviders wrapper = this.getWrapper(file2);
        return wrapper != null ? wrapper.getContributor() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureSchemaFiles() {
        Object object = this.myLock;
        synchronized (object) {
            if (!this.initialized) {
                for (JsonSchemaFileProvider provider : this.getProviders()) {
                    VirtualFile schemaFile = provider.getSchemaFile();
                    if (schemaFile == null) continue;
                    this.mySchemaFiles.add(schemaFile);
                    this.myDefinitions.dropKey(schemaFile);
                    this.myWrappers.remove(schemaFile);
                }
                this.initialized = true;
            }
        }
    }

    @Override
    public boolean isSchemaFile(@NotNull VirtualFile file2, @NotNull Consumer<String> errorConsumer) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "isSchemaFile"));
        }
        if (errorConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorConsumer", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "isSchemaFile"));
        }
        try {
            VfsUtilCore.loadText((VirtualFile)file2);
        }
        catch (IOException e2) {
            errorConsumer.consume((Object)e2.getMessage());
            return false;
        }
        try {
            return JsonSchemaReader.isJsonSchema(this.myProject, file2, errorConsumer);
        }
        catch (Exception e3) {
            this.reset();
            errorConsumer.consume((Object)e3.getMessage());
            return false;
        }
    }

    @Override
    @Nullable
    public DocumentationProvider getDocumentationProvider(@Nullable VirtualFile file2) {
        CodeInsightProviders wrapper = this.getWrapper(file2);
        return wrapper != null ? wrapper.getDocumentationProvider() : null;
    }

    @Override
    public void visitSchemaObject(@NotNull VirtualFile schemaFile, @NotNull Processor<JsonSchemaObject> consumer2) {
        if (schemaFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "visitSchemaObject"));
        }
        if (consumer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "visitSchemaObject"));
        }
        CodeInsightProviders wrapper = this.getWrapperBySchemaFile(schemaFile);
        if (wrapper == null) {
            return;
        }
        wrapper.iterateSchemaObjects(consumer2);
    }

    @Override
    @Nullable
    public List<Pair<Boolean, String>> getMatchingSchemaDescriptors(@Nullable VirtualFile file2) {
        List<CodeInsightProviders> wrappers = this.getWrappers(file2);
        if (wrappers.isEmpty()) {
            return null;
        }
        return ContainerUtil.map(wrappers, (Function)((NotNullFunction)wrapper -> Pair.create((Object)wrapper.isUserSchema(), (Object)wrapper.getName())));
    }

    @Nullable
    private CodeInsightProviders createWrapper(@NotNull JsonSchemaFileProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "createWrapper"));
        }
        JsonSchemaObject resultObject = this.readObject(provider);
        if (resultObject == null) {
            return null;
        }
        return provider.proxyCodeInsightProviders(new JsonSchemaObjectCodeInsightWrapper(this.myProject, provider.getName(), provider.getSchemaType(), provider.getSchemaFile(), resultObject));
    }

    private JsonSchemaObject readObject(@NotNull JsonSchemaFileProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "readObject"));
        }
        VirtualFile file2 = provider.getSchemaFile();
        if (file2 == null) {
            return null;
        }
        return (JsonSchemaObject)ReadAction.compute(() -> {
            if (provider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "lambda$readObject$1"));
            }
            try {
                JsonSchemaReader reader = JsonSchemaReader.create(this.myProject, file2);
                if (reader == null) {
                    return null;
                }
                JsonSchemaObject schemaObject = reader.read();
                if (schemaObject.getId() != null) {
                    this.myDefinitions.register(file2, schemaObject.getId());
                }
                return schemaObject;
            }
            catch (ProcessCanceledException reader) {
            }
            catch (Exception e2) {
                JsonSchemaServiceImpl.logException(provider, e2);
            }
            return null;
        });
    }

    private static void logException(@NotNull JsonSchemaFileProvider provider, Exception e2) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "logException"));
        }
        String message2 = "Error while processing json schema file: " + e2.getMessage();
        if (provider instanceof JsonSchemaImportedProviderMarker) {
            RARE_LOGGER.info(message2, (Throwable)e2);
        } else {
            LOGGER.error(message2, (Throwable)e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Object object = this.myLock;
        synchronized (object) {
            this.myWrappers.clear();
            this.myDefinitions.reset();
            this.initialized = false;
            this.mySchemaFiles.clear();
        }
        JsonSchemaFileTypeManager.getInstance().reset();
    }

    @Nullable
    private CodeInsightProviders getWrapper(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        List<CodeInsightProviders> wrappers = this.getWrappers(file2);
        if (wrappers.isEmpty()) {
            return null;
        }
        return wrappers.size() == 1 ? wrappers.get(0) : new CompositeCodeInsightProviderWithWarning(wrappers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropProviderFromCache(@NotNull VirtualFile schemaFile) {
        if (schemaFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "dropProviderFromCache"));
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myDefinitions.dropKey(schemaFile);
            this.myWrappers.remove(schemaFile);
        }
    }

    @NotNull
    private List<CodeInsightProviders> getWrappers(@Nullable VirtualFile file2) {
        if (file2 == null) {
            List<CodeInsightProviders> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "getWrappers"));
            }
            return list2;
        }
        FileType type = file2.getFileType();
        boolean isJson = type instanceof LanguageFileType && ((LanguageFileType)type).getLanguage().isKindOf((Language)JsonLanguage.INSTANCE);
        SmartList wrappers = new SmartList();
        this.getWrapperSkeletonMethod((Processor<JsonSchemaFileProvider>)((Processor)provider -> (isJson || !SchemaType.userSchema.equals((Object)provider.getSchemaType())) && provider.isAvailable(this.myProject, file2)), (Consumer<CodeInsightProviders>)((Consumer)arg_0 -> JsonSchemaServiceImpl.lambda$getWrappers$3((List)wrappers, arg_0)), true);
        SmartList smartList = wrappers;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "getWrappers"));
        }
        return smartList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private CodeInsightProviders getWrapperBySchemaFile(@NotNull VirtualFile schemaFile) {
        if (schemaFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "getWrapperBySchemaFile"));
        }
        Object object = this.myLock;
        synchronized (object) {
            CodeInsightProviders wrapper2 = this.myWrappers.get(schemaFile);
            if (wrapper2 != null) {
                return wrapper2;
            }
        }
        Ref ref = new Ref();
        this.getWrapperSkeletonMethod((Processor<JsonSchemaFileProvider>)((Processor)provider -> {
            if (schemaFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "lambda$getWrapperBySchemaFile$4"));
            }
            return schemaFile.equals(provider.getSchemaFile());
        }), (Consumer<CodeInsightProviders>)((Consumer)wrapper -> ref.set(wrapper)), false);
        return (CodeInsightProviders)ref.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getWrapperSkeletonMethod(@NotNull Processor<JsonSchemaFileProvider> processor2, @NotNull Consumer<CodeInsightProviders> consumer2, boolean multiple) {
        CodeInsightProviders wrapper;
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "getWrapperSkeletonMethod"));
        }
        if (consumer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "getWrapperSkeletonMethod"));
        }
        List filtered = this.getProviders().stream().filter(arg_0 -> processor2.process(arg_0)).collect(Collectors.toList());
        if (filtered.isEmpty()) {
            return;
        }
        SmartList matchingProviders = new SmartList();
        Object object = this.myLock;
        synchronized (object) {
            for (JsonSchemaFileProvider provider : filtered) {
                wrapper = this.myWrappers.get(provider.getSchemaFile());
                if (wrapper != null) {
                    consumer2.consume((Object)wrapper);
                    if (multiple) continue;
                    return;
                }
                matchingProviders.add(provider);
                if (multiple) continue;
                break;
            }
        }
        if (matchingProviders.isEmpty()) {
            return;
        }
        HashMap<VirtualFile, Pair> created = new HashMap<VirtualFile, Pair>();
        for (JsonSchemaFileProvider provider : matchingProviders) {
            wrapper = this.createWrapper(provider);
            if (wrapper == null) continue;
            created.put(provider.getSchemaFile(), Pair.create((Object)wrapper, (Object)provider));
        }
        List<JsonSchemaFileProvider> providers = this.getProviders();
        Object object2 = this.myLock;
        synchronized (object2) {
            created.forEach((file2, pair) -> {
                if (processor2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "lambda$getWrapperSkeletonMethod$6"));
                }
                if (consumer2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "lambda$getWrapperSkeletonMethod$6"));
                }
                CodeInsightProviders wrapper = (CodeInsightProviders)pair.getFirst();
                JsonSchemaFileProvider provider = (JsonSchemaFileProvider)pair.getSecond();
                if (!providers.contains(provider)) {
                    return;
                }
                if (processor2.process((Object)provider)) {
                    this.myWrappers.putIfAbsent((VirtualFile)file2, wrapper);
                    consumer2.consume((Object)wrapper);
                }
            });
        }
    }

    @Override
    @Nullable
    public VirtualFile getSchemaFileById(@NotNull String id, @Nullable VirtualFile referent) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "getSchemaFileById"));
        }
        VirtualFile schemaFile = this.myDefinitions.getSchemaFileById(id, this);
        if (schemaFile != null) {
            return schemaFile;
        }
        return JsonSchemaServiceImpl.getSchemaFileByRefAsLocalFile(id, referent);
    }

    @Nullable
    public static VirtualFile getSchemaFileByRefAsLocalFile(@NotNull String id, @Nullable VirtualFile referent) {
        VirtualFile dir;
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "getSchemaFileByRefAsLocalFile"));
        }
        String normalizedId = JsonSchemaExportedDefinitions.normalizeId(id);
        if (FileUtil.isAbsolute((String)normalizedId) || referent == null) {
            return VfsUtil.findFileByIoFile((File)new File(normalizedId), (boolean)false);
        }
        VirtualFile virtualFile = dir = referent.isDirectory() ? referent : referent.getParent();
        if (dir != null && dir.isValid()) {
            List parts = StringUtil.split((String)normalizedId.replace("\\", "/"), (String)"/");
            return VfsUtil.findRelativeFile((VirtualFile)dir, (String[])ArrayUtil.toStringArray((Collection)parts));
        }
        return null;
    }

    @Override
    @Nullable
    public Collection<Pair<VirtualFile, String>> getSchemaFilesByFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "getSchemaFilesByFile"));
        }
        CodeInsightProviders wrapper = this.getWrapper(file2);
        if (wrapper != null) {
            SmartList result2 = new SmartList();
            wrapper.iterateSchemaFiles((PairConsumer<VirtualFile, String>)((PairConsumer)(arg_0, arg_1) -> JsonSchemaServiceImpl.lambda$getSchemaFilesByFile$7((List)result2, arg_0, arg_1)));
            return result2;
        }
        return null;
    }

    @Override
    public Set<VirtualFile> getSchemaFiles() {
        if (!this.initialized) {
            this.ensureSchemaFiles();
        }
        return Collections.unmodifiableSet(this.mySchemaFiles);
    }

    @Override
    public void refreshSchemaIds(Set<VirtualFile> toRefresh) {
        for (VirtualFile refresh2 : toRefresh) {
            this.getWrapperBySchemaFile(refresh2);
        }
    }

    private static /* synthetic */ void lambda$getSchemaFilesByFile$7(List result2, VirtualFile schemaFile, String schemaId) {
        result2.add(Pair.create((Object)schemaFile, (Object)schemaId));
    }

    private static /* synthetic */ void lambda$getWrappers$3(List wrappers, CodeInsightProviders wrapper) {
        wrappers.add(wrapper);
    }

    private static class CompositeCodeInsightProviderWithWarning
    implements CodeInsightProviders {
        private final List<CodeInsightProviders> myWrappers;
        private final CompletionContributor myContributor;
        private final Annotator myAnnotator;
        private final DocumentationProvider myDocumentationProvider;

        public CompositeCodeInsightProviderWithWarning(List<CodeInsightProviders> wrappers) {
            List<Object> userSchemaWrappers = ContainerUtil.filter(wrappers, CodeInsightProviders::isUserSchema);
            this.myWrappers = !userSchemaWrappers.isEmpty() && userSchemaWrappers.size() + 1 == wrappers.size() ? userSchemaWrappers : wrappers;
            this.myContributor = new CompletionContributor(){

                public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
                    if (parameters == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$CompositeCodeInsightProviderWithWarning$1", "fillCompletionVariants"));
                    }
                    if (result2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$CompositeCodeInsightProviderWithWarning$1", "fillCompletionVariants"));
                    }
                    for (CodeInsightProviders wrapper : myWrappers) {
                        wrapper.getContributor().fillCompletionVariants(parameters, result2);
                    }
                }
            };
            this.myAnnotator = new Annotator(){

                public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$CompositeCodeInsightProviderWithWarning$2", "annotate"));
                    }
                    if (holder == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$CompositeCodeInsightProviderWithWarning$2", "annotate"));
                    }
                    for (CodeInsightProviders wrapper : myWrappers) {
                        wrapper.getAnnotator().annotate(element, holder);
                    }
                }
            };
            ArrayList<DocumentationProvider> list2 = new ArrayList<DocumentationProvider>();
            for (CodeInsightProviders wrapper : this.myWrappers) {
                list2.add(wrapper.getDocumentationProvider());
            }
            this.myDocumentationProvider = CompositeDocumentationProvider.wrapProviders(list2);
        }

        @Override
        @NotNull
        public CompletionContributor getContributor() {
            CompletionContributor completionContributor = this.myContributor;
            if (completionContributor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$CompositeCodeInsightProviderWithWarning", "getContributor"));
            }
            return completionContributor;
        }

        @Override
        @NotNull
        public Annotator getAnnotator() {
            Annotator annotator = this.myAnnotator;
            if (annotator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$CompositeCodeInsightProviderWithWarning", "getAnnotator"));
            }
            return annotator;
        }

        @Override
        @NotNull
        public DocumentationProvider getDocumentationProvider() {
            DocumentationProvider documentationProvider = this.myDocumentationProvider;
            if (documentationProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$CompositeCodeInsightProviderWithWarning", "getDocumentationProvider"));
            }
            return documentationProvider;
        }

        @Override
        @NotNull
        public String getName() {
            if ("Composite" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$CompositeCodeInsightProviderWithWarning", "getName"));
            }
            return "Composite";
        }

        @Override
        public boolean isUserSchema() {
            return false;
        }

        @Override
        public boolean iterateSchemaObjects(@NotNull Processor<JsonSchemaObject> consumer2) {
            if (consumer2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$CompositeCodeInsightProviderWithWarning", "iterateSchemaObjects"));
            }
            for (CodeInsightProviders wrapper : this.myWrappers) {
                if (wrapper.iterateSchemaObjects(consumer2)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void iterateSchemaFiles(@NotNull PairConsumer<VirtualFile, String> consumer2) {
            if (consumer2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$CompositeCodeInsightProviderWithWarning", "iterateSchemaFiles"));
            }
            for (CodeInsightProviders wrapper : this.myWrappers) {
                wrapper.iterateSchemaFiles(consumer2);
            }
        }
    }
}

