/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ls.newLicenses;

import com.jetbrains.ls.util.Base64Support;
import com.jetbrains.ls.util.Pair;
import com.jetbrains.ls.util.Ref;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.security.Signature;
import java.security.cert.CRL;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.Callable;

public class DecodeCertificates {
    private final Pair myRootCertAndCrl;

    public DecodeCertificates(Pair rootCertAndCrl) {
        this.myRootCertAndCrl = rootCertAndCrl;
    }

    public Ref decodeLicense(Ref encodedLicenseText) throws Exception {
        String[] licenseParts = ((String)encodedLicenseText.get()).split("-");
        if (licenseParts.length != 3) {
            throw new Exception("Invalid license format");
        }
        String licensePartBase64 = licenseParts[0];
        String signatureBase64 = licenseParts[1];
        String certBase64 = licenseParts[2];
        byte[] certBytes = ((Callable<byte[]>)() -> Base64Support.decode(certBase64.getBytes(StandardCharsets.UTF_8))).call();
        Ref certRef = ((Callable<Ref>)() -> this.createCertificate(certBytes, Collections.emptySet(), false)).call();
        byte[] licenseBytes = ((Callable<byte[]>)() -> {
            byte[] bytes = Base64Support.decode(licensePartBase64.getBytes(StandardCharsets.UTF_8));
            Signature sig = Signature.getInstance("SHA1withRSA");
            sig.initVerify((Certificate)Ref.deref(certRef));
            sig.update(bytes);
            if (!sig.verify(Base64Support.decode(signatureBase64.getBytes(StandardCharsets.UTF_8)))) {
                throw new Exception("Signature verification failed"){

                    @Override
                    public synchronized Throwable fillInStackTrace() {
                        return this;
                    }
                };
            }
            return bytes;
        }).call();
        return Ref.create(new String(licenseBytes, StandardCharsets.UTF_8));
    }

    public final Ref createCertificate(byte[] certBytes, Collection<byte[]> intermediateCertsBytes, boolean checkValidityAtCurrentDate) throws Exception {
        Ref certFactoryRef = ((Callable<Ref>)() -> Ref.create(CertificateFactory.getInstance("X.509"))).call();
        Ref certRef = ((Callable<Ref>)() -> Ref.create(((CertificateFactory)Ref.deref(certFactoryRef)).generateCertificate(new ByteArrayInputStream(certBytes)))).call();
        Ref rootCertificate = ((Callable<Ref>)() -> Ref.create(((CertificateFactory)Ref.deref(certFactoryRef)).generateCertificate(new ByteArrayInputStream((byte[])this.myRootCertAndCrl.fst)))).call();
        Collection intermediateCerts = ((Callable<Collection>)() -> {
            HashSet<Certificate> result2 = new HashSet<Certificate>();
            for (byte[] bytes : intermediateCertsBytes) {
                result2.add(((CertificateFactory)Ref.deref(certFactoryRef)).generateCertificate(new ByteArrayInputStream(bytes)));
            }
            return result2;
        }).call();
        boolean validationSuccess = false;
        try {
            PKIXBuilderParameters pkixParams = ((Callable<PKIXBuilderParameters>)() -> {
                X509CertSelector selector = new X509CertSelector();
                X509Certificate cert = (X509Certificate)Ref.deref(certRef);
                selector.setCertificate(cert);
                PKIXBuilderParameters params = new PKIXBuilderParameters(Collections.singleton(new TrustAnchor((X509Certificate)Ref.deref(rootCertificate), null)), (CertSelector)selector);
                params.setRevocationEnabled(false);
                if (!checkValidityAtCurrentDate) {
                    params.setDate(cert.getNotBefore());
                }
                params.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(intermediateCerts)));
                return params;
            }).call();
            validationSuccess = ((Callable<Boolean>)() -> CertPathBuilder.getInstance("PKIX").build(pkixParams).getCertPath() != null).call();
        }
        catch (Exception s2) {
            validationSuccess = false;
        }
        if (!validationSuccess) {
            throw new Exception("Certificate used to sign the license is not signed by JetBrains root certificate"){

                @Override
                public synchronized Throwable fillInStackTrace() {
                    return this;
                }
            };
        }
        ((Callable<Void>)() -> {
            Collection<? extends CRL> crls = ((CertificateFactory)Ref.deref(certFactoryRef)).generateCRLs(new ByteArrayInputStream((byte[])this.myRootCertAndCrl.snd));
            Certificate cert = (Certificate)Ref.deref(certRef);
            for (CRL cRL : crls) {
                if (cRL.isRevoked(cert)) {
                    throw new Exception("Certificate used to sign the license is revoked"){

                        @Override
                        public synchronized Throwable fillInStackTrace() {
                            return this;
                        }
                    };
                }
                for (Object intermediateCert : intermediateCerts) {
                    if (!cRL.isRevoked((Certificate)intermediateCert)) continue;
                    throw new Exception("Certificate used to sign the license is revoked"){

                        @Override
                        public synchronized Throwable fillInStackTrace() {
                            return this;
                        }
                    };
                }
            }
            return null;
        }).call();
        return certRef;
    }
}

