/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ls.requests;

import com.jetbrains.ls.requests.AbstractObtainTicketRequest;
import com.jetbrains.ls.responses.ObtainPermanentTicketGroupResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;

public class ObtainPermanentTicketGroupRequest
extends AbstractObtainTicketRequest<ObtainPermanentTicketGroupResponse> {
    public static final String ACTION_NAME = "obtainPermanentTicketGroup.action";
    private String email;
    private String activationCode;
    private Collection<ProductSelector> productSelectors;

    public ObtainPermanentTicketGroupRequest() {
    }

    public ObtainPermanentTicketGroupRequest(long salt, Collection<ProductSelector> productSelectors, String machineId, String hostName, String userName, String email, String activationCode) {
        super(salt, ObtainPermanentTicketGroupRequest.getProductFamilyIds(productSelectors), machineId, hostName, userName, 0, 0, false);
        this.email = email;
        this.activationCode = activationCode;
        this.productSelectors = productSelectors;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getActivationCode() {
        return this.activationCode;
    }

    public void setActivationCode(String activationCode) {
        this.activationCode = activationCode;
    }

    public String getProductSelectors() {
        if (this.productSelectors == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (ProductSelector selector : this.productSelectors) {
            if (builder.length() > 0) {
                builder.append(",");
            }
            builder.append(selector.toString());
        }
        return builder.toString();
    }

    public void setProductSelectors(String selectors) {
        ArrayList<ProductSelector> result2 = new ArrayList<ProductSelector>();
        if (selectors != null) {
            StringTokenizer tokenizer = new StringTokenizer(selectors, ",", false);
            while (tokenizer.hasMoreTokens()) {
                String selectorStr = tokenizer.nextToken().trim();
                ProductSelector selector = ProductSelector.fromString(selectorStr, 0);
                if (selector == null) continue;
                result2.add(selector);
            }
        }
        this.productSelectors = result2.isEmpty() ? null : result2;
    }

    @NotNull
    public Collection<ProductSelector> getAllProductSelectors() {
        Collection<Object> collection = this.productSelectors == null ? Collections.emptyList() : this.productSelectors;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/ls/requests/ObtainPermanentTicketGroupRequest", "getAllProductSelectors"));
        }
        return collection;
    }

    @Override
    public String getActionName() {
        return ACTION_NAME;
    }

    private static String getProductFamilyIds(Collection<ProductSelector> selectors) {
        if (selectors.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (ProductSelector selector : selectors) {
            if (builder.length() > 0) {
                builder.append(",");
            }
            builder.append(selector.getProductFamilyId());
        }
        return builder.toString();
    }

    public static final class ProductSelector {
        public final String productFamilyId;
        public final int version;
        public final int buildDate;
        public final String edition;

        public ProductSelector(String productFamilyId, int version, int buildDate, String edition) {
            this.productFamilyId = productFamilyId;
            this.version = version;
            this.buildDate = buildDate;
            this.edition = edition == null || edition.length() == 0 || "null".equalsIgnoreCase(edition) ? null : edition;
        }

        public String getProductFamilyId() {
            return this.productFamilyId;
        }

        public int getVersion() {
            return this.version;
        }

        public int getBuildDate() {
            return this.buildDate;
        }

        public String getEdition() {
            return this.edition;
        }

        public String toString() {
            return "{" + this.productFamilyId + "|" + this.version + "|" + this.buildDate + "|" + this.edition + "}";
        }

        public static ProductSelector fromString(String str, int start2) {
            int end;
            if (start2 >= str.length()) {
                return null;
            }
            if (str.charAt(start2) != '{') {
                return null;
            }
            if ((end = str.indexOf(124, ++start2)) < 0) {
                return null;
            }
            String productFamilyId = str.substring(start2, end).trim();
            start2 = end + 1;
            if ((end = str.indexOf(124, start2)) < 0) {
                return null;
            }
            String version = str.substring(start2, end).trim();
            start2 = end + 1;
            if ((end = str.indexOf(124, start2)) < 0) {
                return null;
            }
            String buildDate = str.substring(start2, end).trim();
            start2 = end + 1;
            if ((end = str.indexOf(125, start2)) < 0) {
                return null;
            }
            String edition = str.substring(start2, end).trim();
            try {
                return new ProductSelector(productFamilyId, Integer.parseInt(version), Integer.parseInt(buildDate), edition);
            }
            catch (NumberFormatException e2) {
                return null;
            }
        }
    }
}

