/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ls.responses;

import com.jetbrains.ls.requests.ObtainTicketRequest;
import com.jetbrains.ls.responses.AbstractFloatingResponse;
import com.jetbrains.ls.responses.ResponseCode;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class ObtainTicketResponse
extends AbstractFloatingResponse {
    private String ticketId;
    private String ticketProperties;
    private long prolongationPeriod;

    public ObtainTicketResponse() {
    }

    public ObtainTicketResponse(String ticketId, ResponseCode responseCode, String ticketProperties, String message2, long salt) {
        super(responseCode, message2, salt);
        this.ticketId = ticketId;
        this.ticketProperties = ticketProperties;
    }

    public String getTicketId() {
        return this.ticketId;
    }

    public void setTicketId(String ticketId) {
        this.ticketId = ticketId;
    }

    public String getTicketProperties() {
        return this.ticketProperties;
    }

    public Map<String, String> parseTicketProperties() {
        HashMap<String, String> result2 = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(this.ticketProperties, "\t", false);
        while (tokenizer.hasMoreTokens()) {
            String property = tokenizer.nextToken();
            String name = property.substring(0, property.indexOf("="));
            String value2 = property.substring(property.indexOf("=") + 1);
            result2.put(name, value2);
        }
        return result2;
    }

    public void setTicketProperties(String ticketProperties) {
        this.ticketProperties = ticketProperties;
    }

    public long getProlongationPeriod() {
        return this.prolongationPeriod;
    }

    public void setProlongationPeriod(long prolongationPeriod) {
        this.prolongationPeriod = prolongationPeriod;
    }

    public static ObtainTicketResponse error(String message2, ObtainTicketRequest request2) {
        return new ObtainTicketResponse(null, ResponseCode.ERROR, "", message2, request2.getSalt());
    }
}

