/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ls.util;

import com.jetbrains.ls.Constants;
import com.jetbrains.ls.requests.AbstractRequest;
import com.jetbrains.ls.util.DnsUtil;
import com.jetbrains.ls.util.MachineIDProvider;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;

public class ClientUtil {
    private static final String USER_ON_MACHINE_ID_KEY = "user_id_on_machine";
    private static final String buildNumber;
    private static final AbstractRequest.UserIdentification userIdentification;

    public static String getMachineId() {
        return userIdentification.getMachineId();
    }

    public static String getHostName() {
        return userIdentification.getHostName();
    }

    public static String getUserName() {
        return userIdentification.getUserName();
    }

    public static String getBuildNumber() {
        return buildNumber;
    }

    public static Date parseDate(@NotNull String str) throws ParseException {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/jetbrains/ls/util/ClientUtil", "parseDate"));
        }
        return Constants.getDateFormat().parse(str);
    }

    public static String formatDate(@NotNull Date date) {
        if (date == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "date", "com/jetbrains/ls/util/ClientUtil", "formatDate"));
        }
        return Constants.getDateFormat().format(date);
    }

    public static String formatDate(long date) {
        Date parsedDate;
        try {
            parsedDate = new SimpleDateFormat("yyyyMMdd", Locale.US).parse(String.valueOf(date));
        }
        catch (ParseException ignored) {
            parsedDate = new Date(date);
        }
        return ClientUtil.formatDate(parsedDate);
    }

    private static String initMachineId() {
        String machineId = MachineIDProvider.discover();
        if (machineId != null && !machineId.isEmpty()) {
            return machineId;
        }
        Preferences prefs = Preferences.userRoot().node("jetbrains");
        machineId = prefs.get(USER_ON_MACHINE_ID_KEY, null);
        if (machineId == null || machineId.isEmpty()) {
            machineId = UUID.randomUUID().toString();
            prefs.put(USER_ON_MACHINE_ID_KEY, machineId);
        }
        return machineId;
    }

    static {
        String hostName = DnsUtil.calcHostName();
        String userName = System.getProperty("user.name", "<unknown>");
        String machineId = ClientUtil.initMachineId();
        userIdentification = new AbstractRequest.UserIdentification(machineId, hostName, userName);
        buildNumber = MachineIDProvider.discoverBuildNumber();
    }
}

