/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ls.util;

import java.lang.reflect.Method;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

public class DnsUtil {
    public static final String DEFAULT_DNS_ATTRIBUTE_NAME_PREFIX = "_jetbrains-license-server";
    public static final String DNS_ATTRIBUTE_NAME_PREFIX_PROPERTY = "dns.attribute.name.prefix";
    private static final String[] TXT_ATTRIBUTES = new String[]{"TXT"};

    public static String calcHostName() {
        try {
            return DnsUtil.getLocalHostName();
        }
        catch (Throwable e2) {
            return "<unknown>";
        }
    }

    public static String detectServerUrl() {
        try {
            return DnsUtil.parseDnsEntry(DnsUtil.getLicenseServerDnsEntry()).get("url");
        }
        catch (Exception e2) {
            return "http://jetbrains-license-server";
        }
    }

    private static void visitLocalDomains(String dnsServers, Processor<String> visitor2) throws UnknownHostException {
        HashSet<String> visited = new HashSet<String>();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (interfaces != null) {
                while (interfaces.hasMoreElements()) {
                    NetworkInterface networkInterface = interfaces.nextElement();
                    Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        InetAddress address = addresses.nextElement();
                        if (!DnsUtil.canCheckAddress(address) || DnsUtil.visitDomainSuffixes(address, visited, visitor2)) continue;
                        return;
                    }
                }
            }
        }
        catch (SocketException interfaces) {
            // empty catch block
        }
        if (dnsServers != null) {
            String[] urls = dnsServers.split(" ");
            Pattern pattern = Pattern.compile("dns://(\\d+\\.\\d+\\.\\d+\\.\\d+)");
            for (String url : urls) {
                InetAddress address;
                Matcher m2 = pattern.matcher(url);
                if (!m2.matches() || !DnsUtil.canCheckAddress(address = InetAddress.getByName(m2.group(1))) || DnsUtil.visitDomainSuffixes(address, visited, visitor2)) continue;
                return;
            }
        }
        if (!DnsUtil.visitDomainSuffixes(InetAddress.getLocalHost(), visited, visitor2)) {
            return;
        }
        for (String domain : DnsUtil.getDefaultSearchDomains()) {
            if (!DnsUtil.hasLetters(domain) || !visited.add(domain) || visitor2.process(domain)) continue;
            return;
        }
    }

    private static List<String> getDefaultSearchDomains() {
        try {
            List searchDomains;
            Class<?> configClass = Class.forName("sun.net.dns.ResolverConfiguration");
            Method openMethod = configClass.getDeclaredMethod("open", new Class[0]);
            openMethod.setAccessible(true);
            Method getSearchDomainsMethod = configClass.getDeclaredMethod("searchlist", new Class[0]);
            getSearchDomainsMethod.setAccessible(true);
            Object resolverConfig = openMethod.invoke(null, new Object[0]);
            Object res2 = getSearchDomainsMethod.invoke(resolverConfig, new Object[0]);
            if (res2 instanceof List && !(searchDomains = (List)res2).isEmpty()) {
                ArrayList<String> rv = new ArrayList<String>(searchDomains.size());
                for (Object domain : searchDomains) {
                    if (!(domain instanceof String)) continue;
                    rv.add((String)domain);
                }
                return rv;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    private static boolean canCheckAddress(InetAddress address) {
        return !address.isMulticastAddress() && !(address instanceof Inet6Address) && !address.isLoopbackAddress();
    }

    private static boolean visitDomainSuffixes(InetAddress address, Collection<String> visited, Processor<String> visitor2) {
        String name = address.getCanonicalHostName();
        String domain;
        while (DnsUtil.hasLetters(domain = DnsUtil.extractDomainSuffix(name))) {
            if (!visited.add(domain)) {
                return true;
            }
            if (!visitor2.process(domain)) {
                return false;
            }
            name = domain;
        }
        return true;
    }

    private static boolean hasLetters(String domain) {
        for (int i2 = 0; i2 < domain.length(); ++i2) {
            if (!Character.isLetter(domain.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    private static String extractDomainSuffix(String nodeName) {
        int suffix = nodeName.indexOf(46);
        return suffix > 0 ? nodeName.substring(suffix + 1) : "";
    }

    private static String getLocalHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getCanonicalHostName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getLicenseServerDnsEntry() throws NamingException, UnknownHostException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        final InitialDirContext context2 = new InitialDirContext(env);
        final String prefix = System.getProperty(DNS_ATTRIBUTE_NAME_PREFIX_PROPERTY, DEFAULT_DNS_ATTRIBUTE_NAME_PREFIX);
        String dnsServers = (String)context2.getEnvironment().get("java.naming.provider.url");
        final String[] result2 = new String[]{null};
        try {
            DnsUtil.visitLocalDomains(dnsServers, new Processor<String>(){

                @Override
                public boolean process(String domain) {
                    try {
                        Attributes attributes = context2.getAttributes(prefix + "." + domain, TXT_ATTRIBUTES);
                        result2[0] = (String)attributes.get("TXT").get();
                        return false;
                    }
                    catch (Exception ignored) {
                        return true;
                    }
                }
            });
        }
        finally {
            context2.close();
        }
        String entry = result2[0];
        if (entry != null) {
            return entry;
        }
        throw new NamingException("No license server DNS entries detected in any scanned local domains");
    }

    private static Map<String, String> parseDnsEntry(String entry) {
        HashMap<String, String> map2 = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(entry, ";", false);
        while (tokenizer.hasMoreTokens()) {
            String property = tokenizer.nextToken();
            int eq = property.indexOf(61);
            if (eq <= 0) continue;
            String name = property.substring(0, eq).trim();
            String value2 = property.substring(eq + 1).trim();
            map2.put(name, value2);
        }
        return map2;
    }

    static interface Processor<T> {
        public boolean process(T var1);
    }
}

