/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ls.util;

import com.jetbrains.ls.util.IntHashMap;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

class Entities {
    private static final String[][] BASIC_ARRAY = new String[][]{{"quot", "34"}, {"amp", "38"}, {"lt", "60"}, {"gt", "62"}};
    private static final String[][] APOS_ARRAY = new String[][]{{"apos", "39"}};
    public static final Entities XML = new Entities();
    EntityMap map = new LookupEntityMap();

    Entities() {
    }

    public void addEntities(String[][] entityArray) {
        for (String[] anEntityArray : entityArray) {
            this.addEntity(anEntityArray[0], Integer.parseInt(anEntityArray[1]));
        }
    }

    public void addEntity(String name, int value2) {
        this.map.add(name, value2);
    }

    public String entityName(int value2) {
        return this.map.name(value2);
    }

    public int entityValue(String name) {
        return this.map.value(name);
    }

    public String escape(String str) {
        StringWriter stringWriter = this.createStringWriter(str);
        try {
            this.escape(stringWriter, str);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public void escape(Writer writer, String str) throws IOException {
        int len = str.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = str.charAt(i2);
            String entityName = this.entityName(c2);
            if (entityName == null) {
                if (c2 > '\u007f') {
                    writer.write("&#");
                    writer.write(Integer.toString(c2, 10));
                    writer.write(59);
                    continue;
                }
                writer.write(c2);
                continue;
            }
            writer.write(38);
            writer.write(entityName);
            writer.write(59);
        }
    }

    public String unescape(String str) {
        int firstAmp = str.indexOf(38);
        if (firstAmp < 0) {
            return str;
        }
        StringWriter stringWriter = this.createStringWriter(str);
        try {
            this.doUnescape(stringWriter, str, firstAmp);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    private StringWriter createStringWriter(String str) {
        return new StringWriter((int)((double)str.length() + (double)str.length() * 0.1));
    }

    public void unescape(Writer writer, String str) throws IOException {
        int firstAmp = str.indexOf(38);
        if (firstAmp < 0) {
            writer.write(str);
        } else {
            this.doUnescape(writer, str, firstAmp);
        }
    }

    private void doUnescape(Writer writer, String str, int firstAmp) throws IOException {
        writer.write(str, 0, firstAmp);
        int len = str.length();
        for (int i2 = firstAmp; i2 < len; ++i2) {
            char c2 = str.charAt(i2);
            if (c2 == '&') {
                int nextIdx = i2 + 1;
                int semiColonIdx = str.indexOf(59, nextIdx);
                if (semiColonIdx == -1) {
                    writer.write(c2);
                    continue;
                }
                int amphersandIdx = str.indexOf(38, i2 + 1);
                if (amphersandIdx != -1 && amphersandIdx < semiColonIdx) {
                    writer.write(c2);
                    continue;
                }
                String entityContent = str.substring(nextIdx, semiColonIdx);
                int entityValue = -1;
                int entityContentLen = entityContent.length();
                if (entityContentLen > 0) {
                    if (entityContent.charAt(0) == '#') {
                        if (entityContentLen > 1) {
                            char isHexChar = entityContent.charAt(1);
                            try {
                                switch (isHexChar) {
                                    case 'X': 
                                    case 'x': {
                                        entityValue = Integer.parseInt(entityContent.substring(2), 16);
                                        break;
                                    }
                                    default: {
                                        entityValue = Integer.parseInt(entityContent.substring(1), 10);
                                    }
                                }
                                if (entityValue > 65535) {
                                    entityValue = -1;
                                }
                            }
                            catch (NumberFormatException e2) {
                                entityValue = -1;
                            }
                        }
                    } else {
                        entityValue = this.entityValue(entityContent);
                    }
                }
                if (entityValue == -1) {
                    writer.write(38);
                    writer.write(entityContent);
                    writer.write(59);
                } else {
                    writer.write(entityValue);
                }
                i2 = semiColonIdx;
                continue;
            }
            writer.write(c2);
        }
    }

    static {
        XML.addEntities(BASIC_ARRAY);
        XML.addEntities(APOS_ARRAY);
    }

    static class BinaryEntityMap
    extends ArrayEntityMap {
        public BinaryEntityMap() {
        }

        public BinaryEntityMap(int growBy) {
            super(growBy);
        }

        private int binarySearch(int key) {
            int low = 0;
            int high = this.size - 1;
            while (low <= high) {
                int mid = low + high >> 1;
                int midVal = this.values[mid];
                if (midVal < key) {
                    low = mid + 1;
                    continue;
                }
                if (midVal > key) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -(low + 1);
        }

        @Override
        public void add(String name, int value2) {
            this.ensureCapacity(this.size + 1);
            int insertAt = this.binarySearch(value2);
            if (insertAt > 0) {
                return;
            }
            insertAt = -(insertAt + 1);
            System.arraycopy(this.values, insertAt, this.values, insertAt + 1, this.size - insertAt);
            this.values[insertAt] = value2;
            System.arraycopy(this.names, insertAt, this.names, insertAt + 1, this.size - insertAt);
            this.names[insertAt] = name;
            ++this.size;
        }

        @Override
        public String name(int value2) {
            int index = this.binarySearch(value2);
            if (index < 0) {
                return null;
            }
            return this.names[index];
        }
    }

    static class ArrayEntityMap
    implements EntityMap {
        protected int growBy = 100;
        protected int size = 0;
        protected String[] names;
        protected int[] values;

        public ArrayEntityMap() {
            this.names = new String[this.growBy];
            this.values = new int[this.growBy];
        }

        public ArrayEntityMap(int growBy) {
            this.growBy = growBy;
            this.names = new String[growBy];
            this.values = new int[growBy];
        }

        @Override
        public void add(String name, int value2) {
            this.ensureCapacity(this.size + 1);
            this.names[this.size] = name;
            this.values[this.size] = value2;
            ++this.size;
        }

        protected void ensureCapacity(int capacity) {
            if (capacity > this.names.length) {
                int newSize = Math.max(capacity, this.size + this.growBy);
                String[] newNames = new String[newSize];
                System.arraycopy(this.names, 0, newNames, 0, this.size);
                this.names = newNames;
                int[] newValues = new int[newSize];
                System.arraycopy(this.values, 0, newValues, 0, this.size);
                this.values = newValues;
            }
        }

        @Override
        public String name(int value2) {
            for (int i2 = 0; i2 < this.size; ++i2) {
                if (this.values[i2] != value2) continue;
                return this.names[i2];
            }
            return null;
        }

        @Override
        public int value(String name) {
            for (int i2 = 0; i2 < this.size; ++i2) {
                if (!this.names[i2].equals(name)) continue;
                return this.values[i2];
            }
            return -1;
        }
    }

    static class LookupEntityMap
    extends PrimitiveEntityMap {
        private String[] lookupTable;
        private int LOOKUP_TABLE_SIZE = 256;

        LookupEntityMap() {
        }

        @Override
        public String name(int value2) {
            if (value2 < this.LOOKUP_TABLE_SIZE) {
                return this.lookupTable()[value2];
            }
            return super.name(value2);
        }

        private String[] lookupTable() {
            if (this.lookupTable == null) {
                this.createLookupTable();
            }
            return this.lookupTable;
        }

        private void createLookupTable() {
            this.lookupTable = new String[this.LOOKUP_TABLE_SIZE];
            for (int i2 = 0; i2 < this.LOOKUP_TABLE_SIZE; ++i2) {
                this.lookupTable[i2] = super.name(i2);
            }
        }
    }

    static class TreeEntityMap
    extends MapIntMap {
        public TreeEntityMap() {
            this.mapNameToValue = new TreeMap();
            this.mapValueToName = new TreeMap();
        }
    }

    static class HashEntityMap
    extends MapIntMap {
        public HashEntityMap() {
            this.mapNameToValue = new HashMap();
            this.mapValueToName = new HashMap();
        }
    }

    static abstract class MapIntMap
    implements EntityMap {
        protected Map mapNameToValue;
        protected Map mapValueToName;

        MapIntMap() {
        }

        @Override
        public void add(String name, int value2) {
            this.mapNameToValue.put(name, value2);
            this.mapValueToName.put(value2, name);
        }

        @Override
        public String name(int value2) {
            return (String)this.mapValueToName.get(value2);
        }

        @Override
        public int value(String name) {
            Object value2 = this.mapNameToValue.get(name);
            if (value2 == null) {
                return -1;
            }
            return (Integer)value2;
        }
    }

    static class PrimitiveEntityMap
    implements EntityMap {
        private Map mapNameToValue = new HashMap();
        private IntHashMap mapValueToName = new IntHashMap();

        PrimitiveEntityMap() {
        }

        @Override
        public void add(String name, int value2) {
            this.mapNameToValue.put(name, value2);
            this.mapValueToName.put(value2, name);
        }

        @Override
        public String name(int value2) {
            return (String)this.mapValueToName.get(value2);
        }

        @Override
        public int value(String name) {
            Object value2 = this.mapNameToValue.get(name);
            if (value2 == null) {
                return -1;
            }
            return (Integer)value2;
        }
    }

    static interface EntityMap {
        public void add(String var1, int var2);

        public String name(int var1);

        public int value(String var1);
    }
}

