/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ls.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.jetbrains.annotations.NotNull;

class FileTrustManager
implements X509TrustManager {
    private static final X509TrustManager[] MANAGERS_EMPTY_ARRAY = new X509TrustManager[0];
    private static final X509Certificate[] EMPTY_CERT_ARRAY = new X509Certificate[0];
    @NotNull
    private final File myCertStoreFile;
    @NotNull
    private final char[] myPassword;
    @NotNull
    private volatile X509TrustManager[] myDelegates;
    private volatile long myStoreStamp;

    public FileTrustManager(@NotNull String certStorePath, @NotNull String password) {
        if (certStorePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "certStorePath", "com/jetbrains/ls/util/FileTrustManager", "<init>"));
        }
        if (password == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "password", "com/jetbrains/ls/util/FileTrustManager", "<init>"));
        }
        this.myDelegates = MANAGERS_EMPTY_ARRAY;
        this.myStoreStamp = -1L;
        this.myCertStoreFile = new File(certStorePath);
        this.myPassword = password.toCharArray();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s2) throws CertificateException {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s2) throws CertificateException {
        for (X509TrustManager delegate2 : this.getDelegates()) {
            try {
                delegate2.checkServerTrusted(x509Certificates, s2);
                return;
            }
            catch (CertificateException certificateException) {
            }
        }
        throw new CertificateException();
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        X509TrustManager[] delegates = this.getDelegates();
        if (delegates.length == 0) {
            return EMPTY_CERT_ARRAY;
        }
        if (delegates.length == 1) {
            return delegates[0].getAcceptedIssuers();
        }
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        for (X509TrustManager delegate2 : delegates) {
            X509Certificate[] issuers = delegate2.getAcceptedIssuers();
            if (issuers == null) continue;
            certs.addAll(Arrays.asList(issuers));
        }
        return certs.toArray(EMPTY_CERT_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private X509TrustManager[] getDelegates() {
        long currentStamp = this.myCertStoreFile.lastModified();
        if (this.myStoreStamp != currentStamp) {
            this.myStoreStamp = currentStamp;
            this.myDelegates = MANAGERS_EMPTY_ARRAY;
            try {
                TrustManagerFactory factory2 = TrustManagerFactory.getInstance("X509");
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(this.myCertStoreFile));){
                    keyStore.load(stream, this.myPassword);
                }
                factory2.init(keyStore);
                TrustManager[] trustManagers = factory2.getTrustManagers();
                if (trustManagers != null) {
                    ArrayList<X509TrustManager> managers = new ArrayList<X509TrustManager>();
                    for (TrustManager manager : trustManagers) {
                        if (!(manager instanceof X509TrustManager)) continue;
                        managers.add((X509TrustManager)manager);
                    }
                    this.myDelegates = managers.toArray(MANAGERS_EMPTY_ARRAY);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.myDelegates == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/ls/util/FileTrustManager", "getDelegates"));
        }
        return this.myDelegates;
    }
}

