/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ls.util;

import com.jetbrains.ls.requests.AbstractRequest;
import com.jetbrains.ls.requests.GetPermanentActivationRequest;
import com.jetbrains.ls.requests.ObtainPermanentTicketRequest;
import com.jetbrains.ls.requests.ObtainTicketRequest;
import com.jetbrains.ls.requests.PingRequest;
import com.jetbrains.ls.requests.ProlongTicketRequest;
import com.jetbrains.ls.requests.ReleaseTicketRequest;
import com.jetbrains.ls.responses.AbstractFloatingResponse;
import com.jetbrains.ls.responses.GetPermanentActivationResponse;
import com.jetbrains.ls.responses.ObtainPermanentTicketResponse;
import com.jetbrains.ls.responses.ObtainTicketResponse;
import com.jetbrains.ls.responses.PingResponse;
import com.jetbrains.ls.responses.ProlongTicketResponse;
import com.jetbrains.ls.responses.ReleaseTicketResponse;
import com.jetbrains.ls.util.ClientUtil;
import com.jetbrains.ls.util.RpcUtil;
import com.jetbrains.ls.util.VerificationFailedException;
import com.jetbrains.ls.util.VerifyingSignatureFactory;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class FloatingClientUtil
extends ClientUtil {
    public static PingResponse pingFloating(String serverUrl, String productUUID_or_code) throws VerificationFailedException, IOException {
        PingRequest request2 = new PingRequest();
        request2.setMachineId(FloatingClientUtil.getMachineId());
        request2.setUserName(FloatingClientUtil.getUserName());
        request2.setHostName(FloatingClientUtil.getHostName());
        request2.setProductFamilyId(productUUID_or_code);
        request2.setBuildNumber(FloatingClientUtil.getBuildNumber());
        request2.setSalt(System.currentTimeMillis());
        return FloatingClientUtil.executeRpc(serverUrl, request2);
    }

    public static ObtainTicketResponse obtainTicket(String serverUrl, String productUUID_or_code, int version, int buildDate, boolean sendBuildDateAsVersionToOldServers) throws VerificationFailedException, IOException {
        ObtainTicketRequest request2 = new ObtainTicketRequest(System.currentTimeMillis(), productUUID_or_code, version, buildDate, sendBuildDateAsVersionToOldServers, FloatingClientUtil.getMachineId(), FloatingClientUtil.getHostName(), FloatingClientUtil.getUserName());
        request2.setBuildNumber(FloatingClientUtil.getBuildNumber());
        return FloatingClientUtil.executeRpc(serverUrl, request2);
    }

    public static ProlongTicketResponse prolongTicket(String serverUrl, String ticketId, String productUUID_or_code) throws VerificationFailedException, IOException {
        ProlongTicketRequest request2 = new ProlongTicketRequest(System.currentTimeMillis(), ticketId, productUUID_or_code, FloatingClientUtil.getMachineId(), FloatingClientUtil.getHostName(), FloatingClientUtil.getUserName());
        request2.setBuildNumber(FloatingClientUtil.getBuildNumber());
        return FloatingClientUtil.executeRpc(serverUrl, request2);
    }

    public static ReleaseTicketResponse releaseTicket(String serverUrl, String ticketID, String productUUID_or_code) throws VerificationFailedException, IOException {
        ReleaseTicketRequest request2 = new ReleaseTicketRequest(System.currentTimeMillis(), productUUID_or_code, ticketID, FloatingClientUtil.getMachineId(), FloatingClientUtil.getHostName(), FloatingClientUtil.getUserName());
        request2.setBuildNumber(FloatingClientUtil.getBuildNumber());
        return FloatingClientUtil.executeRpc(serverUrl, request2);
    }

    public static GetPermanentActivationResponse obtainPermanentActivationCode(String serverUrl, String productUUID_or_code, String email) throws VerificationFailedException, IOException {
        GetPermanentActivationRequest request2 = new GetPermanentActivationRequest(System.currentTimeMillis(), productUUID_or_code, email, FloatingClientUtil.getMachineId(), FloatingClientUtil.getHostName(), FloatingClientUtil.getUserName());
        request2.setBuildNumber(FloatingClientUtil.getBuildNumber());
        return FloatingClientUtil.executeRpc(serverUrl, request2);
    }

    public static ObtainPermanentTicketResponse obtainPermanentTicket(String serverUrl, String productUUID_or_code, int version, int buildDate, boolean sendBuildDateAsVersionToOldServers, String email, String activationCode) throws VerificationFailedException, IOException {
        ObtainPermanentTicketRequest request2 = new ObtainPermanentTicketRequest(System.currentTimeMillis(), productUUID_or_code, version, buildDate, sendBuildDateAsVersionToOldServers, FloatingClientUtil.getMachineId(), FloatingClientUtil.getHostName(), FloatingClientUtil.getUserName(), email, activationCode);
        request2.setBuildNumber(FloatingClientUtil.getBuildNumber());
        return FloatingClientUtil.executeRpc(serverUrl, request2);
    }

    @NotNull
    private static <Response extends AbstractFloatingResponse> Response executeRpc(String serverUrl, AbstractRequest<Response> request2) throws VerificationFailedException, IOException {
        AbstractFloatingResponse response = (AbstractFloatingResponse)RpcUtil.executeRpcToLicenseServer((String)serverUrl, request2).fst;
        String serverLease = response.getServerLease();
        if (serverLease != null) {
            String leaseSignature = response.getLeaseSignature();
            RpcUtil.verifySignature(serverLease, leaseSignature, VerifyingSignatureFactory.JBA);
            int idx = serverLease.indexOf(58);
            long validTill = Long.parseLong(serverLease.substring(0, idx));
            String uid = serverLease.substring(idx + 1);
            if (validTill < System.currentTimeMillis()) {
                throw new VerificationFailedException("License server lease has expired. Please contact your system administrator.");
            }
        }
        AbstractFloatingResponse abstractFloatingResponse = response;
        if (abstractFloatingResponse == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/ls/util/FloatingClientUtil", "executeRpc"));
        }
        return (Response)abstractFloatingResponse;
    }
}

