/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ls.util;

import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HttpProxyDiscoveryService {
    private static final List<HttpProxyDiscoveryService> ourServices = new CopyOnWriteArrayList<HttpProxyDiscoveryService>();

    public static void registerImplementation(@NotNull HttpProxyDiscoveryService impl) {
        if (impl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "impl", "com/jetbrains/ls/util/HttpProxyDiscoveryService", "registerImplementation"));
        }
        ourServices.add(impl);
    }

    @Nullable
    public static Proxy detectProxy(URL url) throws IOException {
        try {
            return HttpProxyDiscoveryService.detectProxy(url.toURI());
        }
        catch (URISyntaxException e2) {
            throw new IOException(e2);
        }
    }

    @Nullable
    public static Proxy detectProxy(URI uri2) {
        for (HttpProxyDiscoveryService service : ourServices) {
            ProxySelector selector = service.getProxySelector();
            if (selector == null) continue;
            List<Proxy> proxies = selector.select(uri2);
            for (Proxy proxy : proxies) {
                if (proxy.type() != Proxy.Type.HTTP) continue;
                return proxy;
            }
        }
        return null;
    }

    @Nullable
    public abstract ProxySelector getProxySelector();

    static {
        for (HttpProxyDiscoveryService service : ServiceLoader.load(HttpProxyDiscoveryService.class)) {
            ourServices.add(service);
        }
    }
}

