/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ls.util;

import com.jetbrains.ls.util.PropertyDsc;
import com.jetbrains.ls.util.SkipInToString;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public class IntrospectionUtil {
    private static final ConcurrentHashMap<Class, List<PropertyDsc>> propCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Class, MethodHandle> getValueCache = new ConcurrentHashMap();
    private static Set<String> IGNORED_PROPERTY_NAMES = new HashSet<String>(Arrays.asList("actionName", "class"));

    public static boolean isActionPropertyIgnored(String propertyName) {
        return IGNORED_PROPERTY_NAMES.contains(propertyName);
    }

    public static List<PropertyDsc> getProperties(Class klass) {
        List<PropertyDsc> answer = propCache.get(klass);
        if (answer != null) {
            return answer;
        }
        answer = IntrospectionUtil.buildProperties(klass);
        propCache.put(klass, answer);
        return answer;
    }

    private static List<PropertyDsc> buildProperties(Class klass) {
        try {
            ArrayList<PropertyDsc> answer = new ArrayList<PropertyDsc>();
            for (PropertyDescriptor propertyDescriptor : Introspector.getBeanInfo(klass).getPropertyDescriptors()) {
                String propertyName = propertyDescriptor.getName();
                if (IntrospectionUtil.isActionPropertyIgnored(propertyName)) continue;
                answer.add(new PropertyDsc(propertyName, propertyDescriptor.getPropertyType(), propertyDescriptor.getReadMethod(), propertyDescriptor.getWriteMethod()));
            }
            return answer;
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    @Nullable
    private static MethodHandle resolveGetPropertyValueStringMethod(Class<?> clazz) throws NoSuchMethodException, IllegalAccessException {
        if (getValueCache.containsKey(clazz)) {
            return getValueCache.get(clazz);
        }
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            MethodHandle method2 = lookup.findVirtual(clazz, "getPropertyValueString", MethodType.methodType(String.class, String.class, Object.class));
            getValueCache.put(clazz, method2);
            return method2;
        }
        catch (ReflectiveOperationException e2) {
            return null;
        }
    }

    public static String toString(Object object) {
        StringBuilder sb2 = new StringBuilder();
        Class<?> clazz = object.getClass();
        sb2.append(clazz.getSimpleName());
        sb2.append("[");
        Boolean isFirst = true;
        List<PropertyDsc> propertyDescriptors = IntrospectionUtil.getProperties(clazz);
        for (PropertyDsc propertyDescriptor : propertyDescriptors) {
            try {
                MethodHandle getValueToStringMethod;
                String propertyName = propertyDescriptor.getName();
                Method getter = propertyDescriptor.getReadMethod();
                Object value2 = getter.invoke(object, new Object[0]);
                String propertyValue = getter.getAnnotation(SkipInToString.class) != null ? (value2 != null && !value2.toString().isEmpty() ? "<hidden>" : "") : ((getValueToStringMethod = IntrospectionUtil.resolveGetPropertyValueStringMethod(clazz)) != null ? (String)getValueToStringMethod.bindTo(object).invokeWithArguments(Arrays.asList(propertyName, value2)) : object.toString());
                if (!isFirst.booleanValue()) {
                    sb2.append(", ");
                } else {
                    isFirst = false;
                }
                sb2.append(propertyName).append("='").append(propertyValue).append("'");
            }
            catch (ReflectiveOperationException e2) {
                e2.printStackTrace();
            }
            catch (Throwable e3) {
                throw new RuntimeException(e3);
            }
        }
        sb2.append("]");
        return sb2.toString();
    }
}

