/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ls.util;

import com.jetbrains.ls.requests.ExchangeKeyRequest;
import com.jetbrains.ls.requests.ObtainAgreementRequest;
import com.jetbrains.ls.requests.ObtainLicenseRequest;
import com.jetbrains.ls.requests.PingRequest;
import com.jetbrains.ls.requests.ValidateKeyRequest;
import com.jetbrains.ls.requests.ValidateLicenseRequest;
import com.jetbrains.ls.responses.ExchangeKeyResponse;
import com.jetbrains.ls.responses.ObtainAgreementResponse;
import com.jetbrains.ls.responses.ObtainLicenseResponse;
import com.jetbrains.ls.responses.ObtainUserIdResponse;
import com.jetbrains.ls.responses.PingResponse;
import com.jetbrains.ls.responses.ValidateKeyResponse;
import com.jetbrains.ls.responses.ValidateLicenseResponse;
import com.jetbrains.ls.util.ClientUtil;
import com.jetbrains.ls.util.RpcUtil;
import com.jetbrains.ls.util.VerificationFailedException;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBAClientUtil
extends ClientUtil {
    public static PingResponse pingJBA(String productCode) throws VerificationFailedException, IOException {
        PingRequest request2 = new PingRequest();
        request2.setMachineId(JBAClientUtil.getMachineId());
        request2.setUserName("");
        request2.setHostName("");
        request2.setProductFamilyId(productCode);
        request2.setBuildNumber(JBAClientUtil.getBuildNumber());
        request2.setSalt(System.currentTimeMillis());
        return (PingResponse)RpcUtil.executeRpcToJBA(request2).fst;
    }

    public static ObtainAgreementResponse obtainEvaluationAgreement(String productCode, String existingVersion, @Nullable String licenseID, @Nullable String userId) throws IOException, VerificationFailedException {
        return JBAClientUtil.obtainAgreement(productCode, ObtainAgreementRequest.getEvaluationAgreementName(productCode), existingVersion, licenseID, userId);
    }

    public static ObtainAgreementResponse obtainPrivacyPolicyAgreement(String productCode, String existingVersion, @Nullable String licenseID, @Nullable String userId) throws IOException, VerificationFailedException {
        return JBAClientUtil.obtainAgreement(productCode, "privacy", existingVersion, licenseID, userId);
    }

    private static ObtainAgreementResponse obtainAgreement(String productCode, String fileName, String existingVersion, @Nullable String licenseID, @Nullable String userId) throws IOException, VerificationFailedException {
        ObtainAgreementRequest request2 = new ObtainAgreementRequest(System.currentTimeMillis(), productCode, JBAClientUtil.getMachineId(), "", "", fileName, existingVersion, licenseID, userId);
        request2.setBuildNumber(JBAClientUtil.getBuildNumber());
        return (ObtainAgreementResponse)RpcUtil.executeRpcToJBA(request2).fst;
    }

    public static ObtainUserIdResponse obtainUserId(@NotNull String loginName, @NotNull String password) throws IOException, VerificationFailedException {
        if (loginName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loginName", "com/jetbrains/ls/util/JBAClientUtil", "obtainUserId"));
        }
        if (password == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "password", "com/jetbrains/ls/util/JBAClientUtil", "obtainUserId"));
        }
        return RpcUtil.authenticateUser(loginName, password);
    }

    public static ObtainLicenseResponse obtainLicenses(String userId, String productFamily, int version, String edition, long buildDate) throws IOException, VerificationFailedException {
        ObtainLicenseRequest request2 = new ObtainLicenseRequest(System.currentTimeMillis(), userId, JBAClientUtil.getMachineId(), "", "", productFamily, edition, version, buildDate);
        request2.setBuildNumber(JBAClientUtil.getBuildNumber());
        return (ObtainLicenseResponse)RpcUtil.executeRpcToJBA(request2).fst;
    }

    public static ValidateLicenseResponse validateLicense(String userId, String assetId, String productFamily, int version, String edition, long buildDate) throws IOException, VerificationFailedException {
        return JBAClientUtil.validateLicense(userId, assetId, "", productFamily, version, edition, buildDate);
    }

    public static ValidateLicenseResponse validateLicense(String userId, String assetId, String licenseHash, String productFamily, int version, String edition, long buildDate) throws IOException, VerificationFailedException {
        ValidateLicenseRequest request2 = new ValidateLicenseRequest(System.currentTimeMillis(), userId, assetId, licenseHash, JBAClientUtil.getMachineId(), "", "", productFamily, edition, version, buildDate);
        request2.setBuildNumber(JBAClientUtil.getBuildNumber());
        return (ValidateLicenseResponse)RpcUtil.executeRpcToJBA(request2).fst;
    }

    public static ValidateKeyResponse validateLicenseKey(String productFamily, String licenseKey) throws IOException, VerificationFailedException {
        return JBAClientUtil.validateLicenseKey(productFamily, licenseKey, "");
    }

    public static ValidateKeyResponse validateLicenseKey(String productFamily, String licenseKey, String licenseHash) throws IOException, VerificationFailedException {
        ValidateKeyRequest request2 = new ValidateKeyRequest(System.currentTimeMillis(), productFamily, JBAClientUtil.getMachineId(), "", "", licenseKey, licenseHash);
        request2.setBuildNumber(JBAClientUtil.getBuildNumber());
        return (ValidateKeyResponse)RpcUtil.executeRpcToJBA(request2).fst;
    }

    public static ExchangeKeyResponse exchangeKey(String productFamily, String oldLicenseKey, String firstName, String lastName, String email) throws IOException, VerificationFailedException {
        ExchangeKeyRequest request2 = new ExchangeKeyRequest(System.currentTimeMillis(), productFamily, JBAClientUtil.getMachineId(), "", "", oldLicenseKey, firstName, lastName, email);
        request2.setBuildNumber(JBAClientUtil.getBuildNumber());
        return (ExchangeKeyResponse)RpcUtil.executeRpcToJBA(request2).fst;
    }
}

