/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ls.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

final class ObjectPool<T> {
    private final List<Entry> myPool;
    private final Factory<T> myFactory;

    ObjectPool(int capacity, Factory<T> factory2) {
        this.myFactory = factory2;
        this.myPool = new ArrayList<Entry>();
        for (int idx = 0; idx < capacity; ++idx) {
            this.myPool.add(new Entry(factory2.create()));
        }
    }

    public Item<T> allocate() {
        for (Entry object : this.myPool) {
            if (!object.alloc()) continue;
            return object;
        }
        final T obj = this.myFactory.create();
        this.myFactory.onAllocate(obj);
        return new Item<T>(){

            @Override
            @NotNull
            public T get() {
                Object object = obj;
                if (object == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/ls/util/ObjectPool$1", "get"));
                }
                return object;
            }

            @Override
            public void release() {
                ObjectPool.this.myFactory.onRelease(obj);
            }
        };
    }

    private final class Entry
    implements Item<T> {
        private final AtomicBoolean myIsBusy;
        @NotNull
        private final T myObject;

        Entry(T obj) {
            if (obj == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/jetbrains/ls/util/ObjectPool$Entry", "<init>"));
            }
            this.myIsBusy = new AtomicBoolean(false);
            this.myObject = obj;
        }

        boolean alloc() {
            boolean allocated;
            boolean bl = allocated = !this.myIsBusy.getAndSet(true);
            if (allocated) {
                ObjectPool.this.myFactory.onAllocate(this.myObject);
            }
            return allocated;
        }

        @Override
        public void release() {
            ObjectPool.this.myFactory.onRelease(this.myObject);
            this.myIsBusy.set(false);
        }

        @Override
        @NotNull
        public T get() {
            Object t2 = this.myObject;
            if (t2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/ls/util/ObjectPool$Entry", "get"));
            }
            return t2;
        }
    }

    public static interface Item<Data> {
        @NotNull
        public Data get();

        public void release();
    }

    public static interface Factory<Data> {
        public Data create();

        public void onAllocate(Data var1);

        public void onRelease(Data var1);
    }
}

