/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ls.util;

import com.jetbrains.ls.util.DecodeException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;

public class RSADecoder {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final BigInteger myDigitsMod;
    private final BigInteger myPublicExponent;
    private final BigInteger myPublicModulus;
    private final int myDigitsPerChunk;
    private final int myChunkSize;

    public RSADecoder(BigInteger publicExponent, BigInteger publicModulus) {
        this(publicExponent, publicModulus, 16);
    }

    protected RSADecoder(BigInteger publicExponent, BigInteger publicModulus, int alphabetSize) {
        this.myPublicModulus = publicModulus;
        this.myPublicExponent = publicExponent;
        int keyLength = publicModulus.bitLength();
        this.myChunkSize = keyLength / 8 - 1;
        int digits = (int)Math.ceil((double)keyLength / Math.log(alphabetSize) * Math.log(2.0));
        if (digits % 5 != 0) {
            digits = (digits / 5 + 1) * 5;
        }
        this.myDigitsPerChunk = digits;
        this.myDigitsMod = new BigInteger(Integer.toString(alphabetSize));
    }

    public String decodeString(String data) throws DecodeException {
        try {
            return new String(this.decode(data), "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            return "";
        }
    }

    public byte[] decode(String data) throws DecodeException {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            BigInteger chunkBytes = BigInteger.ZERO;
            int digitsRead = 0;
            for (int i2 = 0; i2 < data.length(); ++i2) {
                char c2 = data.charAt(i2);
                chunkBytes = chunkBytes.multiply(this.myDigitsMod).add(RSADecoder.decodeChar(c2));
                if (++digitsRead != this.myDigitsPerChunk) continue;
                BigInteger decodedChunk = chunkBytes.modPow(this.myPublicExponent, this.myPublicModulus);
                byte[] decodedBytes = decodedChunk.toByteArray();
                stream.write(decodedBytes, Math.max(decodedBytes.length - this.myChunkSize, 0), Math.min(decodedBytes.length, this.myChunkSize));
                chunkBytes = BigInteger.ZERO;
                digitsRead = 0;
            }
            if (digitsRead != 0) {
                throw new DecodeException();
            }
            stream.close();
            return stream.toByteArray();
        }
        catch (IOException iOException) {
            return EMPTY_BYTE_ARRAY;
        }
    }

    private static BigInteger decodeChar(char c2) throws DecodeException {
        int d2;
        if ('0' <= c2 && c2 <= '9') {
            d2 = c2 - 48;
        } else if ('A' <= c2 && c2 <= 'Z') {
            d2 = c2 - 65 + 10;
        } else if ('a' <= c2 && c2 <= 'z') {
            d2 = c2 - 97 + 36;
        } else if ('!' <= c2 && c2 <= ')') {
            d2 = c2 - 33 + 62;
        } else {
            throw new DecodeException();
        }
        return BigInteger.valueOf(d2);
    }
}

