/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ls.util;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import org.jetbrains.annotations.NotNull;

public class RSAEncoder {
    private final BigInteger myPrivateExponent;
    private final BigInteger myPrivateModulus;
    private final int myChunkSize;
    private final int myDigitsPerChunk;
    private final BigInteger myDigitsMod;

    public RSAEncoder(BigInteger privateExponent, BigInteger privateModulus) {
        this(privateExponent, privateModulus, 16);
    }

    protected RSAEncoder(BigInteger privateExponent, BigInteger privateModulus, int alphabetSize) {
        this.myPrivateExponent = privateExponent;
        this.myPrivateModulus = privateModulus;
        int keyLength = privateModulus.bitLength();
        this.myDigitsMod = new BigInteger(String.valueOf(alphabetSize));
        this.myChunkSize = keyLength / 8 - 1;
        int digits = (int)Math.ceil((double)keyLength / Math.log(alphabetSize) * Math.log(2.0));
        if (digits % 5 != 0) {
            digits = (digits / 5 + 1) * 5;
        }
        this.myDigitsPerChunk = digits;
    }

    public String encodeString(String data) {
        try {
            return this.encode(data.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e2) {
            return "";
        }
    }

    public String encode(byte[] data) {
        StringBuilder encoded = new StringBuilder();
        int leap = data.length % this.myChunkSize;
        if (leap > 0) {
            byte[] padded = new byte[this.myChunkSize];
            System.arraycopy(data, 0, padded, this.myChunkSize - leap, leap);
            this.encryptChunk(padded, encoded);
        }
        for (int i2 = leap; i2 < data.length; i2 += this.myChunkSize) {
            byte[] chunk = new byte[this.myChunkSize];
            System.arraycopy(data, i2, chunk, 0, this.myChunkSize);
            this.encryptChunk(chunk, encoded);
        }
        return encoded.toString();
    }

    private void encryptChunk(byte[] buf, StringBuilder encoded) {
        BigInteger chunk = new BigInteger(1, buf);
        if (chunk.compareTo(this.myPrivateModulus) >= 0) {
            throw new IllegalArgumentException("result is too long");
        }
        BigInteger encryptedChunk = chunk.modPow(this.myPrivateExponent, this.myPrivateModulus);
        encoded.append(this.encode(encryptedChunk));
    }

    private CharSequence encode(BigInteger value2) {
        StringBuilder buf = new StringBuilder(this.myDigitsPerChunk);
        for (int i2 = 0; i2 < this.myDigitsPerChunk; ++i2) {
            buf.append(RSAEncoder.digitChar(value2.mod(this.myDigitsMod)));
            value2 = value2.divide(this.myDigitsMod);
        }
        return new ReverseCharSequence(buf);
    }

    private static char digitChar(BigInteger digit) {
        int d2 = digit.intValue();
        if (d2 < 10) {
            return (char)(48 + d2);
        }
        if (d2 < 36) {
            return (char)(65 + d2 - 10);
        }
        if (d2 < 62) {
            return (char)(97 + d2 - 36);
        }
        return (char)(33 + d2 - 62);
    }

    private static class ReverseCharSequence
    implements CharSequence {
        private final CharSequence mySequence;

        public ReverseCharSequence(CharSequence sequence) {
            this.mySequence = sequence;
        }

        @Override
        public int length() {
            return this.mySequence.length();
        }

        @Override
        public char charAt(int index) {
            return this.mySequence.charAt(this.mySequence.length() - index - 1);
        }

        @Override
        @NotNull
        public CharSequence subSequence(int start2, int end) {
            int length = this.mySequence.length();
            ReverseCharSequence reverseCharSequence = new ReverseCharSequence(this.mySequence.subSequence(length - end, length - start2));
            if (reverseCharSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/ls/util/RSAEncoder$ReverseCharSequence", "subSequence"));
            }
            return reverseCharSequence;
        }
    }
}

