/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ls.util;

import com.jetbrains.ls.Constants;
import com.jetbrains.ls.util.Entities;
import com.jetbrains.ls.util.IntrospectionUtil;
import com.jetbrains.ls.util.ObjectPool;
import com.jetbrains.ls.util.PropertyDsc;
import java.beans.IntrospectionException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class ResponseMarshaller {
    private static final String RESPONSE_PACKAGE = "com.jetbrains.ls.responses";
    private static final ObjectPool<DocumentBuilder> ourDocumentBuilderPool = new ObjectPool<DocumentBuilder>(1, new ObjectPool.Factory<DocumentBuilder>(){

        @Override
        public DocumentBuilder create() {
            return ResponseMarshaller.createDocumentBuilder();
        }

        @Override
        public void onAllocate(DocumentBuilder documentBuilder) {
        }

        @Override
        public void onRelease(DocumentBuilder documentBuilder) {
        }
    });
    private static List SIMPLE_CONVERT_CLASSES = Arrays.asList(String.class, Long.TYPE, Long.class, Integer.TYPE, Integer.class, Short.TYPE, Short.class, Float.TYPE, Float.class, Double.TYPE, Double.class, Byte.TYPE, Byte.class, Boolean.TYPE, Boolean.class, Date.class);

    public static <T> T unmarshall(String xml) {
        try {
            Document doc;
            ObjectPool.Item<DocumentBuilder> builderItem = ourDocumentBuilderPool.allocate();
            try {
                doc = builderItem.get().parse(new InputSource(new StringReader(xml)));
            }
            finally {
                builderItem.release();
            }
            Element root = doc.getDocumentElement();
            return (T)ResponseMarshaller.unmarshallBean(root);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    private static Object unmarshallBean(Element beanElement) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IntrospectionException, InvocationTargetException {
        String className = ResponseMarshaller.toFullClassName(beanElement.getNodeName());
        Class<?> beanClass = Class.forName(className);
        Object bean = beanClass.newInstance();
        for (PropertyDsc propertyDescriptor : IntrospectionUtil.getProperties(beanClass)) {
            Object propValue;
            Node propNode = null;
            for (Node child = beanElement.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!child.getNodeName().equals(propertyDescriptor.getName())) continue;
                propNode = child;
                break;
            }
            if (propNode == null) continue;
            if (ResponseMarshaller.isCollectionProperty(propertyDescriptor)) {
                ArrayList<Object> collection = new ArrayList<Object>();
                for (Node listItem = propNode.getFirstChild(); listItem != null; listItem = listItem.getNextSibling()) {
                    if (!(listItem instanceof Element)) continue;
                    Object itemBean = ResponseMarshaller.unmarshallBean((Element)listItem);
                    collection.add(itemBean);
                }
                propValue = collection;
            } else if (ResponseMarshaller.isSimpleConvert(propertyDescriptor.getPropertyType())) {
                String strValue = ResponseMarshaller.unescapeXml(propNode.getTextContent());
                propValue = ResponseMarshaller.convertValue(strValue, propertyDescriptor.getPropertyType());
            } else if (propNode.getChildNodes().item(0) != null) {
                propValue = ResponseMarshaller.unmarshallBean((Element)propNode.getChildNodes().item(0));
            } else {
                throw new RuntimeException("Unsupported node " + propNode);
            }
            propertyDescriptor.getWriteMethod().invoke(bean, propValue);
        }
        return bean;
    }

    public static <T> String marshall(T response) {
        return ResponseMarshaller.marshallBean(response);
    }

    private static String marshallBean(Object data) {
        try {
            StringBuilder build2 = new StringBuilder();
            Class<?> dataClass = data.getClass();
            String beanName = ResponseMarshaller.toShortClassName(dataClass.getName());
            build2.append("<").append(beanName).append(">");
            for (PropertyDsc propertyDescriptor : IntrospectionUtil.getProperties(dataClass)) {
                Object propertyValue = propertyDescriptor.getReadMethod().invoke(data, new Object[0]);
                if (propertyValue == null || propertyValue instanceof Class) continue;
                build2.append("<").append(propertyDescriptor.getName()).append(">");
                if (ResponseMarshaller.isCollectionProperty(propertyDescriptor)) {
                    Collection collection = (Collection)propertyValue;
                    for (Object item : collection) {
                        build2.append(ResponseMarshaller.marshallBean(item));
                    }
                } else if (ResponseMarshaller.isSimpleConvert(propertyDescriptor.getPropertyType())) {
                    String asString2 = Date.class.isAssignableFrom(propertyDescriptor.getPropertyType()) ? Constants.getDateFormat().format((Date)propertyValue) : propertyValue.toString();
                    build2.append(ResponseMarshaller.escapeXml(asString2));
                } else {
                    build2.append(ResponseMarshaller.marshallBean(propertyValue));
                }
                build2.append("</").append(propertyDescriptor.getName()).append(">");
            }
            build2.append("</").append(beanName).append(">");
            return build2.toString();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    private static boolean isCollectionProperty(PropertyDsc propertyDescriptor) {
        return Collection.class.isAssignableFrom(propertyDescriptor.getPropertyType());
    }

    private static String toShortClassName(String fullName) {
        return fullName.substring(fullName.lastIndexOf(".") + 1);
    }

    private static String toFullClassName(String shortName) {
        return "com.jetbrains.ls.responses." + shortName;
    }

    private static boolean isSimpleConvert(Class expectedType) {
        return expectedType.isEnum() || SIMPLE_CONVERT_CLASSES.contains(expectedType);
    }

    public static Object convertValue(String paramValue, Class expectedType) {
        if (String.class.equals((Object)expectedType)) {
            return paramValue;
        }
        if (expectedType.isEnum()) {
            return Enum.valueOf(expectedType, paramValue);
        }
        if (Long.TYPE.equals(expectedType) || Long.class.equals((Object)expectedType)) {
            return Long.parseLong(paramValue);
        }
        if (Integer.TYPE.equals(expectedType) || Integer.class.equals((Object)expectedType)) {
            return Integer.parseInt(paramValue);
        }
        if (Short.TYPE.equals(expectedType) || Short.class.equals((Object)expectedType)) {
            return Short.parseShort(paramValue);
        }
        if (Float.TYPE.equals(expectedType) || Float.class.equals((Object)expectedType)) {
            return Float.valueOf(Float.parseFloat(paramValue));
        }
        if (Double.TYPE.equals(expectedType) || Double.class.equals((Object)expectedType)) {
            return Double.parseDouble(paramValue);
        }
        if (Byte.TYPE.equals(expectedType) || Byte.class.equals((Object)expectedType)) {
            return Byte.parseByte(paramValue);
        }
        if (Boolean.TYPE.equals(expectedType) || Boolean.class.equals((Object)expectedType)) {
            return Boolean.parseBoolean(paramValue);
        }
        if (Date.class.equals((Object)expectedType)) {
            try {
                return Constants.getDateFormat().parse(paramValue);
            }
            catch (ParseException e2) {
                throw new RuntimeException("Expected Date value in format \"yyyy-MM-dd\", but was \"" + paramValue + "\"");
            }
        }
        throw new RuntimeException("Unsupported type " + expectedType.getName() + " in property value: " + paramValue);
    }

    private static String escapeXml(String str) {
        return str == null ? null : Entities.XML.escape(str);
    }

    public static String unescapeXml(String str) {
        return str == null ? null : Entities.XML.unescape(str);
    }

    private static DocumentBuilder createDocumentBuilder() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringComments(true);
        dbf.setIgnoringElementContentWhitespace(true);
        try {
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e2) {
            throw new IllegalStateException(e2);
        }
    }
}

