/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ls.util;

import com.jetbrains.ls.JBAPublicKeys;
import com.jetbrains.ls.requests.AbstractRequest;
import com.jetbrains.ls.responses.AbstractFloatingResponse;
import com.jetbrains.ls.responses.AbstractResponse;
import com.jetbrains.ls.responses.ObtainUserIdResponse;
import com.jetbrains.ls.responses.ResponseCode;
import com.jetbrains.ls.util.Base64Support;
import com.jetbrains.ls.util.CertStorePathProvider;
import com.jetbrains.ls.util.FileTrustManager;
import com.jetbrains.ls.util.HttpProxyDiscoveryService;
import com.jetbrains.ls.util.IntrospectionUtil;
import com.jetbrains.ls.util.Pair;
import com.jetbrains.ls.util.PropertyDsc;
import com.jetbrains.ls.util.ResponseMarshaller;
import com.jetbrains.ls.util.ServiceConfig;
import com.jetbrains.ls.util.VerificationFailedException;
import com.jetbrains.ls.util.VerifyingSignatureFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RpcUtil {
    private static final int SECOND = 1000;
    private static final int DEFAULT_TIMEOUT = 30000;
    private static final int TIMEOUT;
    private static SSLSocketFactory ourSSLSocketFactory;
    private static SSLContext ourSSLClientContext;
    private static GeneralSecurityException ourSSLConfigError;

    @Nullable
    private static FileTrustManager initFileTrustManager() {
        try {
            Iterator<CertStorePathProvider> it = ServiceLoader.load(CertStorePathProvider.class).iterator();
            if (!it.hasNext()) {
                return null;
            }
            CertStorePathProvider pathProvider = it.next();
            return new FileTrustManager(pathProvider.getPath(), pathProvider.getPassword());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Nullable
    public static SSLContext getClientSSLContext() {
        return ourSSLClientContext;
    }

    public static void verifySignature(String contentToVerify, String signatureString, VerifyingSignatureFactory ... sigFactories) throws VerificationFailedException {
        byte[] contentBytes = contentToVerify.getBytes(StandardCharsets.UTF_8);
        Throwable lastError = null;
        for (VerifyingSignatureFactory factory2 : sigFactories) {
            try {
                Pair<byte[], Signature> sig = factory2.create(signatureString, contentToVerify);
                byte[] sigBytes = (byte[])sig.fst;
                Signature signature = (Signature)sig.snd;
                signature.update(contentBytes);
                if (signature.verify(sigBytes)) {
                    return;
                }
                lastError = null;
            }
            catch (Throwable e2) {
                lastError = e2;
            }
        }
        if (lastError != null) {
            throw new VerificationFailedException(lastError.getMessage());
        }
        throw new VerificationFailedException("Verification failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static String readFully(BufferedReader reader) throws IOException {
        StringBuilder out = new StringBuilder();
        char[] buffer = new char[1024];
        try {
            int chars = reader.read(buffer);
            while (chars >= 0) {
                out.append(buffer, 0, chars);
                chars = reader.read(buffer);
            }
        }
        finally {
            reader.close();
        }
        String string2 = out.toString();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/ls/util/RpcUtil", "readFully"));
        }
        return string2;
    }

    @NotNull
    public static String performRequest(URL url, Map<String, String> postData) throws IOException {
        Pair<Integer, BufferedReader> result2 = RpcUtil.createURLReader(url, postData);
        String response = RpcUtil.readFully((BufferedReader)result2.snd);
        if ((Integer)result2.fst != 200) {
            throw new IOException("Remote call failed: " + response);
        }
        String string2 = response;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/ls/util/RpcUtil", "performRequest"));
        }
        return string2;
    }

    public static void verifySignedContent(String content2, VerifyingSignatureFactory ... sigFactories) throws VerificationFailedException {
        String comment;
        int idx = content2.indexOf(10);
        String string2 = comment = idx >= 0 ? content2.substring(0, idx) : "";
        if (!comment.startsWith("<!-- ") || !comment.endsWith(" -->")) {
            throw new VerificationFailedException("Validation failed");
        }
        String data = idx >= 0 ? content2.substring(idx + 1) : content2;
        RpcUtil.verifySignature(data, comment.substring("<!-- ".length(), comment.length() - " -->".length()), sigFactories);
    }

    public static String readFromUrl(URL url) throws IOException {
        Object result2 = RpcUtil.readFromUrl(url, Collections.emptyMap(), new ResultProcessor<Object>(){

            @Override
            public Object processResult(int responseCode, String responseContent) {
                if (responseCode == 200) {
                    return responseContent;
                }
                StringBuilder buf = new StringBuilder();
                buf.append("Http error ").append(responseCode);
                if (responseContent != null && !responseContent.isEmpty()) {
                    buf.append(": ").append(responseContent);
                }
                return new IOException(buf.toString());
            }
        });
        if (result2 instanceof IOException) {
            throw (IOException)result2;
        }
        return (String)result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <Result> Result readFromUrl(URL url, Map<String, String> postData, ResultProcessor<Result> handler2) throws IOException {
        Pair<Integer, BufferedReader> response = RpcUtil.createURLReader(url, postData);
        StringBuilder result2 = new StringBuilder();
        try (BufferedReader reader = (BufferedReader)response.snd;){
            String line = reader.readLine();
            while (line != null) {
                if (result2.length() > 0) {
                    result2.append("\n");
                }
                result2.append(line);
                line = reader.readLine();
            }
        }
        return handler2.processResult((Integer)response.fst, result2.toString());
    }

    @NotNull
    private static Pair<Integer, BufferedReader> createURLReader(URL url, Map<String, String> postData) throws IOException {
        Pair<Integer, BufferedReader> pair;
        try {
            pair = RpcUtil._createURLReader(url, null, postData);
        }
        catch (IOException originalException) {
            Proxy detectedProxy = null;
            try {
                detectedProxy = HttpProxyDiscoveryService.detectProxy(url);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (detectedProxy == null) {
                throw originalException;
            }
            Pair<Integer, BufferedReader> pair2 = RpcUtil._createURLReader(url, detectedProxy, postData);
            if (pair2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/ls/util/RpcUtil", "createURLReader"));
            }
            return pair2;
        }
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/ls/util/RpcUtil", "createURLReader"));
        }
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static Pair<Integer, BufferedReader> _createURLReader(URL url, @Nullable Proxy proxy, Map<String, String> postData) throws IOException {
        HttpURLConnection httpConnection;
        int responseCode;
        URLConnection connection;
        URLConnection uRLConnection = connection = proxy == null ? url.openConnection() : url.openConnection(proxy);
        if (connection instanceof HttpsURLConnection) {
            if (ourSSLConfigError != null) {
                throw new IOException(ourSSLConfigError);
            }
            HttpsURLConnection secureConn = (HttpsURLConnection)connection;
            secureConn.setSSLSocketFactory(ourSSLSocketFactory);
            secureConn.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String s2, SSLSession sslSession) {
                    return true;
                }
            });
        }
        connection.setReadTimeout(TIMEOUT);
        connection.setConnectTimeout(TIMEOUT);
        connection.setRequestProperty("Accept-Encoding", "gzip");
        String userInfo = url.getUserInfo();
        if (userInfo != null && userInfo.length() > 0) {
            String base64Encoded = new String(Base64Support.encode(userInfo.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            connection.setRequestProperty("Authorization", "Basic " + base64Encoded);
        }
        if (!postData.isEmpty()) {
            connection.setDoOutput(true);
            StringBuilder query = new StringBuilder();
            for (Map.Entry<String, String> entry : postData.entrySet()) {
                if (query.length() > 0) {
                    query.append("&");
                }
                query.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8.name()));
            }
            try (OutputStream os = connection.getOutputStream();){
                os.write(query.toString().getBytes(StandardCharsets.UTF_8));
            }
        }
        if (connection instanceof HttpURLConnection && (responseCode = (httpConnection = (HttpURLConnection)connection).getResponseCode()) != 200) {
            String responseMessage = httpConnection.getResponseMessage();
            Pair<Integer, BufferedReader> pair = new Pair<Integer, BufferedReader>(responseCode, new BufferedReader(new StringReader(responseMessage != null ? responseMessage : "")));
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/ls/util/RpcUtil", "_createURLReader"));
            }
            return pair;
        }
        InputStream is = connection.getInputStream();
        String contentEncoding = connection.getContentEncoding();
        if (contentEncoding != null && "gzip".equalsIgnoreCase(contentEncoding)) {
            is = new GZIPInputStream(is);
        }
        Pair<Integer, BufferedReader> pair = new Pair<Integer, BufferedReader>(200, new BufferedReader(new InputStreamReader(is)));
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/ls/util/RpcUtil", "_createURLReader"));
        }
        return pair;
    }

    public static ObtainUserIdResponse authenticateUser(String loginName, String password) throws IOException, VerificationFailedException {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("username", loginName);
        data.put("password", password);
        return RpcUtil.readFromUrl(new URL(ServiceConfig.getAuthorizationUrl()), data, new ResultProcessor<ObtainUserIdResponse>(){

            @Override
            public ObtainUserIdResponse processResult(int responseCode, String responseContent) {
                if (responseCode == 401) {
                    return ObtainUserIdResponse.error("Wrong username or password");
                }
                if (responseCode != 200) {
                    return ObtainUserIdResponse.error(responseContent);
                }
                return new ObtainUserIdResponse(responseContent, ResponseCode.OK, "", 0L);
            }
        });
    }

    public static <Response extends AbstractResponse> Pair<Response, String> executeRpcToJBA(AbstractRequest<Response> request2) throws IOException, VerificationFailedException {
        return RpcUtil.executeRpc(ServiceConfig.getLicenseServiceUrl(), request2, VerifyingSignatureFactory.JBA);
    }

    @NotNull
    public static <Response extends AbstractFloatingResponse> Pair<Response, String> executeRpcToLicenseServer(String serverUrl, AbstractRequest<Response> request2) throws IOException, VerificationFailedException {
        Pair<Response, String> pair = RpcUtil.executeRpc(serverUrl, request2, VerifyingSignatureFactory.OLD_FLOATING, VerifyingSignatureFactory.X509_CERTIFICATE);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/ls/util/RpcUtil", "executeRpcToLicenseServer"));
        }
        return pair;
    }

    @NotNull
    private static <T extends AbstractResponse> Pair<T, String> executeRpc(String baseUrl, AbstractRequest<T> request2, VerifyingSignatureFactory ... sigFactories) throws VerificationFailedException, IOException {
        request2.setClientVersion(4);
        StringBuilder strUrl = new StringBuilder();
        strUrl.append(baseUrl).append("/rpc/").append(request2.getActionName());
        try {
            List<PropertyDsc> propertyDescriptors = IntrospectionUtil.getProperties(request2.getClass());
            boolean firstParam = true;
            for (PropertyDsc propertyDescriptor : propertyDescriptors) {
                String name = propertyDescriptor.getName();
                Object propValue = propertyDescriptor.getReadMethod().invoke(request2, new Object[0]);
                if (propValue == null) continue;
                String stringPropertyValue = propValue.toString();
                if (firstParam) {
                    strUrl.append("?");
                    firstParam = false;
                } else {
                    strUrl.append("&");
                }
                strUrl.append(name).append("=").append(URLEncoder.encode(stringPropertyValue, StandardCharsets.UTF_8.name()));
            }
        }
        catch (Exception e2) {
            throw new VerificationFailedException("Error creating request", e2);
        }
        URL url = new URL(strUrl.toString());
        String reply = RpcUtil.performRequest(url, Collections.emptyMap());
        if (reply.isEmpty()) {
            throw new IOException("Server response is empty, incomplete or corrupted");
        }
        RpcUtil.verifySignedContent(reply, sigFactories);
        AbstractResponse response = (AbstractResponse)ResponseMarshaller.unmarshall(reply);
        if (response.getSalt() != request2.getSalt()) {
            throw new VerificationFailedException("Salt from server does not equals to salt in request");
        }
        Pair<AbstractResponse, String> pair = new Pair<AbstractResponse, String>(response, reply);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/ls/util/RpcUtil", "executeRpc"));
        }
        return pair;
    }

    static {
        int timeoutBase;
        try {
            timeoutBase = Integer.parseInt(System.getProperty("license.request.timeout", String.valueOf(30000)));
        }
        catch (Throwable ignored) {
            timeoutBase = 30000;
        }
        TIMEOUT = timeoutBase;
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(null, new TrustManager[]{new LicenseServerTrustManager(RpcUtil.initFileTrustManager())}, null);
            ourSSLSocketFactory = ctx.getSocketFactory();
            ourSSLClientContext = ctx;
        }
        catch (GeneralSecurityException e2) {
            ourSSLConfigError = e2;
        }
    }

    private static class LicenseServerTrustManager
    implements X509TrustManager {
        @Nullable
        private final X509TrustManager myCustomManager;

        LicenseServerTrustManager(@Nullable X509TrustManager customManager) {
            this.myCustomManager = customManager;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
            if (certs == null || certs.length == 0) {
                throw new IllegalArgumentException("null or zero-length certificate chain");
            }
            if (authType == null || authType.isEmpty()) {
                throw new IllegalArgumentException("null or zero-length authentication type");
            }
            try {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("X509");
                tmf.init((KeyStore)null);
                for (TrustManager trustManager : tmf.getTrustManagers()) {
                    try {
                        ((X509TrustManager)trustManager).checkServerTrusted(certs, authType);
                        return;
                    }
                    catch (CertificateException certificateException) {
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.myCustomManager != null) {
                try {
                    this.myCustomManager.checkServerTrusted(certs, authType);
                    return;
                }
                catch (CertificateException certificateException) {
                    // empty catch block
                }
            }
            this.customCheckServerTrusted(certs);
        }

        private void customCheckServerTrusted(X509Certificate[] certs) throws CertificateException {
            for (X509Certificate cert : certs) {
                try {
                    cert.verify(JBAPublicKeys.SERVER_CERT_SIGNATURE_PUBLIC_KEY);
                    cert.checkValidity();
                }
                catch (CertificateException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new CertificateException(ex);
                }
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }

    public static interface ResultProcessor<Result> {
        public Result processResult(int var1, String var2);
    }
}

