/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ls.util;

import com.jetbrains.ls.util.RpcUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class ServiceConfig {
    private static final String CONFIG_URL = System.getProperty("jb.service.configuration.url", "https://www.jetbrains.com/config/JetBrainsAccount.xml");
    private static final long DATA_AGE_LIMIT = 120000L;
    private static volatile String ourAuthorizationUrl;
    private static volatile String ourLicenseServiceUrl;
    private static volatile String ourResetPasswordUrl;
    private static volatile String ourAboutUrl;
    private static volatile Boolean ourIsEnabled;
    private static volatile long ourLastLoadedStamp;

    private static void loadConfiguration(String configUrl) throws IOException {
        try {
            String authUrl = null;
            String serviceUrl = null;
            String resetPasswordUrl = null;
            String aboutUrl = null;
            Boolean isEnabled = null;
            String xmlContent = RpcUtil.readFromUrl(new URL(configUrl));
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(xmlContent.getBytes("UTF-8")));
            NodeList config = doc.getElementsByTagName("config");
            if (config.getLength() > 0) {
                NodeList children2 = config.item(0).getChildNodes();
                for (int idx = 0; idx < children2.getLength(); ++idx) {
                    Element elem;
                    Node child = children2.item(idx);
                    if (!(child instanceof Element) || !"url".equals((elem = (Element)child).getTagName())) continue;
                    String type = elem.getAttribute("type");
                    String value2 = elem.getAttribute("value");
                    boolean enabled = "true".equalsIgnoreCase(elem.getAttribute("enabled"));
                    if ("auth".equalsIgnoreCase(type)) {
                        authUrl = value2;
                        isEnabled = isEnabled == null ? enabled : isEnabled != false && enabled;
                        continue;
                    }
                    if ("license".equalsIgnoreCase(type)) {
                        serviceUrl = value2;
                        isEnabled = isEnabled == null ? enabled : isEnabled != false && enabled;
                        continue;
                    }
                    if ("reset_password".equalsIgnoreCase(type)) {
                        resetPasswordUrl = value2;
                        continue;
                    }
                    if (!"about".equalsIgnoreCase(type)) continue;
                    aboutUrl = value2;
                }
            }
            ourAuthorizationUrl = authUrl;
            ourLicenseServiceUrl = serviceUrl;
            ourResetPasswordUrl = resetPasswordUrl;
            ourAboutUrl = aboutUrl;
            ourIsEnabled = isEnabled != null && isEnabled != false;
            ourLastLoadedStamp = System.currentTimeMillis();
        }
        catch (ParserConfigurationException e2) {
            throw new IOException(e2);
        }
        catch (SAXException e3) {
            throw new IOException(e3);
        }
    }

    public static boolean isServiceEnabled() {
        try {
            Boolean isEnabled = ourIsEnabled;
            if (isEnabled == null) {
                ServiceConfig.loadConfiguration(CONFIG_URL);
                isEnabled = ourIsEnabled;
            }
            return Boolean.TRUE.equals(isEnabled);
        }
        catch (IOException ignored) {
            return false;
        }
    }

    @NotNull
    public static String getAuthorizationUrl() throws IOException {
        ServiceConfig.clearCachedDataIfNeeded();
        String url = ourAuthorizationUrl;
        if (url == null) {
            ServiceConfig.loadConfiguration(CONFIG_URL);
            url = ourAuthorizationUrl;
            if (url == null) {
                throw new IOException("Authorization URL not specified");
            }
        }
        String string2 = url;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/ls/util/ServiceConfig", "getAuthorizationUrl"));
        }
        return string2;
    }

    @NotNull
    public static String getLicenseServiceUrl() throws IOException {
        ServiceConfig.clearCachedDataIfNeeded();
        String url = ourLicenseServiceUrl;
        if (url == null) {
            ServiceConfig.loadConfiguration(CONFIG_URL);
            url = ourLicenseServiceUrl;
            if (url == null) {
                throw new IOException("License Service URL not specified");
            }
        }
        String string2 = url;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/ls/util/ServiceConfig", "getLicenseServiceUrl"));
        }
        return string2;
    }

    @NotNull
    public static String getResetPasswordUrl() throws IOException {
        ServiceConfig.clearCachedDataIfNeeded();
        String url = ourResetPasswordUrl;
        if (url == null) {
            ServiceConfig.loadConfiguration(CONFIG_URL);
            url = ourResetPasswordUrl;
            if (url == null) {
                throw new IOException("Reset password URL not specified");
            }
        }
        String string2 = url;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/ls/util/ServiceConfig", "getResetPasswordUrl"));
        }
        return string2;
    }

    public static void reset() {
        ourAuthorizationUrl = null;
        ourLicenseServiceUrl = null;
        ourResetPasswordUrl = null;
    }

    private static void clearCachedDataIfNeeded() {
        if (System.currentTimeMillis() - ourLastLoadedStamp > 120000L) {
            ServiceConfig.reset();
        }
    }
}

