/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ls.util;

import com.jetbrains.ls.FloatingPublicKeys;
import com.jetbrains.ls.JBAPublicKeys;
import com.jetbrains.ls.newLicenses.CertSignaturesDecoder;
import com.jetbrains.ls.util.Base64Support;
import com.jetbrains.ls.util.Pair;
import com.jetbrains.ls.util.Ref;
import com.jetbrains.ls.util.VerificationFailedException;
import java.nio.charset.StandardCharsets;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Locale;

public abstract class VerifyingSignatureFactory {
    public static VerifyingSignatureFactory JBA = new VerifyingSignatureFactory(){

        @Override
        public Pair<byte[], Signature> create(String sigString, String payloadData) throws VerificationFailedException {
            try {
                Signature signature = Signature.getInstance("MD5withRSA");
                signature.initVerify(JBAPublicKeys.SIGNATURE_PUBLIC_KEY);
                return new Pair<byte[], Signature>(VerifyingSignatureFactory.decodeHex(sigString), signature);
            }
            catch (Exception e2) {
                throw new VerificationFailedException(e2);
            }
        }
    };
    public static VerifyingSignatureFactory OLD_FLOATING = new VerifyingSignatureFactory(){

        @Override
        public Pair<byte[], Signature> create(String sigString, String payloadData) throws VerificationFailedException {
            try {
                Signature signature = Signature.getInstance("MD5withRSA");
                signature.initVerify(FloatingPublicKeys.PUBLIC_ENCRYPTION_KEY);
                return new Pair<byte[], Signature>(VerifyingSignatureFactory.decodeHex(sigString), signature);
            }
            catch (Exception e2) {
                throw new VerificationFailedException(e2);
            }
        }
    };
    public static VerifyingSignatureFactory X509_CERTIFICATE = new VerifyingSignatureFactory(){

        @Override
        public Pair<byte[], Signature> create(String sigCommentString, String payloadData) throws VerificationFailedException {
            try {
                String[] parts = sigCommentString.split("-");
                if (parts.length < 3) {
                    throw new VerificationFailedException("Invalid signature format");
                }
                String sigType = parts[0];
                String signatureBase64 = parts[1];
                byte[] certBytes = Base64Support.decode(parts[2].getBytes(StandardCharsets.UTF_8));
                ArrayList<byte[]> intermediate = new ArrayList<byte[]>();
                for (int idx = 3; idx < parts.length; ++idx) {
                    intermediate.add(Base64Support.decode(parts[idx].getBytes(StandardCharsets.UTF_8)));
                }
                Signature signature = Signature.getInstance(sigType);
                Ref certRef = CertSignaturesDecoder.create().createCertificate(certBytes, intermediate, false);
                String serverUid = this.findServerUid(payloadData);
                if (serverUid == null || serverUid.isEmpty()) {
                    throw new VerificationFailedException();
                }
                X509Certificate cert = (X509Certificate)Ref.deref(certRef);
                String expectedCn = "CN=" + serverUid + ".lsrv.jetbrains.com";
                if (!expectedCn.equals(cert.getSubjectX500Principal().getName())) {
                    throw new VerificationFailedException();
                }
                signature.initVerify(cert);
                return new Pair<byte[], Signature>(Base64Support.decode(signatureBase64.getBytes(StandardCharsets.UTF_8)), signature);
            }
            catch (VerificationFailedException e2) {
                throw e2;
            }
            catch (Throwable e3) {
                throw new VerificationFailedException(e3.getMessage());
            }
        }

        private String findServerUid(String xmlContent) {
            if (xmlContent == null || xmlContent.isEmpty()) {
                return null;
            }
            String startTag = "<serveruid>";
            String endTag = "</serveruid>";
            String lowercasedXml = xmlContent.toLowerCase(Locale.US);
            int startIndex = lowercasedXml.indexOf("<serveruid>");
            if (startIndex < 0) {
                return null;
            }
            int endIndex = lowercasedXml.indexOf("</serveruid>", startIndex + "<serveruid>".length());
            if (endIndex < 0) {
                return null;
            }
            return xmlContent.substring(startIndex + "<serveruid>".length(), endIndex);
        }
    };

    private VerifyingSignatureFactory() {
    }

    public abstract Pair<byte[], Signature> create(String var1, String var2) throws VerificationFailedException;

    private static byte[] decodeHex(String sigString) throws VerificationFailedException {
        byte[] sig = new byte[sigString.length() / 2];
        int charIndex = 0;
        for (int i2 = 0; i2 < sig.length; ++i2) {
            int high = VerifyingSignatureFactory.decodeChar(sigString.charAt(charIndex++));
            int low = VerifyingSignatureFactory.decodeChar(sigString.charAt(charIndex++));
            sig[i2] = (byte)((high << 4) + low);
        }
        return sig;
    }

    private static int decodeChar(char c2) throws VerificationFailedException {
        if ('0' <= c2 && c2 <= '9') {
            return c2 - 48;
        }
        if ('A' <= c2 && c2 <= 'F') {
            return c2 - 65 + 10;
        }
        if ('a' <= c2 && c2 <= 'f') {
            return c2 - 97 + 10;
        }
        throw new VerificationFailedException("Unexpected character in signature");
    }
}

