/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.EnvironmentUtil;
import com.jetbrains.resharper.RiderEnvironment;
import com.jetbrains.rider.util.NetUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.NoSuchFileException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/resharper/AssemblyExecutionContext;", "", "assemblyFile", "Ljava/io/File;", "params", "", "", "(Ljava/io/File;[Ljava/lang/String;)V", "arguments", "", "envVars", "", "executablePath", "toGeneralCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "toProcessBuilder", "Ljava/lang/ProcessBuilder;", "Companion", "rider"})
public final class AssemblyExecutionContext {
    private String executablePath;
    private final List<String> arguments;
    private final Map<String, String> envVars;
    private static final boolean profile;
    private static final boolean debugMonoAllowConnect;
    private static final boolean debugMonoSuspend;
    private static final boolean debugMonoDebug;
    private static final String monoArgsEnvVar = "MONO_ARGS";
    public static final Companion Companion;

    @NotNull
    public final ProcessBuilder toProcessBuilder() {
        ProcessBuilder builder = new ProcessBuilder(this.executablePath);
        builder.command().addAll((Collection<String>)this.arguments);
        builder.environment().putAll(this.envVars);
        return builder;
    }

    @NotNull
    public final GeneralCommandLine toGeneralCommandLine() {
        GeneralCommandLine cmd = new GeneralCommandLine();
        cmd.setExePath(this.executablePath);
        cmd.addParameters(this.arguments);
        cmd.getEnvironment().putAll(this.envVars);
        return cmd;
    }

    public AssemblyExecutionContext(@NotNull File assemblyFile, String ... params) {
        Intrinsics.checkParameterIsNotNull((Object)assemblyFile, (String)"assemblyFile");
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        this.executablePath = "";
        AssemblyExecutionContext assemblyExecutionContext = this;
        Object object = new ArrayList();
        assemblyExecutionContext.arguments = object;
        assemblyExecutionContext = this;
        assemblyExecutionContext.envVars = object = (Map)new LinkedHashMap();
        if (!assemblyFile.exists() || !assemblyFile.isFile()) {
            throw (Throwable)new NoSuchFileException(assemblyFile, null, null, 6, null);
        }
        if (!SystemInfo.isWindows) {
            String string2 = RiderEnvironment.INSTANCE.getBundledFile("runtime.sh").getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"RiderEnvironment.getBund\u2026runtime.sh\").absolutePath");
            this.executablePath = string2;
            List monoParams = new ArrayList();
            if (AssemblyExecutionContext.Companion.getDebugMonoDebug()) {
                String debugParamName = "--debug";
                monoParams.add(debugParamName);
                this.arguments.add(debugParamName);
            }
            if (AssemblyExecutionContext.Companion.getDebugMonoAllowConnect()) {
                String suspendString = AssemblyExecutionContext.Companion.getDebugMonoSuspend() ? "y" : "n";
                int freePort = NetUtils.INSTANCE.findFreePort(55555);
                String debuggerAgentParamPrefix = "--debugger-agent=transport=dt_socket,server=y,suspend=" + suspendString + ",address=127.0.0.1";
                this.arguments.add(debuggerAgentParamPrefix + ":" + freePort);
                monoParams.add(debuggerAgentParamPrefix + ":{port}");
            }
            Map<String, String> map2 = this.envVars;
            String string3 = AssemblyExecutionContext.Companion.getMonoArgsEnvVar();
            String string4 = CollectionsKt.joinToString$default((Iterable)monoParams, (CharSequence)";", null, null, (int)0, null, null, (int)62, null);
            map2.put(string3, string4);
            if (AssemblyExecutionContext.Companion.getProfile()) {
                this.arguments.add("--profile=log:sample,calldepth=128,output=" + PathManager.getLogPath() + "/" + assemblyFile.getName() + "-" + UUID.randomUUID() + ".mlpd");
            }
            String string5 = assemblyFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"assemblyFile.absolutePath");
            this.arguments.add(string5);
        } else {
            String string6 = assemblyFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"assemblyFile.absolutePath");
            this.executablePath = string6;
        }
        CollectionsKt.addAll((Collection)this.arguments, (Object[])params);
        Map map3 = EnvironmentUtil.getEnvironmentMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)map3, (String)"EnvironmentUtil.getEnvironmentMap()");
        this.envVars.putAll(map3);
    }

    static {
        Companion = new Companion(null);
        profile = StringsKt.equals((String)String.valueOf(true), (String)System.getProperty("rider.mono.profile"), (boolean)true);
        debugMonoAllowConnect = StringsKt.equals((String)String.valueOf(true), (String)System.getProperty("rider.debug.mono.allowConnect"), (boolean)true);
        debugMonoSuspend = StringsKt.equals((String)String.valueOf(true), (String)System.getProperty("rider.debug.mono.suspend"), (boolean)true);
        debugMonoDebug = StringsKt.equals((String)String.valueOf(true), (String)System.getProperty("rider.debug.mono.debug"), (boolean)true);
        monoArgsEnvVar = monoArgsEnvVar;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/resharper/AssemblyExecutionContext$Companion;", "", "()V", "debugMonoAllowConnect", "", "getDebugMonoAllowConnect", "()Z", "debugMonoDebug", "getDebugMonoDebug", "debugMonoSuspend", "getDebugMonoSuspend", "monoArgsEnvVar", "", "getMonoArgsEnvVar", "()Ljava/lang/String;", "profile", "getProfile", "rider"})
    public static final class Companion {
        private final boolean getProfile() {
            return profile;
        }

        private final boolean getDebugMonoAllowConnect() {
            return debugMonoAllowConnect;
        }

        private final boolean getDebugMonoSuspend() {
            return debugMonoSuspend;
        }

        private final boolean getDebugMonoDebug() {
            return debugMonoDebug;
        }

        private final String getMonoArgsEnvVar() {
            return monoArgsEnvVar;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

