/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper;

import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.ApplicationLoadListener;
import com.intellij.idea.IdeaLogger;
import com.intellij.idea.Main;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.resharper.RiderApplicationLoadListener;
import com.jetbrains.resharper.RiderEnvironment;
import com.jetbrains.resharper.protocol.IProtocolHost;
import com.jetbrains.resharper.protocol.ProtocolKeys;
import com.jetbrains.resharper.protocol.ProtocolManager;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import com.jetbrains.resharper.util.idea.DisposableExKt;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.lifetime.LifetimeExKt;
import java.io.File;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J!\u0010\u000b\u001a\u00020\u00062\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\r\"\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/resharper/RiderApplicationLoadListener;", "Lcom/intellij/ide/ApplicationLoadListener;", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "beforeApplicationLoaded", "", "application", "Lcom/intellij/openapi/application/Application;", "configPath", "", "logCommandAsync", "cmd", "", "([Ljava/lang/String;)V", "rider"})
public class RiderApplicationLoadListener
implements ApplicationLoadListener {
    private final Logger logger;

    @Override
    public void beforeApplicationLoaded(@NotNull Application application, @NotNull String configPath) {
        String message2;
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Intrinsics.checkParameterIsNotNull((Object)configPath, (String)"configPath");
        if (SystemInfo.isLinux && SystemInfo.is32Bit) {
            message2 = "32-bit JVM is not supported. Please run Rider under 64-bit Java Runtime";
            Main.showMessage((String)"Unsupported Java Runtime architecture", (String)message2, (boolean)true);
            System.exit(1);
        }
        message2 = "Installation home directory: " + PathManager.getHomePath();
        System.out.println((Object)message2);
        message2 = "System directory: " + PathManager.getSystemPath();
        System.out.println((Object)message2);
        message2 = "Config directory: " + PathManager.getConfigPath();
        System.out.println((Object)message2);
        message2 = "Log directory: " + PathManager.getLogPath();
        System.out.println((Object)message2);
        RiderEnvironment.INSTANCE.getLogDirectory().mkdirs();
        if (SystemInfo.isLinux) {
            this.logCommandAsync("uname", "-a");
            File[] fileArray = new File("/etc").listFiles(beforeApplicationLoaded.releaseFiles.1.INSTANCE);
            if (fileArray == null) {
                fileArray = (File[])((Object[])new File[0]);
            }
            File[] releaseFiles2 = fileArray;
            Object[] $receiver$iv = releaseFiles2;
            for (int i2 = 0; i2 < $receiver$iv.length; ++i2) {
                Object element$iv = $receiver$iv[i2];
                File it = (File)element$iv;
                try {
                    this.logger.info("File " + it + ":" + "\n" + FileUtil.loadFile((File)it));
                    continue;
                }
                catch (Throwable t2) {
                    this.logger.warn(t2);
                }
            }
        }
        if (SystemInfo.isMac) {
            this.logCommandAsync("sw_vers");
        }
        Lifetime applicationLifetime = DisposableExKt.makeLifetime((Disposable)application);
        ProtocolManager protocolManager = new ProtocolManager(applicationLifetime);
        application.putUserData(ProtocolKeys.Companion.getProtocolManagerKey(), (Object)protocolManager);
        MessageBusConnection connection = application.getMessageBus().connect();
        connection.subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener.Adapter(applicationLifetime, protocolManager){
            final /* synthetic */ Lifetime $applicationLifetime;
            final /* synthetic */ ProtocolManager $protocolManager;

            public void appClosing() {
                LifetimeExKt.assertIsAlive(this.$applicationLifetime);
                Iterable $receiver$iv = this.$protocolManager.getProtocolHosts();
                for (T element$iv : $receiver$iv) {
                    IProtocolHost it = (IProtocolHost)element$iv;
                    this.$protocolManager.requestShutdown(it);
                }
            }
            {
                this.$applicationLifetime = $captured_local_variable$0;
                this.$protocolManager = $captured_local_variable$1;
            }
        });
        application.addApplicationListener((ApplicationListener)new ApplicationAdapter(protocolManager){
            final /* synthetic */ ProtocolManager $protocolManager;

            public void applicationExiting() {
                Iterable $receiver$iv = this.$protocolManager.getProtocolHosts();
                for (T element$iv : $receiver$iv) {
                    IProtocolHost it = (IProtocolHost)element$iv;
                    this.$protocolManager.shutdown(it, false);
                }
            }
            {
                this.$protocolManager = $captured_local_variable$0;
            }
        });
    }

    private final void logCommandAsync(String ... cmd) {
        ApplicationKt.getApplication().executeOnPooledThread(new Runnable(cmd){
            final /* synthetic */ String[] $cmd;

            public final void run() {
                String it;
                String cmdline = ParametersListUtil.join((String[])Arrays.copyOf(this.$cmd, this.$cmd.length));
                Process process2 = new ProcessBuilder(Arrays.copyOf(this.$cmd, this.$cmd.length)).start();
                Logger logger = IdeaLogger.getInstance((String)cmdline);
                CapturingProcessHandler handler2 = new CapturingProcessHandler(process2, Charsets.UTF_8, cmdline);
                ProcessOutput output = handler2.runProcess(5000);
                Iterable $receiver$iv = output.getStderrLines();
                for (T element$iv : $receiver$iv) {
                    it = (String)element$iv;
                    logger.info(cmdline + " stderr: " + it);
                }
                $receiver$iv = output.getStdoutLines();
                for (T element$iv : $receiver$iv) {
                    it = (String)element$iv;
                    logger.info(cmdline + ": " + it);
                }
                if (output.getExitCode() != 0) {
                    logger.info(cmdline + " exited with code " + output.getExitCode());
                }
            }
            {
                this.$cmd = stringArray;
            }
        });
    }

    public RiderApplicationLoadListener() {
        Logger logger;
        RiderApplicationLoadListener riderApplicationLoadListener = this;
        Logger logger2 = Logger.getInstance(RiderApplicationLoadListener.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        riderApplicationLoadListener.logger = logger = logger2;
    }
}

