/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.resharper.AssemblyExecutionContext;
import com.jetbrains.resharper.RiderEnvironment;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.lifetime.LifetimeExKt;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*J\u0016\u0010'\u001a\u00020(2\u0006\u0010+\u001a\u00020!2\u0006\u0010,\u001a\u00020-J\u0006\u0010.\u001a\u00020(J'\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00042\u0012\u00102\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000403\"\u00020\u0004\u00a2\u0006\u0002\u00104J'\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u00042\u0012\u00102\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000403\"\u00020\u0004\u00a2\u0006\u0002\u00108J\f\u00109\u001a\b\u0012\u0004\u0012\u00020!0:J\u000e\u0010;\u001a\u00020\u00152\u0006\u0010<\u001a\u00020\u0004J\u000e\u0010=\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020!R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u001b\u0010\r\u001a\u00020\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\r\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0006R\u001b\u0010\u0014\u001a\u00020\u00158FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0011\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0019\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0006R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0017R:\u0010\u001f\u001a.\u0012\f\u0012\n \"*\u0004\u0018\u00010!0! \"*\u0015\u0012\f\u0012\n \"*\u0004\u0018\u00010!0!0$\u00a2\u0006\u0002\b#0 \u00a2\u0006\u0002\b#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010%\u001a.\u0012\f\u0012\n \"*\u0004\u0018\u00010!0! \"*\u0015\u0012\f\u0012\n \"*\u0004\u0018\u00010!0!0$\u00a2\u0006\u0002\b#0 \u00a2\u0006\u0002\b#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/jetbrains/resharper/RiderEnvironment;", "", "()V", "customHostBinDirectory", "", "getCustomHostBinDirectory", "()Ljava/lang/String;", "setCustomHostBinDirectory", "(Ljava/lang/String;)V", "hostBinEnvironmentVariable", "getHostBinEnvironmentVariable", "hostExecutableName", "getHostExecutableName", "is64BitWindows", "", "()Z", "is64BitWindows$delegate", "Lkotlin/Lazy;", "logBackendConf", "getLogBackendConf", "logDirectory", "Ljava/io/File;", "getLogDirectory", "()Ljava/io/File;", "logDirectory$delegate", "logFrontendConf", "getLogFrontendConf", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "reSharperHostExecutable", "getReSharperHostExecutable", "riderHostProcesses", "", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "riderProcesses", "traceEnvVar", "addRiderProcess", "", "processHandler", "Lcom/intellij/execution/process/BaseOSProcessHandler;", "pid", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "applyEnvTraceCategories", "createProcessBuilderForAssembly", "Ljava/lang/ProcessBuilder;", "assemblyFullPath", "params", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/ProcessBuilder;", "createRunCmdForBundledAssembly", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "assemblyName", "(Ljava/lang/String;[Ljava/lang/String;)Lcom/intellij/execution/configurations/GeneralCommandLine;", "getAllHostPids", "", "getBundledFile", "fileName", "isRiderProcess", "rider"})
public final class RiderEnvironment {
    private static final String traceEnvVar = "RESHARPER_TRACE";
    private static final Logger logger;
    private static final Set<Integer> riderProcesses;
    private static final Set<Integer> riderHostProcesses;
    @NotNull
    private static final String hostExecutableName;
    @NotNull
    private static final String hostBinEnvironmentVariable = "RESHARPER_HOST_BIN";
    @Nullable
    private static String customHostBinDirectory;
    @NotNull
    private static final Lazy logDirectory$delegate;
    @NotNull
    private static final Lazy is64BitWindows$delegate;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;
    public static final RiderEnvironment INSTANCE;

    @NotNull
    public final String getHostExecutableName() {
        return hostExecutableName;
    }

    public final void applyEnvTraceCategories() {
        block1: {
            Object object = System.getenv(traceEnvVar);
            if (object == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (char[])new char[]{',', ' ', ':', ';'}, (boolean)false, (int)0, (int)6, null)) == null) break block1;
            Object object2 = object;
            List it = (List)object2;
            Iterable $receiver$iv = it;
            for (Object element$iv : $receiver$iv) {
                String category = (String)element$iv;
                org.apache.log4j.Logger logger = LogManager.getLogger((String)category);
                if (logger == null) continue;
                logger.setLevel(Level.TRACE);
            }
        }
    }

    @NotNull
    public final String getHostBinEnvironmentVariable() {
        return hostBinEnvironmentVariable;
    }

    @Nullable
    public final String getCustomHostBinDirectory() {
        return customHostBinDirectory;
    }

    public final void setCustomHostBinDirectory(@Nullable String string2) {
        customHostBinDirectory = string2;
    }

    @NotNull
    public final File getBundledFile(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        if (customHostBinDirectory != null) {
            File exe = new File(customHostBinDirectory, fileName);
            if (!exe.isFile()) {
                throw (Throwable)new RuntimeException(fileName + " is not found at " + customHostBinDirectory + " (explicitly specified host directory)");
            }
            return exe;
        }
        String bin = System.getenv(hostBinEnvironmentVariable);
        if (bin != null) {
            logger.info("%" + hostBinEnvironmentVariable + "% = " + bin);
            File envExe = new File(bin, fileName);
            if (envExe.isFile()) {
                logger.info(fileName + " found at " + bin + " (from %" + hostBinEnvironmentVariable + "%)");
                return envExe;
            }
        } else {
            logger.info("%" + hostBinEnvironmentVariable + "% is not set");
        }
        File distDir = new File(PathManager.getLibPath(), "ReSharperHost");
        File distExe = new File(distDir, fileName);
        if (distExe.isFile()) {
            logger.info(fileName + " found at " + distExe + " (bundled to IDEA)");
            return distExe;
        }
        throw (Throwable)new IllegalStateException("No '" + fileName + "' found in locations: '%RESHARPER_HOST_BIN%'(" + bin + "), '" + distDir + "'");
    }

    @NotNull
    public final ProcessBuilder createProcessBuilderForAssembly(@NotNull String assemblyFullPath, String ... params) {
        Intrinsics.checkParameterIsNotNull((Object)assemblyFullPath, (String)"assemblyFullPath");
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        File assemblyFile = new File(assemblyFullPath);
        return new AssemblyExecutionContext(assemblyFile, Arrays.copyOf(params, params.length)).toProcessBuilder();
    }

    @NotNull
    public final GeneralCommandLine createRunCmdForBundledAssembly(@NotNull String assemblyName, String ... params) {
        Intrinsics.checkParameterIsNotNull((Object)assemblyName, (String)"assemblyName");
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        File assemblyFile = this.getBundledFile(assemblyName);
        return new AssemblyExecutionContext(assemblyFile, Arrays.copyOf(params, params.length)).toGeneralCommandLine();
    }

    @NotNull
    public final File getReSharperHostExecutable() {
        return this.getBundledFile(hostExecutableName);
    }

    @NotNull
    public final File getLogDirectory() {
        Lazy lazy = logDirectory$delegate;
        RiderEnvironment riderEnvironment = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (File)lazy.getValue();
    }

    @NotNull
    public final String getLogFrontendConf() {
        return PathManager.getBinPath() + File.separator + "log.xml";
    }

    @NotNull
    public final String getLogBackendConf() {
        return PathManager.getBinPath() + File.separator + "backend-log.xml";
    }

    public final boolean is64BitWindows() {
        Lazy lazy = is64BitWindows$delegate;
        RiderEnvironment riderEnvironment = this;
        KProperty kProperty = $$delegatedProperties[1];
        return (Boolean)lazy.getValue();
    }

    public final void addRiderProcess(@NotNull BaseOSProcessHandler processHandler2) {
        Intrinsics.checkParameterIsNotNull((Object)processHandler2, (String)"processHandler");
        Process process2 = processHandler2.getProcess();
        int pid = OSProcessUtil.getProcessID(process2);
        CharSequence charSequence = processHandler2.getCommandLine();
        String string2 = INSTANCE.getReSharperHostExecutable().getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"RiderEnvironment.reSharperHostExecutable.path");
        boolean isHost = StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string2, (boolean)false, (int)2, null);
        if (isHost) {
            riderHostProcesses.add(pid);
        }
        riderProcesses.add(pid);
        processHandler2.addProcessListener((ProcessListener)new ProcessAdapter(pid){
            final /* synthetic */ int $pid;

            public void processTerminated(@Nullable ProcessEvent event) {
                RiderEnvironment.access$getRiderProcesses$p(RiderEnvironment.INSTANCE).remove(this.$pid);
                if (RiderEnvironment.access$getRiderHostProcesses$p(RiderEnvironment.INSTANCE).contains(this.$pid)) {
                    RiderEnvironment.access$getRiderHostProcesses$p(RiderEnvironment.INSTANCE).remove(this.$pid);
                }
            }
            {
                this.$pid = $captured_local_variable$0;
            }
        });
    }

    public final void addRiderProcess(int pid, @NotNull Lifetime lifetime) {
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        riderProcesses.add(pid);
        LifetimeExKt.plusAssign(lifetime, (Function0<Unit>)((Function0)new Function0<Unit>(pid){
            final /* synthetic */ int $pid;

            public final void invoke() {
                RiderEnvironment.access$getRiderProcesses$p(RiderEnvironment.INSTANCE).remove(this.$pid);
            }
            {
                this.$pid = n2;
                super(0);
            }
        }));
    }

    public final boolean isRiderProcess(int pid) {
        return riderProcesses.contains(pid);
    }

    @NotNull
    public final List<Integer> getAllHostPids() {
        return CollectionsKt.toList((Iterable)riderHostProcesses);
    }

    private RiderEnvironment() {
        INSTANCE = this;
        Logger logger = Logger.getInstance(RiderEnvironment.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        RiderEnvironment.logger = logger;
        riderProcesses = ContainerUtil.newConcurrentSet();
        riderHostProcesses = ContainerUtil.newConcurrentSet();
        hostExecutableName = SystemInfo.isUnix ? "JetBrains.ReSharper.Host.exe" : (SystemInfo.is32Bit ? "JetBrains.ReSharper.Host32.exe" : "JetBrains.ReSharper.Host64.exe");
        this.applyEnvTraceCategories();
        hostBinEnvironmentVariable = hostBinEnvironmentVariable;
        logDirectory$delegate = LazyKt.lazy((Function0)logDirectory.2.INSTANCE);
        is64BitWindows$delegate = LazyKt.lazy((Function0)is64BitWindows.2.INSTANCE);
    }

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(RiderEnvironment.class), "logDirectory", "getLogDirectory()Ljava/io/File;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(RiderEnvironment.class), "is64BitWindows", "is64BitWindows()Z"))};
        new RiderEnvironment();
    }

    @NotNull
    public static final /* synthetic */ Set access$getRiderProcesses$p(RiderEnvironment $this) {
        RiderEnvironment riderEnvironment = $this;
        return riderProcesses;
    }

    @NotNull
    public static final /* synthetic */ Set access$getRiderHostProcesses$p(RiderEnvironment $this) {
        RiderEnvironment riderEnvironment = $this;
        return riderHostProcesses;
    }
}

