/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.Services.popups.nova.layouter;

import com.jetbrains.resharper.Services.popups.nova.layouter.Anchoring;
import com.jetbrains.resharper.Services.popups.nova.layouter.Anchoring2D;
import com.jetbrains.resharper.Services.popups.nova.layouter.AnchoringRectKt;
import com.jetbrains.resharper.Services.popups.nova.layouter.LayoutResult;
import com.jetbrains.resharper.Services.popups.nova.layouter.RectangleDocker$WhenMappings;
import com.jetbrains.resharper.Services.popups.nova.layouter.RectangleUtilsKt;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\bH\u0002J\u0018\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\bH\u0002J\u0018\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\bH\u0002J\u0018\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J \u0010#\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\bH\u0002J\b\u0010&\u001a\u0004\u0018\u00010'R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/jetbrains/resharper/Services/popups/nova/layouter/RectangleDocker;", "", "anchor", "Ljava/awt/Rectangle;", "size", "Ljava/awt/Dimension;", "myAllowedDispositions", "", "Lcom/jetbrains/resharper/Services/popups/nova/layouter/Anchoring2D;", "myScreen", "myPadding", "", "(Ljava/awt/Rectangle;Ljava/awt/Dimension;Ljava/util/List;Ljava/awt/Rectangle;I)V", "myAnchorRect", "myCandidateDisposition", "myCandidateRatio", "myCandidateRect", "myCandidateRoom", "mySize", "CenterHorizontally", "", "center", "Ljava/awt/Point;", "rect", "CenterVertically", "CheckCandidate", "", "rectCandidate", "rectRoom", "disposition", "attachRect", "anchorRect", "attachRectInside", "anchorRectPadded", "attachRectMiddle", "attachRectOutside", "mangledDisposition", "originalDisposition", "layout", "Lcom/jetbrains/resharper/Services/popups/nova/layouter/LayoutResult;", "rider"})
public final class RectangleDocker {
    private final Rectangle myAnchorRect;
    private final Dimension mySize;
    private Rectangle myCandidateRect;
    private Rectangle myCandidateRoom;
    private Anchoring2D myCandidateDisposition;
    private int myCandidateRatio;
    private final List<Anchoring2D> myAllowedDispositions;
    private final Rectangle myScreen;
    private final int myPadding;

    @Nullable
    public final LayoutResult layout() {
        LayoutResult layoutResult;
        for (Anchoring2D disposition : this.myAllowedDispositions) {
            if (this.attachRect(this.myAnchorRect, disposition)) break;
        }
        if (this.myCandidateDisposition == null) {
            layoutResult = null;
        } else {
            Anchoring2D anchoring2D = this.myCandidateDisposition;
            if (anchoring2D == null) {
                Intrinsics.throwNpe();
            }
            layoutResult = new LayoutResult(this.myCandidateRoom, this.myCandidateRect, this.myAnchorRect, anchoring2D);
        }
        return layoutResult;
    }

    private final boolean attachRect(Rectangle anchorRect, Anchoring2D disposition) {
        Rectangle visibleAnchorRect;
        if (AnchoringRectKt.isInside(disposition)) {
            Rectangle visibleAnchorRect2;
            if (Intrinsics.areEqual((Object)disposition, (Object)new Anchoring2D(Anchoring.MiddleInside, Anchoring.MiddleInside))) {
                return this.attachRectMiddle(disposition, anchorRect);
            }
            Rectangle a = RectangleUtilsKt.inflate(anchorRect, new Dimension(-this.myPadding, -this.myPadding));
            Rectangle rectangle = visibleAnchorRect2 = a.intersection(this.myScreen);
            Intrinsics.checkExpressionValueIsNotNull((Object)rectangle, (String)"visibleAnchorRect");
            return this.attachRectInside(rectangle, disposition);
        }
        Rectangle a = RectangleUtilsKt.inflate(anchorRect, new Dimension(this.myPadding, this.myPadding));
        Rectangle rectangle = visibleAnchorRect = a.intersection(this.myScreen);
        Intrinsics.checkExpressionValueIsNotNull((Object)rectangle, (String)"visibleAnchorRect");
        return this.attachRectOutside(rectangle, disposition, disposition);
    }

    private final boolean attachRectOutside(Rectangle anchorRectPadded, Anchoring2D mangledDisposition, Anchoring2D originalDisposition) {
        Rectangle rectCandidate = new Rectangle(this.mySize);
        Rectangle rectRoom = new Rectangle(this.myScreen);
        switch (RectangleDocker$WhenMappings.$EnumSwitchMapping$0[mangledDisposition.getHorizontal().ordinal()]) {
            case 1: {
                rectCandidate.x = RectangleUtilsKt.getLeft(anchorRectPadded) - this.mySize.width;
                RectangleUtilsKt.setRight(rectRoom, RectangleUtilsKt.getLeft(anchorRectPadded));
                break;
            }
            case 2: {
                rectCandidate.x = RectangleUtilsKt.getLeft(anchorRectPadded);
                RectangleUtilsKt.setLeft(rectRoom, RectangleUtilsKt.getLeft(anchorRectPadded));
                break;
            }
            case 3: {
                this.CenterHorizontally(RectangleUtilsKt.getCenter(anchorRectPadded), rectCandidate);
                break;
            }
            case 4: {
                rectCandidate.x = RectangleUtilsKt.getRight(anchorRectPadded) - this.mySize.width;
                RectangleUtilsKt.setRight(rectRoom, RectangleUtilsKt.getRight(anchorRectPadded));
                break;
            }
            case 5: {
                rectCandidate.x = RectangleUtilsKt.getRight(anchorRectPadded);
                RectangleUtilsKt.setLeft(rectRoom, RectangleUtilsKt.getRight(anchorRectPadded));
            }
        }
        switch (RectangleDocker$WhenMappings.$EnumSwitchMapping$1[mangledDisposition.getVertical().ordinal()]) {
            case 1: {
                rectCandidate.y = RectangleUtilsKt.getTop(anchorRectPadded) - this.mySize.height;
                RectangleUtilsKt.setBottom(rectRoom, RectangleUtilsKt.getTop(anchorRectPadded));
                break;
            }
            case 2: {
                rectCandidate.y = RectangleUtilsKt.getTop(anchorRectPadded);
                RectangleUtilsKt.setTop(rectRoom, RectangleUtilsKt.getTop(anchorRectPadded));
                break;
            }
            case 3: {
                this.CenterVertically(RectangleUtilsKt.getCenter(anchorRectPadded), rectCandidate);
                break;
            }
            case 4: {
                rectCandidate.y = RectangleUtilsKt.getBottom(anchorRectPadded) - this.mySize.height;
                RectangleUtilsKt.setBottom(rectRoom, RectangleUtilsKt.getBottom(anchorRectPadded));
                break;
            }
            case 5: {
                rectCandidate.y = RectangleUtilsKt.getBottom(anchorRectPadded);
                RectangleUtilsKt.setTop(rectCandidate, RectangleUtilsKt.getBottom(anchorRectPadded));
            }
        }
        Rectangle rectangle = rectCandidate.intersection(this.myScreen);
        Intrinsics.checkExpressionValueIsNotNull((Object)rectangle, (String)"rectCandidate.intersection(myScreen)");
        rectCandidate = rectangle;
        return this.CheckCandidate(rectCandidate, rectRoom, originalDisposition);
    }

    private final boolean attachRectInside(Rectangle anchorRectPadded, Anchoring2D disposition) {
        Anchoring v2;
        Anchoring h2;
        Anchoring2D anchoring2D = disposition;
        Anchoring anchoring = anchoring2D.component1();
        Anchoring anchoring2 = anchoring2D.component2();
        anchoring2D = null;
        switch (RectangleDocker$WhenMappings.$EnumSwitchMapping$2[disposition.getHorizontal().ordinal()]) {
            case 1: {
                h2 = Anchoring.FarOutside;
                anchorRectPadded.x -= anchorRectPadded.width;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                h2 = Anchoring.NearOutside;
                anchorRectPadded.x += anchorRectPadded.width;
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Expect only *Inside disposition here: disposition = " + (Object)((Object)disposition.getHorizontal()) + ".");
            }
        }
        switch (RectangleDocker$WhenMappings.$EnumSwitchMapping$3[disposition.getVertical().ordinal()]) {
            case 1: {
                v2 = Anchoring.FarOutside;
                anchorRectPadded.y -= anchorRectPadded.height;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                v2 = Anchoring.NearOutside;
                anchorRectPadded.y += anchorRectPadded.height;
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Expect only *Inside disposition here: disposition = " + (Object)((Object)disposition.getVertical()) + ".");
            }
        }
        return this.attachRectOutside(anchorRectPadded, new Anchoring2D(h2, v2), disposition);
    }

    private final boolean attachRectMiddle(Anchoring2D disposition, Rectangle anchorRect) {
        Rectangle rectCandidate = new Rectangle(this.mySize);
        Point anchorRectCenter = RectangleUtilsKt.getCenter(anchorRect);
        this.CenterHorizontally(anchorRectCenter, rectCandidate);
        this.CenterVertically(anchorRectCenter, rectCandidate);
        return this.CheckCandidate(rectCandidate, this.myScreen, disposition);
    }

    private final boolean CheckCandidate(Rectangle rectCandidate, Rectangle rectRoom, Anchoring2D disposition) {
        if (rectCandidate.width > this.mySize.width) {
            throw (Throwable)new IllegalStateException("The candidate is wider than needed.");
        }
        if (rectCandidate.height > this.mySize.height) {
            throw (Throwable)new IllegalStateException("The candidate is higher than needed.");
        }
        if (rectCandidate.width == this.mySize.width && rectCandidate.height == this.mySize.height) {
            this.myCandidateRect = rectCandidate;
            this.myCandidateRoom = rectRoom;
            this.myCandidateDisposition = disposition;
            this.myCandidateRatio = 0;
            return true;
        }
        int nRatioHorz = this.mySize.width - rectCandidate.width;
        int nRatioVert = this.mySize.height - rectCandidate.height;
        int nRatio = nRatioHorz * nRatioHorz + nRatioVert * nRatioVert;
        if (nRatio < this.myCandidateRatio) {
            this.myCandidateRect = rectCandidate;
            this.myCandidateRoom = rectRoom;
            this.myCandidateDisposition = disposition;
            this.myCandidateRatio = nRatio;
        }
        return false;
    }

    private final void CenterHorizontally(Point center, Rectangle rect) {
        rect.x = center.x - rect.width / 2;
        if (RectangleUtilsKt.getLeft(rect) < RectangleUtilsKt.getLeft(this.myScreen)) {
            rect.x += RectangleUtilsKt.getLeft(this.myScreen) - RectangleUtilsKt.getLeft(rect);
        }
        if (RectangleUtilsKt.getRight(rect) > RectangleUtilsKt.getRight(this.myScreen)) {
            rect.x -= RectangleUtilsKt.getRight(rect) - RectangleUtilsKt.getRight(this.myScreen);
        }
    }

    private final void CenterVertically(Point center, Rectangle rect) {
        rect.y = center.y - rect.height / 2;
        if (RectangleUtilsKt.getTop(rect) < RectangleUtilsKt.getTop(this.myScreen)) {
            rect.y += RectangleUtilsKt.getTop(this.myScreen) - RectangleUtilsKt.getTop(rect);
        }
        if (RectangleUtilsKt.getBottom(rect) > RectangleUtilsKt.getBottom(this.myScreen)) {
            rect.y -= RectangleUtilsKt.getBottom(rect) - RectangleUtilsKt.getBottom(this.myScreen);
        }
    }

    public RectangleDocker(@NotNull Rectangle anchor, @NotNull Dimension size, @NotNull List<Anchoring2D> myAllowedDispositions, @NotNull Rectangle myScreen, int myPadding) {
        Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
        Intrinsics.checkParameterIsNotNull((Object)size, (String)"size");
        Intrinsics.checkParameterIsNotNull(myAllowedDispositions, (String)"myAllowedDispositions");
        Intrinsics.checkParameterIsNotNull((Object)myScreen, (String)"myScreen");
        this.myAllowedDispositions = myAllowedDispositions;
        this.myScreen = myScreen;
        this.myPadding = myPadding;
        this.myAnchorRect = RectangleUtilsKt.smartClip(anchor, this.myScreen);
        this.mySize = new Dimension(Math.min(this.myScreen.width, size.width), Math.min(this.myScreen.height, size.height));
        this.myCandidateRect = new Rectangle();
        this.myCandidateRoom = new Rectangle();
        this.myCandidateRatio = Integer.MAX_VALUE;
    }
}

