/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.Services.popups.nova.layouter;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\u001a&\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0000\u001a\u00020\u0001\u001a&\u0010\f\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0000\u001a\u00020\u0001\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\u0002\u001a\u0012\u0010\u000f\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u001a\u0010\u000f\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0001\u001a\u0012\u0010\u0014\u001a\u00020\u0015*\u00020\u00022\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0012\u0010\u0016\u001a\u00020\u0015*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u0012\u0010\u0017\u001a\u00020\u0015*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0001\u001a\u0012\u0010\u0018\u001a\u00020\u0015*\u00020\u00022\u0006\u0010\t\u001a\u00020\u0001\u001a\u0012\u0010\u0019\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\"\u0015\u0010\u0007\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0004\"\u0015\u0010\t\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0004\u00a8\u0006\u001b"}, d2={"bottom", "", "Ljava/awt/Rectangle;", "getBottom", "(Ljava/awt/Rectangle;)I", "left", "getLeft", "right", "getRight", "top", "getTop", "rectangleFromLTRB", "rectangleFromLTRBNonNegative", "getCenter", "Ljava/awt/Point;", "inflate", "size", "Ljava/awt/Dimension;", "w", "h", "setBottom", "", "setLeft", "setRight", "setTop", "smartClip", "bounds", "rider"})
public final class RectangleUtilsKt {
    public static final int getLeft(@NotNull Rectangle $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.x;
    }

    public static final int getRight(@NotNull Rectangle $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.x + $receiver.width;
    }

    public static final int getTop(@NotNull Rectangle $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.y;
    }

    public static final int getBottom(@NotNull Rectangle $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.y + $receiver.height;
    }

    @NotNull
    public static final Rectangle inflate(@NotNull Rectangle $receiver, @NotNull Dimension size) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)size, (String)"size");
        return RectangleUtilsKt.inflate($receiver, size.width, size.height);
    }

    @NotNull
    public static final Rectangle inflate(@NotNull Rectangle $receiver, int w2, int h2) {
        Rectangle rectangle;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Rectangle $receiver2 = rectangle = new Rectangle($receiver);
        $receiver2.x -= w2;
        $receiver2.y -= h2;
        $receiver2.width += 2 * w2;
        $receiver2.height += 2 * h2;
        return rectangle;
    }

    public static final void setRight(@NotNull Rectangle $receiver, int right) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        $receiver.width += right - RectangleUtilsKt.getRight($receiver);
    }

    public static final void setLeft(@NotNull Rectangle $receiver, int left) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        $receiver.width -= left - RectangleUtilsKt.getLeft($receiver);
        $receiver.x = left;
    }

    public static final void setBottom(@NotNull Rectangle $receiver, int bottom) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        $receiver.height += bottom - RectangleUtilsKt.getBottom($receiver);
    }

    public static final void setTop(@NotNull Rectangle $receiver, int top) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        $receiver.height -= top - RectangleUtilsKt.getTop($receiver);
        $receiver.y = top;
    }

    @NotNull
    public static final Point getCenter(@NotNull Rectangle $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return new Point((RectangleUtilsKt.getLeft($receiver) + RectangleUtilsKt.getRight($receiver)) / 2, (RectangleUtilsKt.getTop($receiver) + RectangleUtilsKt.getBottom($receiver)) / 2);
    }

    @NotNull
    public static final Rectangle rectangleFromLTRB(int left, int top, int right, int bottom) {
        return new Rectangle(left, top, right - left, bottom - top);
    }

    @NotNull
    public static final Rectangle rectangleFromLTRBNonNegative(int left, int top, int right, int bottom) {
        int l2 = left;
        int r2 = right;
        int t2 = top;
        int b2 = bottom;
        if (l2 > r2) {
            r2 = l2 = (l2 + r2) / 2;
        }
        if (t2 > b2) {
            b2 = t2 = (t2 + b2) / 2;
        }
        return RectangleUtilsKt.rectangleFromLTRB(l2, t2, r2, b2);
    }

    @NotNull
    public static final Rectangle smartClip(@NotNull Rectangle $receiver, @NotNull Rectangle bounds) {
        int t2;
        int r2;
        int l2;
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)bounds, (String)"bounds");
        boolean bl2 = bl = !$receiver.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        boolean bl3 = bl = !bounds.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string3));
        }
        int n2 = RectangleUtilsKt.getLeft($receiver) > RectangleUtilsKt.getLeft(bounds) ? (RectangleUtilsKt.getLeft($receiver) < RectangleUtilsKt.getRight(bounds) ? RectangleUtilsKt.getLeft($receiver) : RectangleUtilsKt.getRight(bounds)) : (l2 = RectangleUtilsKt.getLeft(bounds));
        int n3 = RectangleUtilsKt.getRight($receiver) > RectangleUtilsKt.getLeft(bounds) ? (RectangleUtilsKt.getRight($receiver) < RectangleUtilsKt.getRight(bounds) ? RectangleUtilsKt.getRight($receiver) : RectangleUtilsKt.getRight(bounds)) : (r2 = RectangleUtilsKt.getLeft(bounds));
        int n4 = RectangleUtilsKt.getTop($receiver) > RectangleUtilsKt.getTop(bounds) ? (RectangleUtilsKt.getTop($receiver) < RectangleUtilsKt.getBottom(bounds) ? RectangleUtilsKt.getTop($receiver) : RectangleUtilsKt.getBottom(bounds)) : (t2 = RectangleUtilsKt.getTop(bounds));
        int b2 = RectangleUtilsKt.getBottom($receiver) > RectangleUtilsKt.getTop(bounds) ? (RectangleUtilsKt.getBottom($receiver) < RectangleUtilsKt.getBottom(bounds) ? RectangleUtilsKt.getBottom($receiver) : RectangleUtilsKt.getBottom(bounds)) : RectangleUtilsKt.getTop(bounds);
        return RectangleUtilsKt.rectangleFromLTRBNonNegative(l2, t2, r2, b2);
    }
}

