/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.actions.base;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.jetbrains.resharper.actions.base.RiderBackendActionExecuteTrait;
import com.jetbrains.resharper.actions.base.RiderEditorActionHandlerUpdateTrait;
import com.jetbrains.resharper.actions.base.RiderFrontendActionUpdateTrait;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u00192\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001\u0019B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bJ$\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J$\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014J$\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014J\"\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0004R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/resharper/actions/base/RiderEditorActionHandler;", "Lcom/jetbrains/resharper/actions/base/RiderBackendActionExecuteTrait;", "Lcom/jetbrains/resharper/actions/base/RiderEditorActionHandlerUpdateTrait;", "Lcom/jetbrains/resharper/actions/base/RiderFrontendActionUpdateTrait;", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "reSharperId", "", "baseHandler", "(Ljava/lang/String;Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "getBaseHandler", "()Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "getReSharperId", "()Ljava/lang/String;", "backendIsEnabledForCaret", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "doExecute", "", "executeOnFrontend", "isEnabledForCaret", "Companion", "rider"})
public abstract class RiderEditorActionHandler
extends EditorActionHandler
implements RiderBackendActionExecuteTrait,
RiderEditorActionHandlerUpdateTrait,
RiderFrontendActionUpdateTrait {
    @NotNull
    private final String reSharperId;
    @NotNull
    private final EditorActionHandler baseHandler;
    @NotNull
    private static final Logger logger;
    public static final Companion Companion;

    protected final boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, @Nullable DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)caret, (String)"caret");
        boolean res2 = this.backendIsEnabledForCaret(editor, caret, dataContext);
        return res2 || this.baseHandler.isEnabled(editor, caret, dataContext);
    }

    protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, @Nullable DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        boolean ret = this.backendIsEnabledForCaret(editor, caret, dataContext);
        if (ret) {
            Companion.getLogger().info("Executing ReSharper editor handler '" + this.reSharperId + "'");
            this.backendActionPerformed(this.reSharperId, dataContext);
        } else {
            Companion.getLogger().info("Executing IDEA editor base handler '" + this.reSharperId + "'");
            this.executeOnFrontend(editor, caret, dataContext);
        }
    }

    protected void executeOnFrontend(@NotNull Editor editor, @Nullable Caret caret, @Nullable DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        this.baseHandler.execute(editor, caret, dataContext);
    }

    @Override
    public boolean backendIsEnabledForCaret(@NotNull Editor editor, @Nullable Caret caret, @Nullable DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        return RiderEditorActionHandlerUpdateTrait.DefaultImpls.backendIsEnabledForCaret(this, editor, caret, dataContext) && RiderFrontendActionUpdateTrait.DefaultImpls.frontendUpdate((RiderFrontendActionUpdateTrait)this, this.reSharperId, dataContext);
    }

    @NotNull
    public final String getReSharperId() {
        return this.reSharperId;
    }

    @NotNull
    public final EditorActionHandler getBaseHandler() {
        return this.baseHandler;
    }

    public RiderEditorActionHandler(@NotNull String reSharperId, @NotNull EditorActionHandler baseHandler) {
        Intrinsics.checkParameterIsNotNull((Object)reSharperId, (String)"reSharperId");
        Intrinsics.checkParameterIsNotNull((Object)baseHandler, (String)"baseHandler");
        this.reSharperId = reSharperId;
        this.baseHandler = baseHandler;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(RiderEditorActionHandler.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        RiderEditorActionHandler.logger = logger;
    }

    @Override
    public void backendActionPerformed(@NotNull String reSharperId, @Nullable DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)reSharperId, (String)"reSharperId");
        RiderBackendActionExecuteTrait.DefaultImpls.backendActionPerformed(this, reSharperId, dataContext);
    }

    @Override
    public boolean frontendUpdate(@NotNull String actionId, @Nullable DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)actionId, (String)"actionId");
        return RiderFrontendActionUpdateTrait.DefaultImpls.frontendUpdate((RiderFrontendActionUpdateTrait)this, actionId, dataContext);
    }

    @Override
    public void frontendUpdate(@NotNull String actionId, @NotNull AnActionEvent actionEvent) {
        Intrinsics.checkParameterIsNotNull((Object)actionId, (String)"actionId");
        Intrinsics.checkParameterIsNotNull((Object)actionEvent, (String)"actionEvent");
        RiderFrontendActionUpdateTrait.DefaultImpls.frontendUpdate((RiderFrontendActionUpdateTrait)this, actionId, actionEvent);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/resharper/actions/base/RiderEditorActionHandler$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "rider"})
    public static final class Companion {
        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

