/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.actions.impl.cleanup;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.refactoring.util.RadioUpDownListener;
import com.intellij.ui.ListCellRendererWrapper;
import com.jetbrains.resharper.actions.impl.cleanup.RiderCodeCleanupDialog$WhenMappings;
import com.jetbrains.resharper.actions.impl.cleanup.RiderCodeCleanupDialogWrapper;
import com.jetbrains.resharper.protocol.IPermittedModalities;
import com.jetbrains.rider.model.CleanupProfileModel;
import com.jetbrains.rider.model.CodeCleanupScope;
import com.jetbrains.rider.model.CodeCleanupScopeOverrideType;
import com.jetbrains.rider.model.CodeCleanupScopeType;
import com.jetbrains.rider.model.CodeCleanupToolModel;
import java.awt.Component;
import java.awt.Window;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006J\u001b\u0010\u000f\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u001aJ\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0014R*\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u00068F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/resharper/actions/impl/cleanup/RiderCodeCleanupDialog;", "Lcom/jetbrains/resharper/actions/impl/cleanup/RiderCodeCleanupDialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "value", "Lcom/jetbrains/rider/model/CodeCleanupToolModel;", "viewModel", "getViewModel", "()Lcom/jetbrains/rider/model/CodeCleanupToolModel;", "setViewModel", "(Lcom/jetbrains/rider/model/CodeCleanupToolModel;)V", "Bind", "", "model", "BindProfilesList", "profiles", "", "Lcom/jetbrains/rider/model/CleanupProfileModel;", "([Lcom/jetbrains/rider/model/CleanupProfileModel;)V", "BindScope", "cleanupScope", "Lcom/jetbrains/rider/model/CodeCleanupScope;", "GetSelectedProfileName", "", "GetSelectedScopeOverride", "Lcom/jetbrains/rider/model/CodeCleanupScopeOverrideType;", "createCenterPanel", "Ljavax/swing/JComponent;", "rider"})
public final class RiderCodeCleanupDialog
extends RiderCodeCleanupDialogWrapper {
    @Nullable
    private CodeCleanupToolModel viewModel;

    @Nullable
    public final CodeCleanupToolModel getViewModel() {
        return this.viewModel;
    }

    public final void setViewModel(@Nullable CodeCleanupToolModel value2) {
        this.viewModel = value2;
        if (value2 != null) {
            this.Bind(value2);
            this.validate();
            this.repaint();
        }
    }

    public final void Bind(@NotNull CodeCleanupToolModel model2) {
        Intrinsics.checkParameterIsNotNull((Object)model2, (String)"model");
        this.BindProfilesList(model2.getProfilesList().getValue());
        this.BindScope(model2.getScope().getValue());
    }

    private final void BindProfilesList(CleanupProfileModel[] profiles) {
        JComboBox profilesComboBox = this.profilesComboBoxWithBrowseButton.getComboBox();
        profilesComboBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper<String>(){

            public void customize(@NotNull JList<?> list2, @NotNull String value2, int index, boolean selected, boolean hasFocus) {
                Intrinsics.checkParameterIsNotNull(list2, (String)"list");
                Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
                this.setText(StringUtil.trimLog((String)value2, (int)50));
            }
        });
        String selectedProfile = null;
        DefaultComboBoxModel<String> profilesBoxModel = new DefaultComboBoxModel<String>();
        for (int i2 = 0; i2 < profiles.length; ++i2) {
            CleanupProfileModel profile2 = profiles[i2];
            String profileName = profile2.getProfileName().getValue();
            profilesBoxModel.addElement(profileName);
            if (!profile2.isRecentlyUsed()) continue;
            selectedProfile = profileName;
        }
        int selectedProfileIndex = 0;
        if (selectedProfile != null && (selectedProfileIndex = profilesBoxModel.getIndexOf(selectedProfile)) < 0) {
            selectedProfileIndex = 0;
        }
        profilesComboBox.setModel(profilesBoxModel);
        profilesComboBox.setSelectedIndex(selectedProfileIndex);
        profilesComboBox.setEnabled(true);
        profilesComboBox.setVisible(true);
    }

    private final void BindScope(CodeCleanupScope cleanupScope) {
        this.fileRadioButton.setText(this.fileRadioButton.getText() + " \"" + cleanupScope.getFileName() + "\"");
        this.directoryRadioButton.setText(this.directoryRadioButton.getText() + " \"" + cleanupScope.getDirectoryName() + "\"");
        this.solutionRadioButton.setText(this.solutionRadioButton.getText() + " \"" + cleanupScope.getSolutionName() + "\"");
        this.fileRadioButton.setVisible(cleanupScope.getFileName() != null);
        this.directoryRadioButton.setVisible(cleanupScope.getDirectoryName() != null);
        this.solutionRadioButton.setVisible(true);
        switch (RiderCodeCleanupDialog$WhenMappings.$EnumSwitchMapping$0[cleanupScope.getType().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                this.selectionRadioButton.setSelected(true);
                this.selectionRadioButton.setVisible(true);
                break;
            }
            case 3: {
                this.fileRadioButton.setSelected(true);
                break;
            }
            case 4: {
                this.multipleFilesRadioButton.setSelected(true);
                this.multipleFilesRadioButton.setVisible(true);
                break;
            }
            case 5: {
                this.directoryRadioButton.setSelected(true);
                break;
            }
            case 6: {
                this.solutionRadioButton.setSelected(true);
            }
        }
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.contentPane;
    }

    @NotNull
    public final String GetSelectedProfileName() {
        Object object = this.profilesComboBoxWithBrowseButton.getComboBox().getModel().getSelectedItem();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        return (String)object;
    }

    @NotNull
    public final CodeCleanupScopeOverrideType GetSelectedScopeOverride() {
        CodeCleanupToolModel codeCleanupToolModel = this.getViewModel();
        if (codeCleanupToolModel == null) {
            Intrinsics.throwNpe();
        }
        CodeCleanupScopeType modelScopeType = codeCleanupToolModel.getScope().getValue().getType();
        if (this.fileRadioButton.isSelected() && Intrinsics.areEqual((Object)((Object)modelScopeType), (Object)((Object)CodeCleanupScopeType.File)) ^ true) {
            return CodeCleanupScopeOverrideType.File;
        }
        if (this.solutionRadioButton.isSelected() && Intrinsics.areEqual((Object)((Object)modelScopeType), (Object)((Object)CodeCleanupScopeType.Solution)) ^ true) {
            return CodeCleanupScopeOverrideType.Solution;
        }
        return CodeCleanupScopeOverrideType.No;
    }

    public RiderCodeCleanupDialog(@Nullable Project project2) {
        super(project2, false, DialogWrapper.IdeModalityType.PROJECT);
        IPermittedModalities iPermittedModalities = IPermittedModalities.Companion.getInstance();
        Window window = this.getWindow();
        Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"this.window");
        Component component = window;
        Disposable disposable = this.getDisposable();
        Intrinsics.checkExpressionValueIsNotNull((Object)disposable, (String)"this.disposable");
        iPermittedModalities.allowPumpProtocolForComponent(component, disposable);
        new RadioUpDownListener(this.selectionRadioButton, this.fileRadioButton, this.multipleFilesRadioButton, this.directoryRadioButton, this.solutionRadioButton);
        ButtonGroup scopeButtonsGroup = new ButtonGroup();
        scopeButtonsGroup.add(this.selectionRadioButton);
        scopeButtonsGroup.add(this.fileRadioButton);
        scopeButtonsGroup.add(this.multipleFilesRadioButton);
        scopeButtonsGroup.add(this.directoryRadioButton);
        scopeButtonsGroup.add(this.solutionRadioButton);
    }
}

