/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.addProjectReference;

import com.intellij.openapi.project.Project;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.text.Matcher;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.resharper.addProjectReference.CheckableListModel;
import com.jetbrains.resharper.addProjectReference.CheckableListModelKt;
import com.jetbrains.resharper.addProjectReference.FilteredListModel;
import com.jetbrains.resharper.addProjectReference.ListSearchTextField;
import com.jetbrains.resharper.addProjectReferenceFeature.SectionsModel;
import com.jetbrains.resharper.icons.IconHostKt;
import com.jetbrains.rider.model.RdAddReferenceItem;
import com.jetbrains.rider.model.RdAddReferenceItemKind;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.reactive.IProperty;
import com.jetbrains.rider.util.reactive.Property;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002BY\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f\u0012\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\u0002\u0010\u0013J\b\u0010(\u001a\u00020)H\u0002J<\u0010*\u001a\u0004\u0018\u00010+2\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00192\b\u0010,\u001a\u0004\u0018\u00010\u00032\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000200H\u0016J\u0006\u00102\u001a\u000203J\u0016\u00104\u001a\u00020\n2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u000306H\u0002R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u00067"}, d2={"Lcom/jetbrains/resharper/addProjectReference/AddReferenceListView;", "Ljavax/swing/JPanel;", "Ljavax/swing/ListCellRenderer;", "Lcom/jetbrains/rider/model/RdAddReferenceItem;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/jetbrains/resharper/addProjectReference/FilteredListModel;", "filterText", "Lcom/jetbrains/rider/util/reactive/Property;", "", "matchers", "Lcom/jetbrains/rider/util/reactive/IProperty;", "Lcom/intellij/util/text/Matcher;", "checkableModel", "Lcom/jetbrains/resharper/addProjectReference/CheckableListModel;", "sections", "Lcom/jetbrains/resharper/addProjectReferenceFeature/SectionsModel;", "Lcom/jetbrains/rider/model/RdAddReferenceItemKind;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/resharper/addProjectReference/FilteredListModel;Lcom/jetbrains/rider/util/reactive/Property;Lcom/jetbrains/rider/util/reactive/IProperty;Lcom/jetbrains/resharper/addProjectReference/CheckableListModel;Lcom/jetbrains/resharper/addProjectReferenceFeature/SectionsModel;)V", "getCheckableModel", "()Lcom/jetbrains/resharper/addProjectReference/CheckableListModel;", "getFilterText", "()Lcom/jetbrains/rider/util/reactive/Property;", "list", "Ljavax/swing/JList;", "getMatchers", "()Lcom/jetbrains/rider/util/reactive/IProperty;", "getModel", "()Lcom/jetbrains/resharper/addProjectReference/FilteredListModel;", "popupInfo", "Ljavax/swing/JLabel;", "getProject", "()Lcom/intellij/openapi/project/Project;", "scrollPanel", "Ljavax/swing/JScrollPane;", "searchField", "Lcom/jetbrains/resharper/addProjectReference/ListSearchTextField;", "getSections", "()Lcom/jetbrains/resharper/addProjectReferenceFeature/SectionsModel;", "centerConstraint", "Ljava/awt/GridBagConstraints;", "getListCellRendererComponent", "Ljava/awt/Component;", "value", "index", "", "isSelected", "", "cellHasFocus", "getPreferredFocusedComponent", "Ljavax/swing/JComponent;", "infoText", "selectedItems", "", "rider"})
public final class AddReferenceListView
extends JPanel
implements ListCellRenderer<RdAddReferenceItem> {
    private final JList<RdAddReferenceItem> list;
    private final ListSearchTextField searchField;
    private final JScrollPane scrollPanel;
    private final JLabel popupInfo;
    @NotNull
    private final Project project;
    @NotNull
    private final FilteredListModel<RdAddReferenceItem> model;
    @NotNull
    private final Property<String> filterText;
    @NotNull
    private final IProperty<Matcher> matchers;
    @NotNull
    private final CheckableListModel<RdAddReferenceItem> checkableModel;
    @NotNull
    private final SectionsModel<RdAddReferenceItem, RdAddReferenceItemKind> sections;

    private final String infoText(List<RdAddReferenceItem> selectedItems) {
        String string2;
        switch (selectedItems.size()) {
            case 0: {
                string2 = "no reference is selected";
                break;
            }
            case 1: {
                string2 = "1 reference is selected";
                break;
            }
            default: {
                string2 = selectedItems.size() + " references are selected";
            }
        }
        return string2;
    }

    @Override
    @Nullable
    public Component getListCellRendererComponent(@NotNull JList<? extends RdAddReferenceItem> list2, @Nullable RdAddReferenceItem value2, int index, boolean isSelected, boolean cellHasFocus) {
        JPanel jPanel;
        Intrinsics.checkParameterIsNotNull(list2, (String)"list");
        if (value2 == null) {
            throw (Throwable)new NullPointerException("value");
        }
        String caption = this.sections.caption(value2);
        boolean checked = this.checkableModel.getChecked(value2);
        JBCheckBox jBCheckBox = new JBCheckBox(null, checked);
        Object $receiver = jBCheckBox;
        $receiver.setBackground(UIUtil.getListBackground((boolean)isSelected));
        JBCheckBox box = jBCheckBox;
        $receiver = new SimpleColoredComponent();
        Object $receiver2 = (SimpleColoredComponent)$receiver;
        $receiver2.setForeground(UIUtil.getListForeground((boolean)isSelected));
        $receiver2.setIcon(IconHostKt.toIdeaIcon(value2.getIcon(), this.project));
        SimpleColoredComponent mainLabel = (SimpleColoredComponent)$receiver;
        SpeedSearchUtil.appendColoredFragmentForMatcher((String)value2.getPresentation(), (SimpleColoredComponent)mainLabel, (SimpleTextAttributes)SimpleTextAttributes.REGULAR_ATTRIBUTES, (Matcher)this.matchers.getValue(), (Color)UIUtil.getTreeSelectionBackground((boolean)isSelected), (boolean)true);
        $receiver = value2.getComment();
        if (!($receiver.length() == 0)) {
            mainLabel.append(" <" + value2.getComment() + ">", SimpleTextAttributes.ERROR_ATTRIBUTES);
        }
        $receiver2 = new JPanel(new BorderLayout());
        JPanel $receiver3 = (JPanel)$receiver2;
        $receiver3.setToolTipText(value2.getTooltip());
        $receiver3.setBackground(UIUtil.getListBackground((boolean)isSelected));
        $receiver3.add((Component)box, "West");
        $receiver3.add((Component)mainLabel, "Center");
        JPanel mainPanel = (JPanel)$receiver2;
        if (caption == null) {
            return mainPanel;
        }
        JPanel $receiver4 = jPanel = new JPanel(new BorderLayout());
        $receiver4.setBackground(UIUtil.getListBackground((boolean)isSelected));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = $receiver4;
        JPanel $receiver5 = jPanel2;
        $receiver5.setBackground(UIUtil.getListBackground((boolean)false));
        JComponent jComponent = new JPanel();
        JPanel jPanel4 = $receiver5;
        JComponent $receiver6 = jComponent;
        $receiver6.setBackground(UIUtil.getListBackground((boolean)false));
        $receiver6.setLayout(new GridBagLayout());
        $receiver6.add((Component)new JSeparator(), this.centerConstraint());
        JPanel jPanel5 = jComponent;
        jPanel4.add(jPanel5);
        jComponent = new JLabel();
        jPanel4 = $receiver5;
        $receiver6 = (JLabel)jComponent;
        $receiver6.setFont(UIUtil.getLabelFont().deriveFont(UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL)));
        $receiver6.setForeground(UIUtil.getLabelDisabledForeground());
        ((JLabel)$receiver6).setText(caption);
        jPanel5 = jComponent;
        jPanel4.add((Component)jPanel5, "West");
        JPanel jPanel6 = jPanel2;
        jPanel3.add((Component)jPanel6, "North");
        $receiver4.add((Component)mainPanel, "Center");
        JPanel ret = jPanel;
        return ret;
    }

    private final GridBagConstraints centerConstraint() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = (Insets)JBUI.insets((int)0, (int)5, (int)0, (int)5);
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = 0;
        return constraints;
    }

    @NotNull
    public final JComponent getPreferredFocusedComponent() {
        return (JComponent)((Object)this.searchField);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final FilteredListModel<RdAddReferenceItem> getModel() {
        return this.model;
    }

    @NotNull
    public final Property<String> getFilterText() {
        return this.filterText;
    }

    @NotNull
    public final IProperty<Matcher> getMatchers() {
        return this.matchers;
    }

    @NotNull
    public final CheckableListModel<RdAddReferenceItem> getCheckableModel() {
        return this.checkableModel;
    }

    @NotNull
    public final SectionsModel<RdAddReferenceItem, RdAddReferenceItemKind> getSections() {
        return this.sections;
    }

    public AddReferenceListView(@NotNull Project project2, @NotNull FilteredListModel<RdAddReferenceItem> model2, @NotNull Property<String> filterText, @NotNull IProperty<Matcher> matchers2, @NotNull CheckableListModel<RdAddReferenceItem> checkableModel, @NotNull SectionsModel<? super RdAddReferenceItem, ? super RdAddReferenceItemKind> sections2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull(model2, (String)"model");
        Intrinsics.checkParameterIsNotNull(filterText, (String)"filterText");
        Intrinsics.checkParameterIsNotNull(matchers2, (String)"matchers");
        Intrinsics.checkParameterIsNotNull(checkableModel, (String)"checkableModel");
        Intrinsics.checkParameterIsNotNull(sections2, (String)"sections");
        super(new BorderLayout());
        this.project = project2;
        this.model = model2;
        this.filterText = filterText;
        this.matchers = matchers2;
        this.checkableModel = checkableModel;
        this.sections = sections2;
        JList jList = new JList((ListModel)this.model);
        AddReferenceListView addReferenceListView = this;
        JList $receiver = jList;
        $receiver.setCellRenderer(this);
        JList jList2 = jList;
        addReferenceListView.list = jList2;
        this.searchField = new ListSearchTextField(this.filterText, this.model, this.list);
        this.scrollPanel = new JScrollPane(this.list);
        this.popupInfo = new JLabel();
        this.checkableModel.getChanged().advise(Lifetime.Companion.getEternal(), (Function1<RdAddReferenceItem, Unit>)((Function1)new Function1<RdAddReferenceItem, Unit>(){

            public final void invoke(@NotNull RdAddReferenceItem info) {
                Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
                popupInfo.setText(this.infoText(this.getCheckableModel().selectedItems()));
            }
        }));
        CheckableListModelKt.attachEvents(this.checkableModel, this.list, this.checkableModel, this.model);
        this.checkableModel.getChanged().advise(Lifetime.Companion.getEternal(), (Function1<RdAddReferenceItem, Unit>)((Function1)new Function1<RdAddReferenceItem, Unit>(){

            public final void invoke(@NotNull RdAddReferenceItem item) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                this.getModel().fireItemChanged(item);
            }
        }));
        this.add((Component)((Object)this.searchField), "North");
        this.add((Component)this.scrollPanel, "Center");
        this.add((Component)this.popupInfo, "South");
    }
}

