/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.build;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.jetbrains.resharper.build.BuildHost;
import com.jetbrains.resharper.build.BuildParameters;
import com.jetbrains.resharper.build.BuildRequest;
import com.jetbrains.resharper.build.BuildSessionView;
import com.jetbrains.resharper.protocol.ApplicationProtocolKt;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import com.jetbrains.resharper.util.idea.IExternalTask;
import com.jetbrains.resharper.util.idea.ILifetimedComponent;
import com.jetbrains.resharper.util.idea.LifetimedComponent;
import com.jetbrains.resharper.util.idea.ProgressApiKt;
import com.jetbrains.rider.model.BuildArgs;
import com.jetbrains.rider.model.BuildModel;
import com.jetbrains.rider.model.BuildModelReady;
import com.jetbrains.rider.model.BuildResult;
import com.jetbrains.rider.model.BuildResultKind;
import com.jetbrains.rider.model.BuildSession;
import com.jetbrains.rider.model.BuildTarget;
import com.jetbrains.rider.model.BuildTargetBase;
import com.jetbrains.rider.model.CleanTarget;
import com.jetbrains.rider.model.CustomTarget;
import com.jetbrains.rider.model.RebuildTarget;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.lifetime.LifetimeDefinition;
import com.jetbrains.rider.util.lifetime.LifetimeExKt;
import com.jetbrains.rider.util.reactive.IReadonlyProperty;
import com.jetbrains.rider.util.reactive.IViewable;
import com.jetbrains.rider.util.reactive.Property;
import com.jetbrains.rider.util.reactive.PropertyExKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 42\u00020\u00012\u00020\u0002:\u00014B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010'\u001a\u00020(J1\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020+2!\u0010,\u001a\u001d\u0012\u0013\u0012\u00110.\u00a2\u0006\f\b/\u0012\b\b0\u0012\u0004\b\b(1\u0012\u0004\u0012\u00020(0-J1\u00102\u001a\u00020\u00102\u0006\u0010*\u001a\u00020+2!\u0010,\u001a\u001d\u0012\u0013\u0012\u00110.\u00a2\u0006\f\b/\u0012\b\b0\u0012\u0004\b\b(1\u0012\u0004\u0012\u00020(0-J\b\u00103\u001a\u00020(H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0019\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0012\u0010\u0014\u001a\u00020\u0015X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000eR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u000e\u00a8\u00065"}, d2={"Lcom/jetbrains/resharper/build/BuildHost;", "Lcom/intellij/openapi/components/AbstractProjectComponent;", "Lcom/jetbrains/resharper/util/idea/ILifetimedComponent;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "buildModel", "Lcom/jetbrains/rider/model/BuildModel;", "getBuildModel", "()Lcom/jetbrains/rider/model/BuildModel;", "buildSession", "Lcom/jetbrains/rider/util/reactive/Property;", "Lcom/jetbrains/rider/model/BuildSession;", "getBuildSession", "()Lcom/jetbrains/rider/util/reactive/Property;", "building", "", "getBuilding", "canceling", "getCanceling", "componentLifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "getComponentLifetime", "()Lcom/jetbrains/rider/util/lifetime/Lifetime;", "lastBuildLog", "", "getLastBuildLog", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getProject", "()Lcom/intellij/openapi/project/Project;", "queuedRequest", "Lcom/jetbrains/resharper/build/BuildRequest;", "getQueuedRequest", "()Lcom/jetbrains/resharper/build/BuildRequest;", "setQueuedRequest", "(Lcom/jetbrains/resharper/build/BuildRequest;)V", "ready", "getReady", "cancel", "", "queueBuild", "buildParameters", "Lcom/jetbrains/resharper/build/BuildParameters;", "onFinished", "Lkotlin/Function1;", "Lcom/jetbrains/rider/model/BuildResultKind;", "Lkotlin/ParameterName;", "name", "result", "requestBuild", "updateFileSystem", "Companion", "rider"})
public final class BuildHost
extends AbstractProjectComponent
implements ILifetimedComponent {
    private final Logger logger;
    @NotNull
    private final BuildModel buildModel;
    @NotNull
    private final Property<Boolean> ready;
    @NotNull
    private final Property<Boolean> building;
    @NotNull
    private final Property<Boolean> canceling;
    @NotNull
    private final Property<String> lastBuildLog;
    @NotNull
    private final Property<BuildSession> buildSession;
    @Nullable
    private BuildRequest queuedRequest;
    @NotNull
    private final Project project;
    public static final Companion Companion = new Companion(null);
    private final /* synthetic */ LifetimedComponent $$delegate_0;

    @NotNull
    public final BuildModel getBuildModel() {
        return this.buildModel;
    }

    @NotNull
    public final Property<Boolean> getReady() {
        return this.ready;
    }

    @NotNull
    public final Property<Boolean> getBuilding() {
        return this.building;
    }

    @NotNull
    public final Property<Boolean> getCanceling() {
        return this.canceling;
    }

    @NotNull
    public final Property<String> getLastBuildLog() {
        return this.lastBuildLog;
    }

    @NotNull
    public final Property<BuildSession> getBuildSession() {
        return this.buildSession;
    }

    @Nullable
    public final BuildRequest getQueuedRequest() {
        return this.queuedRequest;
    }

    public final void setQueuedRequest(@Nullable BuildRequest buildRequest) {
        this.queuedRequest = buildRequest;
    }

    public final void cancel() {
        this.canceling.setValue(true);
    }

    public final boolean requestBuild(@NotNull BuildParameters buildParameters, @NotNull Function1<? super BuildResultKind, Unit> onFinished) {
        Intrinsics.checkParameterIsNotNull((Object)buildParameters, (String)"buildParameters");
        Intrinsics.checkParameterIsNotNull(onFinished, (String)"onFinished");
        ApplicationKt.getApplication().assertIsDispatchThread();
        ApplicationKt.getApplication().saveAll();
        if (PropertyExKt.getHasValue((IReadonlyProperty)this.buildModel.getBuildModelReady()) && this.buildModel.getBuildModelReady().getValue().getReady().getValue().booleanValue()) {
            try {
                PropertyExKt.set(this.buildSession, null);
                BuildTargetBase buildOperation = buildParameters.getOperation();
                BuildModelReady buildModelReady = this.buildModel.getBuildModelReady().getValue();
                PropertyExKt.set(buildModelReady.getRequest(), new BuildArgs(buildOperation, buildParameters.getSelectedProjectsPaths(), buildParameters.getDiagnosticsMode()));
                LifetimeDefinition buildLifetimeDef = Lifetime.Companion.create(this.getComponentLifetime());
                Lifetime buildLifetime = buildLifetimeDef.getLifetime();
                AccessToken token = HeavyProcessLatch.INSTANCE.processStarted("Build");
                buildLifetime.add((Function0<Unit>)((Function0)new Function0<Unit>(token){
                    final /* synthetic */ AccessToken $token;

                    public final void invoke() {
                        this.$token.finish();
                    }
                    {
                        this.$token = accessToken;
                        super(0);
                    }
                }));
                PropertyExKt.viewNotNull((IViewable)this.buildSession, buildLifetime, (Function2)new Function2<Lifetime, BuildSession, Unit>(this, onFinished, buildLifetimeDef, buildLifetime){
                    final /* synthetic */ BuildHost this$0;
                    final /* synthetic */ Function1 $onFinished;
                    final /* synthetic */ LifetimeDefinition $buildLifetimeDef;
                    final /* synthetic */ Lifetime $buildLifetime;

                    public final void invoke(@NotNull Lifetime lt, @NotNull BuildSession session2) {
                        Intrinsics.checkParameterIsNotNull((Object)lt, (String)"lt");
                        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
                        BuildHost.access$getLogger$p(this.this$0).info("Build session started");
                        session2.getResult().advise(lt, (Function1<BuildResult, Unit>)((Function1)new Function1<BuildResult, Unit>(this){
                            final /* synthetic */ requestBuild.2 this$0;

                            public final void invoke(@NotNull BuildResult res2) {
                                Intrinsics.checkParameterIsNotNull((Object)res2, (String)"res");
                                BuildHost.access$getLogger$p(this.this$0.this$0).info("Build finished with result: " + res2);
                                BuildHost.access$updateFileSystem(this.this$0.this$0);
                                this.this$0.$onFinished.invoke((Object)((Object)res2.getKind()));
                                this.this$0.$buildLifetimeDef.terminate();
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }));
                        lt.add((Function0<Unit>)((Function0)new Function0<Unit>(this){
                            final /* synthetic */ requestBuild.2 this$0;

                            public final void invoke() {
                                if (LifetimeExKt.isAlive(this.this$0.$buildLifetime)) {
                                    BuildHost.access$getLogger$p(this.this$0.this$0).info("Build finished by lifetime termination");
                                    this.this$0.$onFinished.invoke((Object)((Object)BuildResultKind.Crashed));
                                    this.this$0.$buildLifetimeDef.terminate();
                                }
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        }));
                    }
                    {
                        this.this$0 = buildHost;
                        this.$onFinished = function1;
                        this.$buildLifetimeDef = lifetimeDefinition;
                        this.$buildLifetime = lifetime;
                        super(2);
                    }
                });
                return true;
            }
            catch (Throwable t2) {
                this.logger.error(t2);
                onFinished.invoke((Object)BuildResultKind.Crashed);
                return false;
            }
        }
        this.logger.warn("Cannot execute request !buildModel.buildModelReady.hasValue");
        onFinished.invoke((Object)BuildResultKind.Crashed);
        return false;
    }

    private final void updateFileSystem() {
        boolean async = !ApplicationKt.getApplication().isUnitTestMode();
        LocalFileSystem.getInstance().refresh(async);
    }

    public final void queueBuild(@NotNull BuildParameters buildParameters, @NotNull Function1<? super BuildResultKind, Unit> onFinished) {
        Intrinsics.checkParameterIsNotNull((Object)buildParameters, (String)"buildParameters");
        Intrinsics.checkParameterIsNotNull(onFinished, (String)"onFinished");
        this.queuedRequest = new BuildRequest(buildParameters, onFinished);
        Notifications.Bus.notify((Notification)new Notification(BuildSessionView.Companion.getBUILD_NOTIFICATION_GROUP().getDisplayId(), "", "Build will be executed upon solution load", NotificationType.INFORMATION), (Project)this.project);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public BuildHost(@NotNull Project project2) {
        Logger logger;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        super(project2);
        this.$$delegate_0 = new LifetimedComponent(project2);
        this.project = project2;
        BuildHost buildHost = this;
        Logger logger2 = Logger.getInstance(BuildHost.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        buildHost.logger = logger = logger2;
        this.buildModel = BuildModel.Companion.create(this.getComponentLifetime(), ApplicationProtocolKt.getProtocol(this.project));
        this.ready = new Property<Boolean>(false);
        this.building = new Property<Boolean>(false);
        this.canceling = new Property<Boolean>(false);
        this.lastBuildLog = new Property<String>("");
        this.buildSession = new Property();
        PropertyExKt.viewNotNull((IViewable)this.buildModel.getBuildModelReady(), this.getComponentLifetime(), (Function2)new Function2<Lifetime, BuildModelReady, Unit>(){

            public final void invoke(@NotNull Lifetime lt, @NotNull BuildModelReady buildModelReady) {
                Intrinsics.checkParameterIsNotNull((Object)lt, (String)"lt");
                Intrinsics.checkParameterIsNotNull((Object)buildModelReady, (String)"buildModelReady");
                PropertyExKt.viewNotNull((IViewable)buildModelReady.getBuildSession(), lt, (Function2)new Function2<Lifetime, BuildSession, Unit>(){

                    public final void invoke(@NotNull Lifetime ltlt, final @NotNull BuildSession session2) {
                        Intrinsics.checkParameterIsNotNull((Object)ltlt, (String)"ltlt");
                        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
                        final LifetimeDefinition activeBuildLifetimeDef = ltlt.createNestedDef();
                        Lifetime activeBuildLifetime = activeBuildLifetimeDef.getLifetime();
                        session2.getResult().advise(ltlt, (Function1<BuildResult, Unit>)((Function1)new Function1<BuildResult, Unit>(){

                            public final void invoke(@NotNull BuildResult it) {
                                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                activeBuildLifetimeDef.terminate();
                                this.getBuilding().setValue(false);
                                this.getCanceling().setValue(false);
                            }
                        }));
                        this.getBuildSession().setValue(session2);
                        ltlt.add((Function0<Unit>)((Function0)new Function0<Unit>(){

                            public final void invoke() {
                                if (Intrinsics.areEqual((Object)this.getBuildSession().getValue(), (Object)session2)) {
                                    this.getBuildSession().setValue(null);
                                }
                            }
                        }));
                        this.getBuilding().setValue(true);
                        this.getCanceling().setValue(false);
                        this.getLastBuildLog().setValue("");
                        session2.getLogFileName().view(ltlt, (Function2<Lifetime, String, Unit>)((Function2)new Function2<Lifetime, String, Unit>(){

                            public final void invoke(@NotNull Lifetime ltltlt, @NotNull String fileName) {
                                Intrinsics.checkParameterIsNotNull((Object)ltltlt, (String)"ltltlt");
                                Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
                                CharSequence charSequence = fileName;
                                if (!(charSequence == null || charSequence.length() == 0)) {
                                    this.getLastBuildLog().setValue(fileName);
                                }
                                ltltlt.add((Function0<Unit>)((Function0)new Function0<Unit>(){

                                    public final void invoke() {
                                        this.getLastBuildLog().setValue("");
                                    }
                                }));
                            }
                        }));
                        String progressTitle = Companion.getBuildTargetName(session2.getOperation()) + " solution";
                        final Function0 cancelAction2 = (Function0)new Function0<Unit>(this, session2){
                            final /* synthetic */ 1 this$0;
                            final /* synthetic */ BuildSession $session;

                            public final void invoke() {
                                this.getBuildModel().getProtocol().getScheduler().invokeOrQueue((Function0<Unit>)((Function0)new Function0<Unit>(this){
                                    final /* synthetic */ cancelAction.1 this$0;

                                    public final void invoke() {
                                        if (!this.getComponentLifetime().isTerminated()) {
                                            this.this$0.$session.getCancel().fire();
                                        }
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        super(0);
                                    }
                                }));
                            }
                            {
                                this.this$0 = var1_1;
                                this.$session = buildSession;
                                super(0);
                            }
                        };
                        PropertyExKt.whenTrue((IReadonlyProperty<Boolean>)this.getCanceling(), ltlt, (Function1<? super Lifetime, Unit>)((Function1)new Function1<Lifetime, Unit>(){

                            public final void invoke(@NotNull Lifetime it) {
                                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                cancelAction2.invoke();
                            }
                        }));
                        Task task2 = ProgressApiKt.externalTask(this.getProject(), true, new IExternalTask(activeBuildLifetime, cancelAction2, progressTitle, session2){
                            final /* synthetic */ Lifetime $activeBuildLifetime;
                            final /* synthetic */ Function0 $cancelAction;
                            final /* synthetic */ String $progressTitle;
                            final /* synthetic */ BuildSession $session;

                            @NotNull
                            public Lifetime getLifetime() {
                                return this.$activeBuildLifetime;
                            }

                            @NotNull
                            public Function0<Unit> getCancel() {
                                return this.$cancelAction;
                            }

                            @NotNull
                            public String getTitle() {
                                return this.$progressTitle;
                            }

                            @NotNull
                            public String getHeader() {
                                return PropertyExKt.valueOrDefault(this.$session.getActiveProjectName(), "");
                            }

                            @NotNull
                            public String getDescription() {
                                return "";
                            }

                            public boolean isIndeterminate() {
                                return false;
                            }

                            public double getProgress() {
                                return ((Number)PropertyExKt.valueOrDefault(this.$session.getProgress(), 0.0)).doubleValue();
                            }
                            {
                                this.$activeBuildLifetime = $captured_local_variable$0;
                                this.$cancelAction = $captured_local_variable$1;
                                this.$progressTitle = $captured_local_variable$2;
                                this.$session = $captured_local_variable$3;
                            }
                        });
                        if (!ApplicationKt.getApplication().isUnitTestMode()) {
                            ProgressManager.getInstance().run(task2);
                        }
                    }
                });
                this.getReady().setValue(buildModelReady.getReady().getValue());
                buildModelReady.getReady().advise(lt, (Function1<Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(){

                    public final void invoke(boolean it) {
                        BuildRequest localQueuedRequest;
                        this.getReady().setValue(it);
                        if (it && (localQueuedRequest = this.getQueuedRequest()) != null) {
                            this.setQueuedRequest(null);
                            this.requestBuild(localQueuedRequest.getBuildParameters(), localQueuedRequest.getOnFinished());
                        }
                    }
                }));
                this.getCanceling().setValue(false);
                lt.add((Function0<Unit>)((Function0)new Function0<Unit>(){

                    public final void invoke() {
                        this.getReady().setValue(false);
                    }
                }));
            }
        });
    }

    @Override
    @NotNull
    public Lifetime getComponentLifetime() {
        return this.$$delegate_0.getComponentLifetime();
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLogger$p(BuildHost $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$updateFileSystem(BuildHost $this) {
        $this.updateFileSystem();
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/resharper/build/BuildHost$Companion;", "", "()V", "getBuildTargetName", "", "buildTarget", "Lcom/jetbrains/rider/model/BuildTargetBase;", "rider"})
    public static final class Companion {
        @NotNull
        public final String getBuildTargetName(@NotNull BuildTargetBase buildTarget) {
            Intrinsics.checkParameterIsNotNull((Object)buildTarget, (String)"buildTarget");
            BuildTargetBase buildTargetBase = buildTarget;
            if (buildTargetBase instanceof BuildTarget) {
                return "Build";
            }
            if (buildTargetBase instanceof RebuildTarget) {
                return "Rebuild";
            }
            if (buildTargetBase instanceof CleanTarget) {
                return "Clean";
            }
            if (buildTargetBase instanceof CustomTarget) {
                return ((CustomTarget)buildTarget).getTargetName();
            }
            return "";
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

