/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.build;

import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.actions.CloseTabToolbarAction;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.status.StatusBarUtil;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.jetbrains.resharper.build.BuildHost;
import com.jetbrains.resharper.build.BuildSessionView;
import com.jetbrains.resharper.build.BuildSessionView$WhenMappings;
import com.jetbrains.resharper.build.RiderBuildShowSettingsAction;
import com.jetbrains.resharper.build.ToggleConsoleViewAction;
import com.jetbrains.resharper.build.ViewBuildLogFileAction;
import com.jetbrains.resharper.build.actions.BuildSolutionAction;
import com.jetbrains.resharper.build.ui.BuildResultPanel;
import com.jetbrains.resharper.projectView.ProjectModelViewHost;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import com.jetbrains.resharper.util.idea.ILifetimedComponent;
import com.jetbrains.resharper.util.idea.LifetimedComponent;
import com.jetbrains.rider.model.BuildEvent;
import com.jetbrains.rider.model.BuildEventKind;
import com.jetbrains.rider.model.BuildOutputMessage;
import com.jetbrains.rider.model.BuildResult;
import com.jetbrains.rider.model.BuildResultKind;
import com.jetbrains.rider.model.BuildSession;
import com.jetbrains.rider.model.BuildTarget;
import com.jetbrains.rider.model.BuildTargetBase;
import com.jetbrains.rider.model.CleanTarget;
import com.jetbrains.rider.model.CustomTarget;
import com.jetbrains.rider.model.RebuildTarget;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.lifetime.SequentialLifetimes;
import com.jetbrains.rider.util.reactive.IReadonlyProperty;
import com.jetbrains.rider.util.reactive.IViewable;
import com.jetbrains.rider.util.reactive.PropertyExKt;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 72\u00020\u00012\u00020\u0002:\u00017B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J8\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020#H\u0002J\u0010\u0010-\u001a\u00020#2\u0006\u0010.\u001a\u00020/H\u0002J\u0018\u00100\u001a\u00020\u001a2\u0006\u00101\u001a\u00020#2\u0006\u00102\u001a\u000203H\u0002J\u0018\u00104\u001a\u00020#2\u0006\u00105\u001a\u0002062\u0006\u0010\"\u001a\u00020#H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00020\u0013X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/jetbrains/resharper/build/BuildSessionView;", "Lcom/intellij/openapi/components/AbstractProjectComponent;", "Lcom/jetbrains/resharper/util/idea/ILifetimedComponent;", "project", "Lcom/intellij/openapi/project/Project;", "toolWindowManager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "startupManager", "Lcom/intellij/openapi/startup/StartupManager;", "actionManager", "Lcom/intellij/ide/CommonActionsManager;", "projectModelViewHost", "Lcom/jetbrains/resharper/projectView/ProjectModelViewHost;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/wm/ToolWindowManager;Lcom/intellij/openapi/startup/StartupManager;Lcom/intellij/ide/CommonActionsManager;Lcom/jetbrains/resharper/projectView/ProjectModelViewHost;)V", "buildHost", "Lcom/jetbrains/resharper/build/BuildHost;", "buildToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "componentLifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "getComponentLifetime", "()Lcom/jetbrains/rider/util/lifetime/Lifetime;", "formatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "activateBuildToolWindowIfNotActive", "", "createToolbarPanel", "Ljavax/swing/JPanel;", "buildResultPanel", "Lcom/jetbrains/resharper/build/ui/BuildResultPanel;", "contentManager", "Lcom/intellij/ui/content/ContentManager;", "handleBuildResult", "buildTargetName", "", "buildResult", "Lcom/jetbrains/rider/model/BuildResult;", "isOpenLogFileAfter", "", "logFilePath", "resultsContent", "Lcom/intellij/ui/content/Content;", "openLogFile", "path", "operationInProgressText", "target", "Lcom/jetbrains/rider/model/BuildTargetBase;", "showBuildNotification", "text", "type", "Lcom/intellij/notification/NotificationType;", "statusText", "resultKind", "Lcom/jetbrains/rider/model/BuildResultKind;", "Companion", "rider"})
public final class BuildSessionView
extends AbstractProjectComponent
implements ILifetimedComponent {
    private final BuildHost buildHost;
    private ToolWindow buildToolWindow;
    private final DateTimeFormatter formatter;
    private final Project project;
    private final ToolWindowManager toolWindowManager;
    private final CommonActionsManager actionManager;
    private static final String TOOLWINDOW_ID = "Build";
    @NotNull
    private static final NotificationGroup BUILD_NOTIFICATION_GROUP;
    private static final Logger myLogger;
    private static final String HELP_ID = "build.toolWindow";
    public static final Companion Companion;
    private final /* synthetic */ LifetimedComponent $$delegate_0;

    private final void handleBuildResult(String buildTargetName, BuildResult buildResult, BuildResultPanel buildResultPanel, boolean isOpenLogFileAfter, String logFilePath, Content resultsContent2) {
        String string2;
        String statusText = this.statusText(buildResult.getKind(), buildTargetName);
        switch (BuildSessionView$WhenMappings.$EnumSwitchMapping$0[buildResult.getKind().ordinal()]) {
            case 1: {
                string2 = buildTargetName + " succeeded";
                break;
            }
            case 2: {
                string2 = buildTargetName + " failed";
                break;
            }
            case 3: {
                string2 = buildTargetName + " succeeded";
                break;
            }
            case 4: {
                string2 = buildTargetName + " canceled";
                break;
            }
            case 5: {
                string2 = buildTargetName + " crashed";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String statusShortText = string2;
        resultsContent2.setToolwindowTitle(" - " + statusShortText);
        resultsContent2.setDisplayName(" - " + statusShortText);
        BuildSessionView.Companion.getMyLogger().info("Build result: " + statusShortText + " - " + statusText);
        buildResultPanel.addStatusMessage(statusText);
        if (buildResultPanel.getHasEvents()) {
            buildResultPanel.showEvents();
        }
        if (isOpenLogFileAfter) {
            this.openLogFile(logFilePath);
        }
        ApplicationKt.getApplication().invokeLater(new Runnable(this, buildResult, statusText){
            final /* synthetic */ BuildSessionView this$0;
            final /* synthetic */ BuildResult $buildResult;
            final /* synthetic */ String $statusText;

            public final void run() {
                NotificationType notificationType;
                switch (BuildSessionView$WhenMappings.$EnumSwitchMapping$1[this.$buildResult.getKind().ordinal()]) {
                    case 1: {
                        notificationType = NotificationType.INFORMATION;
                        break;
                    }
                    case 2: {
                        notificationType = NotificationType.ERROR;
                        break;
                    }
                    case 3: {
                        notificationType = NotificationType.WARNING;
                        break;
                    }
                    case 4: {
                        notificationType = NotificationType.ERROR;
                        break;
                    }
                    case 5: {
                        notificationType = NotificationType.ERROR;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                NotificationType notificationType2 = notificationType;
                if (this.$buildResult.getShowNotification() && Intrinsics.areEqual((Object)notificationType2, (Object)NotificationType.INFORMATION)) {
                    BuildSessionView.access$showBuildNotification(this.this$0, this.$statusText, notificationType2);
                } else {
                    StatusBarUtil.setStatusBarInfo(BuildSessionView.access$getProject$p(this.this$0), this.$statusText);
                }
                if (Intrinsics.areEqual((Object)notificationType2, (Object)NotificationType.ERROR)) {
                    BuildSessionView.access$activateBuildToolWindowIfNotActive(this.this$0);
                }
                LocalFileSystem.getInstance().refresh(!ApplicationKt.getApplication().isUnitTestMode());
            }
            {
                this.this$0 = buildSessionView;
                this.$buildResult = buildResult;
                this.$statusText = string2;
            }
        });
    }

    private final JPanel createToolbarPanel(BuildResultPanel buildResultPanel, ContentManager contentManager) {
        Object object = new DefaultActionGroup();
        Object $receiver = object;
        $receiver.add((AnAction)new BuildSolutionAction());
        $receiver.add((AnAction)new ToggleConsoleViewAction(buildResultPanel));
        $receiver.add((AnAction)new ViewBuildLogFileAction());
        $receiver.addSeparator();
        $receiver.add(this.actionManager.createPrevOccurenceAction((OccurenceNavigator)buildResultPanel));
        $receiver.add(this.actionManager.createNextOccurenceAction((OccurenceNavigator)buildResultPanel));
        $receiver.addSeparator();
        $receiver.add((AnAction)new RiderBuildShowSettingsAction(this.project));
        $receiver.add((AnAction)new ContextHelpAction(BuildSessionView.Companion.getHELP_ID()));
        $receiver.add((AnAction)new CloseTabToolbarAction(this, buildResultPanel, contentManager){
            final /* synthetic */ BuildSessionView this$0;
            final /* synthetic */ BuildResultPanel $buildResultPanel$inlined;
            final /* synthetic */ ContentManager $contentManager$inlined;
            {
                this.this$0 = buildSessionView;
                this.$buildResultPanel$inlined = buildResultPanel;
                this.$contentManager$inlined = contentManager;
            }

            public void actionPerformed(AnActionEvent e2) {
                this.$contentManager$inlined.removeAllContents(true);
            }
        });
        DefaultActionGroup buildActionGroup = object;
        object = new JPanel(new BorderLayout());
        $receiver = (JPanel)object;
        ((Container)$receiver).add((Component)ActionManager.getInstance().createActionToolbar("CompilerMessagesToolbar", (ActionGroup)buildActionGroup, false).getComponent(), "West");
        return (JPanel)object;
    }

    private final String statusText(BuildResultKind resultKind, String buildTargetName) {
        String string2;
        String time = LocalDateTime.now().format(this.formatter);
        switch (BuildSessionView$WhenMappings.$EnumSwitchMapping$2[resultKind.ordinal()]) {
            case 1: {
                string2 = buildTargetName + " succeeded at " + time + "\n";
                break;
            }
            case 2: {
                string2 = buildTargetName + " succeeded at " + time + "\n";
                break;
            }
            case 3: {
                string2 = buildTargetName + " failed at " + time + "\n";
                break;
            }
            case 4: {
                string2 = buildTargetName + " cancelled at " + time + "\n";
                break;
            }
            case 5: {
                string2 = buildTargetName + " crashed at " + time + "\n";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string2;
    }

    private final String operationInProgressText(BuildTargetBase target) {
        String string2;
        BuildTargetBase buildTargetBase = target;
        if (buildTargetBase instanceof BuildTarget) {
            string2 = " - Executing build...";
        } else if (buildTargetBase instanceof RebuildTarget) {
            string2 = " - Executing build...";
        } else if (buildTargetBase instanceof CleanTarget) {
            string2 = " - Executing clean...";
        } else if (buildTargetBase instanceof CustomTarget) {
            string2 = " - Executing target " + ((CustomTarget)target).getTargetName() + "...";
        } else {
            throw (Throwable)new IllegalArgumentException("target");
        }
        return string2;
    }

    private final void openLogFile(String path) {
        VirtualFile file2 = VfsUtil.findFileByIoFile((File)new File(path), (boolean)true);
        if (file2 == null) {
            Notifications.Bus.notify((Notification)new Notification("System Messages", "Error", "There is no such file: " + path, NotificationType.ERROR), (Project)this.project);
        } else {
            Intrinsics.checkExpressionValueIsNotNull((Object)FileEditorManager.getInstance((Project)this.project).openFile(file2, true, true), (String)"FileEditorManager.getIns\u2026penFile(file, true, true)");
        }
    }

    private final void activateBuildToolWindowIfNotActive() {
        block1: {
            ToolWindow toolWindow = this.buildToolWindow;
            if (toolWindow != null ? toolWindow.isActive() : false) break block1;
            ToolWindow toolWindow2 = this.buildToolWindow;
            if (toolWindow2 != null) {
                toolWindow2.activate((Runnable)activateBuildToolWindowIfNotActive.1.INSTANCE);
            }
        }
    }

    private final void showBuildNotification(String text2, NotificationType type) {
        Notifications.Bus.notify((Notification)new Notification(Companion.getBUILD_NOTIFICATION_GROUP().getDisplayId(), "", text2, type), (Project)this.project);
    }

    /*
     * WARNING - void declaration
     */
    public BuildSessionView(@NotNull Project project2, @NotNull ToolWindowManager toolWindowManager, @NotNull StartupManager startupManager, @NotNull CommonActionsManager actionManager, final @NotNull ProjectModelViewHost projectModelViewHost) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)toolWindowManager, (String)"toolWindowManager");
        Intrinsics.checkParameterIsNotNull((Object)startupManager, (String)"startupManager");
        Intrinsics.checkParameterIsNotNull((Object)actionManager, (String)"actionManager");
        Intrinsics.checkParameterIsNotNull((Object)projectModelViewHost, (String)"projectModelViewHost");
        super(project2);
        this.$$delegate_0 = new LifetimedComponent(project2);
        this.project = project2;
        this.toolWindowManager = toolWindowManager;
        this.actionManager = actionManager;
        ComponentManager componentManager = (ComponentManager)this.project;
        BuildSessionView buildSessionView = this;
        Object object = $receiver$iv.getComponent(BuildHost.class);
        if (object == null) {
            throw (Throwable)new IllegalStateException("Component " + BuildHost.class + " not found in container " + $receiver$iv);
        }
        Object object2 = object;
        buildSessionView.buildHost = (BuildHost)object2;
        startupManager.runWhenProjectIsInitialized(new Runnable(){

            @Override
            public final void run() {
                ToolWindow toolWindow = toolWindowManager.getToolWindow(Companion.getTOOLWINDOW_ID());
                if (toolWindow == null) {
                    ToolWindow toolWindow2 = toolWindowManager.registerToolWindow(Companion.getTOOLWINDOW_ID(), true, ToolWindowAnchor.BOTTOM, (Disposable)project, true, false);
                    toolWindow = toolWindow2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)toolWindow2, (String)"toolWindowManager.regist\u2026OM, project, true, false)");
                }
                ToolWindow toolWindow3 = toolWindow;
                buildToolWindow = toolWindow3;
                final ContentManager contentManager = toolWindow3.getContentManager();
                toolWindow3.setTitle("");
                toolWindow3.setIcon(IconLoader.getIcon((String)"/rider/toolwindows/toolWindowBuild.png"));
                new ContentManagerWatcher(buildToolWindow, contentManager);
                final SequentialLifetimes resultsLifetime = new SequentialLifetimes(this.getComponentLifetime());
                buildHost.getBuildSession().view(this.getComponentLifetime(), (Function2<Lifetime, BuildSession, Unit>)((Function2)new Function2<Lifetime, BuildSession, Unit>(){

                    public final void invoke(@NotNull Lifetime lt, @Nullable BuildSession session2) {
                        Intrinsics.checkParameterIsNotNull((Object)lt, (String)"lt");
                        if (session2 != null) {
                            session2.getResult().advise(this.getComponentLifetime(), (Function1<BuildResult, Unit>)((Function1)1.INSTANCE));
                        }
                        Companion.getMyLogger().info("new session");
                        lt.add((Function0<Unit>)((Function0)2.INSTANCE));
                    }
                }));
                PropertyExKt.viewNotNull((IViewable)buildHost.getBuildSession(), this.getComponentLifetime(), (Function2)new Function2<Lifetime, BuildSession, Unit>(){

                    public final void invoke(@NotNull Lifetime sessionLifetime, @NotNull BuildSession session2) {
                        Content content2;
                        Intrinsics.checkParameterIsNotNull((Object)sessionLifetime, (String)"sessionLifetime");
                        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
                        Lifetime lifetimeResults = resultsLifetime.next();
                        ToolWindow toolWindow = buildToolWindow;
                        boolean shouldReactivateBuildToolWindow = toolWindow != null ? toolWindow.isActive() : false;
                        contentManager.removeAllContents(true);
                        Content $receiver = content2 = contentManager.getFactory().createContent(null, "Build Results", true);
                        StatusBarUtil.setStatusBarInfo(project, "");
                        BuildResultPanel buildResultPanel = new BuildResultPanel(project, projectModelViewHost, lifetimeResults);
                        $receiver.setComponent((JComponent)((Object)buildResultPanel));
                        BuildSessionView buildSessionView = this;
                        ContentManager contentManager2 = contentManager;
                        Intrinsics.checkExpressionValueIsNotNull((Object)contentManager2, (String)"contentManager");
                        buildResultPanel.setToolbar(buildSessionView.createToolbarPanel(buildResultPanel, contentManager2));
                        String status = this.operationInProgressText(session2.getOperation());
                        $receiver.setToolwindowTitle(status);
                        $receiver.setDisplayName(status);
                        session2.getBuildEvent().advise(sessionLifetime, (Function1<BuildEvent, Unit>)((Function1)new Function1<BuildEvent, Unit>(buildResultPanel, this, lifetimeResults, session2, sessionLifetime){
                            final /* synthetic */ BuildResultPanel $buildResultPanel;
                            final /* synthetic */ 2 this$0;
                            final /* synthetic */ Lifetime $lifetimeResults$inlined;
                            final /* synthetic */ BuildSession $session$inlined;
                            final /* synthetic */ Lifetime $sessionLifetime$inlined;
                            {
                                this.$buildResultPanel = buildResultPanel;
                                this.this$0 = var2_2;
                                this.$lifetimeResults$inlined = lifetime;
                                this.$session$inlined = buildSession;
                                this.$sessionLifetime$inlined = lifetime2;
                                super(1);
                            }

                            public final void invoke(BuildEvent event) {
                                this.$buildResultPanel.addBuildEvent(event);
                                if (Intrinsics.areEqual((Object)((Object)event.getKind()), (Object)((Object)BuildEventKind.Error))) {
                                    BuildSessionView.access$activateBuildToolWindowIfNotActive(this);
                                }
                            }
                        }));
                        session2.getOutputMessage().advise(sessionLifetime, (Function1<BuildOutputMessage, Unit>)((Function1)new Function1<BuildOutputMessage, Unit>(buildResultPanel){
                            final /* synthetic */ BuildResultPanel $buildResultPanel;

                            public final void invoke(@NotNull BuildOutputMessage message2) {
                                Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
                                this.$buildResultPanel.addOutputMessage(message2.getMessage() + "\n", message2.getType());
                            }
                            {
                                this.$buildResultPanel = buildResultPanel;
                                super(1);
                            }
                        }));
                        session2.getResult().advise(sessionLifetime, (Function1<BuildResult, Unit>)((Function1)new Function1<BuildResult, Unit>($receiver, buildResultPanel, this, lifetimeResults, session2, sessionLifetime){
                            final /* synthetic */ Content receiver$0;
                            final /* synthetic */ BuildResultPanel $buildResultPanel;
                            final /* synthetic */ 2 this$0;
                            final /* synthetic */ Lifetime $lifetimeResults$inlined;
                            final /* synthetic */ BuildSession $session$inlined;
                            final /* synthetic */ Lifetime $sessionLifetime$inlined;
                            {
                                this.receiver$0 = content2;
                                this.$buildResultPanel = buildResultPanel;
                                this.this$0 = var3_3;
                                this.$lifetimeResults$inlined = lifetime;
                                this.$session$inlined = buildSession;
                                this.$sessionLifetime$inlined = lifetime2;
                                super(1);
                            }

                            public final void invoke(BuildResult buildResult) {
                                BuildSessionView buildSessionView = this;
                                String string2 = BuildHost.Companion.getBuildTargetName(this.$session$inlined.getOperation());
                                boolean bl = PropertyExKt.getHasValue((IReadonlyProperty)this.$session$inlined.getOpenLogAfterBuild()) && this.$session$inlined.getOpenLogAfterBuild().getValue() != false && PropertyExKt.getHasValue((IReadonlyProperty)this.$session$inlined.getLogFileName());
                                String string3 = PropertyExKt.getHasValue((IReadonlyProperty)this.$session$inlined.getLogFileName()) ? this.$session$inlined.getLogFileName().getValue() : "";
                                Content content2 = this.receiver$0;
                                Intrinsics.checkExpressionValueIsNotNull((Object)content2, (String)"this");
                                BuildSessionView.access$handleBuildResult(buildSessionView, string2, buildResult, this.$buildResultPanel, bl, string3, content2);
                            }
                        }));
                        $receiver.setCloseable(false);
                        Content resultsContent2 = content2;
                        contentManager.addContent(resultsContent2);
                        if (shouldReactivateBuildToolWindow) {
                            this.activateBuildToolWindowIfNotActive();
                        }
                    }
                });
            }
        });
        this.formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
    }

    static {
        Companion = new Companion(null);
        TOOLWINDOW_ID = TOOLWINDOW_ID;
        BUILD_NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"Build Messages", (String)BuildSessionView.Companion.getTOOLWINDOW_ID());
        Logger logger = Logger.getInstance(BuildSessionView.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        myLogger = logger;
        HELP_ID = HELP_ID;
    }

    @Override
    @NotNull
    public Lifetime getComponentLifetime() {
        return this.$$delegate_0.getComponentLifetime();
    }

    public static final /* synthetic */ void access$showBuildNotification(BuildSessionView $this, @NotNull String text2, @NotNull NotificationType type) {
        $this.showBuildNotification(text2, type);
    }

    public static final /* synthetic */ void access$handleBuildResult(BuildSessionView $this, @NotNull String buildTargetName, @NotNull BuildResult buildResult, @NotNull BuildResultPanel buildResultPanel, boolean isOpenLogFileAfter, @NotNull String logFilePath, @NotNull Content resultsContent2) {
        $this.handleBuildResult(buildTargetName, buildResult, buildResultPanel, isOpenLogFileAfter, logFilePath, resultsContent2);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\tX\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/resharper/build/BuildSessionView$Companion;", "", "()V", "BUILD_NOTIFICATION_GROUP", "Lcom/intellij/notification/NotificationGroup;", "Lorg/jetbrains/annotations/NotNull;", "getBUILD_NOTIFICATION_GROUP", "()Lcom/intellij/notification/NotificationGroup;", "HELP_ID", "", "getHELP_ID", "()Ljava/lang/String;", "TOOLWINDOW_ID", "getTOOLWINDOW_ID", "myLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "getMyLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "rider"})
    public static final class Companion {
        private final String getTOOLWINDOW_ID() {
            return TOOLWINDOW_ID;
        }

        @NotNull
        public final NotificationGroup getBUILD_NOTIFICATION_GROUP() {
            return BUILD_NOTIFICATION_GROUP;
        }

        private final Logger getMyLogger() {
            return myLogger;
        }

        private final String getHELP_ID() {
            return HELP_ID;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

