/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.build.ui;

import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.jetbrains.resharper.build.ui.BuildResultPanel$WhenMappings;
import com.jetbrains.resharper.build.ui.RiderBuildResultTreePanel;
import com.jetbrains.resharper.projectView.ProjectModelViewHost;
import com.jetbrains.rider.model.BuildEvent;
import com.jetbrains.rider.model.BuildEventKind;
import com.jetbrains.rider.model.BuildMessageKind;
import com.jetbrains.rider.util.lifetime.Lifetime;
import java.awt.CardLayout;
import java.awt.Component;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 92\u00020\u00012\u00020\u0002:\u00019B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J\u0016\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+J\u000e\u0010,\u001a\u00020$2\u0006\u0010(\u001a\u00020)J\n\u0010-\u001a\u0004\u0018\u00010)H\u0016J\n\u0010.\u001a\u0004\u0018\u00010)H\u0016J\n\u0010/\u001a\u0004\u0018\u000100H\u0016J\n\u00101\u001a\u0004\u0018\u000100H\u0016J\b\u00102\u001a\u00020\u0016H\u0016J\b\u00103\u001a\u00020\u0016H\u0016J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u00020+H\u0002J\u0006\u00107\u001a\u00020$J\u0006\u00108\u001a\u00020$R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR$\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0019\"\u0004\b\u001e\u0010\u001bR$\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0019\"\u0004\b \u0010\u001bR\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/jetbrains/resharper/build/ui/BuildResultPanel;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "Lcom/intellij/ide/OccurenceNavigator;", "project", "Lcom/intellij/openapi/project/Project;", "projectModelViewHost", "Lcom/jetbrains/resharper/projectView/ProjectModelViewHost;", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/resharper/projectView/ProjectModelViewHost;Lcom/jetbrains/rider/util/lifetime/Lifetime;)V", "buildEvents", "Lcom/jetbrains/resharper/build/ui/RiderBuildResultTreePanel;", "getBuildEvents", "()Lcom/jetbrains/resharper/build/ui/RiderBuildResultTreePanel;", "console", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "getConsole", "()Lcom/intellij/execution/impl/ConsoleViewImpl;", "container", "Ljavax/swing/JPanel;", "currentOccurrenceNavigator", "<set-?>", "", "hasErrors", "getHasErrors", "()Z", "setHasErrors", "(Z)V", "hasEvents", "getHasEvents", "setHasEvents", "isConsoleActivated", "setConsoleActivated", "layout", "Ljava/awt/CardLayout;", "addBuildEvent", "", "buildEvent", "Lcom/jetbrains/rider/model/BuildEvent;", "addOutputMessage", "message", "", "messageKind", "Lcom/jetbrains/rider/model/BuildMessageKind;", "addStatusMessage", "getNextOccurenceActionName", "getPreviousOccurenceActionName", "goNextOccurence", "Lcom/intellij/ide/OccurenceNavigator$OccurenceInfo;", "goPreviousOccurence", "hasNextOccurence", "hasPreviousOccurence", "messageKindToConsoleContentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "type", "showConsole", "showEvents", "Companion", "rider"})
public final class BuildResultPanel
extends SimpleToolWindowPanel
implements OccurenceNavigator {
    @NotNull
    private final ConsoleViewImpl console;
    @NotNull
    private final RiderBuildResultTreePanel buildEvents;
    private boolean isConsoleActivated;
    private boolean hasErrors;
    private boolean hasEvents;
    private OccurenceNavigator currentOccurrenceNavigator;
    private final CardLayout layout;
    private final JPanel container;
    private static final String consolePanelName = "console";
    private static final String buildEventsPanelName = "events";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ConsoleViewImpl getConsole() {
        return this.console;
    }

    @NotNull
    public final RiderBuildResultTreePanel getBuildEvents() {
        return this.buildEvents;
    }

    public final boolean isConsoleActivated() {
        return this.isConsoleActivated;
    }

    private final void setConsoleActivated(boolean bl) {
        this.isConsoleActivated = bl;
    }

    public final boolean getHasErrors() {
        return this.hasErrors;
    }

    private final void setHasErrors(boolean bl) {
        this.hasErrors = bl;
    }

    public final boolean getHasEvents() {
        return this.hasEvents;
    }

    private final void setHasEvents(boolean bl) {
        this.hasEvents = bl;
    }

    public final void showConsole() {
        if (this.isConsoleActivated) {
            return;
        }
        this.currentOccurrenceNavigator = this.console;
        this.layout.show(this.container, BuildResultPanel.Companion.getConsolePanelName());
        this.isConsoleActivated = true;
    }

    public final void showEvents() {
        if (!this.isConsoleActivated) {
            return;
        }
        this.currentOccurrenceNavigator = this.buildEvents;
        this.layout.show(this.container, BuildResultPanel.Companion.getBuildEventsPanelName());
        this.isConsoleActivated = false;
    }

    public final void addBuildEvent(@NotNull BuildEvent buildEvent) {
        Intrinsics.checkParameterIsNotNull((Object)buildEvent, (String)"buildEvent");
        this.buildEvents.addBuildEvent(buildEvent);
        if (!this.hasEvents) {
            this.hasEvents = true;
        }
        if (!this.hasErrors && Intrinsics.areEqual((Object)((Object)buildEvent.getKind()), (Object)((Object)BuildEventKind.Error))) {
            this.hasErrors = true;
        }
    }

    private final ConsoleViewContentType messageKindToConsoleContentType(BuildMessageKind type) {
        ConsoleViewContentType consoleViewContentType;
        switch (BuildResultPanel$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                ConsoleViewContentType consoleViewContentType2 = ConsoleViewContentType.ERROR_OUTPUT;
                consoleViewContentType = consoleViewContentType2;
                Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType2, (String)"ConsoleViewContentType.ERROR_OUTPUT");
                break;
            }
            case 2: {
                ConsoleViewContentType consoleViewContentType3 = ConsoleViewContentType.NORMAL_OUTPUT;
                consoleViewContentType = consoleViewContentType3;
                Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType3, (String)"ConsoleViewContentType.NORMAL_OUTPUT");
                break;
            }
            case 3: {
                ConsoleViewContentType consoleViewContentType4 = ConsoleViewContentType.NORMAL_OUTPUT;
                consoleViewContentType = consoleViewContentType4;
                Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType4, (String)"ConsoleViewContentType.NORMAL_OUTPUT");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return consoleViewContentType;
    }

    public final void addOutputMessage(@NotNull String message2, @NotNull BuildMessageKind messageKind) {
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)((Object)messageKind), (String)"messageKind");
        this.console.print(message2, this.messageKindToConsoleContentType(messageKind));
    }

    public final void addStatusMessage(@NotNull String message2) {
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        this.console.print(message2, this.hasErrors ? ConsoleViewContentType.ERROR_OUTPUT : ConsoleViewContentType.NORMAL_OUTPUT);
    }

    public boolean hasNextOccurence() {
        OccurenceNavigator occurenceNavigator = this.currentOccurrenceNavigator;
        if (occurenceNavigator == null) {
            return false;
        }
        OccurenceNavigator navigator = occurenceNavigator;
        return navigator.hasNextOccurence();
    }

    public boolean hasPreviousOccurence() {
        OccurenceNavigator occurenceNavigator = this.currentOccurrenceNavigator;
        if (occurenceNavigator == null) {
            return false;
        }
        OccurenceNavigator navigator = occurenceNavigator;
        return navigator.hasPreviousOccurence();
    }

    @Nullable
    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        OccurenceNavigator occurenceNavigator = this.currentOccurrenceNavigator;
        if (occurenceNavigator == null) {
            return null;
        }
        OccurenceNavigator navigator = occurenceNavigator;
        return navigator.goNextOccurence();
    }

    @Nullable
    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        OccurenceNavigator occurenceNavigator = this.currentOccurrenceNavigator;
        if (occurenceNavigator == null) {
            return null;
        }
        OccurenceNavigator navigator = occurenceNavigator;
        return navigator.goPreviousOccurence();
    }

    @Nullable
    public String getNextOccurenceActionName() {
        OccurenceNavigator occurenceNavigator = this.currentOccurrenceNavigator;
        if (occurenceNavigator == null) {
            return null;
        }
        OccurenceNavigator navigator = occurenceNavigator;
        return navigator.getNextOccurenceActionName();
    }

    @Nullable
    public String getPreviousOccurenceActionName() {
        OccurenceNavigator occurenceNavigator = this.currentOccurrenceNavigator;
        if (occurenceNavigator == null) {
            return null;
        }
        OccurenceNavigator navigator = occurenceNavigator;
        return navigator.getPreviousOccurenceActionName();
    }

    public BuildResultPanel(@NotNull Project project2, @NotNull ProjectModelViewHost projectModelViewHost, @NotNull Lifetime lifetime) {
        JPanel jPanel;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)projectModelViewHost, (String)"projectModelViewHost");
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        super(false);
        ConsoleView consoleView = TextConsoleBuilderFactory.getInstance().createBuilder(project2).getConsole();
        if (consoleView == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.execution.impl.ConsoleViewImpl");
        }
        this.console = (ConsoleViewImpl)consoleView;
        this.buildEvents = new RiderBuildResultTreePanel(project2, projectModelViewHost);
        this.layout = new CardLayout();
        Disposer.register((Disposable)((Disposable)project2), (Disposable)((Disposable)this.console));
        this.setProvideQuickActions(true);
        JPanel jPanel2 = new JPanel(this.layout);
        BuildResultPanel buildResultPanel = this;
        JPanel $receiver = jPanel2;
        $receiver.add((Component)this.console.getComponent(), BuildResultPanel.Companion.getConsolePanelName());
        $receiver.add((Component)((Object)this.buildEvents), BuildResultPanel.Companion.getBuildEventsPanelName());
        buildResultPanel.container = jPanel = jPanel2;
        this.showConsole();
        this.setContent(this.container);
        lifetime.add((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.getConsole().dispose();
            }
        }));
    }

    static {
        consolePanelName = consolePanelName;
        buildEventsPanelName = buildEventsPanelName;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/jetbrains/resharper/build/ui/BuildResultPanel$Companion;", "", "()V", "buildEventsPanelName", "", "getBuildEventsPanelName", "()Ljava/lang/String;", "consolePanelName", "getConsolePanelName", "rider"})
    public static final class Companion {
        private final String getConsolePanelName() {
            return consolePanelName;
        }

        private final String getBuildEventsPanelName() {
            return buildEventsPanelName;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

