/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.build.ui;

import com.intellij.ide.CopyProvider;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.resharper.build.ui.RiderBuildResultTreeModel;
import com.jetbrains.resharper.build.ui.RiderBuildResultTreePanel$WhenMappings;
import com.jetbrains.resharper.projectView.ProjectModelViewHost;
import com.jetbrains.resharper.ui.RiderColor;
import com.jetbrains.resharper.ui.RiderUI;
import com.jetbrains.rider.model.BuildEvent;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u0019H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001dH\u0016J\b\u0010\u001f\u001a\u00020\u000eH\u0016J\b\u0010 \u001a\u00020\u000eH\u0016J\u0010\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010%\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/jetbrains/resharper/build/ui/RiderBuildResultTreePanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "Lcom/intellij/ide/OccurenceNavigator;", "Lcom/intellij/ide/CopyProvider;", "project", "Lcom/intellij/openapi/project/Project;", "projectModelViewHost", "Lcom/jetbrains/resharper/projectView/ProjectModelViewHost;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/resharper/projectView/ProjectModelViewHost;)V", "activeModel", "Lcom/jetbrains/resharper/build/ui/RiderBuildResultTreeModel;", "errors", "hasError", "", "warnings", "addBuildEvent", "", "buildEvent", "Lcom/jetbrains/rider/model/BuildEvent;", "getBackground", "Lcom/jetbrains/resharper/ui/RiderColor;", "getData", "", "dataId", "", "getNextOccurenceActionName", "getPreviousOccurenceActionName", "goNextOccurence", "Lcom/intellij/ide/OccurenceNavigator$OccurenceInfo;", "goPreviousOccurence", "hasNextOccurence", "hasPreviousOccurence", "isCopyEnabled", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isCopyVisible", "performCopy", "rider"})
public final class RiderBuildResultTreePanel
extends BorderLayoutPanel
implements DataProvider,
OccurenceNavigator,
CopyProvider {
    private boolean hasError;
    private final RiderBuildResultTreeModel errors;
    private final RiderBuildResultTreeModel warnings;
    private RiderBuildResultTreeModel activeModel;

    @NotNull
    public RiderColor getBackground() {
        return RiderUI.Companion.getUsualBackgroundColor();
    }

    public final void addBuildEvent(@NotNull BuildEvent buildEvent) {
        Intrinsics.checkParameterIsNotNull((Object)buildEvent, (String)"buildEvent");
        switch (RiderBuildResultTreePanel$WhenMappings.$EnumSwitchMapping$0[buildEvent.getKind().ordinal()]) {
            case 1: {
                if (!this.hasError) {
                    this.hasError = true;
                    this.remove(this.warnings.getTreeScrollPane());
                    this.addToCenter(this.errors.getTreeScrollPane());
                    this.activeModel = this.errors;
                }
                this.activeModel.addBuildEvent(buildEvent);
                break;
            }
            case 2: {
                if (this.hasError) break;
                this.activeModel.addBuildEvent(buildEvent);
            }
        }
    }

    public boolean hasNextOccurence() {
        return this.activeModel.getNavigator().hasNextOccurence();
    }

    public boolean hasPreviousOccurence() {
        return this.activeModel.getNavigator().hasPreviousOccurence();
    }

    @NotNull
    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.activeModel.getNavigator().goNextOccurence();
    }

    @NotNull
    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.activeModel.getNavigator().goPreviousOccurence();
    }

    @NotNull
    public String getNextOccurenceActionName() {
        return this.activeModel.getNavigator().getNextOccurenceActionName();
    }

    @NotNull
    public String getPreviousOccurenceActionName() {
        return this.activeModel.getNavigator().getPreviousOccurenceActionName();
    }

    @Nullable
    public Object getData(@Nullable String dataId) {
        return CommonDataKeys.NAVIGATABLE.is(dataId) ? this.activeModel.getNavigatableForSelected() : (PlatformDataKeys.COPY_PROVIDER.is(dataId) ? this : null);
    }

    public void performCopy(@NotNull DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        CharSequence charSequence = this.activeModel.getTextForCopy();
        if (!(charSequence.length() == 0)) {
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(this.activeModel.getTextForCopy()));
        }
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        CharSequence charSequence = this.activeModel.getTextForCopy();
        return !(charSequence.length() == 0);
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        return true;
    }

    public RiderBuildResultTreePanel(@NotNull Project project2, @NotNull ProjectModelViewHost projectModelViewHost) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)projectModelViewHost, (String)"projectModelViewHost");
        this.errors = new RiderBuildResultTreeModel(project2, projectModelViewHost);
        this.activeModel = this.warnings = new RiderBuildResultTreeModel(project2, projectModelViewHost);
        this.addToCenter(this.warnings.getTreeScrollPane());
    }
}

