/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.colorSchemes;

import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.DefaultColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.jetbrains.resharper.colorSchemes.ColorSchemesUtilKt;
import com.jetbrains.resharper.colorSchemes.RiderColorsSchemeAdapter;
import com.jetbrains.resharper.colorSchemes.RiderKnownSchemes;
import com.jetbrains.rider.model.highlighterRegistration.RiderKnownColorsSchemeModels;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\nH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\bH\u0002J\b\u0010\u000f\u001a\u00020\u0006H\u0016J\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/resharper/colorSchemes/RiderColorsSchemePatchingManager;", "Lcom/intellij/openapi/components/ApplicationComponent;", "colorsManager", "Lcom/intellij/openapi/editor/colors/EditorColorsManager;", "(Lcom/intellij/openapi/editor/colors/EditorColorsManager;)V", "disposeComponent", "", "findExistingScheme", "Lcom/intellij/openapi/editor/colors/impl/AbstractColorsScheme;", "schemeName", "", "getComponentName", "getParentSchemeIfNeeded", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "scheme", "initComponent", "patchIdeaColorsScheme", "source", "Lcom/jetbrains/resharper/colorSchemes/RiderColorsSchemeAdapter;", "Companion", "rider"})
public final class RiderColorsSchemePatchingManager
implements ApplicationComponent {
    private final EditorColorsManager colorsManager;
    private static final String COPY_PREFIX = "_@user_";
    private static final Logger logger;
    public static final Companion Companion;

    @NotNull
    public String getComponentName() {
        return "RiderColorsSchemePatchingManager";
    }

    public void initComponent() {
        EditorColorsScheme[] editorColorsSchemeArray = this.colorsManager.getAllSchemes();
        for (int i2 = 0; i2 < editorColorsSchemeArray.length; ++i2) {
            EditorColorsScheme parent;
            AbstractColorsScheme scheme2;
            EditorColorsScheme it = editorColorsSchemeArray[i2];
            if (it instanceof DefaultColorsScheme) continue;
            EditorColorsScheme editorColorsScheme = it;
            if (!(editorColorsScheme instanceof AbstractColorsScheme)) {
                editorColorsScheme = null;
            }
            if ((AbstractColorsScheme)editorColorsScheme == null) {
                continue;
            }
            if (this.getParentSchemeIfNeeded(scheme2) == null) {
                continue;
            }
            scheme2.setParent(parent);
        }
    }

    public void disposeComponent() {
    }

    private final EditorColorsScheme getParentSchemeIfNeeded(AbstractColorsScheme scheme2) {
        String parentName;
        if (!StringsKt.startsWith$default((String)scheme2.getName(), (String)RiderColorsSchemePatchingManager.Companion.getCOPY_PREFIX(), (boolean)false, (int)2, null)) {
            return null;
        }
        String string2 = scheme2.getName();
        int n2 = RiderColorsSchemePatchingManager.Companion.getCOPY_PREFIX().length();
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        string2 = parentName = string4;
        if (Intrinsics.areEqual((Object)string2, (Object)RiderKnownSchemes.INSTANCE.getReSharperLight().getName()) || Intrinsics.areEqual((Object)string2, (Object)RiderKnownSchemes.INSTANCE.getReSharperDark().getName()) || Intrinsics.areEqual((Object)string2, (Object)RiderKnownSchemes.INSTANCE.getVisualStudioLight().getName()) || Intrinsics.areEqual((Object)string2, (Object)RiderKnownSchemes.INSTANCE.getVisualStudioDark().getName())) {
            return this.colorsManager.getScheme(parentName);
        }
        return null;
    }

    @Nullable
    public final AbstractColorsScheme findExistingScheme(@NotNull String schemeName) {
        Object object;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)schemeName, (String)"schemeName");
            Object[] $receiver$iv = (Object[])RiderKnownColorsSchemeModels.values();
            for (int i2 = 0; i2 < $receiver$iv.length; ++i2) {
                Object element$iv = $receiver$iv[i2];
                RiderKnownColorsSchemeModels it = (RiderKnownColorsSchemeModels)((Object)element$iv);
                if (!Intrinsics.areEqual((Object)it.name(), (Object)schemeName)) continue;
                object = element$iv;
                break block2;
            }
            object = null;
        }
        RiderKnownColorsSchemeModels knownName = (RiderKnownColorsSchemeModels)((Object)object);
        String name = knownName != null ? ColorSchemesUtilKt.transformName(knownName) : schemeName;
        EditorColorsScheme scheme2 = this.colorsManager.getScheme(name);
        EditorColorsScheme editorColorsScheme = scheme2;
        if (!(editorColorsScheme instanceof AbstractColorsScheme)) {
            editorColorsScheme = null;
        }
        return (AbstractColorsScheme)editorColorsScheme;
    }

    public final void patchIdeaColorsScheme(@NotNull RiderColorsSchemeAdapter source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        AbstractColorsScheme scheme2 = this.findExistingScheme(source.getName());
        if (scheme2 == null) {
            RiderColorsSchemePatchingManager.Companion.getLogger().warn("ColorsScheme '" + source.getName() + "' is not found in IDEA, omitting the Scheme patching");
            return;
        }
        RiderColorsSchemePatchingManager.Companion.getLogger().debug("Start patching '" + source.getName() + "' scheme according to ReSharperHost's attributes");
        HashMap<TextAttributesKey, TextAttributes> explicitlyDefinedAttributes = ColorSchemesUtilKt.getSchemeOnlyAttributes(scheme2);
        Map map2 = source.getAllAttributesMap();
        for (Map.Entry entry : map2.entrySet()) {
            Object object;
            Object object2 = entry;
            TextAttributesKey key = (TextAttributesKey)object2.getKey();
            object2 = entry;
            TextAttributes attributes = (TextAttributes)object2.getValue();
            Object object3 = object = (object2 = (Map)explicitlyDefinedAttributes);
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
            }
            if (((Map)object3).containsKey(key)) {
                Logger $receiver$iv = RiderColorsSchemePatchingManager.Companion.getLogger();
                if (!$receiver$iv.isTraceEnabled()) continue;
                Logger logger = $receiver$iv;
                String string2 = "Skipping patching of '" + key + "'";
                logger.trace(string2);
                continue;
            }
            scheme2.setAttributes(key, attributes);
        }
    }

    public RiderColorsSchemePatchingManager(@NotNull EditorColorsManager colorsManager) {
        Intrinsics.checkParameterIsNotNull((Object)colorsManager, (String)"colorsManager");
        this.colorsManager = colorsManager;
    }

    static {
        Companion = new Companion(null);
        COPY_PREFIX = COPY_PREFIX;
        Logger logger = Logger.getInstance(RiderColorsSchemePatchingManager.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        RiderColorsSchemePatchingManager.logger = logger;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/resharper/colorSchemes/RiderColorsSchemePatchingManager$Companion;", "", "()V", "COPY_PREFIX", "", "getCOPY_PREFIX", "()Ljava/lang/String;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "rider"})
    public static final class Companion {
        private final String getCOPY_PREFIX() {
            return COPY_PREFIX;
        }

        private final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

