/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.completion;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.lookup.impl.LookupManagerImpl;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.CaretAdapter;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.jetbrains.resharper.completion.PreemptiveCompletionHost;
import com.jetbrains.resharper.completion.RiderCompletionSupport;
import com.jetbrains.resharper.completion.UtilsKt;
import com.jetbrains.resharper.document.DocumentExKt;
import com.jetbrains.resharper.editorActions.IRiderTypingListener;
import com.jetbrains.resharper.editorActions.RiderTypeHandlerManager;
import com.jetbrains.resharper.editorActions.RiderTypedHandler;
import com.jetbrains.resharper.editorActions.RiderTypedHandlersSupport;
import com.jetbrains.resharper.editors.TextControlHost;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import com.jetbrains.resharper.util.idea.ILifetimedComponent;
import com.jetbrains.resharper.util.idea.LifetimedComponent;
import com.jetbrains.rider.model.LastFocusedTextControl;
import com.jetbrains.rider.model.TextControlTuple;
import com.jetbrains.rider.model.TypeData;
import com.jetbrains.rider.util.lifetime.Lifetime;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 22\u00020\u00012\u00020\u0002:\u00012B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ \u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J(\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020%2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020)H\u0002J\u0010\u0010,\u001a\u00020'2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)H\u0002J \u00100\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u00101\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u00100\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)H\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u00063"}, d2={"Lcom/jetbrains/resharper/completion/CompletionSessionHeuristics;", "Lcom/intellij/openapi/components/AbstractProjectComponent;", "Lcom/jetbrains/resharper/util/idea/ILifetimedComponent;", "project", "Lcom/intellij/openapi/project/Project;", "textControlHost", "Lcom/jetbrains/resharper/editors/TextControlHost;", "completionHost", "Lcom/jetbrains/resharper/completion/PreemptiveCompletionHost;", "psiDocumentManager", "Lcom/intellij/psi/PsiDocumentManager;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/resharper/editors/TextControlHost;Lcom/jetbrains/resharper/completion/PreemptiveCompletionHost;Lcom/intellij/psi/PsiDocumentManager;)V", "getCompletionHost", "()Lcom/jetbrains/resharper/completion/PreemptiveCompletionHost;", "componentLifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "getComponentLifetime", "()Lcom/jetbrains/rider/util/lifetime/Lifetime;", "lastFocusedTextControl", "Lcom/jetbrains/rider/model/LastFocusedTextControl;", "getLastFocusedTextControl", "()Lcom/jetbrains/rider/model/LastFocusedTextControl;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getPsiDocumentManager", "()Lcom/intellij/psi/PsiDocumentManager;", "getTextControlHost", "()Lcom/jetbrains/resharper/editors/TextControlHost;", "charDoesntBreakSession", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "typedChar", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "handleCaretChange", "", "offset", "", "newPosition", "oldPosition", "scheduleCompletion", "reason", "", "shouldSaveByOffset", "shouldSaveCurrentSession", "charTyped", "Companion", "rider"})
public final class CompletionSessionHeuristics
extends AbstractProjectComponent
implements ILifetimedComponent {
    private final Logger logger;
    @NotNull
    private final Project project;
    @NotNull
    private final TextControlHost textControlHost;
    @NotNull
    private final PreemptiveCompletionHost completionHost;
    @NotNull
    private final PsiDocumentManager psiDocumentManager;
    public static final Companion Companion = new Companion(null);
    private final /* synthetic */ LifetimedComponent $$delegate_0;

    private final LastFocusedTextControl getLastFocusedTextControl() {
        TextControlTuple textControlTuple = this.textControlHost.getLastFocusedTextControl().getCurrentValue();
        return textControlTuple != null ? textControlTuple.getTextControl() : null;
    }

    private final void handleCaretChange(Editor editor, int offset, int newPosition, int oldPosition) {
        String string2;
        Logger logger;
        PsiFile psiFile;
        if (this.getLastFocusedTextControl() == null) {
            return;
        }
        Collection collection = editor.getCaretModel().getAllCarets();
        int caretCount = collection.size();
        if (caretCount > 1) {
            this.completionHost.terminateCurrentCompletion("More than one caret detected on caret change");
            return;
        }
        if (Intrinsics.areEqual((Object)editor, (Object)this.textControlHost.getFocusedEditor()) ^ true) {
            return;
        }
        PsiFile psiFile2 = this.psiDocumentManager.getPsiFile(editor.getDocument());
        if (psiFile2 == null) {
            return;
        }
        PsiFile psiFile3 = psiFile = psiFile2;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile3, (String)"psiFile");
        if (!RiderCompletionSupport.backendCompletionEnabled(psiFile3, offset)) {
            return;
        }
        Character typedChar = UtilsKt.getTypedChar(editor, oldPosition, newPosition);
        Logger $receiver$iv = this.logger;
        if ($receiver$iv.isTraceEnabled()) {
            logger = $receiver$iv;
            string2 = "Viewing new caret change. Typed Char is '" + typedChar + "'";
            logger.trace(string2);
        }
        if (this.shouldSaveByOffset(offset)) {
            $receiver$iv = this.logger;
            if ($receiver$iv.isTraceEnabled()) {
                logger = $receiver$iv;
                string2 = "Caret " + offset + " was moved within the active frontend completion. Don't interrupt the session...";
                logger.trace(string2);
            }
            return;
        }
        if (typedChar != null) {
            PsiFile psiFile4 = psiFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile4, (String)"psiFile");
            if (this.charDoesntBreakSession(psiFile4, typedChar.charValue(), editor)) {
                this.logger.trace("Caret was moved due to the simple letter typing. Don't interrupt the session...");
                return;
            }
        }
        this.scheduleCompletion("New completion session is coming for offset " + offset + " and char " + typedChar + ".");
    }

    private final void scheduleCompletion(String reason) {
        this.completionHost.tryScheduleCompletion(reason);
    }

    private final boolean charDoesntBreakSession(PsiFile psiFile, char typedChar, Editor editor) {
        return this.shouldSaveCurrentSession(psiFile, typedChar, editor);
    }

    private final boolean shouldSaveByOffset(int offset) {
        return LookupManagerImpl.getInstance(this.project).getActiveLookup() != null && this.shouldSaveCurrentSession(offset);
    }

    private final boolean shouldSaveCurrentSession(PsiFile psiFile, char charTyped, Editor editor) {
        boolean result2;
        RiderTypedHandler handler2;
        RiderTypedHandler riderTypedHandler = handler2 = RiderTypedHandlersSupport.Companion.getTypeHandler(psiFile, editor.getCaretModel().getOffset());
        boolean bl = result2 = riderTypedHandler != null ? riderTypedHandler.isCompletionTerminator(editor, charTyped) : RiderTypedHandler.Companion.getDefaultCompletionTerminators().contains(Character.valueOf(charTyped));
        return !result2;
    }

    private final boolean shouldSaveCurrentSession(int offset) {
        CompletionProgressIndicator completionProgressIndicator = CompletionServiceImpl.getCompletionService().getCurrentCompletion();
        if (completionProgressIndicator == null) {
            return false;
        }
        CompletionProgressIndicator currentCompletion = completionProgressIndicator;
        return currentCompletion.getOffsetMap().getOffset(CompletionInitializationContext.START_OFFSET) <= offset;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final TextControlHost getTextControlHost() {
        return this.textControlHost;
    }

    @NotNull
    public final PreemptiveCompletionHost getCompletionHost() {
        return this.completionHost;
    }

    @NotNull
    public final PsiDocumentManager getPsiDocumentManager() {
        return this.psiDocumentManager;
    }

    public CompletionSessionHeuristics(@NotNull Project project2, @NotNull TextControlHost textControlHost, @NotNull PreemptiveCompletionHost completionHost, @NotNull PsiDocumentManager psiDocumentManager) {
        Logger logger;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)textControlHost, (String)"textControlHost");
        Intrinsics.checkParameterIsNotNull((Object)completionHost, (String)"completionHost");
        Intrinsics.checkParameterIsNotNull((Object)psiDocumentManager, (String)"psiDocumentManager");
        super(project2);
        this.$$delegate_0 = new LifetimedComponent(project2);
        this.project = project2;
        this.textControlHost = textControlHost;
        this.completionHost = completionHost;
        this.psiDocumentManager = psiDocumentManager;
        CompletionSessionHeuristics completionSessionHeuristics = this;
        Logger logger2 = Logger.getInstance(CompletionSessionHeuristics.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        completionSessionHeuristics.logger = logger = logger2;
        final EditorEventMulticaster eventMulticaster = EditorFactory.getInstance().getEventMulticaster();
        final CaretAdapter adapter2 = new CaretAdapter(this){
            final /* synthetic */ CompletionSessionHeuristics this$0;

            public void caretPositionChanged(@Nullable CaretEvent e2) {
                ApplicationKt.getApplication().assertIsDispatchThread();
                if (e2 == null) {
                    return;
                }
                Editor editor = e2.getEditor();
                LogicalPosition newPosition = e2.getNewPosition();
                LogicalPosition oldPosition = e2.getOldPosition();
                Caret caret = e2.getCaret();
                if (caret == null) {
                    Intrinsics.throwNpe();
                }
                int eventOffset = caret.getOffset();
                Editor editor2 = editor;
                Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"editor");
                CompletionSessionHeuristics.access$handleCaretChange(this.this$0, editor2, eventOffset, editor.logicalPositionToOffset(newPosition), editor.logicalPositionToOffset(oldPosition));
            }

            public void caretAdded(@Nullable CaretEvent e2) {
                this.onAddRemove(e2);
            }

            public void caretRemoved(@Nullable CaretEvent e2) {
                this.onAddRemove(e2);
            }

            private final void onAddRemove(CaretEvent e2) {
                if (e2 == null) {
                    return;
                }
                Editor editor = e2.getEditor();
                Collection collection = editor.getCaretModel().getAllCarets();
                int caretCount = collection.size();
                if (caretCount > 1) {
                    this.this$0.getCompletionHost().terminateCurrentCompletion("More than one caret detected on caret change");
                }
            }
            {
                this.this$0 = $outer;
            }
        };
        final SelectionListener selectionListener2 = new SelectionListener(this){
            final /* synthetic */ CompletionSessionHeuristics this$0;

            public final void selectionChanged(SelectionEvent e2) {
                ApplicationKt.getApplication().assertIsDispatchThread();
                if (e2.getOldRange().isEmpty()) {
                    return;
                }
                if (e2 == null) {
                    return;
                }
                Editor editor = e2.getEditor();
                int newPosition = e2.getNewRange().getStartOffset();
                int oldPosition = e2.getOldRange().getStartOffset();
                int eventOffset = newPosition;
                Editor editor2 = editor;
                Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"editor");
                CompletionSessionHeuristics.access$handleCaretChange(this.this$0, editor2, eventOffset, newPosition, oldPosition);
            }
            {
                this.this$0 = completionSessionHeuristics;
            }
        };
        final DocumentListener documentListener2 = new DocumentListener(this){
            final /* synthetic */ CompletionSessionHeuristics this$0;

            public void documentChanged(@Nullable DocumentEvent event) {
                char c2;
                if (event == null) {
                    return;
                }
                if (DocumentExKt.getFirstEditableEntity(event.getDocument(), this.this$0.getProject()) == null) {
                    return;
                }
                if (event.getNewLength() == 1 && event.getOldLength() == 0 && Character.isLetterOrDigit(c2 = StringsKt.single((CharSequence)event.getNewFragment()))) {
                    return;
                }
                if (CompletionSessionHeuristics.access$shouldSaveByOffset(this.this$0, event.getOffset())) {
                    return;
                }
                CompletionSessionHeuristics.access$scheduleCompletion(this.this$0, "documentModel changed with param: " + event);
            }

            public void beforeDocumentChange(@Nullable DocumentEvent event) {
            }
            {
                this.this$0 = $outer;
            }
        };
        eventMulticaster.addSelectionListener(selectionListener2);
        eventMulticaster.addCaretListener((CaretListener)adapter2);
        eventMulticaster.addDocumentListener(documentListener2);
        this.getComponentLifetime().add((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                eventMulticaster.removeSelectionListener(selectionListener2);
                eventMulticaster.removeCaretListener((CaretListener)adapter2);
                eventMulticaster.removeDocumentListener(documentListener2);
            }
        }));
        this.project.getMessageBus().connect().subscribe(RiderTypeHandlerManager.Companion.getBEFORE_TYPING_SENT(), (Object)new IRiderTypingListener(){

            @Override
            public void beforeSendType(@NotNull TypeData typeData, @NotNull Editor editor) {
                Intrinsics.checkParameterIsNotNull((Object)typeData, (String)"typeData");
                Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
                Collection collection = editor.getCaretModel().getAllCarets();
                int caretCount = collection.size();
                if (caretCount > 1) {
                    this.getCompletionHost().terminateCurrentCompletion("typing with multiple carets or with active multi-range template");
                } else if (!typeData.isCompletionTerminator() && !this.getCompletionHost().getHasSession()) {
                    PsiFile psiFile;
                    PsiFile psiFile2 = this.getPsiDocumentManager().getPsiFile(editor.getDocument());
                    if (psiFile2 == null) {
                        String string2 = "cannot get psi file";
                        throw (Throwable)new IllegalStateException(string2.toString());
                    }
                    PsiFile psiFile3 = psiFile = psiFile2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiFile3, (String)"psiFile");
                    if (this.isTypingAfterTerminator(psiFile3, editor)) {
                        this.getCompletionHost().ensureCompletionIsRunning(CompletionType.BASIC);
                    }
                }
            }

            private final boolean isTypingAfterTerminator(PsiFile psiFile, Editor editor) {
                String string2;
                Logger logger;
                if (editor.getCaretModel().getOffset() == 0) {
                    return true;
                }
                Character c2 = UtilsKt.getTypedChar(editor, editor.getCaretModel().getOffset() - 1, editor.getCaretModel().getOffset());
                if (c2 == null) {
                    return true;
                }
                char c3 = c2.charValue();
                Logger $receiver$iv = logger;
                if ($receiver$iv.isTraceEnabled()) {
                    logger = $receiver$iv;
                    string2 = "isTypingAfterTerminator::typed char is " + c3;
                    logger.trace(string2);
                }
                boolean result2 = !this.charDoesntBreakSession(psiFile, c3, editor);
                Logger $receiver$iv2 = logger;
                if ($receiver$iv2.isTraceEnabled()) {
                    logger = $receiver$iv2;
                    string2 = "Previous char was :" + c3 + ". IsTerminator : " + result2 + " " + "\n" + " Full text is: '" + editor.getDocument().getText() + "' " + "\n" + " offset is '" + editor.getCaretModel().getOffset() + "'";
                    logger.trace(string2);
                }
                return result2;
            }
        });
    }

    static {
        CompletionProgressIndicator.setAutopopupTriggerTime(10);
    }

    @Override
    @NotNull
    public Lifetime getComponentLifetime() {
        return this.$$delegate_0.getComponentLifetime();
    }

    public static final /* synthetic */ void access$handleCaretChange(CompletionSessionHeuristics $this, @NotNull Editor editor, int offset, int newPosition, int oldPosition) {
        $this.handleCaretChange(editor, offset, newPosition, oldPosition);
    }

    public static final /* synthetic */ boolean access$shouldSaveByOffset(CompletionSessionHeuristics $this, int offset) {
        return $this.shouldSaveByOffset(offset);
    }

    public static final /* synthetic */ void access$scheduleCompletion(CompletionSessionHeuristics $this, @NotNull String reason) {
        $this.scheduleCompletion(reason);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/jetbrains/resharper/completion/CompletionSessionHeuristics$Companion;", "", "()V", "rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

