/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.resharper.completion.CompletionSessionState;
import com.jetbrains.resharper.completion.PreemptiveCompletionHost;
import com.jetbrains.resharper.completion.ReSharperLookupItem;
import com.jetbrains.resharper.completion.RiderCompletionSupport;
import com.jetbrains.resharper.completion.UtilsKt;
import com.jetbrains.resharper.document.DocumentExKt;
import com.jetbrains.resharper.editors.TextControlHost;
import com.jetbrains.resharper.editors.TextEditingGateway;
import com.jetbrains.resharper.icons.IconHost;
import com.jetbrains.resharper.internal.flags.IRiderInternalFlag;
import com.jetbrains.resharper.internal.flags.RiderInternalFlag;
import com.jetbrains.resharper.internal.flags.RiderInternalFlags;
import com.jetbrains.resharper.protocol.ApplicationProtocolKt;
import com.jetbrains.resharper.protocol.RdDispatcherExKt;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import com.jetbrains.resharper.util.idea.ILifetimedComponent;
import com.jetbrains.resharper.util.idea.LifetimedComponent;
import com.jetbrains.rider.model.CompletionItem;
import com.jetbrains.rider.model.CompletionList;
import com.jetbrains.rider.model.CompletionMode;
import com.jetbrains.rider.model.CompletionParameters;
import com.jetbrains.rider.model.CompletionSessionModel;
import com.jetbrains.rider.model.CompletionTuple;
import com.jetbrains.rider.model.FocusBehaviour;
import com.jetbrains.rider.model.GatewayState;
import com.jetbrains.rider.model.LastFocusedTextControl;
import com.jetbrains.rider.model.SessionState;
import com.jetbrains.rider.model.TextControlTuple;
import com.jetbrains.rider.util.EmptyIDisposable;
import com.jetbrains.rider.util.IDisposable;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.lifetime.LifetimeDefinition;
import com.jetbrains.rider.util.reactive.IReadonlyProperty;
import com.jetbrains.rider.util.reactive.IViewable;
import com.jetbrains.rider.util.reactive.PropertyExKt;
import com.jetbrains.rider.util.wrappers.Session;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.OperationNotSupportedException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002:\u0001UB-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0016\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0012J>\u00105\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u00122\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u000201072\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001807J(\u00109\u001a\u00020\u00102\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u0012H\u0002J\u001e\u0010A\u001a\u0002012\u0006\u00102\u001a\u0002032\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u000e\u0010C\u001a\u0002012\u0006\u0010D\u001a\u00020EJ\r\u0010F\u001a\u00020GH\u0000\u00a2\u0006\u0002\bHJ\b\u0010I\u001a\u00020JH\u0016J\u0006\u0010K\u001a\u00020\u0016J\u0014\u0010L\u001a\u0002012\f\u0010M\u001a\b\u0012\u0004\u0012\u0002010NJ\u0010\u0010O\u001a\u0002012\u0006\u0010P\u001a\u00020EH\u0002J\u000e\u0010Q\u001a\u0002012\u0006\u0010R\u001a\u00020JJ\b\u0010S\u001a\u000201H\u0002J\u000e\u0010T\u001a\u0002012\u0006\u0010R\u001a\u00020JR\u001a\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00020\u0012X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0012\u0010\u0015\u001a\u00020\u00168\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\"\u001a\n $*\u0004\u0018\u00010#0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00180)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010*\u001a\u00020+8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lcom/jetbrains/resharper/completion/PreemptiveCompletionHost;", "Lcom/intellij/openapi/components/AbstractProjectComponent;", "Lcom/jetbrains/resharper/util/idea/ILifetimedComponent;", "project", "Lcom/intellij/openapi/project/Project;", "iconHost", "Lcom/jetbrains/resharper/icons/IconHost;", "textControlHost", "Lcom/jetbrains/resharper/editors/TextControlHost;", "textEditingGateway", "Lcom/jetbrains/resharper/editors/TextEditingGateway;", "internalFlags", "Lcom/jetbrains/resharper/internal/flags/RiderInternalFlags;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/resharper/icons/IconHost;Lcom/jetbrains/resharper/editors/TextControlHost;Lcom/jetbrains/resharper/editors/TextEditingGateway;Lcom/jetbrains/resharper/internal/flags/RiderInternalFlags;)V", "advancedLookupItems", "Lcom/intellij/util/containers/ImmutableList;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "componentLifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "getComponentLifetime", "()Lcom/jetbrains/rider/util/lifetime/Lifetime;", "focusBehaviour", "Lcom/jetbrains/rider/model/FocusBehaviour;", "hasSession", "", "getHasSession", "()Z", "lastFocusedTextControl", "Lcom/jetbrains/rider/model/LastFocusedTextControl;", "getLastFocusedTextControl", "()Lcom/jetbrains/rider/model/LastFocusedTextControl;", "lightLookupItems", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "preemptiveCompletionQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "kotlin.jvm.PlatformType", "saveSession", "sessionId", "Ljava/util/concurrent/atomic/AtomicInteger;", "shouldBeTriggeredFlag", "Lcom/jetbrains/resharper/internal/flags/RiderInternalFlag;", "state", "Lcom/jetbrains/resharper/completion/CompletionSessionState;", "getState$rider", "()Lcom/jetbrains/resharper/completion/CompletionSessionState;", "setState$rider", "(Lcom/jetbrains/resharper/completion/CompletionSessionState;)V", "consumeAdvancedItems", "", "consumer", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "consumerLifetime", "consumeLightItemsSetFocus", "focusDegreeAction", "Lkotlin/Function1;", "passesFilter", "createLookupItem", "completionItem", "Lcom/jetbrains/rider/model/CompletionItem;", "completionSessionModel", "Lcom/jetbrains/rider/model/CompletionSessionModel;", "priority", "", "currentSessionLifetime", "dumpCurrentState", "lightItemsRef", "ensureCompletionIsRunning", "completionType", "Lcom/intellij/codeInsight/completion/CompletionType;", "getCompleteItemCookie", "Lcom/jetbrains/rider/util/IDisposable;", "getCompleteItemCookie$rider", "getComponentName", "", "getCurrentFocusBehaviour", "onCurrentSessionTerminated", "action", "Lkotlin/Function0;", "restartRightAway", "type", "terminateCurrentCompletion", "reason", "terminateIfEmpty", "tryScheduleCompletion", "CompleteItemCookie", "rider"})
public final class PreemptiveCompletionHost
extends AbstractProjectComponent
implements ILifetimedComponent {
    private final Logger logger;
    private final AtomicInteger sessionId;
    private boolean saveSession;
    private final MergingUpdateQueue preemptiveCompletionQueue;
    private volatile ImmutableList<LookupElement> lightLookupItems;
    private volatile ImmutableList<LookupElement> advancedLookupItems;
    private volatile FocusBehaviour focusBehaviour;
    @NotNull
    private volatile CompletionSessionState state;
    private final RiderInternalFlag<Boolean> shouldBeTriggeredFlag;
    private final Project project;
    private final IconHost iconHost;
    private final TextControlHost textControlHost;
    private final TextEditingGateway textEditingGateway;
    private final /* synthetic */ LifetimedComponent $$delegate_0;

    private final LastFocusedTextControl getLastFocusedTextControl() {
        TextControlTuple textControlTuple = this.textControlHost.getLastFocusedTextControl().getCurrentValue();
        return textControlTuple != null ? textControlTuple.getTextControl() : null;
    }

    @NotNull
    public final CompletionSessionState getState$rider() {
        return this.state;
    }

    public final void setState$rider(@NotNull CompletionSessionState completionSessionState) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)completionSessionState), (String)"<set-?>");
        this.state = completionSessionState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ensureCompletionIsRunning(@NotNull CompletionType completionType) {
        Object shouldRestart;
        Intrinsics.checkParameterIsNotNull((Object)completionType, (String)"completionType");
        this.logger.trace("ensureCompletionIsRunning: start");
        ApplicationKt.getApplication().assertIsDispatchThread();
        Object object = this.getLastFocusedTextControl();
        if (object == null || (object = ((LastFocusedTextControl)object).getCompletionSession()) == null) {
            return;
        }
        Object completionSession = object;
        CompletionTuple completionTuple = (CompletionTuple)PropertyExKt.getValueOrNull((IReadonlyProperty)completionSession);
        CompletionParameters currentCompletionMode = completionTuple != null ? completionTuple.getParameters() : null;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        PreemptiveCompletionHost preemptiveCompletionHost = this;
        synchronized (preemptiveCompletionHost) {
            shouldRestart.element = Intrinsics.areEqual((Object)((Object)this.state), (Object)((Object)CompletionSessionState.Inactive)) || currentCompletionMode == null || Intrinsics.areEqual((Object)((Object)currentCompletionMode.getMode()), (Object)((Object)UtilsKt.toModel(completionType))) ^ true;
            Unit unit = Unit.INSTANCE;
        }
        if (shouldRestart.element) {
            CompletionParameters completionParameters = currentCompletionMode;
            this.terminateCurrentCompletion("'Ensure completion is running' reschedules the completion. State : " + (Object)((Object)this.state) + ", CurrentCompletionMode: " + (Object)((Object)(completionParameters != null ? completionParameters.getMode() : null)) + ", Requested Completion Type: " + completionType);
            this.restartRightAway(completionType);
        }
        shouldRestart = null;
    }

    public final void tryScheduleCompletion(@NotNull String reason) {
        Intrinsics.checkParameterIsNotNull((Object)reason, (String)"reason");
        if (this.saveSession) {
            return;
        }
        this.terminateCurrentCompletion(reason);
        this.logger.trace("queueing preemptive background completion...");
        this.preemptiveCompletionQueue.queue(new Update(this, "perform preemptive completion"){
            final /* synthetic */ PreemptiveCompletionHost this$0;

            public void run() {
                PreemptiveCompletionHost.access$restartRightAway(this.this$0, CompletionType.BASIC);
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void restartRightAway(CompletionType type) {
        ApplicationKt.getApplication().assertIsDispatchThread();
        if (!this.shouldBeTriggeredFlag.getValue().booleanValue()) {
            return;
        }
        if (Intrinsics.areEqual((Object)((Object)this.textEditingGateway.getGatewayState().getValue()), (Object)((Object)GatewayState.SyncFromBackend))) {
            return;
        }
        Editor editor = this.textControlHost.getFocusedEditor();
        if (editor == null) {
            return;
        }
        Editor focusedEditor = editor;
        if (!RiderCompletionSupport.backendCompletionEnabled$default(focusedEditor, 0, 2, null)) {
            return;
        }
        LastFocusedTextControl lastFocusedTextControl = this.getLastFocusedTextControl();
        if (lastFocusedTextControl == null) {
            return;
        }
        LastFocusedTextControl lastFocusedEditorModel = lastFocusedTextControl;
        this.preemptiveCompletionQueue.cancelAllUpdates();
        Lifetime lastFocusedTextControlLifetime = this.textControlHost.getLastFocusedTextControl().getCurrentLifetime();
        CompletionMode completionMode = UtilsKt.toCompletionMode(type);
        CompletionSessionModel completionSessionModel = new CompletionSessionModel();
        CompletionParameters completionParameters = new CompletionParameters(completionMode, true, focusedEditor.getCaretModel().getOffset());
        Session<CompletionTuple> completionSession = new Session<CompletionTuple>(lastFocusedEditorModel.getCompletionSession());
        Logger $receiver$iv = this.logger;
        if ($receiver$iv.isTraceEnabled()) {
            Logger logger = $receiver$iv;
            String string2 = "Start completion session #" + this.sessionId.incrementAndGet() + " for offset " + focusedEditor.getCaretModel().getOffset() + " and type " + type;
            logger.trace(string2);
        }
        Lifetime sessionLifetime = completionSession.refresh(new CompletionTuple(completionParameters, completionSessionModel), lastFocusedTextControlLifetime);
        PreemptiveCompletionHost preemptiveCompletionHost = this;
        synchronized (preemptiveCompletionHost) {
            this.state = CompletionSessionState.InProgress;
            Unit unit = Unit.INSTANCE;
        }
        sessionLifetime.add((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ PreemptiveCompletionHost this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                PreemptiveCompletionHost.access$getLogger$p(this.this$0).trace("sessionLifetimeDefinition is terminated");
                PreemptiveCompletionHost preemptiveCompletionHost = this.this$0;
                synchronized (preemptiveCompletionHost) {
                    this.this$0.setState$rider(CompletionSessionState.Inactive);
                    PreemptiveCompletionHost.access$setLightLookupItems$p(this.this$0, null);
                    PreemptiveCompletionHost.access$setFocusBehaviour$p(this.this$0, FocusBehaviour.Hard);
                    PreemptiveCompletionHost.access$setAdvancedLookupItems$p(this.this$0, null);
                    Unit unit = Unit.INSTANCE;
                }
            }
            {
                this.this$0 = preemptiveCompletionHost;
                super(0);
            }
        }));
        completionSessionModel.getLightCompletionItems().adviseOn(sessionLifetime, RdDispatcherExKt.getBackgroundScheduler(ApplicationProtocolKt.getProtocol(this.project).getScheduler()), (Function1<CompletionList, Unit>)((Function1)new Function1<CompletionList, Unit>(this, completionSessionModel, sessionLifetime){
            final /* synthetic */ PreemptiveCompletionHost this$0;
            final /* synthetic */ CompletionSessionModel $completionSessionModel;
            final /* synthetic */ Lifetime $sessionLifetime;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke(@NotNull CompletionList completionList) {
                void $receiver$iv;
                String string2;
                Object object;
                Object object2;
                Intrinsics.checkParameterIsNotNull((Object)completionList, (String)"completionList");
                List<CompletionItem> lightModelItems = completionList.getItems();
                Logger $receiver$iv2 = PreemptiveCompletionHost.access$getLogger$p(this.this$0);
                if ($receiver$iv2.isTraceEnabled()) {
                    object2 = $receiver$iv2;
                    object = lightModelItems;
                    StringBuilder stringBuilder = new StringBuilder().append("Fetching basic items... ");
                    int n2 = object.size();
                    string2 = stringBuilder.append(n2).append(" items received").toString();
                    object2.trace(string2);
                }
                object = lightModelItems;
                Collection destination$iv = new LinkedList<E>();
                for (T item$iv : $receiver$iv) {
                    void it;
                    CompletionItem $i$f$trace = (CompletionItem)item$iv;
                    object2 = destination$iv;
                    string2 = PreemptiveCompletionHost.access$createLookupItem(this.this$0, (CompletionItem)it, this.$completionSessionModel, it.getPriority(), this.$sessionLifetime);
                    object2.add(string2);
                }
                LinkedList lookupItems = (LinkedList)destination$iv;
                object = this.this$0;
                synchronized (object) {
                    if (Intrinsics.areEqual((Object)((Object)this.this$0.getState$rider()), (Object)((Object)CompletionSessionState.Inactive))) {
                        return;
                    }
                    PreemptiveCompletionHost.access$setLightLookupItems$p(this.this$0, ContainerUtil.immutableList((List)lookupItems));
                    this.this$0.setState$rider(CompletionSessionState.LightCompleted);
                    Unit unit = Unit.INSTANCE;
                }
                PreemptiveCompletionHost.access$getLogger$p(this.this$0).trace("done fetching basic items.");
            }
            {
                this.this$0 = preemptiveCompletionHost;
                this.$completionSessionModel = completionSessionModel;
                this.$sessionLifetime = lifetime;
                super(1);
            }
        }));
        completionSessionModel.getAdvancedItems().adviseOn(sessionLifetime, RdDispatcherExKt.getBackgroundScheduler(ApplicationProtocolKt.getProtocol(this.project).getScheduler()), (Function1<CompletionList, Unit>)((Function1)new Function1<CompletionList, Unit>(this, completionSessionModel, sessionLifetime){
            final /* synthetic */ PreemptiveCompletionHost this$0;
            final /* synthetic */ CompletionSessionModel $completionSessionModel;
            final /* synthetic */ Lifetime $sessionLifetime;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke(@NotNull CompletionList completionList) {
                void $receiver$iv;
                String string2;
                Object object;
                Object object2;
                Intrinsics.checkParameterIsNotNull((Object)completionList, (String)"completionList");
                List<CompletionItem> fullCompletionList = completionList.getItems();
                Logger $receiver$iv2 = PreemptiveCompletionHost.access$getLogger$p(this.this$0);
                if ($receiver$iv2.isTraceEnabled()) {
                    object2 = $receiver$iv2;
                    object = fullCompletionList;
                    StringBuilder stringBuilder = new StringBuilder().append("Fetching advanced items... ");
                    int n2 = object.size();
                    string2 = stringBuilder.append(n2).append(" items received").toString();
                    object2.trace(string2);
                }
                object = fullCompletionList;
                Collection destination$iv = new LinkedList<E>();
                for (T item$iv : $receiver$iv) {
                    void it;
                    CompletionItem $i$f$trace = (CompletionItem)item$iv;
                    object2 = destination$iv;
                    string2 = PreemptiveCompletionHost.access$createLookupItem(this.this$0, (CompletionItem)it, this.$completionSessionModel, it.getPriority(), this.$sessionLifetime);
                    object2.add(string2);
                }
                LinkedList lookupItems = (LinkedList)destination$iv;
                object = this.this$0;
                synchronized (object) {
                    if (Intrinsics.areEqual((Object)((Object)this.this$0.getState$rider()), (Object)((Object)CompletionSessionState.Inactive))) {
                        return;
                    }
                    PreemptiveCompletionHost.access$setAdvancedLookupItems$p(this.this$0, ContainerUtil.immutableList((List)lookupItems));
                    this.this$0.setState$rider(CompletionSessionState.Completed);
                    Unit unit = Unit.INSTANCE;
                }
                ApplicationKt.getApplication().invokeLater(new Runnable(this){
                    final /* synthetic */ restartRightAway.5 this$0;

                    public final void run() {
                        PreemptiveCompletionHost.access$terminateIfEmpty(this.this$0.this$0);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                PreemptiveCompletionHost.access$getLogger$p(this.this$0).trace("done fetching advanced items.");
            }
            {
                this.this$0 = preemptiveCompletionHost;
                this.$completionSessionModel = completionSessionModel;
                this.$sessionLifetime = lifetime;
                super(1);
            }
        }));
        completionSessionModel.isSoft().adviseOn(sessionLifetime, RdDispatcherExKt.getBackgroundScheduler(ApplicationProtocolKt.getProtocol(this.project).getScheduler()), (Function1<FocusBehaviour, Unit>)((Function1)new Function1<FocusBehaviour, Unit>(this){
            final /* synthetic */ PreemptiveCompletionHost this$0;

            public final void invoke(@NotNull FocusBehaviour backendValue) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)backendValue), (String)"backendValue");
                Logger $receiver$iv = PreemptiveCompletionHost.access$getLogger$p(this.this$0);
                if ($receiver$iv.isTraceEnabled()) {
                    Logger logger = $receiver$iv;
                    String string2 = "Got focusBehaviour == " + (Object)((Object)backendValue);
                    logger.trace(string2);
                }
                PreemptiveCompletionHost.access$setFocusBehaviour$p(this.this$0, backendValue);
            }
            {
                this.this$0 = preemptiveCompletionHost;
                super(1);
            }
        }));
        completionSessionModel.getSessionState().advise(sessionLifetime, (Function1<SessionState, Unit>)((Function1)new Function1<SessionState, Unit>(this){
            final /* synthetic */ PreemptiveCompletionHost this$0;

            public final void invoke(@NotNull SessionState param) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)param), (String)"param");
                if (Intrinsics.areEqual((Object)((Object)param), (Object)((Object)SessionState.ReturnedNull))) {
                    this.this$0.terminateCurrentCompletion("Got empty results list from the backend");
                }
            }
            {
                this.this$0 = preemptiveCompletionHost;
                super(1);
            }
        }));
        PropertyExKt.set(completionSessionModel.getAdvancedItemsContainer(), true);
        this.textEditingGateway.closeToBackend(sessionLifetime, "Suppression for completion offset " + focusedEditor.getCaretModel().getOffset() + " for " + DocumentExKt.getTextControlId(focusedEditor));
    }

    private final void terminateIfEmpty() {
        ApplicationKt.getApplication().assertIsDispatchThread();
        if (Intrinsics.areEqual((Object)((Object)this.state), (Object)((Object)CompletionSessionState.Completed)) && UtilKt.isNullOrEmpty((Collection)this.lightLookupItems) && UtilKt.isNullOrEmpty((Collection)this.advancedLookupItems)) {
            this.terminateCurrentCompletion("Backend has calculated the completion list and there are 0 items.");
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void consumeLightItemsSetFocus(@NotNull CompletionResultSet consumer2, @NotNull Lifetime consumerLifetime, @NotNull Function1<? super FocusBehaviour, Unit> focusDegreeAction, @NotNull Function1<? super LookupElement, Boolean> passesFilter) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)consumer2, (String)"consumer");
        Intrinsics.checkParameterIsNotNull((Object)consumerLifetime, (String)"consumerLifetime");
        Intrinsics.checkParameterIsNotNull(focusDegreeAction, (String)"focusDegreeAction");
        Intrinsics.checkParameterIsNotNull(passesFilter, (String)"passesFilter");
        this.logger.trace("consuming light items. Wait for items to be fetched....");
        boolean $receiver$iv2 = this.getHasSession();
        if (!$receiver$iv2) {
            return;
        }
        UtilsKt.waitForResults(this, consumerLifetime, CompletionSessionState.LightCompleted);
        this.logger.trace("Light items fetched. Consuming them....");
        focusDegreeAction.invoke((Object)this.focusBehaviour);
        ImmutableList<LookupElement> immutableList = this.lightLookupItems;
        if (immutableList == null) {
            return;
        }
        ImmutableList<LookupElement> lightItemsRef = immutableList;
        this.dumpCurrentState(consumer2, lightItemsRef);
        Iterable $i$a$1$onFalse = (Iterable)lightItemsRef;
        CompletionResultSet completionResultSet = consumer2;
        void $i$f$onFalse = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            LookupElement it;
            LookupElement lookupElement = it = (LookupElement)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)lookupElement, (String)"it");
            if (!((Boolean)passesFilter.invoke((Object)lookupElement)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        completionResultSet.addAllElements((Iterable)list2);
        this.logger.trace("Light items consumed");
    }

    /*
     * WARNING - void declaration
     */
    private final void dumpCurrentState(CompletionResultSet consumer2, ImmutableList<LookupElement> lightItemsRef) {
        void $receiver$iv;
        String initial$iv;
        this.logger.trace("Dumping items:");
        Iterable iterable = CollectionsKt.take((Iterable)((Iterable)lightItemsRef), (int)40);
        String accumulator$iv = initial$iv = "\n";
        for (Object element$iv : $receiver$iv) {
            void lookupElement;
            LookupElement lookupElement2 = (LookupElement)element$iv;
            String s2 = accumulator$iv;
            accumulator$iv = s2 + ("'" + lookupElement.getLookupString() + "'") + "\n";
        }
        String dump = accumulator$iv;
        this.logger.trace(dump);
        LookupElement lookupElement = (LookupElement)CollectionsKt.lastOrNull((List)((List)lightItemsRef));
        this.logger.trace("last item is " + (lookupElement != null ? lookupElement.getLookupString() : null));
    }

    public final void consumeAdvancedItems(@NotNull CompletionResultSet consumer2, @NotNull Lifetime consumerLifetime) {
        Intrinsics.checkParameterIsNotNull((Object)consumer2, (String)"consumer");
        Intrinsics.checkParameterIsNotNull((Object)consumerLifetime, (String)"consumerLifetime");
        this.logger.trace("consuming advanced items. Wait for items to be fetched....");
        boolean $receiver$iv = this.getHasSession();
        if (!$receiver$iv) {
            return;
        }
        UtilsKt.waitForResults(this, consumerLifetime, CompletionSessionState.Completed);
        this.logger.trace("Advanced items fetched. Consuming them....");
        ImmutableList<LookupElement> immutableList = this.advancedLookupItems;
        if (immutableList == null) {
            return;
        }
        ImmutableList<LookupElement> advancedItemsRef = immutableList;
        this.dumpCurrentState(consumer2, advancedItemsRef);
        consumer2.addAllElements((Iterable)advancedItemsRef);
        this.logger.trace("Advanced items consumed");
    }

    private final LookupElement createLookupItem(CompletionItem completionItem, CompletionSessionModel completionSessionModel, double priority, Lifetime currentSessionLifetime) {
        ReSharperLookupItem reSharperLookupItem = new ReSharperLookupItem(completionItem, completionSessionModel.getComplete(), this.project, this.iconHost, this.logger, currentSessionLifetime);
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)reSharperLookupItem, (double)priority);
        Intrinsics.checkExpressionValueIsNotNull((Object)lookupElement, (String)"PrioritizedLookupElement\u2026rperLookupItem, priority)");
        return lookupElement;
    }

    @NotNull
    public final IDisposable getCompleteItemCookie$rider() {
        ApplicationKt.getApplication().assertIsDispatchThread();
        boolean $receiver$iv = this.getHasSession();
        if (!$receiver$iv) {
            return EmptyIDisposable.Companion.getInstance();
        }
        return new CompleteItemCookie(this);
    }

    @NotNull
    public String getComponentName() {
        return "PreemptiveCompletionHost";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean getHasSession() {
        PreemptiveCompletionHost preemptiveCompletionHost = this;
        synchronized (preemptiveCompletionHost) {
            boolean bl = this.state.compareTo((Enum)CompletionSessionState.Inactive) > 0;
            return bl;
        }
    }

    public final void terminateCurrentCompletion(@NotNull String reason) {
        block2: {
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)reason, (String)"reason");
            ApplicationKt.getApplication().assertIsDispatchThread();
            if (this.saveSession) {
                this.logger.trace("trying to terminate current session while completing an item");
                return;
            }
            Logger $receiver$iv = this.logger;
            if ($receiver$iv.isTraceEnabled()) {
                Logger logger = $receiver$iv;
                String string2 = "Completion session is about to be terminated. Reason:" + "\n" + " " + reason;
                logger.trace(string2);
            }
            if ((object = this.getLastFocusedTextControl()) == null || (object = ((LastFocusedTextControl)object).getCompletionSession()) == null) break block2;
            object.setValue(null);
        }
    }

    public final void onCurrentSessionTerminated(@NotNull Function0<Unit> action2) {
        Intrinsics.checkParameterIsNotNull(action2, (String)"action");
        Object object = this.getLastFocusedTextControl();
        if (object == null || (object = ((LastFocusedTextControl)object).getCompletionSession()) == null) {
            String string2 = "you cannot call this api without completion session";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        Object value2 = object;
        LifetimeDefinition def = this.getComponentLifetime().createNestedDef();
        PropertyExKt.viewNotNull((IViewable)value2, def.getLifetime(), (Function2)new Function2<Lifetime, CompletionTuple, Unit>(action2, def){
            final /* synthetic */ Function0 $action;
            final /* synthetic */ LifetimeDefinition $def;

            public final void invoke(@NotNull Lifetime sessionLifetime, @NotNull CompletionTuple completionTuple) {
                Intrinsics.checkParameterIsNotNull((Object)sessionLifetime, (String)"sessionLifetime");
                Intrinsics.checkParameterIsNotNull((Object)completionTuple, (String)"completionTuple");
                if (!sessionLifetime.isTerminated()) {
                    sessionLifetime.add((Function0<Unit>)((Function0)new Function0<Unit>(this){
                        final /* synthetic */ onCurrentSessionTerminated.1 this$0;

                        public final void invoke() {
                            this.this$0.$action.invoke();
                            this.this$0.$def.terminate();
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }));
                }
            }
            {
                this.$action = function0;
                this.$def = lifetimeDefinition;
                super(2);
            }
        });
    }

    @NotNull
    public final FocusBehaviour getCurrentFocusBehaviour() {
        return this.focusBehaviour;
    }

    /*
     * WARNING - void declaration
     */
    public PreemptiveCompletionHost(@NotNull Project project2, @NotNull IconHost iconHost, @NotNull TextControlHost textControlHost, @NotNull TextEditingGateway textEditingGateway, @NotNull RiderInternalFlags internalFlags) {
        RiderInternalFlag<void> riderInternalFlag;
        void key$iv;
        void defaultValue$iv;
        void this_$iv;
        boolean isRestartRequired$iv;
        String desc$iv;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)iconHost, (String)"iconHost");
        Intrinsics.checkParameterIsNotNull((Object)textControlHost, (String)"textControlHost");
        Intrinsics.checkParameterIsNotNull((Object)textEditingGateway, (String)"textEditingGateway");
        Intrinsics.checkParameterIsNotNull((Object)internalFlags, (String)"internalFlags");
        super(project2);
        this.$$delegate_0 = new LifetimedComponent(project2);
        this.project = project2;
        this.iconHost = iconHost;
        this.textControlHost = textControlHost;
        this.textEditingGateway = textEditingGateway;
        PreemptiveCompletionHost preemptiveCompletionHost = this;
        Logger logger = Logger.getInstance(PreemptiveCompletionHost.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        preemptiveCompletionHost.logger = object = logger;
        this.sessionId = new AtomicInteger(0);
        this.preemptiveCompletionQueue = new MergingUpdateQueue("preemptiveCompletionQueue", 10, true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this.project, null, true).setRestartTimerOnAdd(true);
        this.focusBehaviour = FocusBehaviour.Hard;
        this.state = CompletionSessionState.Inactive;
        RiderInternalFlags $i$f$getLogger = internalFlags;
        String string2 = "completion.shouldBeTriggered";
        Boolean bl = true;
        String string3 = "Completion should be triggered";
        boolean bl2 = false;
        int n2 = 8;
        RiderInternalFlag.Companion companion = null;
        preemptiveCompletionHost = this;
        if ((n2 & 4) != 0) {
            desc$iv = "";
        }
        if ((n2 & 8) != 0) {
            isRestartRequired$iv = false;
        }
        companion = RiderInternalFlag.Companion;
        void var13_15 = this_$iv;
        void var14_16 = defaultValue$iv;
        if (var14_16 instanceof Boolean) {
            riderInternalFlag = new RiderInternalFlag<void>((String)key$iv, defaultValue$iv, desc$iv, isRestartRequired$iv, RiderInternalFlag.FlagType.Boolean);
        } else if (var14_16 instanceof String) {
            riderInternalFlag = new RiderInternalFlag<void>((String)key$iv, defaultValue$iv, desc$iv, isRestartRequired$iv, RiderInternalFlag.FlagType.String);
        } else if (var14_16 instanceof Integer) {
            riderInternalFlag = new RiderInternalFlag<void>((String)key$iv, defaultValue$iv, desc$iv, isRestartRequired$iv, RiderInternalFlag.FlagType.Int);
        } else if (var14_16 instanceof Color) {
            riderInternalFlag = new RiderInternalFlag<void>((String)key$iv, defaultValue$iv, desc$iv, isRestartRequired$iv, RiderInternalFlag.FlagType.Color);
        } else {
            throw (Throwable)new OperationNotSupportedException("Error in RiderInternalFlag registration (" + (String)key$iv + ")");
        }
        RiderInternalFlag<void> riderInternalFlag2 = riderInternalFlag;
        preemptiveCompletionHost.shouldBeTriggeredFlag = object = (RiderInternalFlag)var13_15.register((IRiderInternalFlag)riderInternalFlag2);
        this.preemptiveCompletionQueue.setPassThrough(false);
    }

    @Override
    @NotNull
    public Lifetime getComponentLifetime() {
        return this.$$delegate_0.getComponentLifetime();
    }

    public static final /* synthetic */ boolean access$getSaveSession$p(PreemptiveCompletionHost $this) {
        return $this.saveSession;
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLogger$p(PreemptiveCompletionHost $this) {
        return $this.logger;
    }

    @Nullable
    public static final /* synthetic */ ImmutableList access$getLightLookupItems$p(PreemptiveCompletionHost $this) {
        return $this.lightLookupItems;
    }

    public static final /* synthetic */ void access$setLightLookupItems$p(PreemptiveCompletionHost $this, @Nullable ImmutableList immutableList) {
        $this.lightLookupItems = immutableList;
    }

    @NotNull
    public static final /* synthetic */ FocusBehaviour access$getFocusBehaviour$p(PreemptiveCompletionHost $this) {
        return $this.focusBehaviour;
    }

    public static final /* synthetic */ void access$setFocusBehaviour$p(PreemptiveCompletionHost $this, @NotNull FocusBehaviour focusBehaviour) {
        $this.focusBehaviour = focusBehaviour;
    }

    @Nullable
    public static final /* synthetic */ ImmutableList access$getAdvancedLookupItems$p(PreemptiveCompletionHost $this) {
        return $this.advancedLookupItems;
    }

    public static final /* synthetic */ void access$setAdvancedLookupItems$p(PreemptiveCompletionHost $this, @Nullable ImmutableList immutableList) {
        $this.advancedLookupItems = immutableList;
    }

    @NotNull
    public static final /* synthetic */ LookupElement access$createLookupItem(PreemptiveCompletionHost $this, @NotNull CompletionItem completionItem, @NotNull CompletionSessionModel completionSessionModel, double priority, @NotNull Lifetime currentSessionLifetime) {
        return $this.createLookupItem(completionItem, completionSessionModel, priority, currentSessionLifetime);
    }

    public static final /* synthetic */ void access$terminateIfEmpty(PreemptiveCompletionHost $this) {
        $this.terminateIfEmpty();
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/jetbrains/resharper/completion/PreemptiveCompletionHost$CompleteItemCookie;", "Lcom/jetbrains/rider/util/IDisposable;", "preemptiveCompletionHost", "Lcom/jetbrains/resharper/completion/PreemptiveCompletionHost;", "(Lcom/jetbrains/resharper/completion/PreemptiveCompletionHost;)V", "getPreemptiveCompletionHost", "()Lcom/jetbrains/resharper/completion/PreemptiveCompletionHost;", "dispose", "", "rider"})
    private static final class CompleteItemCookie
    implements IDisposable {
        @NotNull
        private final PreemptiveCompletionHost preemptiveCompletionHost;

        @Override
        public void dispose() {
            this.preemptiveCompletionHost.saveSession = false;
            boolean bl = this.preemptiveCompletionHost.getHasSession();
            if (!bl) {
                String string2 = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            this.preemptiveCompletionHost.restartRightAway(CompletionType.BASIC);
        }

        @NotNull
        public final PreemptiveCompletionHost getPreemptiveCompletionHost() {
            return this.preemptiveCompletionHost;
        }

        public CompleteItemCookie(@NotNull PreemptiveCompletionHost preemptiveCompletionHost) {
            Intrinsics.checkParameterIsNotNull((Object)preemptiveCompletionHost, (String)"preemptiveCompletionHost");
            this.preemptiveCompletionHost = preemptiveCompletionHost;
            ApplicationKt.getApplication().assertIsDispatchThread();
            boolean bl = this.preemptiveCompletionHost.getHasSession();
            if (!bl) {
                String string2 = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            this.preemptiveCompletionHost.saveSession = true;
        }
    }
}

