/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.jetbrains.resharper.completion.RiderCompletionSupport;
import com.jetbrains.resharper.completion.RiderFrontendAutoPopupHeuristics;
import com.jetbrains.resharper.completion.UtilsKt;
import com.jetbrains.resharper.ideaInterop.fileTypes.razor.RazorLanguage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/resharper/completion/RazorFrontendAutopopupHeuristics;", "Lcom/jetbrains/resharper/completion/RiderFrontendAutoPopupHeuristics;", "()V", "checkAutoPopup", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate$Result;", "charTyped", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isBlessedChar", "", "rider"})
public final class RazorFrontendAutopopupHeuristics
extends RiderFrontendAutoPopupHeuristics {
    @Override
    @Nullable
    public TypedHandlerDelegate.Result checkAutoPopup(char charTyped, @NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        if (!file2.getLanguage().is((Language)RazorLanguage.INSTANCE)) {
            return super.checkAutoPopup(charTyped, project2, editor, file2);
        }
        if (RiderCompletionSupport.backendCompletionEnabled(file2, editor.getCaretModel().getOffset())) {
            char c2;
            Character previousChar = UtilsKt.getTypedChar(editor, editor.getCaretModel().getOffset() - 1, editor.getCaretModel().getOffset());
            if (this.isBlessedChar(charTyped) && previousChar != null && !Character.isDigit(c2 = previousChar.charValue())) {
                this.getLogger().trace("scheduling autoPopup on frontend after '.'");
                AutoPopupController.getInstance(project2).scheduleAutoPopup(editor);
                return TypedHandlerDelegate.Result.STOP;
            }
            return TypedHandlerDelegate.Result.STOP;
        }
        return super.checkAutoPopup(charTyped, project2, editor, file2);
    }

    private final boolean isBlessedChar(char charTyped) {
        return charTyped == '.' || charTyped == '@' || charTyped == '<';
    }
}

