/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.completion;

import com.intellij.codeInsight.completion.AutoCompletionContext;
import com.intellij.codeInsight.completion.AutoCompletionDecision;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.impl.DispreferLiveTemplates;
import com.intellij.codeInsight.completion.impl.PreferStartMatching;
import com.intellij.codeInsight.completion.impl.RealPrefixMatchingWeigher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.LookupManagerImpl;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ElementPatternCondition;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.jetbrains.resharper.completion.CustomCharPattern;
import com.jetbrains.resharper.completion.PreemptiveCompletionHost;
import com.jetbrains.resharper.completion.ReSharperCompletionContributor;
import com.jetbrains.resharper.completion.ReSharperCompletionContributor$WhenMappings;
import com.jetbrains.resharper.completion.ReSharperCompletionContributorKt;
import com.jetbrains.resharper.completion.ReSharperCompletionPattern;
import com.jetbrains.resharper.completion.ReSharperLookupItem;
import com.jetbrains.resharper.completion.UtilsKt;
import com.jetbrains.resharper.ideaInterop.fileTypes.csharp.CSharpLanguage;
import com.jetbrains.resharper.ideaInterop.fileTypes.razor.RazorLanguage;
import com.jetbrains.resharper.util.idea.DisposableExKt;
import com.jetbrains.rider.model.CompletionItemType;
import com.jetbrains.rider.model.FocusBehaviour;
import com.jetbrains.rider.util.lifetime.Lifetime;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CharIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\n\u001a\u00020\u0019H\u0016J\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/jetbrains/resharper/completion/ReSharperCompletionContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "completionId", "Ljava/util/concurrent/atomic/AtomicInteger;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "beforeCompletion", "", "context", "Lcom/intellij/codeInsight/completion/CompletionInitializationContext;", "duringCompletion", "fillCompletionVariants", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "getIdentifierPart", "Lcom/jetbrains/resharper/completion/CustomCharPattern;", "language", "Lcom/intellij/lang/Language;", "getIdentifierStart", "handleAutoCompletionPossibility", "Lcom/intellij/codeInsight/completion/AutoCompletionDecision;", "Lcom/intellij/codeInsight/completion/AutoCompletionContext;", "handleEmptyLookup", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "invokeAutoPopup", "", "position", "Lcom/intellij/psi/PsiElement;", "typeChar", "", "rider"})
public final class ReSharperCompletionContributor
extends CompletionContributor
implements DumbAware {
    private final Logger logger;
    private final AtomicInteger completionId;

    private final CustomCharPattern getIdentifierStart(Language language) {
        Language language2 = language;
        if (Intrinsics.areEqual((Object)language2, (Object)((Object)CSharpLanguage.INSTANCE))) {
            return CustomCharPattern.customCharacter().csharpIdentifierStart();
        }
        if (Intrinsics.areEqual((Object)language2, (Object)((Object)RazorLanguage.INSTANCE))) {
            return CustomCharPattern.customCharacter().razorCSharpIdentifierStart();
        }
        return CustomCharPattern.customCharacter().csharpIdentifierStart();
    }

    private final CustomCharPattern getIdentifierPart(Language language) {
        Language language2 = language;
        if (Intrinsics.areEqual((Object)language2, (Object)((Object)CSharpLanguage.INSTANCE))) {
            return CustomCharPattern.customCharacter().csharpIdentifierPart();
        }
        if (Intrinsics.areEqual((Object)language2, (Object)((Object)RazorLanguage.INSTANCE))) {
            return CustomCharPattern.customCharacter().razorCSharpIdentifierPart();
        }
        return CustomCharPattern.customCharacter().csharpIdentifierPart();
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
        super.fillCompletionVariants(parameters, result2);
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Project project2 = context2.getEditor().getProject();
        if (project2 == null) {
            Intrinsics.throwNpe();
        }
        ComponentManager $receiver$iv = (ComponentManager)project2;
        Object object = $receiver$iv.getComponent(PreemptiveCompletionHost.class);
        if (object == null) {
            throw (Throwable)new IllegalStateException("Component " + PreemptiveCompletionHost.class + " not found in container " + $receiver$iv);
        }
        PreemptiveCompletionHost helper = (PreemptiveCompletionHost)object;
        helper.ensureCompletionIsRunning(ReSharperCompletionContributorKt.getRealCompletionType(context2.getCompletionType(), context2.getInvocationCount()));
    }

    @Nullable
    public String handleEmptyLookup(@NotNull CompletionParameters parameters, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        return super.handleEmptyLookup(parameters, editor);
    }

    @Nullable
    public AutoCompletionDecision handleAutoCompletionPossibility(@NotNull AutoCompletionContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        return super.handleAutoCompletionPossibility(context2);
    }

    public boolean invokeAutoPopup(@NotNull PsiElement position, char typeChar) {
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        return super.invokeAutoPopup(position, typeChar);
    }

    public void duringCompletion(@NotNull CompletionInitializationContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        super.duringCompletion(context2);
    }

    public ReSharperCompletionContributor() {
        Logger logger;
        ReSharperCompletionContributor reSharperCompletionContributor = this;
        Logger logger2 = Logger.getInstance(ReSharperCompletionContributor.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        reSharperCompletionContributor.logger = logger = logger2;
        this.completionId = new AtomicInteger(0);
        CompletionProvider<CompletionParameters> resharperBackendProvider2 = new CompletionProvider<CompletionParameters>(this){
            final /* synthetic */ ReSharperCompletionContributor this$0;

            protected void addCompletions(@NotNull CompletionParameters params, @Nullable ProcessingContext context2, @NotNull CompletionResultSet initialResultSet) {
                String string2;
                Logger logger;
                Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
                Intrinsics.checkParameterIsNotNull((Object)initialResultSet, (String)"initialResultSet");
                Logger $receiver$iv = ReSharperCompletionContributor.access$getLogger$p(this.this$0);
                if ($receiver$iv.isTraceEnabled()) {
                    logger = $receiver$iv;
                    string2 = "start contributor #" + ReSharperCompletionContributor.access$getCompletionId$p(this.this$0).incrementAndGet() + ".";
                    logger.trace(string2);
                }
                Project project2 = params.getEditor().getProject();
                if (project2 == null) {
                    Intrinsics.throwNpe();
                }
                ComponentManager $receiver$iv2 = (ComponentManager)project2;
                Object object = $receiver$iv2.getComponent(PreemptiveCompletionHost.class);
                if (object == null) {
                    throw (Throwable)new IllegalStateException("Component " + PreemptiveCompletionHost.class + " not found in container " + $receiver$iv2);
                }
                PreemptiveCompletionHost helper = (PreemptiveCompletionHost)object;
                CompletionProcess completionProcess = CompletionService.getCompletionService().getCurrentCompletion();
                if (!(completionProcess instanceof Disposable)) {
                    completionProcess = null;
                }
                Disposable disposable = (Disposable)completionProcess;
                if (disposable == null) {
                    return;
                }
                Disposable indicatorDisposable = disposable;
                if (Disposer.isDisposed((Disposable)indicatorDisposable)) {
                    return;
                }
                Lifetime popupLifetime = DisposableExKt.makeLifetime(indicatorDisposable);
                PsiElement psiElement = params.getOriginalPosition();
                int n2 = params.getOffset();
                Language language = params.getOriginalFile().getLanguage();
                Intrinsics.checkExpressionValueIsNotNull((Object)language, (String)"params.originalFile.language");
                ElementPattern elementPattern2 = (ElementPattern)ReSharperCompletionContributor.access$getIdentifierPart(this.this$0, language);
                Language language2 = params.getOriginalFile().getLanguage();
                Intrinsics.checkExpressionValueIsNotNull((Object)language2, (String)"params.originalFile.language");
                String prefix = CompletionUtil.findIdentifierPrefix(psiElement, n2, (ElementPattern<Character>)elementPattern2, (ElementPattern<Character>)((ElementPattern)ReSharperCompletionContributor.access$getIdentifierStart(this.this$0, language2)));
                Logger $receiver$iv3 = ReSharperCompletionContributor.access$getLogger$p(this.this$0);
                if ($receiver$iv3.isTraceEnabled()) {
                    logger = $receiver$iv3;
                    string2 = "prefix is '" + prefix + "'";
                    logger.trace(string2);
                }
                CompletionResultSet consumer2 = initialResultSet.withPrefixMatcher(prefix).withRelevanceSorter(CompletionSorter.emptySorter().weigh((LookupElementWeigher)new DispreferLiveTemplates()).weigh((LookupElementWeigher)new PreferStartMatching()).weigh((LookupElementWeigher)new RealPrefixMatchingWeigher()).weigh(new LookupElementWeigher("priority"){

                    @NotNull
                    public Double weigh(@NotNull LookupElement element) {
                        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                        return element instanceof PrioritizedLookupElement ? -((PrioritizedLookupElement)element).getPriority() : -0.0;
                    }
                }));
                CompletionProcess completionProcess2 = CompletionService.getCompletionService().getCurrentCompletion();
                if (completionProcess2 == null) {
                    return;
                }
                CompletionProcess indicator = completionProcess2;
                LookupEx lookupEx = LookupManagerImpl.getActiveLookup(params.getEditor());
                if (!(lookupEx instanceof LookupImpl)) {
                    lookupEx = null;
                }
                LookupImpl lookupImpl = (LookupImpl)lookupEx;
                if (lookupImpl == null) {
                    return;
                }
                LookupImpl lookup = lookupImpl;
                ReSharperCompletionContributor.access$getLogger$p(this.this$0).trace("Contributor. before");
                CompletionResultSet completionResultSet = consumer2;
                Intrinsics.checkExpressionValueIsNotNull((Object)completionResultSet, (String)"consumer");
                helper.consumeLightItemsSetFocus(completionResultSet, popupLifetime, (Function1<? super FocusBehaviour, Unit>)((Function1)new Function1<FocusBehaviour, Unit>(indicator, lookup, prefix){
                    final /* synthetic */ CompletionProcess $indicator;
                    final /* synthetic */ LookupImpl $lookup;
                    final /* synthetic */ String $prefix;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final void invoke(@NotNull FocusBehaviour behaviour) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)behaviour), (String)"behaviour");
                        if (!this.$indicator.isAutopopupCompletion()) {
                            return;
                        }
                        switch (ReSharperCompletionContributor$WhenMappings.$EnumSwitchMapping$0[behaviour.ordinal()]) {
                            case 1: {
                                this.$lookup.setFocusDegree(LookupImpl.FocusDegree.UNFOCUSED);
                                return;
                            }
                            case 2: {
                                char element$iv;
                                char it;
                                char c2;
                                CharSequence charSequence = this.$prefix;
                                if (charSequence.length() == 0) {
                                    this.$lookup.setFocusDegree(LookupImpl.FocusDegree.UNFOCUSED);
                                    return;
                                }
                                CharSequence $receiver$iv = this.$prefix;
                                CharIterator charIterator = StringsKt.iterator((CharSequence)$receiver$iv);
                                do {
                                    if (!charIterator.hasNext()) return;
                                } while (!(!Character.isDigit(c2 = (it = (element$iv = charIterator.nextChar())))));
                                boolean bl = true;
                                if (!bl) return;
                                this.$lookup.setFocusDegree(LookupImpl.FocusDegree.FOCUSED);
                            }
                        }
                    }
                    {
                        this.$indicator = completionProcess;
                        this.$lookup = lookupImpl;
                        this.$prefix = string2;
                        super(1);
                    }
                }), (Function1<? super LookupElement, Boolean>)((Function1)new Function1<LookupElement, Boolean>(this, prefix){
                    final /* synthetic */ resharperBackendProvider.1 this$0;
                    final /* synthetic */ String $prefix;

                    public final boolean invoke(@NotNull LookupElement lookupElement) {
                        Intrinsics.checkParameterIsNotNull((Object)lookupElement, (String)"lookupElement");
                        String string2 = this.$prefix;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"prefix");
                        return resharperBackendProvider.1.access$passesTheFilter(this.this$0, lookupElement, string2);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$prefix = string2;
                        super(1);
                    }
                }));
                ReSharperCompletionContributor.access$getLogger$p(this.this$0).trace("Contributor. after light");
                CompletionResultSet completionResultSet2 = consumer2;
                Intrinsics.checkExpressionValueIsNotNull((Object)completionResultSet2, (String)"consumer");
                helper.consumeAdvancedItems(completionResultSet2, popupLifetime);
                Logger $receiver$iv4 = ReSharperCompletionContributor.access$getLogger$p(this.this$0);
                if ($receiver$iv4.isTraceEnabled()) {
                    logger = $receiver$iv4;
                    string2 = "contributor has finished its job. " + consumer2;
                    logger.trace(string2);
                }
            }

            private final boolean passesTheFilter(LookupElement lookupElement, String prefix) {
                ReSharperLookupItem reSharperLookupItem = UtilsKt.tryGetReSharperItem(lookupElement);
                if (reSharperLookupItem == null) {
                    String string2 = "cannot get resharper item from lookupElement " + lookupElement;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                ReSharperLookupItem resharperItem = reSharperLookupItem;
                boolean isTemplateItem = Intrinsics.areEqual((Object)((Object)resharperItem.getCompletionItem().getItemType()), (Object)((Object)CompletionItemType.TemplateItem));
                CharSequence charSequence = prefix;
                return charSequence.length() == 0 && (StringsKt.startsWith$default((CharSequence)lookupElement.getLookupString(), (char)'#', (boolean)false, (int)2, null) || isTemplateItem) ? false : !isTemplateItem || StringsKt.startsWith$default((String)lookupElement.getLookupString(), (String)prefix, (boolean)false, (int)2, null);
            }
            {
                this.this$0 = $outer;
            }

            public static final /* synthetic */ boolean access$passesTheFilter(resharperBackendProvider.1 $this, @NotNull LookupElement lookupElement, @NotNull String prefix) {
                return $this.passesTheFilter(lookupElement, prefix);
            }
        };
        ElementPattern<PsiElement> elementPattern2 = new ElementPattern<PsiElement>(){

            @Nullable
            public ElementPatternCondition<PsiElement> getCondition() {
                return new ElementPatternCondition((InitialPatternCondition)new ReSharperCompletionPattern());
            }

            public boolean accepts(@Nullable Object o2, @Nullable ProcessingContext context2) {
                return true;
            }

            public boolean accepts(@Nullable Object o2) {
                return true;
            }
        };
        this.extend(CompletionType.BASIC, (ElementPattern)elementPattern2, (CompletionProvider)resharperBackendProvider2);
        this.extend(CompletionType.CLASS_NAME, (ElementPattern)elementPattern2, (CompletionProvider)resharperBackendProvider2);
        this.extend(CompletionType.SMART, (ElementPattern)elementPattern2, (CompletionProvider)resharperBackendProvider2);
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLogger$p(ReSharperCompletionContributor $this) {
        return $this.logger;
    }

    @NotNull
    public static final /* synthetic */ AtomicInteger access$getCompletionId$p(ReSharperCompletionContributor $this) {
        return $this.completionId;
    }

    @Nullable
    public static final /* synthetic */ CustomCharPattern access$getIdentifierPart(ReSharperCompletionContributor $this, @NotNull Language language) {
        return $this.getIdentifierPart(language);
    }

    @Nullable
    public static final /* synthetic */ CustomCharPattern access$getIdentifierStart(ReSharperCompletionContributor $this, @NotNull Language language) {
        return $this.getIdentifierStart(language);
    }
}

