/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.completion;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.internal.DumpLookupElementWeights;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.Project;
import com.jetbrains.resharper.completion.PreemptiveCompletionHost;
import com.jetbrains.resharper.completion.ReSharperLookupItem;
import com.jetbrains.resharper.completion.RiderLookupAsyncPresenter;
import com.jetbrains.resharper.completion.UtilsKt;
import com.jetbrains.resharper.daemon.DocumentMarkupContributor;
import com.jetbrains.resharper.daemon.MarkupSuppressionKind;
import com.jetbrains.resharper.daemon.components.RiderMarkupHost;
import com.jetbrains.resharper.daemon.util.HighlightersUtilKt;
import com.jetbrains.resharper.ui.RiderUIKt;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import com.jetbrains.resharper.util.idea.DisposableExKt;
import com.jetbrains.resharper.util.idea.EditorUtilKt;
import com.jetbrains.rider.model.FocusBehaviour;
import com.jetbrains.rider.model.ModelRichText;
import com.jetbrains.rider.util.lifetime.Lifetime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CharIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0001H\u0002J\u001a\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u001a\u0010\u0017\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001a\u0010\u0018\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0018\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J\b\u0010\u001f\u001a\u00020\u001dH\u0016J\u0016\u0010 \u001a\u00020\u00102\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/jetbrains/resharper/completion/ReSharperLookup;", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "lookupArranger", "Lcom/intellij/codeInsight/lookup/LookupArranger;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/codeInsight/lookup/LookupArranger;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "preemptiveCompletionHost", "Lcom/jetbrains/resharper/completion/PreemptiveCompletionHost;", "updater", "Lcom/jetbrains/resharper/completion/RiderLookupAsyncPresenter;", "dumpLookup", "", "activeLookup", "finishLookup", "completionChar", "", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "fireItemSelected", "insertLookupString", "prefix", "", "refreshUi", "mayCheckReused", "", "onExplicitAction", "showLookup", "updateWidth", "resharperItems", "", "Lcom/jetbrains/resharper/completion/ReSharperLookupItem;", "rider"})
public final class ReSharperLookup
extends LookupImpl {
    private final PreemptiveCompletionHost preemptiveCompletionHost;
    private final RiderLookupAsyncPresenter updater;
    private final Logger logger;

    @Override
    public boolean showLookup() {
        this.logger.info("Showing lookup");
        Document document = this.getEditor().getDocument();
        Lifetime lifetime = DisposableExKt.makeLifetime(this);
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        Document document2 = document;
        Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"document");
        DocumentMarkupContributor documentMarkupContributor = RiderMarkupHost.Companion.getMarkupContributor(project2, document2);
        if (documentMarkupContributor != null) {
            documentMarkupContributor.suppress(lifetime, MarkupSuppressionKind.FULL);
        }
        MarkupModel markupModel = DocumentMarkupModel.forDocument(document, this.getProject(), true);
        if (markupModel == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.MarkupModelEx");
        }
        MarkupModelEx markupModel2 = (MarkupModelEx)markupModel;
        HighlightersUtilKt.vanishHighlightersByTyping(lifetime, markupModel2);
        if (this.preemptiveCompletionHost.getHasSession()) {
            this.preemptiveCompletionHost.onCurrentSessionTerminated((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ ReSharperLookup this$0;

                public final void invoke() {
                    if (!EditorUtilKt.hasMultipleEditPoints(this.this$0.getEditor())) {
                        ReSharperLookup.access$getLogger$p(this.this$0).trace("hiding lookup due to session termination");
                        this.this$0.hideLookup(false);
                    }
                }
                {
                    this.this$0 = reSharperLookup;
                    super(0);
                }
            }));
        }
        return super.showLookup();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void refreshUi(boolean mayCheckReused, boolean onExplicitAction) {
        CharSequence charSequence;
        this.logger.trace("refreshUI");
        boolean hasSession = this.preemptiveCompletionHost.getHasSession();
        if (hasSession && Intrinsics.areEqual((Object)((Object)this.preemptiveCompletionHost.getCurrentFocusBehaviour()), (Object)((Object)FocusBehaviour.SoftWhenEmpty)) && !((charSequence = (CharSequence)this.getAdditionalPrefix()).length() == 0)) {
            boolean bl;
            block8: {
                CharSequence $receiver$iv = this.getAdditionalPrefix();
                CharIterator charIterator = StringsKt.iterator((CharSequence)$receiver$iv);
                while (charIterator.hasNext()) {
                    char element$iv = charIterator.nextChar();
                    char it = element$iv;
                    char c2 = it;
                    if (!(!Character.isDigit(c2))) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
            if (bl) {
                this.setFocusDegree(LookupImpl.FocusDegree.FOCUSED);
            }
        }
        super.refreshUi(mayCheckReused, onExplicitAction);
        if (hasSession && !ApplicationKt.getApplication().isUnitTestMode()) {
            void $receiver$iv$iv;
            void $receiver$iv$iv2;
            Iterable $receiver$iv;
            Iterable element$iv = $receiver$iv = (Iterable)this.getItems();
            Iterable<ReSharperLookupItem> destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv2;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                ReSharperLookupItem reSharperLookupItem;
                Object element$iv$iv = element$iv$iv$iv;
                LookupElement it = (LookupElement)element$iv$iv;
                if (UtilsKt.tryGetReSharperItem(it) == null) continue;
                ReSharperLookupItem it$iv$iv = reSharperLookupItem;
                destination$iv$iv.add(it$iv$iv);
            }
            List resharperItems = (List)destination$iv$iv;
            Iterable $receiver$iv2 = resharperItems;
            destination$iv$iv = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                ReSharperLookupItem it = (ReSharperLookupItem)((Object)element$iv$iv);
                if (!it.shouldRequestUpdate()) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List toUpdate = (List)destination$iv$iv2;
            if (!toUpdate.isEmpty()) {
                this.updater.updatePresentation(toUpdate, this, (Function0<Unit>)((Function0)new Function0<Unit>(this, resharperItems){
                    final /* synthetic */ ReSharperLookup this$0;
                    final /* synthetic */ List $resharperItems;

                    public final void invoke() {
                        ReSharperLookup.access$updateWidth(this.this$0, this.$resharperItems);
                        if (this.this$0.isVisible() && !this.this$0.isLookupDisposed()) {
                            ReSharperLookup.access$repaintLookup(this.this$0, false, false, ReSharperLookup.access$isSelectionVisible(this.this$0), true);
                        }
                    }
                    {
                        this.this$0 = reSharperLookup;
                        this.$resharperItems = list2;
                        super(0);
                    }
                }));
            }
            if (!resharperItems.isEmpty()) {
                this.updateWidth(resharperItems);
            }
        }
    }

    private final void updateWidth(List<ReSharperLookupItem> resharperItems) {
        int width = 0;
        ReSharperLookupItem widestItem = null;
        for (ReSharperLookupItem lookupItem : resharperItems) {
            ModelRichText modelRichText = lookupItem.getDisplayName();
            int displayNameLength = modelRichText != null ? RiderUIKt.getLength(modelRichText) : 0;
            String string2 = lookupItem.getTypeName();
            int typeNameLength = string2 != null ? string2.length() : 0;
            int newWidth = displayNameLength + typeNameLength;
            if (newWidth <= width) continue;
            width = newWidth;
            widestItem = lookupItem;
        }
        if (widestItem != null) {
            this.logger.trace("Updating lookup width with '" + (Object)((Object)widestItem) + "' item as the most widest...");
            this.updateLookupWidth(widestItem);
        }
    }

    @Override
    public void finishLookup(char completionChar, @Nullable LookupElement item) {
        CompletionProgressIndicator completionProgressIndicator;
        if (!this.getEditor().getSelectionModel().hasSelection() && UtilsKt.tryGetReSharperItem(item) != null && (completionProgressIndicator = CompletionServiceImpl.getCompletionService().getCurrentCompletion()) != null && (completionProgressIndicator = completionProgressIndicator.getOffsetMap()) != null) {
            completionProgressIndicator.addOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET, this.getEditor().getCaretModel().getOffset());
        }
        super.finishLookup(completionChar, item);
    }

    @Override
    protected void insertLookupString(@Nullable LookupElement item, int prefix) {
        if (UtilsKt.tryGetReSharperItem(item) == null) {
            super.insertLookupString(item, prefix);
            return;
        }
    }

    @Override
    public void fireItemSelected(@Nullable LookupElement item, char completionChar) {
        super.fireItemSelected(item, completionChar);
    }

    private final void dumpLookup(LookupImpl activeLookup) {
        StringBuilder sb2;
        StringBuilder stringBuilder = sb2 = new StringBuilder();
        CharSequence charSequence = "Lookup dump:";
        StringsKt.appendln((StringBuilder)stringBuilder.append((String)charSequence));
        LookupElement selected = activeLookup.getCurrentItem();
        charSequence = sb2;
        StringBuilder stringBuilder2 = new StringBuilder().append("selected: '").append(selected).append("'").append("\n").append("prefix: '");
        LookupElement lookupElement = selected;
        if (lookupElement == null) {
            Intrinsics.throwNpe();
        }
        String string2 = stringBuilder2.append(activeLookup.itemPattern(lookupElement)).append("'").toString();
        StringsKt.appendln((StringBuilder)((StringBuilder)charSequence).append(string2));
        Iterable $receiver$iv = DumpLookupElementWeights.getLookupElementWeights(activeLookup, false);
        for (Object element$iv : $receiver$iv) {
            String it = (String)element$iv;
            StringBuilder stringBuilder3 = sb2;
            StringsKt.appendln((StringBuilder)stringBuilder3.append(it));
        }
        this.logger.trace(sb2.toString());
    }

    public ReSharperLookup(@NotNull Project project2, @NotNull Editor editor, @NotNull LookupArranger lookupArranger) {
        ComponentManager $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)lookupArranger, (String)"lookupArranger");
        super(project2, editor, lookupArranger);
        ComponentManager componentManager = (ComponentManager)project2;
        ReSharperLookup reSharperLookup = this;
        Object object = $receiver$iv.getComponent(PreemptiveCompletionHost.class);
        if (object == null) {
            throw (Throwable)new IllegalStateException("Component " + PreemptiveCompletionHost.class + " not found in container " + $receiver$iv);
        }
        Object object2 = object;
        reSharperLookup.preemptiveCompletionHost = (PreemptiveCompletionHost)object2;
        $receiver$iv = (ComponentManager)project2;
        reSharperLookup = this;
        Object object3 = $receiver$iv.getComponent(RiderLookupAsyncPresenter.class);
        if (object3 == null) {
            throw (Throwable)new IllegalStateException("Component " + RiderLookupAsyncPresenter.class + " not found in container " + $receiver$iv);
        }
        object2 = object3;
        reSharperLookup.updater = (RiderLookupAsyncPresenter)object2;
        reSharperLookup = this;
        Logger logger = Logger.getInstance(ReSharperLookup.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        object2 = logger;
        reSharperLookup.logger = object2;
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLogger$p(ReSharperLookup $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$updateWidth(ReSharperLookup $this, @NotNull List resharperItems) {
        $this.updateWidth(resharperItems);
    }

    public static final /* synthetic */ void access$repaintLookup(ReSharperLookup $this, boolean onExplicitAction, boolean reused, boolean selectionVisible, boolean itemsChanged) {
        $this.repaintLookup(onExplicitAction, reused, selectionVisible, itemsChanged);
    }

    public static final /* synthetic */ boolean access$isSelectionVisible(ReSharperLookup $this) {
        return $this.isSelectionVisible();
    }
}

