/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.completion;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.resharper.completion.PreemptiveCompletionHost;
import com.jetbrains.resharper.icons.IconHost;
import com.jetbrains.resharper.icons.IconHostKt;
import com.jetbrains.resharper.util.idea.ExtensionsKt;
import com.jetbrains.rider.framework.impl.IRdCall;
import com.jetbrains.rider.model.CompleteData;
import com.jetbrains.rider.model.CompletionItem;
import com.jetbrains.rider.model.EffectStyle;
import com.jetbrains.rider.model.Icon;
import com.jetbrains.rider.model.LookupSummaryInfo;
import com.jetbrains.rider.model.ModelRichString;
import com.jetbrains.rider.model.ModelRichText;
import com.jetbrains.rider.util.IDisposable;
import com.jetbrains.rider.util.lifetime.Lifetime;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010/\u001a\u00020*H\u0016J\u0012\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u000103H\u0016J\b\u00104\u001a\u00020\u0007H\u0016J\u0012\u00105\u001a\u0002012\b\u00106\u001a\u0004\u0018\u000107H\u0016J\u0006\u00108\u001a\u00020\u0007J\u000e\u00109\u001a\u00020\u00072\u0006\u0010:\u001a\u00020;R\u001f\u0010\u0004\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001c\u0010#\u001a\u0004\u0018\u00010$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001c\u0010)\u001a\u0004\u0018\u00010*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.\u00a8\u0006<"}, d2={"Lcom/jetbrains/resharper/completion/ReSharperLookupItem;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "completionItem", "Lcom/jetbrains/rider/model/CompletionItem;", "completeItem", "Lcom/jetbrains/rider/framework/impl/IRdCall;", "Lcom/jetbrains/rider/model/CompleteData;", "", "project", "Lcom/intellij/openapi/project/Project;", "iconHost", "Lcom/jetbrains/resharper/icons/IconHost;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "sessionLifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "(Lcom/jetbrains/rider/model/CompletionItem;Lcom/jetbrains/rider/framework/impl/IRdCall;Lcom/intellij/openapi/project/Project;Lcom/jetbrains/resharper/icons/IconHost;Lcom/intellij/openapi/diagnostic/Logger;Lcom/jetbrains/rider/util/lifetime/Lifetime;)V", "getCompleteItem", "()Lcom/jetbrains/rider/framework/impl/IRdCall;", "getCompletionItem", "()Lcom/jetbrains/rider/model/CompletionItem;", "displayName", "Lcom/jetbrains/rider/model/ModelRichText;", "getDisplayName", "()Lcom/jetbrains/rider/model/ModelRichText;", "setDisplayName", "(Lcom/jetbrains/rider/model/ModelRichText;)V", "getIconHost", "()Lcom/jetbrains/resharper/icons/IconHost;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSessionLifetime", "()Lcom/jetbrains/rider/util/lifetime/Lifetime;", "summaryInfo", "Lcom/jetbrains/rider/model/LookupSummaryInfo;", "getSummaryInfo", "()Lcom/jetbrains/rider/model/LookupSummaryInfo;", "setSummaryInfo", "(Lcom/jetbrains/rider/model/LookupSummaryInfo;)V", "typeName", "", "getTypeName", "()Ljava/lang/String;", "setTypeName", "(Ljava/lang/String;)V", "getLookupString", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "isWorthShowingInAutoPopup", "renderElement", "presentation", "Lcom/intellij/codeInsight/lookup/LookupElementPresentation;", "shouldRequestUpdate", "syncBackendInsertion", "completionChar", "", "rider"})
public final class ReSharperLookupItem
extends LookupElement {
    @Nullable
    private ModelRichText displayName;
    @Nullable
    private String typeName;
    @Nullable
    private LookupSummaryInfo summaryInfo;
    @NotNull
    private final CompletionItem completionItem;
    @NotNull
    private final IRdCall<CompleteData, Boolean> completeItem;
    @NotNull
    private final Project project;
    @NotNull
    private final IconHost iconHost;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Lifetime sessionLifetime;

    @Nullable
    public final ModelRichText getDisplayName() {
        return this.displayName;
    }

    public final void setDisplayName(@Nullable ModelRichText modelRichText) {
        this.displayName = modelRichText;
    }

    @Nullable
    public final String getTypeName() {
        return this.typeName;
    }

    public final void setTypeName(@Nullable String string2) {
        this.typeName = string2;
    }

    @Nullable
    public final LookupSummaryInfo getSummaryInfo() {
        return this.summaryInfo;
    }

    public final void setSummaryInfo(@Nullable LookupSummaryInfo lookupSummaryInfo) {
        this.summaryInfo = lookupSummaryInfo;
    }

    @NotNull
    public String getLookupString() {
        return this.completionItem.getShortText();
    }

    /*
     * WARNING - void declaration
     */
    public void renderElement(@Nullable LookupElementPresentation presentation) {
        Icon icon = this.completionItem.getIcon();
        if (icon != null) {
            LookupElementPresentation lookupElementPresentation = presentation;
            if (lookupElementPresentation == null) {
                Intrinsics.throwNpe();
            }
            lookupElementPresentation.setIcon(IconHostKt.toIdeaIcon(icon, this.iconHost));
        }
        if (this.displayName == null) {
            LookupElementPresentation lookupElementPresentation = presentation;
            if (lookupElementPresentation == null) {
                Intrinsics.throwNpe();
            }
            lookupElementPresentation.setItemText(this.completionItem.getShortText());
        } else {
            Collection collection;
            int n2;
            ModelRichText modelRichText = this.displayName;
            if (modelRichText == null) {
                Intrinsics.throwNpe();
            }
            ModelRichString firstSpan = modelRichText.getParts().get(0);
            LookupElementPresentation lookupElementPresentation = presentation;
            if (lookupElementPresentation == null) {
                Intrinsics.throwNpe();
            }
            lookupElementPresentation.setItemText(firstSpan.getText());
            int n3 = 1;
            ModelRichText modelRichText2 = this.displayName;
            if (modelRichText2 == null) {
                Intrinsics.throwNpe();
            }
            if (n3 <= (n2 = (collection = (Collection)modelRichText2.getParts()).size() - 1)) {
                while (true) {
                    void i2;
                    ModelRichText modelRichText3 = this.displayName;
                    if (modelRichText3 == null) {
                        Intrinsics.throwNpe();
                    }
                    ModelRichString currentSpan = modelRichText3.getParts().get((int)i2);
                    presentation.appendTailText(currentSpan.getText(), true);
                    if (i2 == n2) break;
                    ++i2;
                }
            }
            if (firstSpan.getEffectStyle().equals((Object)EffectStyle.StrikeOut)) {
                presentation.setStrikeout(true);
            }
        }
        if (this.typeName != null) {
            presentation.setTypeText(this.typeName);
        }
    }

    public boolean isWorthShowingInAutoPopup() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final boolean syncBackendInsertion(char completionChar) {
        void syncResult;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        ComponentManager $receiver$iv = (ComponentManager)this.project;
        Object object = $receiver$iv.getComponent(PreemptiveCompletionHost.class);
        if (object == null) {
            throw (Throwable)new IllegalStateException("Component " + PreemptiveCompletionHost.class + " not found in container " + $receiver$iv);
        }
        IDisposable disposable$iv = ((PreemptiveCompletionHost)object).getCompleteItemCookie$rider();
        try {
            boolean $i$f$getComponent;
            this.logger.info("Start handleInsert. Completion char: '" + completionChar + "'. Id: " + this.completionItem.getId());
            boolean bl = $i$f$getComponent = !this.sessionLifetime.isTerminated();
            if (!$i$f$getComponent) {
                String string2 = "Executing " + (Object)((Object)this) + " with terminated lifetime";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            CompleteData completeTask = new CompleteData(this.completionItem, Character.valueOf(completionChar));
            syncResult.element = ExtensionsKt.syncFromBackend(this.completeItem, completeTask, this.project, this.sessionLifetime);
            this.logger.info("End handleInsert. Completion char: '" + completionChar + "'. Id: " + this.completionItem.getId());
        }
        finally {
            disposable$iv.dispose();
        }
        Boolean bl = (Boolean)syncResult.element;
        return bl != null ? bl : true;
    }

    public void handleInsert(@Nullable InsertionContext context2) {
        throw (Throwable)new UnsupportedOperationException();
    }

    public final boolean shouldRequestUpdate() {
        return this.displayName == null;
    }

    @NotNull
    public final CompletionItem getCompletionItem() {
        return this.completionItem;
    }

    @NotNull
    public final IRdCall<CompleteData, Boolean> getCompleteItem() {
        return this.completeItem;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final IconHost getIconHost() {
        return this.iconHost;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final Lifetime getSessionLifetime() {
        return this.sessionLifetime;
    }

    public ReSharperLookupItem(@NotNull CompletionItem completionItem, @NotNull IRdCall<? super CompleteData, Boolean> completeItem, @NotNull Project project2, @NotNull IconHost iconHost, @NotNull Logger logger, @NotNull Lifetime sessionLifetime) {
        Intrinsics.checkParameterIsNotNull((Object)completionItem, (String)"completionItem");
        Intrinsics.checkParameterIsNotNull(completeItem, (String)"completeItem");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)iconHost, (String)"iconHost");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)sessionLifetime, (String)"sessionLifetime");
        this.completionItem = completionItem;
        this.completeItem = completeItem;
        this.project = project2;
        this.iconHost = iconHost;
        this.logger = logger;
        this.sessionLifetime = sessionLifetime;
        this.displayName = this.completionItem.getDisplayName();
        this.typeName = this.completionItem.getTypeName();
    }
}

