/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.editorActions.CompletionAutoPopupHandler;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.jetbrains.resharper.completion.RiderCompletionSupport;
import com.jetbrains.resharper.completion.UtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/resharper/completion/RiderFrontendAutoPopupHeuristics;", "Lcom/intellij/codeInsight/editorActions/CompletionAutoPopupHandler;", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "checkAutoPopup", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate$Result;", "charTyped", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "rider"})
public class RiderFrontendAutoPopupHeuristics
extends CompletionAutoPopupHandler {
    @NotNull
    private final Logger logger;

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    @Override
    @Nullable
    public TypedHandlerDelegate.Result checkAutoPopup(char charTyped, @NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        if (RiderCompletionSupport.backendCompletionEnabled(file2, editor.getCaretModel().getOffset())) {
            char c2;
            Character previousChar = UtilsKt.getTypedChar(editor, editor.getCaretModel().getOffset() - 1, editor.getCaretModel().getOffset());
            if (charTyped == '.' && previousChar != null && !Character.isDigit(c2 = previousChar.charValue())) {
                this.logger.trace("scheduling autoPopup on frontend after '.'");
                AutoPopupController.getInstance(project2).scheduleAutoPopup(editor);
                return TypedHandlerDelegate.Result.STOP;
            }
            if (Character.isLetter(charTyped) && (previousChar == null || !Character.isDigit(c2 = previousChar.charValue()))) {
                Logger $receiver$iv = this.logger;
                if ($receiver$iv.isTraceEnabled()) {
                    Logger logger = $receiver$iv;
                    String string2 = "scheduling autoPopup on frontend after '" + charTyped + "'";
                    logger.trace(string2);
                }
                AutoPopupController.getInstance(project2).scheduleAutoPopup(editor);
                return TypedHandlerDelegate.Result.STOP;
            }
            return TypedHandlerDelegate.Result.STOP;
        }
        return super.checkAutoPopup(charTyped, project2, editor, file2);
    }

    public RiderFrontendAutoPopupHeuristics() {
        Logger logger;
        RiderFrontendAutoPopupHeuristics riderFrontendAutoPopupHeuristics = this;
        Logger logger2 = Logger.getInstance(RiderFrontendAutoPopupHeuristics.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        riderFrontendAutoPopupHeuristics.logger = logger = logger2;
    }
}

