/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.completion;

import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.resharper.completion.CompletionSessionState;
import com.jetbrains.resharper.completion.PreemptiveCompletionHost;
import com.jetbrains.resharper.completion.ReSharperLookupItem;
import com.jetbrains.resharper.completion.UtilsKt$WhenMappings;
import com.jetbrains.resharper.util.idea.SyncEventWithInterrupt;
import com.jetbrains.rider.model.CompletionMode;
import com.jetbrains.rider.util.lifetime.Lifetime;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a%\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u001a\n\u0010\u0010\u001a\u00020\t*\u00020\u000b\u001a\u001a\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017\u00a8\u0006\u0018"}, d2={"getTypedChar", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "oldOffset", "", "newOffset", "(Lcom/intellij/openapi/editor/Editor;II)Ljava/lang/Character;", "toCompletionMode", "Lcom/jetbrains/rider/model/CompletionMode;", "type", "Lcom/intellij/codeInsight/completion/CompletionType;", "tryGetReSharperItem", "Lcom/jetbrains/resharper/completion/ReSharperLookupItem;", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "toModel", "waitForResults", "", "Lcom/jetbrains/resharper/completion/PreemptiveCompletionHost;", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "releaseWhen", "Lcom/jetbrains/resharper/completion/CompletionSessionState;", "rider"})
public final class UtilsKt {
    @NotNull
    public static final CompletionMode toModel(@NotNull CompletionType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        switch (UtilsKt$WhenMappings.$EnumSwitchMapping$0[$receiver.ordinal()]) {
            case 1: {
                return CompletionMode.Basic;
            }
            case 2: {
                return CompletionMode.Import;
            }
            case 3: {
                return CompletionMode.Smart;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @Nullable
    public static final Character getTypedChar(@NotNull Editor editor, int oldOffset, int newOffset) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        if (newOffset - oldOffset != 1 || oldOffset > newOffset || oldOffset < 0) {
            return null;
        }
        TextRange typedCharRange = new TextRange(oldOffset, newOffset);
        String string3 = string2 = editor.getDocument().getText(typedCharRange);
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray = string3.toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        char[] range = cArray;
        Character c2 = ArraysKt.firstOrNull((char[])range);
        if (c2 == null) {
            return null;
        }
        char typedChar = c2.charValue();
        return Character.valueOf(typedChar);
    }

    @Nullable
    public static final ReSharperLookupItem tryGetReSharperItem(@Nullable LookupElement item) {
        if (item instanceof ReSharperLookupItem) {
            return (ReSharperLookupItem)item;
        }
        LookupElement decorator = item;
        while (decorator instanceof LookupElementDecorator) {
            LookupElement delegate2 = ((LookupElementDecorator)decorator).getDelegate();
            if (delegate2 instanceof ReSharperLookupItem) {
                return (ReSharperLookupItem)delegate2;
            }
            decorator = delegate2;
        }
        return null;
    }

    public static final void waitForResults(@NotNull PreemptiveCompletionHost $receiver, @NotNull Lifetime lifetime, @NotNull CompletionSessionState releaseWhen) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        Intrinsics.checkParameterIsNotNull((Object)((Object)releaseWhen), (String)"releaseWhen");
        if ($receiver.getState$rider().compareTo((Enum)releaseWhen) >= 0 || Intrinsics.areEqual((Object)((Object)$receiver.getState$rider()), (Object)((Object)CompletionSessionState.Inactive))) {
            return;
        }
        SyncEventWithInterrupt syncLock = new SyncEventWithInterrupt();
        int fullTimeout = 15000;
        long millisecondsNow = System.currentTimeMillis();
        syncLock.waitFor(lifetime, (Function0<Unit>)((Function0)new Function0<Unit>($receiver, releaseWhen, syncLock, fullTimeout, millisecondsNow){
            final /* synthetic */ PreemptiveCompletionHost receiver$0;
            final /* synthetic */ CompletionSessionState $releaseWhen;
            final /* synthetic */ SyncEventWithInterrupt $syncLock;
            final /* synthetic */ int $fullTimeout;
            final /* synthetic */ long $millisecondsNow;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                PreemptiveCompletionHost preemptiveCompletionHost = this.receiver$0;
                synchronized (preemptiveCompletionHost) {
                    if (this.receiver$0.getState$rider().compareTo((Enum)this.$releaseWhen) >= 0 || Intrinsics.areEqual((Object)((Object)this.receiver$0.getState$rider()), (Object)((Object)CompletionSessionState.Inactive))) {
                        this.$syncLock.set();
                    }
                    Unit unit = Unit.INSTANCE;
                }
                if (System.currentTimeMillis() - this.$millisecondsNow > (long)this.$fullTimeout) {
                    throw (Throwable)new TimeoutException("[Completion]Timeout in ReSharper contributor. Full.");
                }
                ProgressManager.checkCanceled();
            }
            {
                this.receiver$0 = preemptiveCompletionHost;
                this.$releaseWhen = completionSessionState;
                this.$syncLock = syncEventWithInterrupt;
                this.$fullTimeout = n2;
                this.$millisecondsNow = l2;
                super(0);
            }
        }));
    }

    @NotNull
    public static final CompletionMode toCompletionMode(@NotNull CompletionType type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        CompletionMode completionMode = CompletionMode.Basic;
        if (Intrinsics.areEqual((Object)type, (Object)CompletionType.CLASS_NAME)) {
            completionMode = CompletionMode.Import;
        } else if (Intrinsics.areEqual((Object)type, (Object)CompletionType.SMART)) {
            completionMode = CompletionMode.Smart;
        }
        return completionMode;
    }
}

