/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.daemon;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.resharper.daemon.HighlighterStorage;
import com.jetbrains.resharper.daemon.IRiderDocumentMarkupAdapter;
import com.jetbrains.resharper.daemon.MarkupSuppressionKind;
import com.jetbrains.resharper.daemon.RiderHighlighterRangeRepairer;
import com.jetbrains.resharper.daemon.RiderMarkupSuppressor;
import com.jetbrains.resharper.daemon.util.HighlightersUtilKt;
import com.jetbrains.resharper.daemon.util.mock.DummyHighlighterEx;
import com.jetbrains.rider.model.HighlighterModel;
import com.jetbrains.rider.util.lifetime.Lifetime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 %2\u00020\u0001:\u0001%B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0006\u0010\u0013\u001a\u00020\u0010J\u0014\u0010\u0014\u001a\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016J\u0014\u0010\u0017\u001a\u00020\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0016J\"\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002J\u0006\u0010\u001f\u001a\u00020\u0010J\u0016\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/jetbrains/resharper/daemon/DocumentMarkupContributor;", "", "markupAdapter", "Lcom/jetbrains/resharper/daemon/IRiderDocumentMarkupAdapter;", "rangeRepairer", "Lcom/jetbrains/resharper/daemon/RiderHighlighterRangeRepairer;", "suppressor", "Lcom/jetbrains/resharper/daemon/RiderMarkupSuppressor;", "(Lcom/jetbrains/resharper/daemon/IRiderDocumentMarkupAdapter;Lcom/jetbrains/resharper/daemon/RiderHighlighterRangeRepairer;Lcom/jetbrains/resharper/daemon/RiderMarkupSuppressor;)V", "getMarkupAdapter", "()Lcom/jetbrains/resharper/daemon/IRiderDocumentMarkupAdapter;", "storage", "Lcom/jetbrains/resharper/daemon/HighlighterStorage;", "getStorage", "()Lcom/jetbrains/resharper/daemon/HighlighterStorage;", "assertUnique", "", "model", "Lcom/jetbrains/rider/model/HighlighterModel;", "flushHighlighters", "highlightersAdded", "added", "", "highlightersRemoved", "removed", "", "registerHighlighter", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "useRecycling", "", "forceCreation", "removeAllHighlighters", "suppress", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "suppressionKind", "Lcom/jetbrains/resharper/daemon/MarkupSuppressionKind;", "Companion", "rider"})
public final class DocumentMarkupContributor {
    @NotNull
    private final HighlighterStorage storage;
    @NotNull
    private final IRiderDocumentMarkupAdapter markupAdapter;
    private final RiderHighlighterRangeRepairer rangeRepairer;
    private final RiderMarkupSuppressor suppressor;
    private static final Logger logger;
    private static final DummyHighlighterEx invalidHighlighter;
    public static final Companion Companion;

    @NotNull
    public final HighlighterStorage getStorage() {
        return this.storage;
    }

    public final void flushHighlighters() {
        List<RangeHighlighterEx> notDeleted;
        Collection $receiver$iv3;
        String string2;
        Object object;
        Object object2;
        DocumentMarkupContributor.Companion.getLogger().debug("highlighter flush triggered!");
        Logger $receiver$iv2 = DocumentMarkupContributor.Companion.getLogger();
        if ($receiver$iv2.isTraceEnabled()) {
            object2 = $receiver$iv2;
            Object[] objectArray = this.markupAdapter.getAllHighlighters();
            object = new StringBuilder().append("highlighters in document:");
            int n2 = objectArray.length;
            string2 = ((StringBuilder)object).append(n2).toString();
            object2.trace(string2);
        }
        ArrayList<HighlighterModel> notReused = new ArrayList<HighlighterModel>();
        List<HighlighterModel> notRegistered = this.storage.flushNotRegistered$rider();
        object = notRegistered;
        if (!object.isEmpty()) {
            Logger $receiver$iv3;
            Logger $receiver$iv4 = DocumentMarkupContributor.Companion.getLogger();
            if ($receiver$iv4.isTraceEnabled()) {
                object2 = $receiver$iv4;
                string2 = "Flushing to markup " + notRegistered.size() + " not registered highlighters";
                object2.trace(string2);
            }
            for (HighlighterModel model2 : notRegistered) {
                RangeHighlighterEx isRegistered = this.registerHighlighter(model2, true, false);
                if (isRegistered != null) continue;
                notReused.add(model2);
            }
            int reused = notRegistered.size() - notReused.size();
            if (reused != 0 && ($receiver$iv3 = DocumentMarkupContributor.Companion.getLogger()).isTraceEnabled()) {
                object2 = $receiver$iv3;
                string2 = "Successfully reused " + reused + " highlighters during flush";
                object2.trace(string2);
            }
        }
        if (!($receiver$iv3 = (Collection)(notDeleted = this.storage.flushNotDeleted$rider())).isEmpty()) {
            $receiver$iv3 = DocumentMarkupContributor.Companion.getLogger();
            if ($receiver$iv3.isTraceEnabled()) {
                object2 = $receiver$iv3;
                string2 = "Deleting " + notDeleted.size() + " highlighters from markup";
                object2.trace(string2);
            }
            this.markupAdapter.beforeBulkRemove(notDeleted);
            for (RangeHighlighterEx highlighter2 : notDeleted) {
                this.markupAdapter.removeHighlighter(highlighter2);
            }
        }
        if (notReused.size() != 0) {
            $receiver$iv3 = DocumentMarkupContributor.Companion.getLogger();
            if ($receiver$iv3.isTraceEnabled()) {
                object2 = $receiver$iv3;
                string2 = "Registering last portion of " + notReused.size() + " highlighters which have failed at reusing";
                object2.trace(string2);
            }
            ArrayList<RangeHighlighterEx> added = new ArrayList<RangeHighlighterEx>();
            Iterator iterator2 = notReused.iterator();
            while (iterator2.hasNext()) {
                RangeHighlighterEx highlighter3;
                HighlighterModel model3;
                HighlighterModel highlighterModel = model3 = (HighlighterModel)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)highlighterModel, (String)"model");
                if (this.registerHighlighter(highlighterModel, false, true) == null) {
                    Intrinsics.throwNpe();
                }
                if (Intrinsics.areEqual((Object)highlighter3, (Object)DocumentMarkupContributor.Companion.getInvalidHighlighter())) {
                    DocumentMarkupContributor.Companion.getLogger().warn("Invalid highlighters are presented in notRegistered highlighters during flush");
                    continue;
                }
                added.add(highlighter3);
            }
            Collection collection = added;
            if (!collection.isEmpty()) {
                this.markupAdapter.afterBulkAdd((List<? extends RangeHighlighterEx>)added);
            }
        }
        this.rangeRepairer.shrinkHistory();
    }

    public final void highlightersAdded(@NotNull List<? extends HighlighterModel> added) {
        Intrinsics.checkParameterIsNotNull(added, (String)"added");
        for (HighlighterModel highlighterModel : added) {
            if (this.suppressor.shouldSuppressAddition(highlighterModel.getRegistryKey())) {
                this.storage.queueRegistration$rider(highlighterModel);
                continue;
            }
            this.registerHighlighter(highlighterModel, true, true);
        }
    }

    private final void assertUnique(HighlighterModel model2) {
        boolean bl;
        boolean bl2 = bl = this.storage.get(model2.getId()) == null;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Multiple highlighter registration on IDEA-side!\n" + (" id: " + model2.getId() + " kind: " + model2.getRegistryKey() + " range: (" + model2.getStart() + "," + model2.getEnd() + ")");
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
    }

    private final RangeHighlighterEx registerHighlighter(HighlighterModel model2, boolean useRecycling, boolean forceCreation) {
        RangeHighlighterEx recycledHighlighter;
        boolean bl;
        this.assertUnique(model2);
        boolean bl2 = bl = useRecycling || forceCreation;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "highlighter would be registered only if it was invalid";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        TextRange correctedRange = this.rangeRepairer.repair(model2);
        if (correctedRange == null) {
            this.storage.addInvalidHighlighter$rider(model2);
            return DocumentMarkupContributor.Companion.getInvalidHighlighter();
        }
        if (useRecycling && (recycledHighlighter = this.storage.recycle$rider(correctedRange, model2)) != null) {
            this.markupAdapter.updateHighlighter(recycledHighlighter, model2);
            this.storage.addHighlighter$rider(model2.getId(), recycledHighlighter);
            return recycledHighlighter;
        }
        if (forceCreation) {
            RangeHighlighterEx highlighter2 = this.markupAdapter.addHighlighter(correctedRange, model2);
            this.storage.addHighlighter$rider(model2.getId(), highlighter2);
            return highlighter2;
        }
        return null;
    }

    public final void highlightersRemoved(@NotNull List<Integer> removed) {
        Intrinsics.checkParameterIsNotNull(removed, (String)"removed");
        Iterator<Integer> iterator2 = removed.iterator();
        while (iterator2.hasNext()) {
            RangeHighlighterEx highlighter2;
            int id = ((Number)iterator2.next()).intValue();
            if (this.storage.remove$rider(id) == null) {
                continue;
            }
            if (this.suppressor.shouldSuppressDeletion(HighlightersUtilKt.getRegistryKey(highlighter2))) {
                this.storage.queueDeletion$rider(highlighter2);
                continue;
            }
            this.markupAdapter.removeHighlighter(highlighter2);
        }
    }

    public final void removeAllHighlighters() {
        boolean any2;
        block3: {
            boolean bl;
            List allHighlighters = CollectionsKt.plus(this.storage.getRegisteredHighlighters(), (Iterable)this.storage.flushNotDeleted$rider());
            DocumentMarkupContributor.Companion.getLogger().debug("Cleaning highlighter storage. Total amount " + allHighlighters.size());
            this.markupAdapter.beforeBulkRemove(allHighlighters);
            for (RangeHighlighterEx highlighter2 : allHighlighters) {
                this.markupAdapter.removeHighlighter(highlighter2);
            }
            this.storage.clear$rider();
            Object[] $receiver$iv = this.markupAdapter.getAllHighlighters();
            for (int i2 = 0; i2 < $receiver$iv.length; ++i2) {
                Object element$iv = $receiver$iv[i2];
                RangeHighlighter it = (RangeHighlighter)element$iv;
                if (!(HighlightersUtilKt.getTryGetRegistryKey(it) != null)) continue;
                bl = true;
                break block3;
            }
            bl = any2 = false;
        }
        if (any2) {
            DocumentMarkupContributor.Companion.getLogger().error("Rider registered highlighters are presented in Markup model after cleaning");
        }
    }

    public final void suppress(@NotNull Lifetime lifetime, @NotNull MarkupSuppressionKind suppressionKind) {
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        Intrinsics.checkParameterIsNotNull((Object)((Object)suppressionKind), (String)"suppressionKind");
        this.suppressor.suppress(lifetime, suppressionKind);
    }

    @NotNull
    public final IRiderDocumentMarkupAdapter getMarkupAdapter() {
        return this.markupAdapter;
    }

    public DocumentMarkupContributor(@NotNull IRiderDocumentMarkupAdapter markupAdapter, @NotNull RiderHighlighterRangeRepairer rangeRepairer, @NotNull RiderMarkupSuppressor suppressor) {
        Intrinsics.checkParameterIsNotNull((Object)markupAdapter, (String)"markupAdapter");
        Intrinsics.checkParameterIsNotNull((Object)rangeRepairer, (String)"rangeRepairer");
        Intrinsics.checkParameterIsNotNull((Object)suppressor, (String)"suppressor");
        this.markupAdapter = markupAdapter;
        this.rangeRepairer = rangeRepairer;
        this.suppressor = suppressor;
        this.storage = new HighlighterStorage();
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(DocumentMarkupContributor.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        DocumentMarkupContributor.logger = logger;
        invalidHighlighter = new DummyHighlighterEx(-1, -1, "Invalid Rider Highlighter");
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/resharper/daemon/DocumentMarkupContributor$Companion;", "", "()V", "invalidHighlighter", "Lcom/jetbrains/resharper/daemon/util/mock/DummyHighlighterEx;", "getInvalidHighlighter", "()Lcom/jetbrains/resharper/daemon/util/mock/DummyHighlighterEx;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "rider"})
    public static final class Companion {
        private final Logger getLogger() {
            return logger;
        }

        private final DummyHighlighterEx getInvalidHighlighter() {
            return invalidHighlighter;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

